/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.media;

import android.annotation.TargetApi;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.media.AudioManager;
import android.os.Build;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.IBinder;
import android.os.Process;
import android.os.RemoteException;
import android.os.ResultReceiver;
import android.os.SystemClock;
import android.support.annotation.GuardedBy;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.media.AudioAttributesCompat;
import android.support.v4.media.AudioFocusHandler;
import android.support.v4.media.BaseMediaPlayer;
import android.support.v4.media.DataSourceDesc;
import android.support.v4.media.MediaController2;
import android.support.v4.media.MediaItem2;
import android.support.v4.media.MediaMetadata2;
import android.support.v4.media.MediaPlaylistAgent;
import android.support.v4.media.MediaSession2;
import android.support.v4.media.MediaSession2Stub;
import android.support.v4.media.MediaSessionLegacyStub;
import android.support.v4.media.MediaUtils2;
import android.support.v4.media.SessionCommand2;
import android.support.v4.media.SessionCommandGroup2;
import android.support.v4.media.SessionPlaylistAgentImplBase;
import android.support.v4.media.SessionToken2;
import android.support.v4.media.SessionToken2ImplBase;
import android.support.v4.media.VolumeProviderCompat;
import android.support.v4.media.session.MediaSessionCompat;
import android.support.v4.media.session.PlaybackStateCompat;
import android.support.v4.util.ObjectsCompat;
import android.text.TextUtils;
import android.util.Log;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.Executor;

@TargetApi(value=19)
class MediaSession2ImplBase
implements MediaSession2.SupportLibraryImpl {
    private static final String DEFAULT_MEDIA_SESSION_TAG_PREFIX = "android.media.session2.id";
    private static final String DEFAULT_MEDIA_SESSION_TAG_DELIM = ".";
    static final String TAG = "MS2ImplBase";
    static final boolean DEBUG = Log.isLoggable((String)"MS2ImplBase", (int)3);
    private final Context mContext;
    private final HandlerThread mHandlerThread;
    private final Handler mHandler;
    private final MediaSessionCompat mSessionCompat;
    private final MediaSession2Stub mSession2Stub;
    private final MediaSessionLegacyStub mSessionLegacyStub;
    private final Executor mCallbackExecutor;
    private final MediaSession2.SessionCallback mCallback;
    private final SessionToken2 mSessionToken;
    private final AudioManager mAudioManager;
    private final BaseMediaPlayer.PlayerEventCallback mPlayerEventCallback;
    private final MediaPlaylistAgent.PlaylistEventCallback mPlaylistEventCallback;
    private final AudioFocusHandler mAudioFocusHandler;
    private final MediaSession2 mInstance;
    private final PendingIntent mSessionActivity;
    final Object mLock = new Object();
    @GuardedBy(value="mLock")
    private BaseMediaPlayer mPlayer;
    @GuardedBy(value="mLock")
    private MediaPlaylistAgent mPlaylistAgent;
    @GuardedBy(value="mLock")
    private SessionPlaylistAgentImplBase mSessionPlaylistAgent;
    @GuardedBy(value="mLock")
    private VolumeProviderCompat mVolumeProvider;
    @GuardedBy(value="mLock")
    private MediaSession2.OnDataSourceMissingHelper mDsmHelper;
    @GuardedBy(value="mLock")
    private MediaController2.PlaybackInfo mPlaybackInfo;

    MediaSession2ImplBase(MediaSession2 instance, Context context, String id, BaseMediaPlayer player, MediaPlaylistAgent playlistAgent, VolumeProviderCompat volumeProvider, PendingIntent sessionActivity, Executor callbackExecutor, MediaSession2.SessionCallback callback) {
        this.mContext = context;
        this.mInstance = instance;
        this.mHandlerThread = new HandlerThread("MediaController2_Thread");
        this.mHandlerThread.start();
        this.mHandler = new Handler(this.mHandlerThread.getLooper());
        this.mSession2Stub = new MediaSession2Stub(this);
        this.mSessionLegacyStub = new MediaSessionLegacyStub(this);
        this.mSessionActivity = sessionActivity;
        this.mCallback = callback;
        this.mCallbackExecutor = callbackExecutor;
        this.mAudioManager = (AudioManager)context.getSystemService("audio");
        this.mPlayerEventCallback = new MyPlayerEventCallback(this);
        this.mPlaylistEventCallback = new MyPlaylistEventCallback(this);
        this.mAudioFocusHandler = new AudioFocusHandler(context, this.getInstance());
        String libraryService = MediaSession2ImplBase.getServiceName(context, "android.media.MediaLibraryService2", id);
        String sessionService = MediaSession2ImplBase.getServiceName(context, "android.media.MediaSessionService2", id);
        if (sessionService != null && libraryService != null) {
            throw new IllegalArgumentException("Ambiguous session type. Multiple session services define the same id=" + id);
        }
        this.mSessionToken = libraryService != null ? new SessionToken2(new SessionToken2ImplBase(Process.myUid(), 2, context.getPackageName(), libraryService, id, this.mSession2Stub)) : (sessionService != null ? new SessionToken2(new SessionToken2ImplBase(Process.myUid(), 1, context.getPackageName(), sessionService, id, this.mSession2Stub)) : new SessionToken2(new SessionToken2ImplBase(Process.myUid(), 0, context.getPackageName(), null, id, this.mSession2Stub)));
        String sessionCompatId = TextUtils.join((CharSequence)DEFAULT_MEDIA_SESSION_TAG_DELIM, (Object[])new String[]{DEFAULT_MEDIA_SESSION_TAG_PREFIX, id});
        this.mSessionCompat = new MediaSessionCompat(context, sessionCompatId, this.mSessionToken);
        this.mSessionCompat.setCallback(this.mSessionLegacyStub, this.mHandler);
        this.mSessionCompat.setSessionActivity(sessionActivity);
        this.updatePlayer(player, playlistAgent, volumeProvider);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updatePlayer(@NonNull BaseMediaPlayer player, @Nullable MediaPlaylistAgent playlistAgent, @Nullable VolumeProviderCompat volumeProvider) {
        MediaPlaylistAgent oldAgent;
        BaseMediaPlayer oldPlayer;
        boolean hasPlaybackInfoChanged;
        boolean hasAgentChanged;
        boolean hasPlayerChanged;
        if (player == null) {
            throw new IllegalArgumentException("player shouldn't be null");
        }
        final MediaController2.PlaybackInfo info = this.createPlaybackInfo(volumeProvider, player.getAudioAttributes());
        Object object = this.mLock;
        synchronized (object) {
            hasPlayerChanged = this.mPlayer != player;
            hasAgentChanged = this.mPlaylistAgent != playlistAgent;
            hasPlaybackInfoChanged = this.mPlaybackInfo != info;
            oldPlayer = this.mPlayer;
            oldAgent = this.mPlaylistAgent;
            this.mPlayer = player;
            if (playlistAgent == null) {
                this.mSessionPlaylistAgent = new SessionPlaylistAgentImplBase(this, this.mPlayer);
                if (this.mDsmHelper != null) {
                    this.mSessionPlaylistAgent.setOnDataSourceMissingHelper(this.mDsmHelper);
                }
                playlistAgent = this.mSessionPlaylistAgent;
            }
            this.mPlaylistAgent = playlistAgent;
            this.mVolumeProvider = volumeProvider;
            this.mPlaybackInfo = info;
        }
        if (volumeProvider == null) {
            int stream = this.getLegacyStreamType(player.getAudioAttributes());
            this.mSessionCompat.setPlaybackToLocal(stream);
        }
        if (player != oldPlayer) {
            player.registerPlayerEventCallback(this.mCallbackExecutor, this.mPlayerEventCallback);
            if (oldPlayer != null) {
                oldPlayer.unregisterPlayerEventCallback(this.mPlayerEventCallback);
            }
        }
        if (playlistAgent != oldAgent) {
            playlistAgent.registerPlaylistEventCallback(this.mCallbackExecutor, this.mPlaylistEventCallback);
            if (oldAgent != null) {
                oldAgent.unregisterPlaylistEventCallback(this.mPlaylistEventCallback);
            }
        }
        if (oldPlayer != null) {
            if (hasAgentChanged) {
                this.notifyAgentUpdatedNotLocked(oldAgent);
            }
            if (hasPlayerChanged) {
                this.notifyPlayerUpdatedNotLocked(oldPlayer);
            }
            if (hasPlaybackInfoChanged) {
                this.notifyToAllControllers(new NotifyRunnable(){

                    @Override
                    public void run(MediaSession2.ControllerCb callback) throws RemoteException {
                        callback.onPlaybackInfoChanged(info);
                    }
                });
            }
        }
    }

    private MediaController2.PlaybackInfo createPlaybackInfo(VolumeProviderCompat volumeProvider, AudioAttributesCompat attrs) {
        MediaController2.PlaybackInfo info;
        if (volumeProvider == null) {
            int stream = this.getLegacyStreamType(attrs);
            int controlType = 2;
            if (Build.VERSION.SDK_INT >= 21 && this.mAudioManager.isVolumeFixed()) {
                controlType = 0;
            }
            info = MediaController2.PlaybackInfo.createPlaybackInfo(1, attrs, controlType, this.mAudioManager.getStreamMaxVolume(stream), this.mAudioManager.getStreamVolume(stream));
        } else {
            info = MediaController2.PlaybackInfo.createPlaybackInfo(2, attrs, volumeProvider.getVolumeControl(), volumeProvider.getMaxVolume(), volumeProvider.getCurrentVolume());
        }
        return info;
    }

    private int getLegacyStreamType(@Nullable AudioAttributesCompat attrs) {
        int stream;
        if (attrs == null) {
            stream = 3;
        } else {
            stream = attrs.getLegacyStreamType();
            if (stream == Integer.MIN_VALUE) {
                stream = 3;
            }
        }
        return stream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mPlayer == null) {
                return;
            }
            this.mAudioFocusHandler.close();
            this.mPlayer.unregisterPlayerEventCallback(this.mPlayerEventCallback);
            this.mPlayer = null;
            this.mSessionCompat.release();
            this.notifyToAllControllers(new NotifyRunnable(){

                @Override
                public void run(MediaSession2.ControllerCb callback) throws RemoteException {
                    callback.onDisconnected();
                }
            });
            this.mHandler.removeCallbacksAndMessages(null);
            if (this.mHandlerThread.isAlive()) {
                if (Build.VERSION.SDK_INT >= 18) {
                    this.mHandlerThread.quitSafely();
                } else {
                    this.mHandlerThread.quit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NonNull
    public BaseMediaPlayer getPlayer() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mPlayer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NonNull
    public MediaPlaylistAgent getPlaylistAgent() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mPlaylistAgent;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public VolumeProviderCompat getVolumeProvider() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mVolumeProvider;
        }
    }

    @Override
    @NonNull
    public SessionToken2 getToken() {
        return this.mSessionToken;
    }

    @Override
    @NonNull
    public List<MediaSession2.ControllerInfo> getConnectedControllers() {
        return this.mSession2Stub.getConnectedControllers();
    }

    @Override
    public void setCustomLayout(@NonNull MediaSession2.ControllerInfo controller, final @NonNull List<MediaSession2.CommandButton> layout) {
        if (controller == null) {
            throw new IllegalArgumentException("controller shouldn't be null");
        }
        if (layout == null) {
            throw new IllegalArgumentException("layout shouldn't be null");
        }
        this.notifyToController(controller, new NotifyRunnable(){

            @Override
            public void run(MediaSession2.ControllerCb callback) throws RemoteException {
                callback.onCustomLayoutChanged(layout);
            }
        });
    }

    @Override
    public void setAllowedCommands(@NonNull MediaSession2.ControllerInfo controller, final @NonNull SessionCommandGroup2 commands) {
        if (controller == null) {
            throw new IllegalArgumentException("controller shouldn't be null");
        }
        if (commands == null) {
            throw new IllegalArgumentException("commands shouldn't be null");
        }
        this.mSession2Stub.setAllowedCommands(controller, commands);
        this.notifyToController(controller, new NotifyRunnable(){

            @Override
            public void run(MediaSession2.ControllerCb callback) throws RemoteException {
                callback.onAllowedCommandsChanged(commands);
            }
        });
    }

    @Override
    public void sendCustomCommand(final @NonNull SessionCommand2 command, final @Nullable Bundle args) {
        if (command == null) {
            throw new IllegalArgumentException("command shouldn't be null");
        }
        this.notifyToAllControllers(new NotifyRunnable(){

            @Override
            public void run(MediaSession2.ControllerCb callback) throws RemoteException {
                callback.onCustomCommand(command, args, null);
            }
        });
    }

    @Override
    public void sendCustomCommand(@NonNull MediaSession2.ControllerInfo controller, final @NonNull SessionCommand2 command, final @Nullable Bundle args, final @Nullable ResultReceiver receiver) {
        if (controller == null) {
            throw new IllegalArgumentException("controller shouldn't be null");
        }
        if (command == null) {
            throw new IllegalArgumentException("command shouldn't be null");
        }
        this.notifyToController(controller, new NotifyRunnable(){

            @Override
            public void run(MediaSession2.ControllerCb callback) throws RemoteException {
                callback.onCustomCommand(command, args, receiver);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void play() {
        BaseMediaPlayer player;
        Object object = this.mLock;
        synchronized (object) {
            player = this.mPlayer;
        }
        if (player != null) {
            if (this.mAudioFocusHandler.onPlayRequested()) {
                player.play();
            } else {
                Log.w((String)TAG, (String)"play() wouldn't be called because of the failure in audio focus");
            }
        } else if (DEBUG) {
            Log.d((String)TAG, (String)"API calls after the close()", (Throwable)new IllegalStateException());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pause() {
        BaseMediaPlayer player;
        Object object = this.mLock;
        synchronized (object) {
            player = this.mPlayer;
        }
        if (player != null) {
            if (this.mAudioFocusHandler.onPauseRequested()) {
                player.pause();
            } else {
                Log.w((String)TAG, (String)"pause() wouldn't be called of the failure in audio focus");
            }
        } else if (DEBUG) {
            Log.d((String)TAG, (String)"API calls after the close()", (Throwable)new IllegalStateException());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() {
        BaseMediaPlayer player;
        Object object = this.mLock;
        synchronized (object) {
            player = this.mPlayer;
        }
        if (player != null) {
            player.reset();
        } else if (DEBUG) {
            Log.d((String)TAG, (String)"API calls after the close()", (Throwable)new IllegalStateException());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void prepare() {
        BaseMediaPlayer player;
        Object object = this.mLock;
        synchronized (object) {
            player = this.mPlayer;
        }
        if (player != null) {
            player.prepare();
        } else if (DEBUG) {
            Log.d((String)TAG, (String)"API calls after the close()", (Throwable)new IllegalStateException());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void seekTo(long pos) {
        BaseMediaPlayer player;
        Object object = this.mLock;
        synchronized (object) {
            player = this.mPlayer;
        }
        if (player != null) {
            player.seekTo(pos);
        } else if (DEBUG) {
            Log.d((String)TAG, (String)"API calls after the close()", (Throwable)new IllegalStateException());
        }
    }

    @Override
    public void skipForward() {
    }

    @Override
    public void skipBackward() {
    }

    @Override
    public void notifyError(final int errorCode, final @Nullable Bundle extras) {
        this.notifyToAllControllers(new NotifyRunnable(){

            @Override
            public void run(MediaSession2.ControllerCb callback) throws RemoteException {
                callback.onError(errorCode, extras);
            }
        });
    }

    @Override
    public void notifyRoutesInfoChanged(@NonNull MediaSession2.ControllerInfo controller, final @Nullable List<Bundle> routes) {
        this.notifyToController(controller, new NotifyRunnable(){

            @Override
            public void run(MediaSession2.ControllerCb callback) throws RemoteException {
                callback.onRoutesInfoChanged(routes);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getPlayerState() {
        BaseMediaPlayer player;
        Object object = this.mLock;
        synchronized (object) {
            player = this.mPlayer;
        }
        if (player != null) {
            return player.getPlayerState();
        }
        if (DEBUG) {
            Log.d((String)TAG, (String)"API calls after the close()", (Throwable)new IllegalStateException());
        }
        return 3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getCurrentPosition() {
        BaseMediaPlayer player;
        Object object = this.mLock;
        synchronized (object) {
            player = this.mPlayer;
        }
        if (this.isInPlaybackState(player)) {
            return player.getCurrentPosition();
        }
        if (DEBUG) {
            Log.d((String)TAG, (String)"API calls after the close()", (Throwable)new IllegalStateException());
        }
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getDuration() {
        BaseMediaPlayer player;
        Object object = this.mLock;
        synchronized (object) {
            player = this.mPlayer;
        }
        if (this.isInPlaybackState(player)) {
            return player.getDuration();
        }
        if (DEBUG) {
            Log.d((String)TAG, (String)"API calls after the close()", (Throwable)new IllegalStateException());
        }
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getBufferedPosition() {
        BaseMediaPlayer player;
        Object object = this.mLock;
        synchronized (object) {
            player = this.mPlayer;
        }
        if (this.isInPlaybackState(player)) {
            return player.getBufferedPosition();
        }
        if (DEBUG) {
            Log.d((String)TAG, (String)"API calls after the close()", (Throwable)new IllegalStateException());
        }
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getBufferingState() {
        BaseMediaPlayer player;
        Object object = this.mLock;
        synchronized (object) {
            player = this.mPlayer;
        }
        if (player != null) {
            return player.getBufferingState();
        }
        if (DEBUG) {
            Log.d((String)TAG, (String)"API calls after the close()", (Throwable)new IllegalStateException());
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public float getPlaybackSpeed() {
        BaseMediaPlayer player;
        Object object = this.mLock;
        synchronized (object) {
            player = this.mPlayer;
        }
        if (this.isInPlaybackState(player)) {
            return player.getPlaybackSpeed();
        }
        if (DEBUG) {
            Log.d((String)TAG, (String)"API calls after the close()", (Throwable)new IllegalStateException());
        }
        return 1.0f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPlaybackSpeed(float speed) {
        BaseMediaPlayer player;
        Object object = this.mLock;
        synchronized (object) {
            player = this.mPlayer;
        }
        if (player != null) {
            player.setPlaybackSpeed(speed);
        } else if (DEBUG) {
            Log.d((String)TAG, (String)"API calls after the close()", (Throwable)new IllegalStateException());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setOnDataSourceMissingHelper(@NonNull MediaSession2.OnDataSourceMissingHelper helper) {
        if (helper == null) {
            throw new IllegalArgumentException("helper shouldn't be null");
        }
        Object object = this.mLock;
        synchronized (object) {
            this.mDsmHelper = helper;
            if (this.mSessionPlaylistAgent != null) {
                this.mSessionPlaylistAgent.setOnDataSourceMissingHelper(helper);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearOnDataSourceMissingHelper() {
        Object object = this.mLock;
        synchronized (object) {
            this.mDsmHelper = null;
            if (this.mSessionPlaylistAgent != null) {
                this.mSessionPlaylistAgent.clearOnDataSourceMissingHelper();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<MediaItem2> getPlaylist() {
        MediaPlaylistAgent agent;
        Object object = this.mLock;
        synchronized (object) {
            agent = this.mPlaylistAgent;
        }
        if (agent != null) {
            return agent.getPlaylist();
        }
        if (DEBUG) {
            Log.d((String)TAG, (String)"API calls after the close()", (Throwable)new IllegalStateException());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPlaylist(@NonNull List<MediaItem2> list, @Nullable MediaMetadata2 metadata) {
        MediaPlaylistAgent agent;
        if (list == null) {
            throw new IllegalArgumentException("list shouldn't be null");
        }
        Object object = this.mLock;
        synchronized (object) {
            agent = this.mPlaylistAgent;
        }
        if (agent != null) {
            agent.setPlaylist(list, metadata);
        } else if (DEBUG) {
            Log.d((String)TAG, (String)"API calls after the close()", (Throwable)new IllegalStateException());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void skipToPlaylistItem(@NonNull MediaItem2 item) {
        MediaPlaylistAgent agent;
        if (item == null) {
            throw new IllegalArgumentException("item shouldn't be null");
        }
        Object object = this.mLock;
        synchronized (object) {
            agent = this.mPlaylistAgent;
        }
        if (agent != null) {
            agent.skipToPlaylistItem(item);
        } else if (DEBUG) {
            Log.d((String)TAG, (String)"API calls after the close()", (Throwable)new IllegalStateException());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void skipToPreviousItem() {
        MediaPlaylistAgent agent;
        Object object = this.mLock;
        synchronized (object) {
            agent = this.mPlaylistAgent;
        }
        if (agent != null) {
            agent.skipToPreviousItem();
        } else if (DEBUG) {
            Log.d((String)TAG, (String)"API calls after the close()", (Throwable)new IllegalStateException());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void skipToNextItem() {
        MediaPlaylistAgent agent;
        Object object = this.mLock;
        synchronized (object) {
            agent = this.mPlaylistAgent;
        }
        if (agent != null) {
            agent.skipToNextItem();
        } else if (DEBUG) {
            Log.d((String)TAG, (String)"API calls after the close()", (Throwable)new IllegalStateException());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MediaMetadata2 getPlaylistMetadata() {
        MediaPlaylistAgent agent;
        Object object = this.mLock;
        synchronized (object) {
            agent = this.mPlaylistAgent;
        }
        if (agent != null) {
            return agent.getPlaylistMetadata();
        }
        if (DEBUG) {
            Log.d((String)TAG, (String)"API calls after the close()", (Throwable)new IllegalStateException());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addPlaylistItem(int index, @NonNull MediaItem2 item) {
        MediaPlaylistAgent agent;
        if (index < 0) {
            throw new IllegalArgumentException("index shouldn't be negative");
        }
        if (item == null) {
            throw new IllegalArgumentException("item shouldn't be null");
        }
        Object object = this.mLock;
        synchronized (object) {
            agent = this.mPlaylistAgent;
        }
        if (agent != null) {
            agent.addPlaylistItem(index, item);
        } else if (DEBUG) {
            Log.d((String)TAG, (String)"API calls after the close()", (Throwable)new IllegalStateException());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removePlaylistItem(@NonNull MediaItem2 item) {
        MediaPlaylistAgent agent;
        if (item == null) {
            throw new IllegalArgumentException("item shouldn't be null");
        }
        Object object = this.mLock;
        synchronized (object) {
            agent = this.mPlaylistAgent;
        }
        if (agent != null) {
            agent.removePlaylistItem(item);
        } else if (DEBUG) {
            Log.d((String)TAG, (String)"API calls after the close()", (Throwable)new IllegalStateException());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replacePlaylistItem(int index, @NonNull MediaItem2 item) {
        MediaPlaylistAgent agent;
        if (index < 0) {
            throw new IllegalArgumentException("index shouldn't be negative");
        }
        if (item == null) {
            throw new IllegalArgumentException("item shouldn't be null");
        }
        Object object = this.mLock;
        synchronized (object) {
            agent = this.mPlaylistAgent;
        }
        if (agent != null) {
            agent.replacePlaylistItem(index, item);
        } else if (DEBUG) {
            Log.d((String)TAG, (String)"API calls after the close()", (Throwable)new IllegalStateException());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MediaItem2 getCurrentMediaItem() {
        MediaPlaylistAgent agent;
        Object object = this.mLock;
        synchronized (object) {
            agent = this.mPlaylistAgent;
        }
        if (agent != null) {
            return agent.getCurrentMediaItem();
        }
        if (DEBUG) {
            Log.d((String)TAG, (String)"API calls after the close()", (Throwable)new IllegalStateException());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updatePlaylistMetadata(@Nullable MediaMetadata2 metadata) {
        MediaPlaylistAgent agent;
        Object object = this.mLock;
        synchronized (object) {
            agent = this.mPlaylistAgent;
        }
        if (agent != null) {
            agent.updatePlaylistMetadata(metadata);
        } else if (DEBUG) {
            Log.d((String)TAG, (String)"API calls after the close()", (Throwable)new IllegalStateException());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getRepeatMode() {
        MediaPlaylistAgent agent;
        Object object = this.mLock;
        synchronized (object) {
            agent = this.mPlaylistAgent;
        }
        if (agent != null) {
            return agent.getRepeatMode();
        }
        if (DEBUG) {
            Log.d((String)TAG, (String)"API calls after the close()", (Throwable)new IllegalStateException());
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setRepeatMode(int repeatMode) {
        MediaPlaylistAgent agent;
        Object object = this.mLock;
        synchronized (object) {
            agent = this.mPlaylistAgent;
        }
        if (agent != null) {
            agent.setRepeatMode(repeatMode);
        } else if (DEBUG) {
            Log.d((String)TAG, (String)"API calls after the close()", (Throwable)new IllegalStateException());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getShuffleMode() {
        MediaPlaylistAgent agent;
        Object object = this.mLock;
        synchronized (object) {
            agent = this.mPlaylistAgent;
        }
        if (agent != null) {
            return agent.getShuffleMode();
        }
        if (DEBUG) {
            Log.d((String)TAG, (String)"API calls after the close()", (Throwable)new IllegalStateException());
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setShuffleMode(int shuffleMode) {
        MediaPlaylistAgent agent;
        Object object = this.mLock;
        synchronized (object) {
            agent = this.mPlaylistAgent;
        }
        if (agent != null) {
            agent.setShuffleMode(shuffleMode);
        } else if (DEBUG) {
            Log.d((String)TAG, (String)"API calls after the close()", (Throwable)new IllegalStateException());
        }
    }

    @Override
    @NonNull
    public MediaSession2 getInstance() {
        return this.mInstance;
    }

    @Override
    @NonNull
    public IBinder getSessionBinder() {
        return this.mSession2Stub.asBinder();
    }

    @Override
    public Context getContext() {
        return this.mContext;
    }

    @Override
    public Executor getCallbackExecutor() {
        return this.mCallbackExecutor;
    }

    @Override
    public MediaSession2.SessionCallback getCallback() {
        return this.mCallback;
    }

    @Override
    public MediaSessionCompat getSessionCompat() {
        return this.mSessionCompat;
    }

    @Override
    public AudioFocusHandler getAudioFocusHandler() {
        return this.mAudioFocusHandler;
    }

    @Override
    public boolean isClosed() {
        return !this.mHandlerThread.isAlive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PlaybackStateCompat getPlaybackStateCompat() {
        Object object = this.mLock;
        synchronized (object) {
            int state = MediaUtils2.convertToPlaybackStateCompatState(this.getPlayerState(), this.getBufferingState());
            long allActions = 0x37FFFFL;
            return new PlaybackStateCompat.Builder().setState(state, this.getCurrentPosition(), this.getPlaybackSpeed()).setActions(allActions).setBufferedPosition(this.getBufferedPosition()).build();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MediaController2.PlaybackInfo getPlaybackInfo() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mPlaybackInfo;
        }
    }

    @Override
    public PendingIntent getSessionActivity() {
        return this.mSessionActivity;
    }

    private static String getServiceName(Context context, String serviceAction, String id) {
        PackageManager manager = context.getPackageManager();
        Intent serviceIntent = new Intent(serviceAction);
        serviceIntent.setPackage(context.getPackageName());
        List services = manager.queryIntentServices(serviceIntent, 128);
        String serviceName = null;
        if (services != null) {
            for (int i = 0; i < services.size(); ++i) {
                String serviceId = SessionToken2.getSessionId((ResolveInfo)services.get(i));
                if (serviceId == null || !TextUtils.equals((CharSequence)id, (CharSequence)serviceId) || ((ResolveInfo)services.get((int)i)).serviceInfo == null) continue;
                if (serviceName != null) {
                    throw new IllegalArgumentException("Ambiguous session type. Multiple session services define the same id=" + id);
                }
                serviceName = ((ResolveInfo)services.get((int)i)).serviceInfo.name;
            }
        }
        return serviceName;
    }

    private boolean isInPlaybackState(@Nullable BaseMediaPlayer player) {
        return player != null && player.getPlayerState() != 0 && player.getPlayerState() != 3;
    }

    private void notifyAgentUpdatedNotLocked(MediaPlaylistAgent oldAgent) {
        List<MediaItem2> newPlaylist;
        List<MediaItem2> oldPlaylist = oldAgent.getPlaylist();
        if (!ObjectsCompat.equals(oldPlaylist, newPlaylist = this.getPlaylist())) {
            this.notifyToAllControllers(new NotifyRunnable(){

                @Override
                public void run(MediaSession2.ControllerCb callback) throws RemoteException {
                    callback.onPlaylistChanged(newPlaylist, MediaSession2ImplBase.this.getPlaylistMetadata());
                }
            });
        } else {
            MediaMetadata2 newMetadata;
            MediaMetadata2 oldMetadata = oldAgent.getPlaylistMetadata();
            if (!ObjectsCompat.equals((Object)oldMetadata, (Object)(newMetadata = this.getPlaylistMetadata()))) {
                this.notifyToAllControllers(new NotifyRunnable(){

                    @Override
                    public void run(MediaSession2.ControllerCb callback) throws RemoteException {
                        callback.onPlaylistMetadataChanged(newMetadata);
                    }
                });
            }
        }
        MediaItem2 oldCurrentItem = oldAgent.getCurrentMediaItem();
        final MediaItem2 newCurrentItem = this.getCurrentMediaItem();
        if (!ObjectsCompat.equals((Object)oldCurrentItem, (Object)newCurrentItem)) {
            this.notifyToAllControllers(new NotifyRunnable(){

                @Override
                public void run(MediaSession2.ControllerCb callback) throws RemoteException {
                    callback.onCurrentMediaItemChanged(newCurrentItem);
                }
            });
        }
        final int repeatMode = this.getRepeatMode();
        if (oldAgent.getRepeatMode() != repeatMode) {
            this.notifyToAllControllers(new NotifyRunnable(){

                @Override
                public void run(MediaSession2.ControllerCb callback) throws RemoteException {
                    callback.onRepeatModeChanged(repeatMode);
                }
            });
        }
        final int shuffleMode = this.getShuffleMode();
        if (oldAgent.getShuffleMode() != shuffleMode) {
            this.notifyToAllControllers(new NotifyRunnable(){

                @Override
                public void run(MediaSession2.ControllerCb callback) throws RemoteException {
                    callback.onShuffleModeChanged(shuffleMode);
                }
            });
        }
    }

    private void notifyPlayerUpdatedNotLocked(BaseMediaPlayer oldPlayer) {
        float speed;
        final long currentTimeMs = SystemClock.elapsedRealtime();
        final long positionMs = this.getCurrentPosition();
        final int playerState = this.getPlayerState();
        this.notifyToAllControllers(new NotifyRunnable(){

            @Override
            public void run(MediaSession2.ControllerCb callback) throws RemoteException {
                callback.onPlayerStateChanged(currentTimeMs, positionMs, playerState);
            }
        });
        final MediaItem2 item = this.getCurrentMediaItem();
        if (item != null) {
            final int bufferingState = this.getBufferingState();
            final long bufferedPositionMs = this.getBufferedPosition();
            this.notifyToAllControllers(new NotifyRunnable(){

                @Override
                public void run(MediaSession2.ControllerCb callback) throws RemoteException {
                    callback.onBufferingStateChanged(item, bufferingState, bufferedPositionMs);
                }
            });
        }
        if ((speed = this.getPlaybackSpeed()) != oldPlayer.getPlaybackSpeed()) {
            this.notifyToAllControllers(new NotifyRunnable(){

                @Override
                public void run(MediaSession2.ControllerCb callback) throws RemoteException {
                    callback.onPlaybackSpeedChanged(currentTimeMs, positionMs, speed);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyPlaylistChangedOnExecutor(MediaPlaylistAgent playlistAgent, final List<MediaItem2> list, final MediaMetadata2 metadata) {
        Object object = this.mLock;
        synchronized (object) {
            if (playlistAgent != this.mPlaylistAgent) {
                return;
            }
        }
        this.mCallback.onPlaylistChanged(this.mInstance, playlistAgent, list, metadata);
        this.notifyToAllControllers(new NotifyRunnable(){

            @Override
            public void run(MediaSession2.ControllerCb callback) throws RemoteException {
                callback.onPlaylistChanged(list, metadata);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyPlaylistMetadataChangedOnExecutor(MediaPlaylistAgent playlistAgent, final MediaMetadata2 metadata) {
        Object object = this.mLock;
        synchronized (object) {
            if (playlistAgent != this.mPlaylistAgent) {
                return;
            }
        }
        this.mCallback.onPlaylistMetadataChanged(this.mInstance, playlistAgent, metadata);
        this.notifyToAllControllers(new NotifyRunnable(){

            @Override
            public void run(MediaSession2.ControllerCb callback) throws RemoteException {
                callback.onPlaylistMetadataChanged(metadata);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyRepeatModeChangedOnExecutor(MediaPlaylistAgent playlistAgent, final int repeatMode) {
        Object object = this.mLock;
        synchronized (object) {
            if (playlistAgent != this.mPlaylistAgent) {
                return;
            }
        }
        this.mCallback.onRepeatModeChanged(this.mInstance, playlistAgent, repeatMode);
        this.notifyToAllControllers(new NotifyRunnable(){

            @Override
            public void run(MediaSession2.ControllerCb callback) throws RemoteException {
                callback.onRepeatModeChanged(repeatMode);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyShuffleModeChangedOnExecutor(MediaPlaylistAgent playlistAgent, final int shuffleMode) {
        Object object = this.mLock;
        synchronized (object) {
            if (playlistAgent != this.mPlaylistAgent) {
                return;
            }
        }
        this.mCallback.onShuffleModeChanged(this.mInstance, playlistAgent, shuffleMode);
        this.notifyToAllControllers(new NotifyRunnable(){

            @Override
            public void run(MediaSession2.ControllerCb callback) throws RemoteException {
                callback.onShuffleModeChanged(shuffleMode);
            }
        });
    }

    void notifyToController(final @NonNull MediaSession2.ControllerInfo controller, @NonNull NotifyRunnable runnable) {
        if (controller == null) {
            return;
        }
        try {
            runnable.run(controller.getControllerCb());
        }
        catch (DeadObjectException e) {
            if (DEBUG) {
                Log.d((String)TAG, (String)(controller.toString() + " is gone"), (Throwable)e);
            }
            this.mSession2Stub.removeControllerInfo(controller);
            this.mCallbackExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    MediaSession2ImplBase.this.mCallback.onDisconnected(MediaSession2ImplBase.this.getInstance(), controller);
                }
            });
        }
        catch (RemoteException e) {
            Log.w((String)TAG, (String)("Exception in " + controller.toString()), (Throwable)e);
        }
    }

    void notifyToAllControllers(@NonNull NotifyRunnable runnable) {
        List<MediaSession2.ControllerInfo> controllers = this.getConnectedControllers();
        for (int i = 0; i < controllers.size(); ++i) {
            this.notifyToController(controllers.get(i), runnable);
        }
    }

    private static class MyPlaylistEventCallback
    extends MediaPlaylistAgent.PlaylistEventCallback {
        private final WeakReference<MediaSession2ImplBase> mSession;

        private MyPlaylistEventCallback(MediaSession2ImplBase session) {
            this.mSession = new WeakReference<MediaSession2ImplBase>(session);
        }

        @Override
        public void onPlaylistChanged(MediaPlaylistAgent playlistAgent, List<MediaItem2> list, MediaMetadata2 metadata) {
            MediaSession2ImplBase session = (MediaSession2ImplBase)this.mSession.get();
            if (session == null) {
                return;
            }
            session.notifyPlaylistChangedOnExecutor(playlistAgent, list, metadata);
        }

        @Override
        public void onPlaylistMetadataChanged(MediaPlaylistAgent playlistAgent, MediaMetadata2 metadata) {
            MediaSession2ImplBase session = (MediaSession2ImplBase)this.mSession.get();
            if (session == null) {
                return;
            }
            session.notifyPlaylistMetadataChangedOnExecutor(playlistAgent, metadata);
        }

        @Override
        public void onRepeatModeChanged(MediaPlaylistAgent playlistAgent, int repeatMode) {
            MediaSession2ImplBase session = (MediaSession2ImplBase)this.mSession.get();
            if (session == null) {
                return;
            }
            session.notifyRepeatModeChangedOnExecutor(playlistAgent, repeatMode);
        }

        @Override
        public void onShuffleModeChanged(MediaPlaylistAgent playlistAgent, int shuffleMode) {
            MediaSession2ImplBase session = (MediaSession2ImplBase)this.mSession.get();
            if (session == null) {
                return;
            }
            session.notifyShuffleModeChangedOnExecutor(playlistAgent, shuffleMode);
        }
    }

    private static class MyPlayerEventCallback
    extends BaseMediaPlayer.PlayerEventCallback {
        private final WeakReference<MediaSession2ImplBase> mSession;

        private MyPlayerEventCallback(MediaSession2ImplBase session) {
            this.mSession = new WeakReference<MediaSession2ImplBase>(session);
        }

        @Override
        public void onCurrentDataSourceChanged(final BaseMediaPlayer player, final DataSourceDesc dsd) {
            final MediaSession2ImplBase session = this.getSession();
            if (session == null) {
                return;
            }
            session.getCallbackExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    MediaItem2 item;
                    if (dsd == null) {
                        item = null;
                    } else {
                        item = MyPlayerEventCallback.this.getMediaItem(session, dsd);
                        if (item == null) {
                            Log.w((String)MediaSession2ImplBase.TAG, (String)("Cannot obtain media item from the dsd=" + dsd));
                            return;
                        }
                    }
                    session.getCallback().onCurrentMediaItemChanged(session.getInstance(), player, item);
                    session.notifyToAllControllers(new NotifyRunnable(){

                        @Override
                        public void run(MediaSession2.ControllerCb callback) throws RemoteException {
                            callback.onCurrentMediaItemChanged(item);
                        }
                    });
                }
            });
        }

        @Override
        public void onMediaPrepared(final BaseMediaPlayer mpb, final DataSourceDesc dsd) {
            final MediaSession2ImplBase session = this.getSession();
            if (session == null || dsd == null) {
                return;
            }
            session.getCallbackExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    MediaItem2 item = MyPlayerEventCallback.this.getMediaItem(session, dsd);
                    if (item == null) {
                        return;
                    }
                    if (item.equals(session.getCurrentMediaItem())) {
                        long duration = session.getDuration();
                        if (duration < 0L) {
                            return;
                        }
                        MediaMetadata2 metadata = item.getMetadata();
                        if (metadata != null) {
                            if (!metadata.containsKey("android.media.metadata.DURATION")) {
                                metadata = new MediaMetadata2.Builder(metadata).putLong("android.media.metadata.DURATION", duration).build();
                            } else {
                                long durationFromMetadata = metadata.getLong("android.media.metadata.DURATION");
                                if (duration != durationFromMetadata) {
                                    Log.w((String)MediaSession2ImplBase.TAG, (String)("duration mismatch for an item. duration from player=" + duration + " duration from metadata=" + durationFromMetadata + ". May be a timing issue?"));
                                }
                                metadata = null;
                            }
                        } else {
                            metadata = new MediaMetadata2.Builder().putLong("android.media.metadata.DURATION", duration).putString("android.media.metadata.MEDIA_ID", item.getMediaId()).build();
                        }
                        if (metadata != null) {
                            item.setMetadata(metadata);
                            session.notifyToAllControllers(new NotifyRunnable(){

                                @Override
                                public void run(MediaSession2.ControllerCb callback) throws RemoteException {
                                    callback.onPlaylistChanged(session.getPlaylist(), session.getPlaylistMetadata());
                                }
                            });
                        }
                    }
                    session.getCallback().onMediaPrepared(session.getInstance(), mpb, item);
                }
            });
        }

        @Override
        public void onPlayerStateChanged(final BaseMediaPlayer player, final int state) {
            final MediaSession2ImplBase session = this.getSession();
            if (session == null) {
                return;
            }
            session.getCallbackExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    session.mAudioFocusHandler.onPlayerStateChanged(state);
                    session.getCallback().onPlayerStateChanged(session.getInstance(), player, state);
                    session.notifyToAllControllers(new NotifyRunnable(){

                        @Override
                        public void run(MediaSession2.ControllerCb callback) throws RemoteException {
                            callback.onPlayerStateChanged(SystemClock.elapsedRealtime(), player.getCurrentPosition(), state);
                        }
                    });
                }
            });
        }

        @Override
        public void onBufferingStateChanged(final BaseMediaPlayer mpb, final DataSourceDesc dsd, final int state) {
            final MediaSession2ImplBase session = this.getSession();
            if (session == null || dsd == null) {
                return;
            }
            session.getCallbackExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    final MediaItem2 item = MyPlayerEventCallback.this.getMediaItem(session, dsd);
                    if (item == null) {
                        return;
                    }
                    session.getCallback().onBufferingStateChanged(session.getInstance(), mpb, item, state);
                    session.notifyToAllControllers(new NotifyRunnable(){

                        @Override
                        public void run(MediaSession2.ControllerCb callback) throws RemoteException {
                            callback.onBufferingStateChanged(item, state, mpb.getBufferedPosition());
                        }
                    });
                }
            });
        }

        @Override
        public void onPlaybackSpeedChanged(final BaseMediaPlayer mpb, final float speed) {
            final MediaSession2ImplBase session = this.getSession();
            if (session == null) {
                return;
            }
            session.getCallbackExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    session.getCallback().onPlaybackSpeedChanged(session.getInstance(), mpb, speed);
                    session.notifyToAllControllers(new NotifyRunnable(){

                        @Override
                        public void run(MediaSession2.ControllerCb callback) throws RemoteException {
                            callback.onPlaybackSpeedChanged(SystemClock.elapsedRealtime(), session.getCurrentPosition(), speed);
                        }
                    });
                }
            });
        }

        @Override
        public void onSeekCompleted(final BaseMediaPlayer mpb, final long position) {
            final MediaSession2ImplBase session = this.getSession();
            if (session == null) {
                return;
            }
            session.getCallbackExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    session.getCallback().onSeekCompleted(session.getInstance(), mpb, position);
                    session.notifyToAllControllers(new NotifyRunnable(){

                        @Override
                        public void run(MediaSession2.ControllerCb callback) throws RemoteException {
                            callback.onSeekCompleted(SystemClock.elapsedRealtime(), session.getCurrentPosition(), position);
                        }
                    });
                }
            });
        }

        private MediaSession2ImplBase getSession() {
            MediaSession2ImplBase session = (MediaSession2ImplBase)this.mSession.get();
            if (session == null && DEBUG) {
                Log.d((String)MediaSession2ImplBase.TAG, (String)"Session is closed", (Throwable)new IllegalStateException());
            }
            return session;
        }

        private MediaItem2 getMediaItem(MediaSession2ImplBase session, DataSourceDesc dsd) {
            MediaPlaylistAgent agent = session.getPlaylistAgent();
            if (agent == null) {
                if (DEBUG) {
                    Log.d((String)MediaSession2ImplBase.TAG, (String)"Session is closed", (Throwable)new IllegalStateException());
                }
                return null;
            }
            MediaItem2 item = agent.getMediaItem(dsd);
            if (item == null && DEBUG) {
                Log.d((String)MediaSession2ImplBase.TAG, (String)("Could not find matching item for dsd=" + dsd), (Throwable)new NoSuchElementException());
            }
            return item;
        }
    }

    @FunctionalInterface
    static interface NotifyRunnable {
        public void run(MediaSession2.ControllerCb var1) throws RemoteException;
    }
}

