/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.media;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.IBinder;
import android.support.annotation.GuardedBy;
import android.support.v4.media.MediaSession2;
import android.support.v4.media.MediaSessionService2;
import android.support.v4.media.SessionToken2;
import android.util.Log;

class MediaSessionService2ImplBase
implements MediaSessionService2.SupportLibraryImpl {
    private static final String TAG = "MSS2ImplBase";
    private static final boolean DEBUG = true;
    private final Object mLock = new Object();
    @GuardedBy(value="mLock")
    private MediaSession2 mSession;

    MediaSessionService2ImplBase() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onCreate(MediaSessionService2 service) {
        SessionToken2 token = new SessionToken2((Context)service, new ComponentName((Context)service, ((Object)((Object)service)).getClass().getName()));
        if (token.getType() != this.getSessionType()) {
            throw new RuntimeException("Expected session type " + this.getSessionType() + " but was " + token.getType());
        }
        MediaSession2 session = service.onCreateSession(token.getId());
        Object object = this.mLock;
        synchronized (object) {
            this.mSession = session;
            if (this.mSession == null || !token.getId().equals(this.mSession.getToken().getId()) || this.mSession.getToken().getType() != this.getSessionType()) {
                this.mSession = null;
                throw new RuntimeException("Expected session with id " + token.getId() + " and type " + token.getType() + ", but got " + this.mSession);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IBinder onBind(Intent intent) {
        if ("android.media.MediaSessionService2".equals(intent.getAction())) {
            Object object = this.mLock;
            synchronized (object) {
                if (this.mSession != null) {
                    return this.mSession.getSessionBinder();
                }
                Log.d((String)TAG, (String)"Session hasn't created");
            }
        }
        return null;
    }

    @Override
    public MediaSessionService2.MediaNotification onUpdateNotification() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MediaSession2 getSession() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mSession;
        }
    }

    @Override
    public int getSessionType() {
        return 1;
    }
}

