/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.media.subtitle;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.media.MediaFormat;
import android.support.annotation.RequiresApi;
import android.support.annotation.RestrictTo;
import android.support.mediacompat.R;
import android.support.v4.media.subtitle.Cea608CCParser;
import android.support.v4.media.subtitle.ClosedCaptionWidget;
import android.support.v4.media.subtitle.SubtitleController;
import android.support.v4.media.subtitle.SubtitleTrack;
import android.text.Spannable;
import android.text.SpannableStringBuilder;
import android.text.TextPaint;
import android.util.AttributeSet;
import android.view.View;
import android.view.accessibility.CaptioningManager;
import android.widget.LinearLayout;
import android.widget.TextView;
import java.util.ArrayList;

@RequiresApi(value=28)
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class ClosedCaptionRenderer
extends SubtitleController.Renderer {
    private final Context mContext;
    private Cea608CCWidget mCCWidget;

    public ClosedCaptionRenderer(Context context) {
        this.mContext = context;
    }

    @Override
    public boolean supports(MediaFormat format) {
        if (format.containsKey("mime")) {
            String mimeType = format.getString("mime");
            return "text/cea-608".equals(mimeType);
        }
        return false;
    }

    @Override
    public SubtitleTrack createTrack(MediaFormat format) {
        String mimeType = format.getString("mime");
        if ("text/cea-608".equals(mimeType)) {
            if (this.mCCWidget == null) {
                this.mCCWidget = new Cea608CCWidget(this.mContext);
            }
            return new Cea608CaptionTrack(this.mCCWidget, format);
        }
        throw new RuntimeException("No matching format: " + format.toString());
    }

    class Cea608CCWidget
    extends ClosedCaptionWidget
    implements Cea608CCParser.DisplayListener {
        private static final String DUMMY_TEXT = "1234567890123456789012345678901234";
        private final Rect mTextBounds;

        Cea608CCWidget(Context context) {
            this(context, null);
        }

        Cea608CCWidget(Context context, AttributeSet attrs) {
            this(context, attrs, 0);
        }

        Cea608CCWidget(Context context, AttributeSet attrs, int defStyle) {
            this(context, attrs, defStyle, 0);
        }

        Cea608CCWidget(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
            super(context, attrs, defStyleAttr, defStyleRes);
            this.mTextBounds = new Rect();
        }

        @Override
        public ClosedCaptionWidget.ClosedCaptionLayout createCaptionLayout(Context context) {
            return new CCLayout(context);
        }

        @Override
        public void onDisplayChanged(SpannableStringBuilder[] styledTexts) {
            ((CCLayout)this.mClosedCaptionLayout).update(styledTexts);
            if (this.mListener != null) {
                this.mListener.onChanged(this);
            }
        }

        @Override
        public CaptioningManager.CaptionStyle getCaptionStyle() {
            return this.mCaptionStyle;
        }

        private class CCLayout
        extends LinearLayout
        implements ClosedCaptionWidget.ClosedCaptionLayout {
            private static final int MAX_ROWS = 15;
            private static final float SAFE_AREA_RATIO = 0.9f;
            private final CCLineBox[] mLineBoxes;

            CCLayout(Context context) {
                super(context);
                this.mLineBoxes = new CCLineBox[15];
                this.setGravity(0x800003);
                this.setOrientation(1);
                for (int i = 0; i < 15; ++i) {
                    this.mLineBoxes[i] = new CCLineBox(this.getContext());
                    this.addView((View)this.mLineBoxes[i], -2, -2);
                }
            }

            @Override
            public void setCaptionStyle(CaptioningManager.CaptionStyle captionStyle) {
                for (int i = 0; i < 15; ++i) {
                    this.mLineBoxes[i].setCaptionStyle(captionStyle);
                }
            }

            @Override
            public void setFontScale(float fontScale) {
            }

            void update(SpannableStringBuilder[] textBuffer) {
                for (int i = 0; i < 15; ++i) {
                    if (textBuffer[i] != null) {
                        this.mLineBoxes[i].setText((CharSequence)textBuffer[i], TextView.BufferType.SPANNABLE);
                        this.mLineBoxes[i].setVisibility(0);
                        continue;
                    }
                    this.mLineBoxes[i].setVisibility(4);
                }
            }

            protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
                super.onMeasure(widthMeasureSpec, heightMeasureSpec);
                int safeWidth = this.getMeasuredWidth();
                int safeHeight = this.getMeasuredHeight();
                if (safeWidth * 3 >= safeHeight * 4) {
                    safeWidth = safeHeight * 4 / 3;
                } else {
                    safeHeight = safeWidth * 3 / 4;
                }
                safeWidth = (int)((float)safeWidth * 0.9f);
                safeHeight = (int)((float)safeHeight * 0.9f);
                int lineHeight = safeHeight / 15;
                int lineHeightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)lineHeight, (int)0x40000000);
                int lineWidthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)safeWidth, (int)0x40000000);
                for (int i = 0; i < 15; ++i) {
                    this.mLineBoxes[i].measure(lineWidthMeasureSpec, lineHeightMeasureSpec);
                }
            }

            protected void onLayout(boolean changed, int l, int t, int r, int b) {
                int safeHeight;
                int safeWidth;
                int viewPortWidth = r - l;
                int viewPortHeight = b - t;
                if (viewPortWidth * 3 >= viewPortHeight * 4) {
                    safeWidth = viewPortHeight * 4 / 3;
                    safeHeight = viewPortHeight;
                } else {
                    safeWidth = viewPortWidth;
                    safeHeight = viewPortWidth * 3 / 4;
                }
                safeWidth = (int)((float)safeWidth * 0.9f);
                safeHeight = (int)((float)safeHeight * 0.9f);
                int left = (viewPortWidth - safeWidth) / 2;
                int top = (viewPortHeight - safeHeight) / 2;
                for (int i = 0; i < 15; ++i) {
                    this.mLineBoxes[i].layout(left, top + safeHeight * i / 15, left + safeWidth, top + safeHeight * (i + 1) / 15);
                }
            }
        }

        private class CCLineBox
        extends TextView {
            private static final float FONT_PADDING_RATIO = 0.75f;
            private static final float EDGE_OUTLINE_RATIO = 0.1f;
            private static final float EDGE_SHADOW_RATIO = 0.05f;
            private float mOutlineWidth;
            private float mShadowRadius;
            private float mShadowOffset;
            private int mTextColor;
            private int mBgColor;
            private int mEdgeType;
            private int mEdgeColor;

            CCLineBox(Context context) {
                super(context);
                this.mTextColor = -1;
                this.mBgColor = -16777216;
                this.mEdgeType = 0;
                this.mEdgeColor = 0;
                this.setGravity(17);
                this.setBackgroundColor(0);
                this.setTextColor(-1);
                this.setTypeface(Typeface.MONOSPACE);
                this.setVisibility(4);
                Resources res = this.getContext().getResources();
                this.mOutlineWidth = res.getDimensionPixelSize(R.dimen.subtitle_outline_width);
                this.mShadowRadius = res.getDimensionPixelSize(R.dimen.subtitle_shadow_radius);
                this.mShadowOffset = res.getDimensionPixelSize(R.dimen.subtitle_shadow_offset);
            }

            void setCaptionStyle(CaptioningManager.CaptionStyle captionStyle) {
                this.mTextColor = captionStyle.foregroundColor;
                this.mBgColor = captionStyle.backgroundColor;
                this.mEdgeType = captionStyle.edgeType;
                this.mEdgeColor = captionStyle.edgeColor;
                this.setTextColor(this.mTextColor);
                if (this.mEdgeType == 2) {
                    this.setShadowLayer(this.mShadowRadius, this.mShadowOffset, this.mShadowOffset, this.mEdgeColor);
                } else {
                    this.setShadowLayer(0.0f, 0.0f, 0.0f, 0);
                }
                this.invalidate();
            }

            protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
                float fontSize = (float)View.MeasureSpec.getSize((int)heightMeasureSpec) * 0.75f;
                this.setTextSize(0, fontSize);
                this.mOutlineWidth = 0.1f * fontSize + 1.0f;
                this.mShadowOffset = this.mShadowRadius = 0.05f * fontSize + 1.0f;
                this.setScaleX(1.0f);
                this.getPaint().getTextBounds(Cea608CCWidget.DUMMY_TEXT, 0, Cea608CCWidget.DUMMY_TEXT.length(), Cea608CCWidget.this.mTextBounds);
                float actualTextWidth = Cea608CCWidget.this.mTextBounds.width();
                float requiredTextWidth = View.MeasureSpec.getSize((int)widthMeasureSpec);
                this.setScaleX(requiredTextWidth / actualTextWidth);
                super.onMeasure(widthMeasureSpec, heightMeasureSpec);
            }

            protected void onDraw(Canvas c) {
                if (this.mEdgeType == -1 || this.mEdgeType == 0 || this.mEdgeType == 2) {
                    super.onDraw(c);
                    return;
                }
                if (this.mEdgeType == 1) {
                    this.drawEdgeOutline(c);
                } else {
                    this.drawEdgeRaisedOrDepressed(c);
                }
            }

            private void drawEdgeOutline(Canvas c) {
                TextPaint textPaint = this.getPaint();
                Paint.Style previousStyle = textPaint.getStyle();
                Paint.Join previousJoin = textPaint.getStrokeJoin();
                float previousWidth = textPaint.getStrokeWidth();
                this.setTextColor(this.mEdgeColor);
                textPaint.setStyle(Paint.Style.FILL_AND_STROKE);
                textPaint.setStrokeJoin(Paint.Join.ROUND);
                textPaint.setStrokeWidth(this.mOutlineWidth);
                super.onDraw(c);
                this.setTextColor(this.mTextColor);
                textPaint.setStyle(previousStyle);
                textPaint.setStrokeJoin(previousJoin);
                textPaint.setStrokeWidth(previousWidth);
                this.setBackgroundSpans(0);
                super.onDraw(c);
                this.setBackgroundSpans(this.mBgColor);
            }

            private void drawEdgeRaisedOrDepressed(Canvas c) {
                TextPaint textPaint = this.getPaint();
                Paint.Style previousStyle = textPaint.getStyle();
                textPaint.setStyle(Paint.Style.FILL);
                boolean raised = this.mEdgeType == 3;
                int colorUp = raised ? -1 : this.mEdgeColor;
                int colorDown = raised ? this.mEdgeColor : -1;
                float offset = this.mShadowRadius / 2.0f;
                this.setShadowLayer(this.mShadowRadius, -offset, -offset, colorUp);
                super.onDraw(c);
                this.setBackgroundSpans(0);
                this.setShadowLayer(this.mShadowRadius, offset, offset, colorDown);
                super.onDraw(c);
                textPaint.setStyle(previousStyle);
                this.setBackgroundSpans(this.mBgColor);
            }

            private void setBackgroundSpans(int color2) {
                CharSequence text = this.getText();
                if (text instanceof Spannable) {
                    Spannable spannable = (Spannable)text;
                    Cea608CCParser.MutableBackgroundColorSpan[] bgSpans = (Cea608CCParser.MutableBackgroundColorSpan[])spannable.getSpans(0, spannable.length(), Cea608CCParser.MutableBackgroundColorSpan.class);
                    for (int i = 0; i < bgSpans.length; ++i) {
                        bgSpans[i].setBackgroundColor(color2);
                    }
                }
            }
        }
    }

    static class Cea608CaptionTrack
    extends SubtitleTrack {
        private final Cea608CCParser mCCParser;
        private final Cea608CCWidget mRenderingWidget;

        Cea608CaptionTrack(Cea608CCWidget renderingWidget, MediaFormat format) {
            super(format);
            this.mRenderingWidget = renderingWidget;
            this.mCCParser = new Cea608CCParser(this.mRenderingWidget);
        }

        @Override
        public void onData(byte[] data, boolean eos, long runID) {
            this.mCCParser.parse(data);
        }

        @Override
        public SubtitleTrack.RenderingWidget getRenderingWidget() {
            return this.mRenderingWidget;
        }

        @Override
        public void updateView(ArrayList<SubtitleTrack.Cue> activeCues) {
        }
    }
}

