/*
 * Decompiled with CFR 0.152.
 */
package android.support.v13.app;

import android.app.Activity;
import android.app.Fragment;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.RequiresApi;
import java.util.Arrays;

public class FragmentCompat {
    static final FragmentCompatImpl IMPL = Build.VERSION.SDK_INT >= 24 ? new FragmentCompatApi24Impl() : (Build.VERSION.SDK_INT >= 23 ? new FragmentCompatApi23Impl() : (Build.VERSION.SDK_INT >= 15 ? new FragmentCompatApi15Impl() : new FragmentCompatBaseImpl()));

    @Deprecated
    public static void setMenuVisibility(Fragment f, boolean visible) {
        f.setMenuVisibility(visible);
    }

    public static void setUserVisibleHint(Fragment f, boolean deferStart) {
        IMPL.setUserVisibleHint(f, deferStart);
    }

    public static void requestPermissions(@NonNull Fragment fragment, @NonNull String[] permissions, int requestCode) {
        IMPL.requestPermissions(fragment, permissions, requestCode);
    }

    public static boolean shouldShowRequestPermissionRationale(@NonNull Fragment fragment, @NonNull String permission) {
        return IMPL.shouldShowRequestPermissionRationale(fragment, permission);
    }

    public static interface OnRequestPermissionsResultCallback {
        public void onRequestPermissionsResult(int var1, @NonNull String[] var2, @NonNull int[] var3);
    }

    @RequiresApi(value=24)
    static class FragmentCompatApi24Impl
    extends FragmentCompatApi23Impl {
        FragmentCompatApi24Impl() {
        }

        @Override
        public void setUserVisibleHint(Fragment f, boolean deferStart) {
            f.setUserVisibleHint(deferStart);
        }
    }

    @RequiresApi(value=23)
    static class FragmentCompatApi23Impl
    extends FragmentCompatApi15Impl {
        FragmentCompatApi23Impl() {
        }

        @Override
        public void requestPermissions(Fragment fragment, String[] permissions, int requestCode) {
            fragment.requestPermissions(permissions, requestCode);
        }

        @Override
        public boolean shouldShowRequestPermissionRationale(Fragment fragment, String permission) {
            return fragment.shouldShowRequestPermissionRationale(permission);
        }
    }

    @RequiresApi(value=15)
    static class FragmentCompatApi15Impl
    extends FragmentCompatBaseImpl {
        FragmentCompatApi15Impl() {
        }

        @Override
        public void setUserVisibleHint(Fragment f, boolean deferStart) {
            f.setUserVisibleHint(deferStart);
        }
    }

    static class FragmentCompatBaseImpl
    implements FragmentCompatImpl {
        FragmentCompatBaseImpl() {
        }

        @Override
        public void setUserVisibleHint(Fragment f, boolean deferStart) {
        }

        @Override
        public void requestPermissions(final Fragment fragment, final String[] permissions, final int requestCode) {
            Handler handler = new Handler(Looper.getMainLooper());
            handler.post(new Runnable(){

                @Override
                public void run() {
                    int[] grantResults = new int[permissions.length];
                    Activity context = fragment.getActivity();
                    if (context != null) {
                        PackageManager packageManager = context.getPackageManager();
                        String packageName = context.getPackageName();
                        int permissionCount = permissions.length;
                        for (int i = 0; i < permissionCount; ++i) {
                            grantResults[i] = packageManager.checkPermission(permissions[i], packageName);
                        }
                    } else {
                        Arrays.fill(grantResults, -1);
                    }
                    ((OnRequestPermissionsResultCallback)fragment).onRequestPermissionsResult(requestCode, permissions, grantResults);
                }
            });
        }

        @Override
        public boolean shouldShowRequestPermissionRationale(Fragment fragment, String permission) {
            return false;
        }
    }

    static interface FragmentCompatImpl {
        public void setUserVisibleHint(Fragment var1, boolean var2);

        public void requestPermissions(Fragment var1, String[] var2, int var3);

        public boolean shouldShowRequestPermissionRationale(Fragment var1, String var2);
    }
}

