/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.view;

import android.os.Build;
import android.support.v4.view.ViewCompat;
import android.support.v4.view.ViewPropertyAnimatorCompatICS;
import android.support.v4.view.ViewPropertyAnimatorCompatJB;
import android.support.v4.view.ViewPropertyAnimatorCompatJellybeanMr2;
import android.support.v4.view.ViewPropertyAnimatorListener;
import android.view.View;
import android.view.animation.Interpolator;
import java.lang.ref.WeakReference;

public class ViewPropertyAnimatorCompat {
    private static final String TAG = "ViewAnimatorCompat";
    private WeakReference<View> mView;
    static final ViewPropertyAnimatorCompatImpl IMPL;

    ViewPropertyAnimatorCompat(View view) {
        this.mView = new WeakReference<View>(view);
    }

    public ViewPropertyAnimatorCompat setDuration(long value) {
        View view = (View)this.mView.get();
        if (view != null) {
            IMPL.setDuration(view, value);
        }
        return this;
    }

    public ViewPropertyAnimatorCompat alpha(float value) {
        View view = (View)this.mView.get();
        if (view != null) {
            IMPL.alpha(view, value);
        }
        return this;
    }

    public ViewPropertyAnimatorCompat alphaBy(float value) {
        View view = (View)this.mView.get();
        if (view != null) {
            IMPL.alphaBy(view, value);
        }
        return this;
    }

    public ViewPropertyAnimatorCompat translationX(float value) {
        View view = (View)this.mView.get();
        if (view != null) {
            IMPL.translationX(view, value);
        }
        return this;
    }

    public ViewPropertyAnimatorCompat translationY(float value) {
        View view = (View)this.mView.get();
        if (view != null) {
            IMPL.translationY(view, value);
        }
        return this;
    }

    public ViewPropertyAnimatorCompat withEndAction(Runnable runnable) {
        View view = (View)this.mView.get();
        if (view != null) {
            IMPL.withEndAction(view, runnable);
        }
        return this;
    }

    public long getDuration() {
        View view = (View)this.mView.get();
        if (view != null) {
            return IMPL.getDuration(view);
        }
        return 0L;
    }

    public ViewPropertyAnimatorCompat setInterpolator(Interpolator value) {
        View view = (View)this.mView.get();
        if (view != null) {
            IMPL.setInterpolator(view, value);
        }
        return this;
    }

    public Interpolator getInterpolator() {
        View view = (View)this.mView.get();
        if (view != null) {
            return IMPL.getInterpolator(view);
        }
        return null;
    }

    public ViewPropertyAnimatorCompat setStartDelay(long value) {
        View view = (View)this.mView.get();
        if (view != null) {
            IMPL.setStartDelay(view, value);
        }
        return this;
    }

    public long getStartDelay() {
        View view = (View)this.mView.get();
        if (view != null) {
            return IMPL.getStartDelay(view);
        }
        return 0L;
    }

    public ViewPropertyAnimatorCompat rotation(float value) {
        View view = (View)this.mView.get();
        if (view != null) {
            IMPL.rotation(view, value);
        }
        return this;
    }

    public ViewPropertyAnimatorCompat rotationBy(float value) {
        View view = (View)this.mView.get();
        if (view != null) {
            IMPL.rotationBy(view, value);
        }
        return this;
    }

    public ViewPropertyAnimatorCompat rotationX(float value) {
        View view = (View)this.mView.get();
        if (view != null) {
            IMPL.rotationX(view, value);
        }
        return this;
    }

    public ViewPropertyAnimatorCompat rotationXBy(float value) {
        View view = (View)this.mView.get();
        if (view != null) {
            IMPL.rotationXBy(view, value);
        }
        return this;
    }

    public ViewPropertyAnimatorCompat rotationY(float value) {
        View view = (View)this.mView.get();
        if (view != null) {
            IMPL.rotationY(view, value);
        }
        return this;
    }

    public ViewPropertyAnimatorCompat rotationYBy(float value) {
        View view = (View)this.mView.get();
        if (view != null) {
            IMPL.rotationYBy(view, value);
        }
        return this;
    }

    public ViewPropertyAnimatorCompat scaleX(float value) {
        View view = (View)this.mView.get();
        if (view != null) {
            IMPL.scaleX(view, value);
        }
        return this;
    }

    public ViewPropertyAnimatorCompat scaleXBy(float value) {
        View view = (View)this.mView.get();
        if (view != null) {
            IMPL.scaleXBy(view, value);
        }
        return this;
    }

    public ViewPropertyAnimatorCompat scaleY(float value) {
        View view = (View)this.mView.get();
        if (view != null) {
            IMPL.scaleY(view, value);
        }
        return this;
    }

    public ViewPropertyAnimatorCompat scaleYBy(float value) {
        View view = (View)this.mView.get();
        if (view != null) {
            IMPL.scaleYBy(view, value);
        }
        return this;
    }

    public void cancel() {
        View view = (View)this.mView.get();
        if (view != null) {
            IMPL.cancel(view);
        }
    }

    public ViewPropertyAnimatorCompat x(float value) {
        View view = (View)this.mView.get();
        if (view != null) {
            IMPL.x(view, value);
        }
        return this;
    }

    public ViewPropertyAnimatorCompat xBy(float value) {
        View view = (View)this.mView.get();
        if (view != null) {
            IMPL.xBy(view, value);
        }
        return this;
    }

    public ViewPropertyAnimatorCompat y(float value) {
        View view = (View)this.mView.get();
        if (view != null) {
            IMPL.y(view, value);
        }
        return this;
    }

    public ViewPropertyAnimatorCompat yBy(float value) {
        View view = (View)this.mView.get();
        if (view != null) {
            IMPL.yBy(view, value);
        }
        return this;
    }

    public ViewPropertyAnimatorCompat translationXBy(float value) {
        View view = (View)this.mView.get();
        if (view != null) {
            IMPL.translationXBy(view, value);
        }
        return this;
    }

    public ViewPropertyAnimatorCompat translationYBy(float value) {
        View view = (View)this.mView.get();
        if (view != null) {
            IMPL.translationYBy(view, value);
        }
        return this;
    }

    public void start() {
        View view = (View)this.mView.get();
        if (view != null) {
            IMPL.start(view);
        }
    }

    public ViewPropertyAnimatorCompat withLayer() {
        View view = (View)this.mView.get();
        if (view != null) {
            IMPL.withLayer(view);
        }
        return this;
    }

    public ViewPropertyAnimatorCompat withStartAction(Runnable runnable) {
        View view = (View)this.mView.get();
        if (view != null) {
            IMPL.withStartAction(view, runnable);
        }
        return this;
    }

    public ViewPropertyAnimatorCompat setListener(ViewPropertyAnimatorListener listener) {
        View view = (View)this.mView.get();
        if (view != null) {
            IMPL.setListener(view, listener);
        }
        return this;
    }

    static {
        int version = Build.VERSION.SDK_INT;
        IMPL = version >= 18 ? new JBMr2ViewPropertyAnimatorCompatImpl() : (version >= 16 ? new JBViewPropertyAnimatorCompatImpl() : (version >= 14 ? new ICSViewPropertyAnimatorCompatImpl() : new BaseViewPropertyAnimatorCompatImpl()));
    }

    static class JBMr2ViewPropertyAnimatorCompatImpl
    extends JBViewPropertyAnimatorCompatImpl {
        JBMr2ViewPropertyAnimatorCompatImpl() {
        }

        @Override
        public Interpolator getInterpolator(View view) {
            return ViewPropertyAnimatorCompatJellybeanMr2.getInterpolator((View)view);
        }
    }

    static class JBViewPropertyAnimatorCompatImpl
    extends ICSViewPropertyAnimatorCompatImpl {
        JBViewPropertyAnimatorCompatImpl() {
        }

        @Override
        public void withStartAction(View view, Runnable runnable) {
            ViewPropertyAnimatorCompatJB.withStartAction((View)view, (Runnable)runnable);
        }

        @Override
        public void withEndAction(View view, Runnable runnable) {
            ViewPropertyAnimatorCompatJB.withEndAction((View)view, (Runnable)runnable);
        }

        @Override
        public void withLayer(View view) {
            ViewPropertyAnimatorCompatJB.withLayer((View)view);
        }
    }

    static class ICSViewPropertyAnimatorCompatImpl
    extends BaseViewPropertyAnimatorCompatImpl {
        ICSViewPropertyAnimatorCompatImpl() {
        }

        @Override
        public void setDuration(View view, long value) {
            ViewPropertyAnimatorCompatICS.setDuration((View)view, (long)value);
        }

        @Override
        public void alpha(View view, float value) {
            ViewPropertyAnimatorCompatICS.alpha((View)view, (float)value);
        }

        @Override
        public void translationX(View view, float value) {
            ViewPropertyAnimatorCompatICS.translationX((View)view, (float)value);
        }

        @Override
        public void translationY(View view, float value) {
            ViewPropertyAnimatorCompatICS.translationY((View)view, (float)value);
        }

        @Override
        public long getDuration(View view) {
            return ViewPropertyAnimatorCompatICS.getDuration((View)view);
        }

        @Override
        public void setInterpolator(View view, Interpolator value) {
            ViewPropertyAnimatorCompatICS.setInterpolator((View)view, (Interpolator)value);
        }

        @Override
        public void setStartDelay(View view, long value) {
            ViewPropertyAnimatorCompatICS.setStartDelay((View)view, (long)value);
        }

        @Override
        public long getStartDelay(View view) {
            return ViewPropertyAnimatorCompatICS.getStartDelay((View)view);
        }

        @Override
        public void alphaBy(View view, float value) {
            ViewPropertyAnimatorCompatICS.alphaBy((View)view, (float)value);
        }

        @Override
        public void rotation(View view, float value) {
            ViewPropertyAnimatorCompatICS.rotation((View)view, (float)value);
        }

        @Override
        public void rotationBy(View view, float value) {
            ViewPropertyAnimatorCompatICS.rotationBy((View)view, (float)value);
        }

        @Override
        public void rotationX(View view, float value) {
            ViewPropertyAnimatorCompatICS.rotationX((View)view, (float)value);
        }

        @Override
        public void rotationXBy(View view, float value) {
            ViewPropertyAnimatorCompatICS.rotationXBy((View)view, (float)value);
        }

        @Override
        public void rotationY(View view, float value) {
            ViewPropertyAnimatorCompatICS.rotationY((View)view, (float)value);
        }

        @Override
        public void rotationYBy(View view, float value) {
            ViewPropertyAnimatorCompatICS.rotationYBy((View)view, (float)value);
        }

        @Override
        public void scaleX(View view, float value) {
            ViewPropertyAnimatorCompatICS.scaleX((View)view, (float)value);
        }

        @Override
        public void scaleXBy(View view, float value) {
            ViewPropertyAnimatorCompatICS.scaleXBy((View)view, (float)value);
        }

        @Override
        public void scaleY(View view, float value) {
            ViewPropertyAnimatorCompatICS.scaleY((View)view, (float)value);
        }

        @Override
        public void scaleYBy(View view, float value) {
            ViewPropertyAnimatorCompatICS.scaleYBy((View)view, (float)value);
        }

        @Override
        public void cancel(View view) {
            ViewPropertyAnimatorCompatICS.cancel((View)view);
        }

        @Override
        public void x(View view, float value) {
            ViewPropertyAnimatorCompatICS.x((View)view, (float)value);
        }

        @Override
        public void xBy(View view, float value) {
            ViewPropertyAnimatorCompatICS.xBy((View)view, (float)value);
        }

        @Override
        public void y(View view, float value) {
            ViewPropertyAnimatorCompatICS.y((View)view, (float)value);
        }

        @Override
        public void yBy(View view, float value) {
            ViewPropertyAnimatorCompatICS.yBy((View)view, (float)value);
        }

        @Override
        public void translationXBy(View view, float value) {
            ViewPropertyAnimatorCompatICS.translationXBy((View)view, (float)value);
        }

        @Override
        public void translationYBy(View view, float value) {
            ViewPropertyAnimatorCompatICS.translationYBy((View)view, (float)value);
        }

        @Override
        public void start(View view) {
            ViewPropertyAnimatorCompatICS.start((View)view);
        }

        @Override
        public void setListener(View view, ViewPropertyAnimatorListener listener) {
            ViewPropertyAnimatorCompatICS.setListener((View)view, (ViewPropertyAnimatorListener)listener);
        }

        @Override
        public void withEndAction(View view, final Runnable runnable) {
            this.setListener(view, new ViewPropertyAnimatorListener(){

                public void onAnimationStart(View view) {
                }

                public void onAnimationEnd(View view) {
                    runnable.run();
                    ICSViewPropertyAnimatorCompatImpl.this.setListener(view, null);
                }

                public void onAnimationCancel(View view) {
                }
            });
        }

        @Override
        public void withStartAction(View view, final Runnable runnable) {
            this.setListener(view, new ViewPropertyAnimatorListener(){

                public void onAnimationStart(View view) {
                    runnable.run();
                    ICSViewPropertyAnimatorCompatImpl.this.setListener(view, null);
                }

                public void onAnimationEnd(View view) {
                }

                public void onAnimationCancel(View view) {
                }
            });
        }

        @Override
        public void withLayer(View view) {
            final int currentLayerType = ViewCompat.getLayerType(view);
            this.setListener(view, new ViewPropertyAnimatorListener(){

                public void onAnimationStart(View view) {
                    ViewCompat.setLayerType(view, 2, null);
                }

                public void onAnimationEnd(View view) {
                    ViewCompat.setLayerType(view, currentLayerType, null);
                    ICSViewPropertyAnimatorCompatImpl.this.setListener(view, null);
                }

                public void onAnimationCancel(View view) {
                }
            });
        }
    }

    static class BaseViewPropertyAnimatorCompatImpl
    implements ViewPropertyAnimatorCompatImpl {
        BaseViewPropertyAnimatorCompatImpl() {
        }

        @Override
        public void setDuration(View view, long value) {
        }

        @Override
        public void alpha(View view, float value) {
        }

        @Override
        public void translationX(View view, float value) {
        }

        @Override
        public void translationY(View view, float value) {
        }

        @Override
        public void withEndAction(View view, Runnable runnable) {
            runnable.run();
        }

        @Override
        public long getDuration(View view) {
            return 0L;
        }

        @Override
        public void setInterpolator(View view, Interpolator value) {
        }

        @Override
        public Interpolator getInterpolator(View view) {
            return null;
        }

        @Override
        public void setStartDelay(View view, long value) {
        }

        @Override
        public long getStartDelay(View view) {
            return 0L;
        }

        @Override
        public void alphaBy(View view, float value) {
        }

        @Override
        public void rotation(View view, float value) {
        }

        @Override
        public void rotationBy(View view, float value) {
        }

        @Override
        public void rotationX(View view, float value) {
        }

        @Override
        public void rotationXBy(View view, float value) {
        }

        @Override
        public void rotationY(View view, float value) {
        }

        @Override
        public void rotationYBy(View view, float value) {
        }

        @Override
        public void scaleX(View view, float value) {
        }

        @Override
        public void scaleXBy(View view, float value) {
        }

        @Override
        public void scaleY(View view, float value) {
        }

        @Override
        public void scaleYBy(View view, float value) {
        }

        @Override
        public void cancel(View view) {
        }

        @Override
        public void x(View view, float value) {
        }

        @Override
        public void xBy(View view, float value) {
        }

        @Override
        public void y(View view, float value) {
        }

        @Override
        public void yBy(View view, float value) {
        }

        @Override
        public void translationXBy(View view, float value) {
        }

        @Override
        public void translationYBy(View view, float value) {
        }

        @Override
        public void start(View view) {
        }

        @Override
        public void withLayer(View view) {
        }

        @Override
        public void withStartAction(View view, Runnable runnable) {
            runnable.run();
        }

        @Override
        public void setListener(View view, ViewPropertyAnimatorListener listener) {
        }
    }

    static interface ViewPropertyAnimatorCompatImpl {
        public void setDuration(View var1, long var2);

        public long getDuration(View var1);

        public void setInterpolator(View var1, Interpolator var2);

        public Interpolator getInterpolator(View var1);

        public void setStartDelay(View var1, long var2);

        public long getStartDelay(View var1);

        public void alpha(View var1, float var2);

        public void alphaBy(View var1, float var2);

        public void rotation(View var1, float var2);

        public void rotationBy(View var1, float var2);

        public void rotationX(View var1, float var2);

        public void rotationXBy(View var1, float var2);

        public void rotationY(View var1, float var2);

        public void rotationYBy(View var1, float var2);

        public void scaleX(View var1, float var2);

        public void scaleXBy(View var1, float var2);

        public void scaleY(View var1, float var2);

        public void scaleYBy(View var1, float var2);

        public void cancel(View var1);

        public void x(View var1, float var2);

        public void xBy(View var1, float var2);

        public void y(View var1, float var2);

        public void yBy(View var1, float var2);

        public void translationX(View var1, float var2);

        public void translationXBy(View var1, float var2);

        public void translationY(View var1, float var2);

        public void translationYBy(View var1, float var2);

        public void start(View var1);

        public void withLayer(View var1);

        public void withStartAction(View var1, Runnable var2);

        public void withEndAction(View var1, Runnable var2);

        public void setListener(View var1, ViewPropertyAnimatorListener var2);
    }
}

