/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.media;

import android.content.Intent;
import android.media.MediaDescription;
import android.media.browse.MediaBrowser;
import android.os.Binder;
import android.os.Build;
import android.os.Bundle;
import android.os.IBinder;
import android.os.Parcel;
import android.os.RemoteException;
import android.support.v4.media.ParceledListSliceAdapterApi21;
import android.support.v4.media.ServiceBinderAdapterApi21;
import android.support.v4.media.ServiceCallbacksAdapterApi21;
import java.util.ArrayList;
import java.util.List;

class MediaBrowserServiceCompatApi21 {
    private static Object sNullParceledListSliceObj;

    MediaBrowserServiceCompatApi21() {
    }

    public static Object createService() {
        return new MediaBrowserServiceAdaptorApi21();
    }

    public static void onCreate(Object serviceObj, ServiceImplApi21 serviceImpl) {
        ((MediaBrowserServiceAdaptorApi21)serviceObj).onCreate(serviceImpl);
    }

    public static IBinder onBind(Object serviceObj, Intent intent) {
        return ((MediaBrowserServiceAdaptorApi21)serviceObj).onBind(intent);
    }

    public static Object parcelListToParceledListSliceObject(List<Parcel> list) {
        if (list == null) {
            if (Build.VERSION.SDK_INT <= 23) {
                return sNullParceledListSliceObj;
            }
            return null;
        }
        ArrayList<MediaBrowser.MediaItem> itemList = new ArrayList<MediaBrowser.MediaItem>();
        for (Parcel parcel : list) {
            parcel.setDataPosition(0);
            itemList.add((MediaBrowser.MediaItem)MediaBrowser.MediaItem.CREATOR.createFromParcel(parcel));
            parcel.recycle();
        }
        return ParceledListSliceAdapterApi21.newInstance(itemList);
    }

    static {
        MediaDescription nullDescription = new MediaDescription.Builder().setMediaId("android.support.v4.media.MediaBrowserCompat.NULL_MEDIA_ITEM").build();
        MediaBrowser.MediaItem nullMediaItem = new MediaBrowser.MediaItem(nullDescription, 0);
        ArrayList<MediaBrowser.MediaItem> nullMediaItemList = new ArrayList<MediaBrowser.MediaItem>();
        nullMediaItemList.add(nullMediaItem);
        sNullParceledListSliceObj = ParceledListSliceAdapterApi21.newInstance(nullMediaItemList);
    }

    static class MediaBrowserServiceAdaptorApi21 {
        Binder mBinder;

        MediaBrowserServiceAdaptorApi21() {
        }

        public void onCreate(ServiceImplApi21 serviceImpl) {
            this.mBinder = this.createServiceBinder(serviceImpl);
        }

        public IBinder onBind(Intent intent) {
            if ("android.media.browse.MediaBrowserService".equals(intent.getAction())) {
                return this.mBinder;
            }
            return null;
        }

        protected Binder createServiceBinder(ServiceImplApi21 serviceImpl) {
            return new ServiceBinderAdapterApi21(serviceImpl);
        }
    }

    public static class ServiceCallbacksImplApi21
    implements ServiceCallbacksApi21 {
        final ServiceCallbacksAdapterApi21 mCallbacks;

        ServiceCallbacksImplApi21(Object callbacksObj) {
            this.mCallbacks = this.createCallbacks(callbacksObj);
        }

        @Override
        public IBinder asBinder() {
            return this.mCallbacks.asBinder();
        }

        @Override
        public void onConnect(String root, Object session, Bundle extras) throws RemoteException {
            this.mCallbacks.onConnect(root, session, extras);
        }

        @Override
        public void onConnectFailed() throws RemoteException {
            this.mCallbacks.onConnectFailed();
        }

        @Override
        public void onLoadChildren(String mediaId, List<Parcel> list) throws RemoteException {
            this.mCallbacks.onLoadChildren(mediaId, MediaBrowserServiceCompatApi21.parcelListToParceledListSliceObject(list));
        }

        ServiceCallbacksAdapterApi21 createCallbacks(Object callbacksObj) {
            return new ServiceCallbacksAdapterApi21(callbacksObj);
        }
    }

    public static interface ServiceCallbacksApi21 {
        public IBinder asBinder();

        public void onConnect(String var1, Object var2, Bundle var3) throws RemoteException;

        public void onConnectFailed() throws RemoteException;

        public void onLoadChildren(String var1, List<Parcel> var2) throws RemoteException;
    }

    public static interface ServiceImplApi21 {
        public void connect(String var1, Bundle var2, ServiceCallbacksApi21 var3);

        public void disconnect(ServiceCallbacksApi21 var1);

        public void addSubscription(String var1, ServiceCallbacksApi21 var2);

        public void removeSubscription(String var1, ServiceCallbacksApi21 var2);
    }
}

