/*
 * Decompiled with CFR 0.152.
 */
package android.support.graphics.drawable;

import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.ColorFilter;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathMeasure;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.Rect;
import android.graphics.Shader;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.VectorDrawable;
import android.os.Build;
import android.support.annotation.ColorInt;
import android.support.annotation.DrawableRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import android.support.annotation.RestrictTo;
import android.support.graphics.drawable.AndroidResources;
import android.support.graphics.drawable.VectorDrawableCommon;
import android.support.v4.content.res.ComplexColorCompat;
import android.support.v4.content.res.ResourcesCompat;
import android.support.v4.content.res.TypedArrayUtils;
import android.support.v4.graphics.PathParser;
import android.support.v4.graphics.drawable.DrawableCompat;
import android.support.v4.util.ArrayMap;
import android.util.AttributeSet;
import android.util.Log;
import android.util.Xml;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class VectorDrawableCompat
extends VectorDrawableCommon {
    static final String LOGTAG = "VectorDrawableCompat";
    static final PorterDuff.Mode DEFAULT_TINT_MODE = PorterDuff.Mode.SRC_IN;
    private static final String SHAPE_CLIP_PATH = "clip-path";
    private static final String SHAPE_GROUP = "group";
    private static final String SHAPE_PATH = "path";
    private static final String SHAPE_VECTOR = "vector";
    private static final int LINECAP_BUTT = 0;
    private static final int LINECAP_ROUND = 1;
    private static final int LINECAP_SQUARE = 2;
    private static final int LINEJOIN_MITER = 0;
    private static final int LINEJOIN_ROUND = 1;
    private static final int LINEJOIN_BEVEL = 2;
    private static final int MAX_CACHED_BITMAP_SIZE = 2048;
    private static final boolean DBG_VECTOR_DRAWABLE = false;
    private VectorDrawableCompatState mVectorState;
    private PorterDuffColorFilter mTintFilter;
    private ColorFilter mColorFilter;
    private boolean mMutated;
    private boolean mAllowCaching = true;
    private Drawable.ConstantState mCachedConstantStateDelegate;
    private final float[] mTmpFloats = new float[9];
    private final Matrix mTmpMatrix = new Matrix();
    private final Rect mTmpBounds = new Rect();

    VectorDrawableCompat() {
        this.mVectorState = new VectorDrawableCompatState();
    }

    VectorDrawableCompat(@NonNull VectorDrawableCompatState state) {
        this.mVectorState = state;
        this.mTintFilter = this.updateTintFilter(this.mTintFilter, state.mTint, state.mTintMode);
    }

    public Drawable mutate() {
        if (this.mDelegateDrawable != null) {
            this.mDelegateDrawable.mutate();
            return this;
        }
        if (!this.mMutated && super.mutate() == this) {
            this.mVectorState = new VectorDrawableCompatState(this.mVectorState);
            this.mMutated = true;
        }
        return this;
    }

    Object getTargetByName(String name) {
        return this.mVectorState.mVPathRenderer.mVGTargetsMap.get((Object)name);
    }

    public Drawable.ConstantState getConstantState() {
        if (this.mDelegateDrawable != null && Build.VERSION.SDK_INT >= 24) {
            return new VectorDrawableDelegateState(this.mDelegateDrawable.getConstantState());
        }
        this.mVectorState.mChangingConfigurations = this.getChangingConfigurations();
        return this.mVectorState;
    }

    public void draw(Canvas canvas) {
        if (this.mDelegateDrawable != null) {
            this.mDelegateDrawable.draw(canvas);
            return;
        }
        this.copyBounds(this.mTmpBounds);
        if (this.mTmpBounds.width() <= 0 || this.mTmpBounds.height() <= 0) {
            return;
        }
        PorterDuffColorFilter colorFilter = this.mColorFilter == null ? this.mTintFilter : this.mColorFilter;
        canvas.getMatrix(this.mTmpMatrix);
        this.mTmpMatrix.getValues(this.mTmpFloats);
        float canvasScaleX = Math.abs(this.mTmpFloats[0]);
        float canvasScaleY = Math.abs(this.mTmpFloats[4]);
        float canvasSkewX = Math.abs(this.mTmpFloats[1]);
        float canvasSkewY = Math.abs(this.mTmpFloats[3]);
        if (canvasSkewX != 0.0f || canvasSkewY != 0.0f) {
            canvasScaleX = 1.0f;
            canvasScaleY = 1.0f;
        }
        int scaledWidth = (int)((float)this.mTmpBounds.width() * canvasScaleX);
        int scaledHeight = (int)((float)this.mTmpBounds.height() * canvasScaleY);
        scaledWidth = Math.min(2048, scaledWidth);
        scaledHeight = Math.min(2048, scaledHeight);
        if (scaledWidth <= 0 || scaledHeight <= 0) {
            return;
        }
        int saveCount = canvas.save();
        canvas.translate((float)this.mTmpBounds.left, (float)this.mTmpBounds.top);
        boolean needMirroring = this.needMirroring();
        if (needMirroring) {
            canvas.translate((float)this.mTmpBounds.width(), 0.0f);
            canvas.scale(-1.0f, 1.0f);
        }
        this.mTmpBounds.offsetTo(0, 0);
        this.mVectorState.createCachedBitmapIfNeeded(scaledWidth, scaledHeight);
        if (!this.mAllowCaching) {
            this.mVectorState.updateCachedBitmap(scaledWidth, scaledHeight);
        } else if (!this.mVectorState.canReuseCache()) {
            this.mVectorState.updateCachedBitmap(scaledWidth, scaledHeight);
            this.mVectorState.updateCacheStates();
        }
        this.mVectorState.drawCachedBitmapWithRootAlpha(canvas, (ColorFilter)colorFilter, this.mTmpBounds);
        canvas.restoreToCount(saveCount);
    }

    public int getAlpha() {
        if (this.mDelegateDrawable != null) {
            return DrawableCompat.getAlpha((Drawable)this.mDelegateDrawable);
        }
        return this.mVectorState.mVPathRenderer.getRootAlpha();
    }

    public void setAlpha(int alpha) {
        if (this.mDelegateDrawable != null) {
            this.mDelegateDrawable.setAlpha(alpha);
            return;
        }
        if (this.mVectorState.mVPathRenderer.getRootAlpha() != alpha) {
            this.mVectorState.mVPathRenderer.setRootAlpha(alpha);
            this.invalidateSelf();
        }
    }

    public void setColorFilter(ColorFilter colorFilter) {
        if (this.mDelegateDrawable != null) {
            this.mDelegateDrawable.setColorFilter(colorFilter);
            return;
        }
        this.mColorFilter = colorFilter;
        this.invalidateSelf();
    }

    PorterDuffColorFilter updateTintFilter(PorterDuffColorFilter tintFilter, ColorStateList tint, PorterDuff.Mode tintMode) {
        if (tint == null || tintMode == null) {
            return null;
        }
        int color = tint.getColorForState(this.getState(), 0);
        return new PorterDuffColorFilter(color, tintMode);
    }

    public void setTint(int tint) {
        if (this.mDelegateDrawable != null) {
            DrawableCompat.setTint((Drawable)this.mDelegateDrawable, (int)tint);
            return;
        }
        this.setTintList(ColorStateList.valueOf((int)tint));
    }

    public void setTintList(ColorStateList tint) {
        if (this.mDelegateDrawable != null) {
            DrawableCompat.setTintList((Drawable)this.mDelegateDrawable, (ColorStateList)tint);
            return;
        }
        VectorDrawableCompatState state = this.mVectorState;
        if (state.mTint != tint) {
            state.mTint = tint;
            this.mTintFilter = this.updateTintFilter(this.mTintFilter, tint, state.mTintMode);
            this.invalidateSelf();
        }
    }

    public void setTintMode(PorterDuff.Mode tintMode) {
        if (this.mDelegateDrawable != null) {
            DrawableCompat.setTintMode((Drawable)this.mDelegateDrawable, (PorterDuff.Mode)tintMode);
            return;
        }
        VectorDrawableCompatState state = this.mVectorState;
        if (state.mTintMode != tintMode) {
            state.mTintMode = tintMode;
            this.mTintFilter = this.updateTintFilter(this.mTintFilter, state.mTint, tintMode);
            this.invalidateSelf();
        }
    }

    public boolean isStateful() {
        if (this.mDelegateDrawable != null) {
            return this.mDelegateDrawable.isStateful();
        }
        return super.isStateful() || this.mVectorState != null && (this.mVectorState.isStateful() || this.mVectorState.mTint != null && this.mVectorState.mTint.isStateful());
    }

    protected boolean onStateChange(int[] stateSet) {
        if (this.mDelegateDrawable != null) {
            return this.mDelegateDrawable.setState(stateSet);
        }
        boolean changed = false;
        VectorDrawableCompatState state = this.mVectorState;
        if (state.mTint != null && state.mTintMode != null) {
            this.mTintFilter = this.updateTintFilter(this.mTintFilter, state.mTint, state.mTintMode);
            this.invalidateSelf();
            changed = true;
        }
        if (state.isStateful() && state.onStateChanged(stateSet)) {
            this.invalidateSelf();
            changed = true;
        }
        return changed;
    }

    public int getOpacity() {
        if (this.mDelegateDrawable != null) {
            return this.mDelegateDrawable.getOpacity();
        }
        return -3;
    }

    public int getIntrinsicWidth() {
        if (this.mDelegateDrawable != null) {
            return this.mDelegateDrawable.getIntrinsicWidth();
        }
        return (int)this.mVectorState.mVPathRenderer.mBaseWidth;
    }

    public int getIntrinsicHeight() {
        if (this.mDelegateDrawable != null) {
            return this.mDelegateDrawable.getIntrinsicHeight();
        }
        return (int)this.mVectorState.mVPathRenderer.mBaseHeight;
    }

    public boolean canApplyTheme() {
        if (this.mDelegateDrawable != null) {
            DrawableCompat.canApplyTheme((Drawable)this.mDelegateDrawable);
        }
        return false;
    }

    public boolean isAutoMirrored() {
        if (this.mDelegateDrawable != null) {
            return DrawableCompat.isAutoMirrored((Drawable)this.mDelegateDrawable);
        }
        return this.mVectorState.mAutoMirrored;
    }

    public void setAutoMirrored(boolean mirrored) {
        if (this.mDelegateDrawable != null) {
            DrawableCompat.setAutoMirrored((Drawable)this.mDelegateDrawable, (boolean)mirrored);
            return;
        }
        this.mVectorState.mAutoMirrored = mirrored;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public float getPixelSize() {
        if (this.mVectorState == null || this.mVectorState.mVPathRenderer == null || this.mVectorState.mVPathRenderer.mBaseWidth == 0.0f || this.mVectorState.mVPathRenderer.mBaseHeight == 0.0f || this.mVectorState.mVPathRenderer.mViewportHeight == 0.0f || this.mVectorState.mVPathRenderer.mViewportWidth == 0.0f) {
            return 1.0f;
        }
        float intrinsicWidth = this.mVectorState.mVPathRenderer.mBaseWidth;
        float intrinsicHeight = this.mVectorState.mVPathRenderer.mBaseHeight;
        float viewportWidth = this.mVectorState.mVPathRenderer.mViewportWidth;
        float viewportHeight = this.mVectorState.mVPathRenderer.mViewportHeight;
        float scaleX = viewportWidth / intrinsicWidth;
        float scaleY = viewportHeight / intrinsicHeight;
        return Math.min(scaleX, scaleY);
    }

    @Nullable
    public static VectorDrawableCompat create(@NonNull Resources res, @DrawableRes int resId, @Nullable Resources.Theme theme) {
        if (Build.VERSION.SDK_INT >= 24) {
            VectorDrawableCompat drawable = new VectorDrawableCompat();
            drawable.mDelegateDrawable = ResourcesCompat.getDrawable((Resources)res, (int)resId, (Resources.Theme)theme);
            drawable.mCachedConstantStateDelegate = new VectorDrawableDelegateState(drawable.mDelegateDrawable.getConstantState());
            return drawable;
        }
        try {
            int type;
            XmlResourceParser parser = res.getXml(resId);
            AttributeSet attrs = Xml.asAttributeSet((XmlPullParser)parser);
            while ((type = parser.next()) != 2 && type != 1) {
            }
            if (type != 2) {
                throw new XmlPullParserException("No start tag found");
            }
            return VectorDrawableCompat.createFromXmlInner(res, (XmlPullParser)parser, attrs, theme);
        }
        catch (XmlPullParserException e) {
            Log.e((String)LOGTAG, (String)"parser error", (Throwable)e);
        }
        catch (IOException e) {
            Log.e((String)LOGTAG, (String)"parser error", (Throwable)e);
        }
        return null;
    }

    public static VectorDrawableCompat createFromXmlInner(Resources r, XmlPullParser parser, AttributeSet attrs, Resources.Theme theme) throws XmlPullParserException, IOException {
        VectorDrawableCompat drawable = new VectorDrawableCompat();
        drawable.inflate(r, parser, attrs, theme);
        return drawable;
    }

    static int applyAlpha(int color, float alpha) {
        int alphaBytes = Color.alpha((int)color);
        color &= 0xFFFFFF;
        return color |= (int)((float)alphaBytes * alpha) << 24;
    }

    public void inflate(Resources res, XmlPullParser parser, AttributeSet attrs) throws XmlPullParserException, IOException {
        if (this.mDelegateDrawable != null) {
            this.mDelegateDrawable.inflate(res, parser, attrs);
            return;
        }
        this.inflate(res, parser, attrs, null);
    }

    public void inflate(Resources res, XmlPullParser parser, AttributeSet attrs, Resources.Theme theme) throws XmlPullParserException, IOException {
        VPathRenderer pathRenderer;
        if (this.mDelegateDrawable != null) {
            DrawableCompat.inflate((Drawable)this.mDelegateDrawable, (Resources)res, (XmlPullParser)parser, (AttributeSet)attrs, (Resources.Theme)theme);
            return;
        }
        VectorDrawableCompatState state = this.mVectorState;
        state.mVPathRenderer = pathRenderer = new VPathRenderer();
        TypedArray a = TypedArrayUtils.obtainAttributes((Resources)res, (Resources.Theme)theme, (AttributeSet)attrs, (int[])AndroidResources.STYLEABLE_VECTOR_DRAWABLE_TYPE_ARRAY);
        this.updateStateFromTypedArray(a, parser);
        a.recycle();
        state.mChangingConfigurations = this.getChangingConfigurations();
        state.mCacheDirty = true;
        this.inflateInternal(res, parser, attrs, theme);
        this.mTintFilter = this.updateTintFilter(this.mTintFilter, state.mTint, state.mTintMode);
    }

    private static PorterDuff.Mode parseTintModeCompat(int value, PorterDuff.Mode defaultMode) {
        switch (value) {
            case 3: {
                return PorterDuff.Mode.SRC_OVER;
            }
            case 5: {
                return PorterDuff.Mode.SRC_IN;
            }
            case 9: {
                return PorterDuff.Mode.SRC_ATOP;
            }
            case 14: {
                return PorterDuff.Mode.MULTIPLY;
            }
            case 15: {
                return PorterDuff.Mode.SCREEN;
            }
            case 16: {
                return PorterDuff.Mode.ADD;
            }
        }
        return defaultMode;
    }

    private void updateStateFromTypedArray(TypedArray a, XmlPullParser parser) throws XmlPullParserException {
        VectorDrawableCompatState state = this.mVectorState;
        VPathRenderer pathRenderer = state.mVPathRenderer;
        int mode = TypedArrayUtils.getNamedInt((TypedArray)a, (XmlPullParser)parser, (String)"tintMode", (int)6, (int)-1);
        state.mTintMode = VectorDrawableCompat.parseTintModeCompat(mode, PorterDuff.Mode.SRC_IN);
        ColorStateList tint = a.getColorStateList(1);
        if (tint != null) {
            state.mTint = tint;
        }
        state.mAutoMirrored = TypedArrayUtils.getNamedBoolean((TypedArray)a, (XmlPullParser)parser, (String)"autoMirrored", (int)5, (boolean)state.mAutoMirrored);
        pathRenderer.mViewportWidth = TypedArrayUtils.getNamedFloat((TypedArray)a, (XmlPullParser)parser, (String)"viewportWidth", (int)7, (float)pathRenderer.mViewportWidth);
        pathRenderer.mViewportHeight = TypedArrayUtils.getNamedFloat((TypedArray)a, (XmlPullParser)parser, (String)"viewportHeight", (int)8, (float)pathRenderer.mViewportHeight);
        if (pathRenderer.mViewportWidth <= 0.0f) {
            throw new XmlPullParserException(a.getPositionDescription() + "<vector> tag requires viewportWidth > 0");
        }
        if (pathRenderer.mViewportHeight <= 0.0f) {
            throw new XmlPullParserException(a.getPositionDescription() + "<vector> tag requires viewportHeight > 0");
        }
        pathRenderer.mBaseWidth = a.getDimension(3, pathRenderer.mBaseWidth);
        pathRenderer.mBaseHeight = a.getDimension(2, pathRenderer.mBaseHeight);
        if (pathRenderer.mBaseWidth <= 0.0f) {
            throw new XmlPullParserException(a.getPositionDescription() + "<vector> tag requires width > 0");
        }
        if (pathRenderer.mBaseHeight <= 0.0f) {
            throw new XmlPullParserException(a.getPositionDescription() + "<vector> tag requires height > 0");
        }
        float alphaInFloat = TypedArrayUtils.getNamedFloat((TypedArray)a, (XmlPullParser)parser, (String)"alpha", (int)4, (float)pathRenderer.getAlpha());
        pathRenderer.setAlpha(alphaInFloat);
        String name = a.getString(0);
        if (name != null) {
            pathRenderer.mRootName = name;
            pathRenderer.mVGTargetsMap.put((Object)name, (Object)pathRenderer);
        }
    }

    private void inflateInternal(Resources res, XmlPullParser parser, AttributeSet attrs, Resources.Theme theme) throws XmlPullParserException, IOException {
        VectorDrawableCompatState state = this.mVectorState;
        VPathRenderer pathRenderer = state.mVPathRenderer;
        boolean noPathTag = true;
        ArrayDeque<VGroup> groupStack = new ArrayDeque<VGroup>();
        groupStack.push(pathRenderer.mRootGroup);
        int eventType = parser.getEventType();
        int innerDepth = parser.getDepth() + 1;
        while (eventType != 1 && (parser.getDepth() >= innerDepth || eventType != 3)) {
            String tagName;
            if (eventType == 2) {
                VPath path;
                tagName = parser.getName();
                VGroup currentGroup = (VGroup)groupStack.peek();
                if (SHAPE_PATH.equals(tagName)) {
                    path = new VFullPath();
                    ((VFullPath)path).inflate(res, attrs, theme, parser);
                    currentGroup.mChildren.add(path);
                    if (path.getPathName() != null) {
                        pathRenderer.mVGTargetsMap.put((Object)path.getPathName(), (Object)path);
                    }
                    noPathTag = false;
                    state.mChangingConfigurations |= ((VFullPath)path).mChangingConfigurations;
                } else if (SHAPE_CLIP_PATH.equals(tagName)) {
                    path = new VClipPath();
                    ((VClipPath)path).inflate(res, attrs, theme, parser);
                    currentGroup.mChildren.add(path);
                    if (path.getPathName() != null) {
                        pathRenderer.mVGTargetsMap.put((Object)path.getPathName(), (Object)path);
                    }
                    state.mChangingConfigurations |= ((VClipPath)path).mChangingConfigurations;
                } else if (SHAPE_GROUP.equals(tagName)) {
                    VGroup newChildGroup = new VGroup();
                    newChildGroup.inflate(res, attrs, theme, parser);
                    currentGroup.mChildren.add(newChildGroup);
                    groupStack.push(newChildGroup);
                    if (newChildGroup.getGroupName() != null) {
                        pathRenderer.mVGTargetsMap.put((Object)newChildGroup.getGroupName(), (Object)newChildGroup);
                    }
                    state.mChangingConfigurations |= newChildGroup.mChangingConfigurations;
                }
            } else if (eventType == 3 && SHAPE_GROUP.equals(tagName = parser.getName())) {
                groupStack.pop();
            }
            eventType = parser.next();
        }
        if (noPathTag) {
            throw new XmlPullParserException("no path defined");
        }
    }

    private void printGroupTree(VGroup currentGroup, int level) {
        int i;
        String indent = "";
        for (i = 0; i < level; ++i) {
            indent = indent + "    ";
        }
        Log.v((String)LOGTAG, (String)(indent + "current group is :" + currentGroup.getGroupName() + " rotation is " + currentGroup.mRotate));
        Log.v((String)LOGTAG, (String)(indent + "matrix is :" + currentGroup.getLocalMatrix().toString()));
        for (i = 0; i < currentGroup.mChildren.size(); ++i) {
            VObject child = currentGroup.mChildren.get(i);
            if (child instanceof VGroup) {
                this.printGroupTree((VGroup)child, level + 1);
                continue;
            }
            ((VPath)child).printVPath(level + 1);
        }
    }

    void setAllowCaching(boolean allowCaching) {
        this.mAllowCaching = allowCaching;
    }

    private boolean needMirroring() {
        if (Build.VERSION.SDK_INT >= 17) {
            return this.isAutoMirrored() && DrawableCompat.getLayoutDirection((Drawable)this) == 1;
        }
        return false;
    }

    @Override
    protected void onBoundsChange(Rect bounds) {
        if (this.mDelegateDrawable != null) {
            this.mDelegateDrawable.setBounds(bounds);
        }
    }

    public int getChangingConfigurations() {
        if (this.mDelegateDrawable != null) {
            return this.mDelegateDrawable.getChangingConfigurations();
        }
        return super.getChangingConfigurations() | this.mVectorState.getChangingConfigurations();
    }

    public void invalidateSelf() {
        if (this.mDelegateDrawable != null) {
            this.mDelegateDrawable.invalidateSelf();
            return;
        }
        super.invalidateSelf();
    }

    public void scheduleSelf(Runnable what, long when) {
        if (this.mDelegateDrawable != null) {
            this.mDelegateDrawable.scheduleSelf(what, when);
            return;
        }
        super.scheduleSelf(what, when);
    }

    public boolean setVisible(boolean visible, boolean restart) {
        if (this.mDelegateDrawable != null) {
            return this.mDelegateDrawable.setVisible(visible, restart);
        }
        return super.setVisible(visible, restart);
    }

    public void unscheduleSelf(Runnable what) {
        if (this.mDelegateDrawable != null) {
            this.mDelegateDrawable.unscheduleSelf(what);
            return;
        }
        super.unscheduleSelf(what);
    }

    private static class VFullPath
    extends VPath {
        private int[] mThemeAttrs;
        private static final int FILL_TYPE_WINDING = 0;
        ComplexColorCompat mStrokeColor;
        float mStrokeWidth = 0.0f;
        ComplexColorCompat mFillColor;
        float mStrokeAlpha = 1.0f;
        int mFillRule = 0;
        float mFillAlpha = 1.0f;
        float mTrimPathStart = 0.0f;
        float mTrimPathEnd = 1.0f;
        float mTrimPathOffset = 0.0f;
        Paint.Cap mStrokeLineCap = Paint.Cap.BUTT;
        Paint.Join mStrokeLineJoin = Paint.Join.MITER;
        float mStrokeMiterlimit = 4.0f;

        public VFullPath() {
        }

        public VFullPath(VFullPath copy) {
            super(copy);
            this.mThemeAttrs = copy.mThemeAttrs;
            this.mStrokeColor = copy.mStrokeColor;
            this.mStrokeWidth = copy.mStrokeWidth;
            this.mStrokeAlpha = copy.mStrokeAlpha;
            this.mFillColor = copy.mFillColor;
            this.mFillRule = copy.mFillRule;
            this.mFillAlpha = copy.mFillAlpha;
            this.mTrimPathStart = copy.mTrimPathStart;
            this.mTrimPathEnd = copy.mTrimPathEnd;
            this.mTrimPathOffset = copy.mTrimPathOffset;
            this.mStrokeLineCap = copy.mStrokeLineCap;
            this.mStrokeLineJoin = copy.mStrokeLineJoin;
            this.mStrokeMiterlimit = copy.mStrokeMiterlimit;
        }

        private Paint.Cap getStrokeLineCap(int id, Paint.Cap defValue) {
            switch (id) {
                case 0: {
                    return Paint.Cap.BUTT;
                }
                case 1: {
                    return Paint.Cap.ROUND;
                }
                case 2: {
                    return Paint.Cap.SQUARE;
                }
            }
            return defValue;
        }

        private Paint.Join getStrokeLineJoin(int id, Paint.Join defValue) {
            switch (id) {
                case 0: {
                    return Paint.Join.MITER;
                }
                case 1: {
                    return Paint.Join.ROUND;
                }
                case 2: {
                    return Paint.Join.BEVEL;
                }
            }
            return defValue;
        }

        @Override
        public boolean canApplyTheme() {
            return this.mThemeAttrs != null;
        }

        public void inflate(Resources r, AttributeSet attrs, Resources.Theme theme, XmlPullParser parser) {
            TypedArray a = TypedArrayUtils.obtainAttributes((Resources)r, (Resources.Theme)theme, (AttributeSet)attrs, (int[])AndroidResources.STYLEABLE_VECTOR_DRAWABLE_PATH);
            this.updateStateFromTypedArray(a, parser, theme);
            a.recycle();
        }

        private void updateStateFromTypedArray(TypedArray a, XmlPullParser parser, Resources.Theme theme) {
            String pathData;
            this.mThemeAttrs = null;
            boolean hasPathData = TypedArrayUtils.hasAttribute((XmlPullParser)parser, (String)"pathData");
            if (!hasPathData) {
                return;
            }
            String pathName = a.getString(0);
            if (pathName != null) {
                this.mPathName = pathName;
            }
            if ((pathData = a.getString(2)) != null) {
                this.mNodes = PathParser.createNodesFromPathData((String)pathData);
            }
            this.mFillColor = TypedArrayUtils.getNamedComplexColor((TypedArray)a, (XmlPullParser)parser, (Resources.Theme)theme, (String)"fillColor", (int)1, (int)0);
            this.mFillAlpha = TypedArrayUtils.getNamedFloat((TypedArray)a, (XmlPullParser)parser, (String)"fillAlpha", (int)12, (float)this.mFillAlpha);
            int lineCap = TypedArrayUtils.getNamedInt((TypedArray)a, (XmlPullParser)parser, (String)"strokeLineCap", (int)8, (int)-1);
            this.mStrokeLineCap = this.getStrokeLineCap(lineCap, this.mStrokeLineCap);
            int lineJoin = TypedArrayUtils.getNamedInt((TypedArray)a, (XmlPullParser)parser, (String)"strokeLineJoin", (int)9, (int)-1);
            this.mStrokeLineJoin = this.getStrokeLineJoin(lineJoin, this.mStrokeLineJoin);
            this.mStrokeMiterlimit = TypedArrayUtils.getNamedFloat((TypedArray)a, (XmlPullParser)parser, (String)"strokeMiterLimit", (int)10, (float)this.mStrokeMiterlimit);
            this.mStrokeColor = TypedArrayUtils.getNamedComplexColor((TypedArray)a, (XmlPullParser)parser, (Resources.Theme)theme, (String)"strokeColor", (int)3, (int)0);
            this.mStrokeAlpha = TypedArrayUtils.getNamedFloat((TypedArray)a, (XmlPullParser)parser, (String)"strokeAlpha", (int)11, (float)this.mStrokeAlpha);
            this.mStrokeWidth = TypedArrayUtils.getNamedFloat((TypedArray)a, (XmlPullParser)parser, (String)"strokeWidth", (int)4, (float)this.mStrokeWidth);
            this.mTrimPathEnd = TypedArrayUtils.getNamedFloat((TypedArray)a, (XmlPullParser)parser, (String)"trimPathEnd", (int)6, (float)this.mTrimPathEnd);
            this.mTrimPathOffset = TypedArrayUtils.getNamedFloat((TypedArray)a, (XmlPullParser)parser, (String)"trimPathOffset", (int)7, (float)this.mTrimPathOffset);
            this.mTrimPathStart = TypedArrayUtils.getNamedFloat((TypedArray)a, (XmlPullParser)parser, (String)"trimPathStart", (int)5, (float)this.mTrimPathStart);
            this.mFillRule = TypedArrayUtils.getNamedInt((TypedArray)a, (XmlPullParser)parser, (String)"fillType", (int)13, (int)this.mFillRule);
        }

        @Override
        public boolean isStateful() {
            return this.mFillColor.isStateful() || this.mStrokeColor.isStateful();
        }

        @Override
        public boolean onStateChanged(int[] stateSet) {
            boolean changed = this.mFillColor.onStateChanged(stateSet);
            return changed |= this.mStrokeColor.onStateChanged(stateSet);
        }

        @Override
        public void applyTheme(Resources.Theme t) {
            if (this.mThemeAttrs == null) {
                return;
            }
        }

        @ColorInt
        int getStrokeColor() {
            return this.mStrokeColor.getColor();
        }

        void setStrokeColor(int strokeColor) {
            this.mStrokeColor.setColor(strokeColor);
        }

        float getStrokeWidth() {
            return this.mStrokeWidth;
        }

        void setStrokeWidth(float strokeWidth) {
            this.mStrokeWidth = strokeWidth;
        }

        float getStrokeAlpha() {
            return this.mStrokeAlpha;
        }

        void setStrokeAlpha(float strokeAlpha) {
            this.mStrokeAlpha = strokeAlpha;
        }

        @ColorInt
        int getFillColor() {
            return this.mFillColor.getColor();
        }

        void setFillColor(int fillColor) {
            this.mFillColor.setColor(fillColor);
        }

        float getFillAlpha() {
            return this.mFillAlpha;
        }

        void setFillAlpha(float fillAlpha) {
            this.mFillAlpha = fillAlpha;
        }

        float getTrimPathStart() {
            return this.mTrimPathStart;
        }

        void setTrimPathStart(float trimPathStart) {
            this.mTrimPathStart = trimPathStart;
        }

        float getTrimPathEnd() {
            return this.mTrimPathEnd;
        }

        void setTrimPathEnd(float trimPathEnd) {
            this.mTrimPathEnd = trimPathEnd;
        }

        float getTrimPathOffset() {
            return this.mTrimPathOffset;
        }

        void setTrimPathOffset(float trimPathOffset) {
            this.mTrimPathOffset = trimPathOffset;
        }
    }

    private static class VClipPath
    extends VPath {
        public VClipPath() {
        }

        public VClipPath(VClipPath copy) {
            super(copy);
        }

        public void inflate(Resources r, AttributeSet attrs, Resources.Theme theme, XmlPullParser parser) {
            boolean hasPathData = TypedArrayUtils.hasAttribute((XmlPullParser)parser, (String)"pathData");
            if (!hasPathData) {
                return;
            }
            TypedArray a = TypedArrayUtils.obtainAttributes((Resources)r, (Resources.Theme)theme, (AttributeSet)attrs, (int[])AndroidResources.STYLEABLE_VECTOR_DRAWABLE_CLIP_PATH);
            this.updateStateFromTypedArray(a);
            a.recycle();
        }

        private void updateStateFromTypedArray(TypedArray a) {
            String pathData;
            String pathName = a.getString(0);
            if (pathName != null) {
                this.mPathName = pathName;
            }
            if ((pathData = a.getString(1)) != null) {
                this.mNodes = PathParser.createNodesFromPathData((String)pathData);
            }
        }

        @Override
        public boolean isClipPath() {
            return true;
        }
    }

    private static abstract class VPath
    extends VObject {
        protected PathParser.PathDataNode[] mNodes = null;
        String mPathName;
        int mChangingConfigurations;

        public VPath() {
        }

        public void printVPath(int level) {
            String indent = "";
            for (int i = 0; i < level; ++i) {
                indent = indent + "    ";
            }
            Log.v((String)VectorDrawableCompat.LOGTAG, (String)(indent + "current path is :" + this.mPathName + " pathData is " + this.nodesToString(this.mNodes)));
        }

        public String nodesToString(PathParser.PathDataNode[] nodes) {
            String result = " ";
            for (int i = 0; i < nodes.length; ++i) {
                result = result + nodes[i].mType + ":";
                float[] params = nodes[i].mParams;
                for (int j = 0; j < params.length; ++j) {
                    result = result + params[j] + ",";
                }
            }
            return result;
        }

        public VPath(VPath copy) {
            this.mPathName = copy.mPathName;
            this.mChangingConfigurations = copy.mChangingConfigurations;
            this.mNodes = PathParser.deepCopyNodes((PathParser.PathDataNode[])copy.mNodes);
        }

        public void toPath(Path path) {
            path.reset();
            if (this.mNodes != null) {
                PathParser.PathDataNode.nodesToPath((PathParser.PathDataNode[])this.mNodes, (Path)path);
            }
        }

        public String getPathName() {
            return this.mPathName;
        }

        public boolean canApplyTheme() {
            return false;
        }

        public void applyTheme(Resources.Theme t) {
        }

        public boolean isClipPath() {
            return false;
        }

        public PathParser.PathDataNode[] getPathData() {
            return this.mNodes;
        }

        public void setPathData(PathParser.PathDataNode[] nodes) {
            if (!PathParser.canMorph((PathParser.PathDataNode[])this.mNodes, (PathParser.PathDataNode[])nodes)) {
                this.mNodes = PathParser.deepCopyNodes((PathParser.PathDataNode[])nodes);
            } else {
                PathParser.updateNodes((PathParser.PathDataNode[])this.mNodes, (PathParser.PathDataNode[])nodes);
            }
        }
    }

    private static class VGroup
    extends VObject {
        final Matrix mStackedMatrix = new Matrix();
        final ArrayList<VObject> mChildren = new ArrayList();
        float mRotate = 0.0f;
        private float mPivotX = 0.0f;
        private float mPivotY = 0.0f;
        private float mScaleX = 1.0f;
        private float mScaleY = 1.0f;
        private float mTranslateX = 0.0f;
        private float mTranslateY = 0.0f;
        final Matrix mLocalMatrix = new Matrix();
        int mChangingConfigurations;
        private int[] mThemeAttrs;
        private String mGroupName = null;

        public VGroup(VGroup copy, ArrayMap<String, Object> targetsMap) {
            this.mRotate = copy.mRotate;
            this.mPivotX = copy.mPivotX;
            this.mPivotY = copy.mPivotY;
            this.mScaleX = copy.mScaleX;
            this.mScaleY = copy.mScaleY;
            this.mTranslateX = copy.mTranslateX;
            this.mTranslateY = copy.mTranslateY;
            this.mThemeAttrs = copy.mThemeAttrs;
            this.mGroupName = copy.mGroupName;
            this.mChangingConfigurations = copy.mChangingConfigurations;
            if (this.mGroupName != null) {
                targetsMap.put((Object)this.mGroupName, (Object)this);
            }
            this.mLocalMatrix.set(copy.mLocalMatrix);
            ArrayList<VObject> children = copy.mChildren;
            for (int i = 0; i < children.size(); ++i) {
                VPath newPath;
                VObject copyChild = children.get(i);
                if (copyChild instanceof VGroup) {
                    VGroup copyGroup = (VGroup)copyChild;
                    this.mChildren.add(new VGroup(copyGroup, targetsMap));
                    continue;
                }
                if (copyChild instanceof VFullPath) {
                    newPath = new VFullPath((VFullPath)copyChild);
                } else if (copyChild instanceof VClipPath) {
                    newPath = new VClipPath((VClipPath)copyChild);
                } else {
                    throw new IllegalStateException("Unknown object in the tree!");
                }
                this.mChildren.add(newPath);
                if (newPath.mPathName == null) continue;
                targetsMap.put((Object)newPath.mPathName, (Object)newPath);
            }
        }

        public VGroup() {
        }

        public String getGroupName() {
            return this.mGroupName;
        }

        public Matrix getLocalMatrix() {
            return this.mLocalMatrix;
        }

        public void inflate(Resources res, AttributeSet attrs, Resources.Theme theme, XmlPullParser parser) {
            TypedArray a = TypedArrayUtils.obtainAttributes((Resources)res, (Resources.Theme)theme, (AttributeSet)attrs, (int[])AndroidResources.STYLEABLE_VECTOR_DRAWABLE_GROUP);
            this.updateStateFromTypedArray(a, parser);
            a.recycle();
        }

        private void updateStateFromTypedArray(TypedArray a, XmlPullParser parser) {
            this.mThemeAttrs = null;
            this.mRotate = TypedArrayUtils.getNamedFloat((TypedArray)a, (XmlPullParser)parser, (String)"rotation", (int)5, (float)this.mRotate);
            this.mPivotX = a.getFloat(1, this.mPivotX);
            this.mPivotY = a.getFloat(2, this.mPivotY);
            this.mScaleX = TypedArrayUtils.getNamedFloat((TypedArray)a, (XmlPullParser)parser, (String)"scaleX", (int)3, (float)this.mScaleX);
            this.mScaleY = TypedArrayUtils.getNamedFloat((TypedArray)a, (XmlPullParser)parser, (String)"scaleY", (int)4, (float)this.mScaleY);
            this.mTranslateX = TypedArrayUtils.getNamedFloat((TypedArray)a, (XmlPullParser)parser, (String)"translateX", (int)6, (float)this.mTranslateX);
            this.mTranslateY = TypedArrayUtils.getNamedFloat((TypedArray)a, (XmlPullParser)parser, (String)"translateY", (int)7, (float)this.mTranslateY);
            String groupName = a.getString(0);
            if (groupName != null) {
                this.mGroupName = groupName;
            }
            this.updateLocalMatrix();
        }

        private void updateLocalMatrix() {
            this.mLocalMatrix.reset();
            this.mLocalMatrix.postTranslate(-this.mPivotX, -this.mPivotY);
            this.mLocalMatrix.postScale(this.mScaleX, this.mScaleY);
            this.mLocalMatrix.postRotate(this.mRotate, 0.0f, 0.0f);
            this.mLocalMatrix.postTranslate(this.mTranslateX + this.mPivotX, this.mTranslateY + this.mPivotY);
        }

        public float getRotation() {
            return this.mRotate;
        }

        public void setRotation(float rotation) {
            if (rotation != this.mRotate) {
                this.mRotate = rotation;
                this.updateLocalMatrix();
            }
        }

        public float getPivotX() {
            return this.mPivotX;
        }

        public void setPivotX(float pivotX) {
            if (pivotX != this.mPivotX) {
                this.mPivotX = pivotX;
                this.updateLocalMatrix();
            }
        }

        public float getPivotY() {
            return this.mPivotY;
        }

        public void setPivotY(float pivotY) {
            if (pivotY != this.mPivotY) {
                this.mPivotY = pivotY;
                this.updateLocalMatrix();
            }
        }

        public float getScaleX() {
            return this.mScaleX;
        }

        public void setScaleX(float scaleX) {
            if (scaleX != this.mScaleX) {
                this.mScaleX = scaleX;
                this.updateLocalMatrix();
            }
        }

        public float getScaleY() {
            return this.mScaleY;
        }

        public void setScaleY(float scaleY) {
            if (scaleY != this.mScaleY) {
                this.mScaleY = scaleY;
                this.updateLocalMatrix();
            }
        }

        public float getTranslateX() {
            return this.mTranslateX;
        }

        public void setTranslateX(float translateX) {
            if (translateX != this.mTranslateX) {
                this.mTranslateX = translateX;
                this.updateLocalMatrix();
            }
        }

        public float getTranslateY() {
            return this.mTranslateY;
        }

        public void setTranslateY(float translateY) {
            if (translateY != this.mTranslateY) {
                this.mTranslateY = translateY;
                this.updateLocalMatrix();
            }
        }

        @Override
        public boolean isStateful() {
            for (int i = 0; i < this.mChildren.size(); ++i) {
                if (!this.mChildren.get(i).isStateful()) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean onStateChanged(int[] stateSet) {
            boolean changed = false;
            for (int i = 0; i < this.mChildren.size(); ++i) {
                changed |= this.mChildren.get(i).onStateChanged(stateSet);
            }
            return changed;
        }
    }

    private static abstract class VObject {
        private VObject() {
        }

        public boolean isStateful() {
            return false;
        }

        public boolean onStateChanged(int[] stateSet) {
            return false;
        }
    }

    private static class VPathRenderer {
        private final Path mPath;
        private final Path mRenderPath;
        private static final Matrix IDENTITY_MATRIX = new Matrix();
        private final Matrix mFinalPathMatrix = new Matrix();
        Paint mStrokePaint;
        Paint mFillPaint;
        private PathMeasure mPathMeasure;
        private int mChangingConfigurations;
        final VGroup mRootGroup;
        float mBaseWidth = 0.0f;
        float mBaseHeight = 0.0f;
        float mViewportWidth = 0.0f;
        float mViewportHeight = 0.0f;
        int mRootAlpha = 255;
        String mRootName = null;
        Boolean mIsStateful = null;
        final ArrayMap<String, Object> mVGTargetsMap = new ArrayMap();

        public VPathRenderer() {
            this.mRootGroup = new VGroup();
            this.mPath = new Path();
            this.mRenderPath = new Path();
        }

        public void setRootAlpha(int alpha) {
            this.mRootAlpha = alpha;
        }

        public int getRootAlpha() {
            return this.mRootAlpha;
        }

        public void setAlpha(float alpha) {
            this.setRootAlpha((int)(alpha * 255.0f));
        }

        public float getAlpha() {
            return (float)this.getRootAlpha() / 255.0f;
        }

        public VPathRenderer(VPathRenderer copy) {
            this.mRootGroup = new VGroup(copy.mRootGroup, this.mVGTargetsMap);
            this.mPath = new Path(copy.mPath);
            this.mRenderPath = new Path(copy.mRenderPath);
            this.mBaseWidth = copy.mBaseWidth;
            this.mBaseHeight = copy.mBaseHeight;
            this.mViewportWidth = copy.mViewportWidth;
            this.mViewportHeight = copy.mViewportHeight;
            this.mChangingConfigurations = copy.mChangingConfigurations;
            this.mRootAlpha = copy.mRootAlpha;
            this.mRootName = copy.mRootName;
            if (copy.mRootName != null) {
                this.mVGTargetsMap.put((Object)copy.mRootName, (Object)this);
            }
            this.mIsStateful = copy.mIsStateful;
        }

        private void drawGroupTree(VGroup currentGroup, Matrix currentMatrix, Canvas canvas, int w, int h, ColorFilter filter) {
            currentGroup.mStackedMatrix.set(currentMatrix);
            currentGroup.mStackedMatrix.preConcat(currentGroup.mLocalMatrix);
            canvas.save();
            for (int i = 0; i < currentGroup.mChildren.size(); ++i) {
                VObject child = currentGroup.mChildren.get(i);
                if (child instanceof VGroup) {
                    VGroup childGroup = (VGroup)child;
                    this.drawGroupTree(childGroup, currentGroup.mStackedMatrix, canvas, w, h, filter);
                    continue;
                }
                if (!(child instanceof VPath)) continue;
                VPath childPath = (VPath)child;
                this.drawPath(currentGroup, childPath, canvas, w, h, filter);
            }
            canvas.restore();
        }

        public void draw(Canvas canvas, int w, int h, ColorFilter filter) {
            this.drawGroupTree(this.mRootGroup, IDENTITY_MATRIX, canvas, w, h, filter);
        }

        private void drawPath(VGroup vGroup, VPath vPath, Canvas canvas, int w, int h, ColorFilter filter) {
            float scaleX = (float)w / this.mViewportWidth;
            float scaleY = (float)h / this.mViewportHeight;
            float minScale = Math.min(scaleX, scaleY);
            Matrix groupStackedMatrix = vGroup.mStackedMatrix;
            this.mFinalPathMatrix.set(groupStackedMatrix);
            this.mFinalPathMatrix.postScale(scaleX, scaleY);
            float matrixScale = this.getMatrixScale(groupStackedMatrix);
            if (matrixScale == 0.0f) {
                return;
            }
            vPath.toPath(this.mPath);
            Path path = this.mPath;
            this.mRenderPath.reset();
            if (vPath.isClipPath()) {
                this.mRenderPath.addPath(path, this.mFinalPathMatrix);
                canvas.clipPath(this.mRenderPath);
            } else {
                VFullPath fullPath = (VFullPath)vPath;
                if (fullPath.mTrimPathStart != 0.0f || fullPath.mTrimPathEnd != 1.0f) {
                    float start = (fullPath.mTrimPathStart + fullPath.mTrimPathOffset) % 1.0f;
                    float end = (fullPath.mTrimPathEnd + fullPath.mTrimPathOffset) % 1.0f;
                    if (this.mPathMeasure == null) {
                        this.mPathMeasure = new PathMeasure();
                    }
                    this.mPathMeasure.setPath(this.mPath, false);
                    float len = this.mPathMeasure.getLength();
                    start *= len;
                    end *= len;
                    path.reset();
                    if (start > end) {
                        this.mPathMeasure.getSegment(start, len, path, true);
                        this.mPathMeasure.getSegment(0.0f, end, path, true);
                    } else {
                        this.mPathMeasure.getSegment(start, end, path, true);
                    }
                    path.rLineTo(0.0f, 0.0f);
                }
                this.mRenderPath.addPath(path, this.mFinalPathMatrix);
                if (fullPath.mFillColor.willDraw()) {
                    ComplexColorCompat fill = fullPath.mFillColor;
                    if (this.mFillPaint == null) {
                        this.mFillPaint = new Paint(1);
                        this.mFillPaint.setStyle(Paint.Style.FILL);
                    }
                    Paint fillPaint = this.mFillPaint;
                    if (fill.isGradient()) {
                        Shader shader = fill.getShader();
                        shader.setLocalMatrix(this.mFinalPathMatrix);
                        fillPaint.setShader(shader);
                        fillPaint.setAlpha(Math.round(fullPath.mFillAlpha * 255.0f));
                    } else {
                        fillPaint.setColor(VectorDrawableCompat.applyAlpha(fill.getColor(), fullPath.mFillAlpha));
                    }
                    fillPaint.setColorFilter(filter);
                    this.mRenderPath.setFillType(fullPath.mFillRule == 0 ? Path.FillType.WINDING : Path.FillType.EVEN_ODD);
                    canvas.drawPath(this.mRenderPath, fillPaint);
                }
                if (fullPath.mStrokeColor.willDraw()) {
                    ComplexColorCompat strokeColor = fullPath.mStrokeColor;
                    if (this.mStrokePaint == null) {
                        this.mStrokePaint = new Paint(1);
                        this.mStrokePaint.setStyle(Paint.Style.STROKE);
                    }
                    Paint strokePaint = this.mStrokePaint;
                    if (fullPath.mStrokeLineJoin != null) {
                        strokePaint.setStrokeJoin(fullPath.mStrokeLineJoin);
                    }
                    if (fullPath.mStrokeLineCap != null) {
                        strokePaint.setStrokeCap(fullPath.mStrokeLineCap);
                    }
                    strokePaint.setStrokeMiter(fullPath.mStrokeMiterlimit);
                    if (strokeColor.isGradient()) {
                        Shader shader = strokeColor.getShader();
                        shader.setLocalMatrix(this.mFinalPathMatrix);
                        strokePaint.setShader(shader);
                        strokePaint.setAlpha(Math.round(fullPath.mStrokeAlpha * 255.0f));
                    } else {
                        strokePaint.setColor(VectorDrawableCompat.applyAlpha(strokeColor.getColor(), fullPath.mStrokeAlpha));
                    }
                    strokePaint.setColorFilter(filter);
                    float finalStrokeScale = minScale * matrixScale;
                    strokePaint.setStrokeWidth(fullPath.mStrokeWidth * finalStrokeScale);
                    canvas.drawPath(this.mRenderPath, strokePaint);
                }
            }
        }

        private static float cross(float v1x, float v1y, float v2x, float v2y) {
            return v1x * v2y - v1y * v2x;
        }

        private float getMatrixScale(Matrix groupStackedMatrix) {
            float[] unitVectors = new float[]{0.0f, 1.0f, 1.0f, 0.0f};
            groupStackedMatrix.mapVectors(unitVectors);
            float scaleX = (float)Math.hypot(unitVectors[0], unitVectors[1]);
            float scaleY = (float)Math.hypot(unitVectors[2], unitVectors[3]);
            float crossProduct = VPathRenderer.cross(unitVectors[0], unitVectors[1], unitVectors[2], unitVectors[3]);
            float maxScale = Math.max(scaleX, scaleY);
            float matrixScale = 0.0f;
            if (maxScale > 0.0f) {
                matrixScale = Math.abs(crossProduct) / maxScale;
            }
            return matrixScale;
        }

        public boolean isStateful() {
            if (this.mIsStateful == null) {
                this.mIsStateful = this.mRootGroup.isStateful();
            }
            return this.mIsStateful;
        }

        public boolean onStateChanged(int[] stateSet) {
            return this.mRootGroup.onStateChanged(stateSet);
        }
    }

    private static class VectorDrawableCompatState
    extends Drawable.ConstantState {
        int mChangingConfigurations;
        VPathRenderer mVPathRenderer;
        ColorStateList mTint = null;
        PorterDuff.Mode mTintMode = DEFAULT_TINT_MODE;
        boolean mAutoMirrored;
        Bitmap mCachedBitmap;
        int[] mCachedThemeAttrs;
        ColorStateList mCachedTint;
        PorterDuff.Mode mCachedTintMode;
        int mCachedRootAlpha;
        boolean mCachedAutoMirrored;
        boolean mCacheDirty;
        Paint mTempPaint;

        public VectorDrawableCompatState(VectorDrawableCompatState copy) {
            if (copy != null) {
                this.mChangingConfigurations = copy.mChangingConfigurations;
                this.mVPathRenderer = new VPathRenderer(copy.mVPathRenderer);
                if (copy.mVPathRenderer.mFillPaint != null) {
                    this.mVPathRenderer.mFillPaint = new Paint(copy.mVPathRenderer.mFillPaint);
                }
                if (copy.mVPathRenderer.mStrokePaint != null) {
                    this.mVPathRenderer.mStrokePaint = new Paint(copy.mVPathRenderer.mStrokePaint);
                }
                this.mTint = copy.mTint;
                this.mTintMode = copy.mTintMode;
                this.mAutoMirrored = copy.mAutoMirrored;
            }
        }

        public void drawCachedBitmapWithRootAlpha(Canvas canvas, ColorFilter filter, Rect originalBounds) {
            Paint p = this.getPaint(filter);
            canvas.drawBitmap(this.mCachedBitmap, null, originalBounds, p);
        }

        public boolean hasTranslucentRoot() {
            return this.mVPathRenderer.getRootAlpha() < 255;
        }

        public Paint getPaint(ColorFilter filter) {
            if (!this.hasTranslucentRoot() && filter == null) {
                return null;
            }
            if (this.mTempPaint == null) {
                this.mTempPaint = new Paint();
                this.mTempPaint.setFilterBitmap(true);
            }
            this.mTempPaint.setAlpha(this.mVPathRenderer.getRootAlpha());
            this.mTempPaint.setColorFilter(filter);
            return this.mTempPaint;
        }

        public void updateCachedBitmap(int width, int height) {
            this.mCachedBitmap.eraseColor(0);
            Canvas tmpCanvas = new Canvas(this.mCachedBitmap);
            this.mVPathRenderer.draw(tmpCanvas, width, height, null);
        }

        public void createCachedBitmapIfNeeded(int width, int height) {
            if (this.mCachedBitmap == null || !this.canReuseBitmap(width, height)) {
                this.mCachedBitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                this.mCacheDirty = true;
            }
        }

        public boolean canReuseBitmap(int width, int height) {
            return width == this.mCachedBitmap.getWidth() && height == this.mCachedBitmap.getHeight();
        }

        public boolean canReuseCache() {
            return !this.mCacheDirty && this.mCachedTint == this.mTint && this.mCachedTintMode == this.mTintMode && this.mCachedAutoMirrored == this.mAutoMirrored && this.mCachedRootAlpha == this.mVPathRenderer.getRootAlpha();
        }

        public void updateCacheStates() {
            this.mCachedTint = this.mTint;
            this.mCachedTintMode = this.mTintMode;
            this.mCachedRootAlpha = this.mVPathRenderer.getRootAlpha();
            this.mCachedAutoMirrored = this.mAutoMirrored;
            this.mCacheDirty = false;
        }

        public VectorDrawableCompatState() {
            this.mVPathRenderer = new VPathRenderer();
        }

        @NonNull
        public Drawable newDrawable() {
            return new VectorDrawableCompat(this);
        }

        @NonNull
        public Drawable newDrawable(Resources res) {
            return new VectorDrawableCompat(this);
        }

        public int getChangingConfigurations() {
            return this.mChangingConfigurations;
        }

        public boolean isStateful() {
            return this.mVPathRenderer.isStateful();
        }

        public boolean onStateChanged(int[] stateSet) {
            boolean changed = this.mVPathRenderer.onStateChanged(stateSet);
            this.mCacheDirty |= changed;
            return changed;
        }
    }

    @RequiresApi(value=24)
    private static class VectorDrawableDelegateState
    extends Drawable.ConstantState {
        private final Drawable.ConstantState mDelegateState;

        public VectorDrawableDelegateState(Drawable.ConstantState state) {
            this.mDelegateState = state;
        }

        public Drawable newDrawable() {
            VectorDrawableCompat drawableCompat = new VectorDrawableCompat();
            drawableCompat.mDelegateDrawable = (VectorDrawable)this.mDelegateState.newDrawable();
            return drawableCompat;
        }

        public Drawable newDrawable(Resources res) {
            VectorDrawableCompat drawableCompat = new VectorDrawableCompat();
            drawableCompat.mDelegateDrawable = (VectorDrawable)this.mDelegateState.newDrawable(res);
            return drawableCompat;
        }

        public Drawable newDrawable(Resources res, Resources.Theme theme) {
            VectorDrawableCompat drawableCompat = new VectorDrawableCompat();
            drawableCompat.mDelegateDrawable = (VectorDrawable)this.mDelegateState.newDrawable(res, theme);
            return drawableCompat;
        }

        public boolean canApplyTheme() {
            return this.mDelegateState.canApplyTheme();
        }

        public int getChangingConfigurations() {
            return this.mDelegateState.getChangingConfigurations();
        }
    }
}

