/*
 * Decompiled with CFR 0.152.
 */
package android.support.test.espresso.intent;

import android.app.Instrumentation;
import android.content.Intent;
import android.support.test.espresso.intent.Checks;
import android.support.test.espresso.intent.ResettingStubber;
import org.hamcrest.Matcher;

public final class OngoingStubbing {
    private final Matcher<Intent> matcher;
    private final ResettingStubber resettingStubber;
    private final Instrumentation instrumentation;

    OngoingStubbing(Matcher<Intent> matcher, ResettingStubber resettingStubber, Instrumentation instrumentation) {
        this.matcher = Checks.checkNotNull(matcher);
        this.resettingStubber = Checks.checkNotNull(resettingStubber);
        this.instrumentation = Checks.checkNotNull(instrumentation);
    }

    public void respondWith(final Instrumentation.ActivityResult result) {
        Checks.checkNotNull(result);
        this.instrumentation.waitForIdleSync();
        this.instrumentation.runOnMainSync(new Runnable(){

            @Override
            public void run() {
                OngoingStubbing.this.resettingStubber.setActivityResultForIntent((Matcher<Intent>)OngoingStubbing.this.matcher, result);
            }
        });
        this.instrumentation.waitForIdleSync();
    }
}

