/*
 * Decompiled with CFR 0.152.
 */
package android.support.test.internal.runner.intent;

import android.content.Intent;
import android.support.annotation.NonNull;
import android.support.test.runner.intent.IntentCallback;
import android.support.test.runner.intent.IntentMonitor;
import android.util.Log;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public final class IntentMonitorImpl
implements IntentMonitor {
    private static final String TAG = "IntentMonitorImpl";
    List<WeakReference<IntentCallback>> mCallbacks = Collections.synchronizedList(new ArrayList());

    @Override
    public void addIntentCallback(@NonNull IntentCallback callback) {
        if (null == callback) {
            throw new NullPointerException("callback cannot be null!");
        }
        boolean needsAdd = true;
        Iterator<WeakReference<IntentCallback>> refIter = this.mCallbacks.iterator();
        while (refIter.hasNext()) {
            IntentCallback storedCallback = (IntentCallback)refIter.next().get();
            if (null == storedCallback) {
                refIter.remove();
                continue;
            }
            if (storedCallback != callback) continue;
            needsAdd = false;
        }
        if (needsAdd) {
            this.mCallbacks.add(new WeakReference<IntentCallback>(callback));
        }
    }

    @Override
    public void removeIntentCallback(@NonNull IntentCallback callback) {
        if (null == callback) {
            throw new NullPointerException("callback cannot be null!");
        }
        Iterator<WeakReference<IntentCallback>> refIter = this.mCallbacks.iterator();
        while (refIter.hasNext()) {
            IntentCallback storedCallback = (IntentCallback)refIter.next().get();
            if (null == storedCallback) {
                refIter.remove();
                continue;
            }
            if (storedCallback != callback) continue;
            refIter.remove();
        }
    }

    public void signalIntent(Intent intent) {
        Iterator<WeakReference<IntentCallback>> refIter = this.mCallbacks.iterator();
        while (refIter.hasNext()) {
            IntentCallback callback = (IntentCallback)refIter.next().get();
            if (null == callback) {
                refIter.remove();
                continue;
            }
            try {
                callback.onIntentSent(new Intent(intent));
            }
            catch (RuntimeException e) {
                Log.e((String)TAG, (String)String.format("Callback threw exception! (callback: %s intent: %s)", callback, intent), (Throwable)e);
            }
        }
    }
}

