/*
 * Decompiled with CFR 0.152.
 */
package android.support.test.internal.util;

import android.app.ActivityManager;
import android.content.Context;
import android.os.Process;
import android.support.annotation.VisibleForTesting;
import android.text.TextUtils;
import android.util.Log;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public final class ProcessUtil {
    private static final String TAG = "ProcessUtil";
    private static final List<Integer> RETRY_WAIT_INTERVALS = Collections.unmodifiableList(Arrays.asList(8, 8, 16, 32, 64, 128, 256));
    private static String processName;

    public static String getCurrentProcessName(Context context) {
        if (!TextUtils.isEmpty((CharSequence)processName)) {
            return processName;
        }
        try {
            processName = ProcessUtil.getCurrentProcessNameUsingActivityManager(context);
        }
        catch (SecurityException isIsolatedProcess) {
            Log.i((String)TAG, (String)"Could not read process name from ActivityManager (isolatedProcess?)");
            return "";
        }
        if (processName.isEmpty()) {
            Log.w((String)TAG, (String)"Could not figure out process name using ActivityManager, falling back to use /proc. Note that processName fetched from /proc may be truncated!");
            processName = ProcessUtil.getCurrentProcessNameUsingProc();
            if (processName.isEmpty()) {
                Log.w((String)TAG, (String)"Could not figure out process name /proc either");
            }
        }
        return processName;
    }

    @VisibleForTesting
    static String getCurrentProcessNameUsingActivityManager(Context context) {
        int pid = Process.myPid();
        ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
        if (activityManager != null) {
            List runningAppProcesses = activityManager.getRunningAppProcesses();
            if (null == runningAppProcesses) {
                int retryAttempt = 0;
                while (null == runningAppProcesses && retryAttempt < RETRY_WAIT_INTERVALS.size()) {
                    try {
                        Log.i((String)TAG, (String)"Waiting for running app processes...");
                        Thread.sleep(RETRY_WAIT_INTERVALS.get(retryAttempt++).intValue());
                        runningAppProcesses = activityManager.getRunningAppProcesses();
                    }
                    catch (InterruptedException ie) {
                        Log.w((String)TAG, (String)"Interrupted while waiting for running app processes", (Throwable)ie);
                        return "";
                    }
                }
            }
            for (ActivityManager.RunningAppProcessInfo processInfo : ProcessUtil.emptyIfNull(runningAppProcesses)) {
                if (processInfo.pid != pid) continue;
                return processInfo.processName;
            }
            Log.w((String)TAG, (String)"Couldn't get running processes from ActivityManager!");
        } else {
            Log.w((String)TAG, (String)new StringBuilder(89).append("ActivityManager#getRunningAppProcesses did not return an entry matching pid = ").append(pid).toString());
        }
        return "";
    }

    private static <E> Iterable<E> emptyIfNull(Iterable<E> iterable) {
        return null == iterable ? Collections.emptyList() : iterable;
    }

    @VisibleForTesting
    static String getCurrentProcessNameUsingProc() {
        BufferedReader br = null;
        String processName = "";
        try {
            br = new BufferedReader(new FileReader("/proc/self/cmdline"));
            processName = br.readLine().trim();
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (Exception e) {
                Log.w((String)TAG, (String)e.getMessage(), (Throwable)e);
            }
        }
        return processName;
    }

    @VisibleForTesting
    static void resetProcessName() {
        processName = "";
    }
}

