/*
 * Decompiled with CFR 0.152.
 */
package android.support.test.internal.runner;

import android.app.Instrumentation;
import android.content.pm.InstrumentationInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.support.test.runner.lifecycle.ApplicationLifecycleCallback;
import android.util.Log;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.junit.runner.notification.RunListener;

public class RunnerArgs {
    private static final String LOG_TAG = "RunnerArgs";
    static final String ARGUMENT_TEST_CLASS = "class";
    static final String ARGUMENT_NOT_TEST_CLASS = "notClass";
    static final String ARGUMENT_TEST_SIZE = "size";
    static final String ARGUMENT_LOG_ONLY = "log";
    static final String ARGUMENT_ANNOTATION = "annotation";
    static final String ARGUMENT_NOT_ANNOTATION = "notAnnotation";
    static final String ARGUMENT_NUM_SHARDS = "numShards";
    static final String ARGUMENT_SHARD_INDEX = "shardIndex";
    static final String ARGUMENT_DELAY_IN_MILLIS = "delay_msec";
    static final String ARGUMENT_COVERAGE = "coverage";
    static final String ARGUMENT_COVERAGE_PATH = "coverageFile";
    static final String ARGUMENT_SUITE_ASSIGNMENT = "suiteAssignment";
    static final String ARGUMENT_DEBUG = "debug";
    static final String ARGUMENT_LISTENER = "listener";
    static final String ARGUMENT_TEST_PACKAGE = "package";
    static final String ARGUMENT_NOT_TEST_PACKAGE = "notPackage";
    static final String ARGUMENT_TIMEOUT = "timeout_msec";
    static final String ARGUMENT_TEST_FILE = "testFile";
    static final String ARGUMENT_DISABLE_ANALYTICS = "disableAnalytics";
    static final String ARGUMENT_APP_LISTENER = "appListener";
    private static final char CLASS_SEPARATOR = ',';
    private static final char METHOD_SEPARATOR = '#';
    public final boolean debug;
    public final boolean suiteAssignment;
    public final boolean codeCoverage;
    public final String codeCoveragePath;
    public final int delayInMillis;
    public final boolean logOnly;
    public final List<String> testPackages;
    public final List<String> notTestPackages;
    public final String testSize;
    public final String annotation;
    public final List<String> notAnnotations;
    public final long testTimeout;
    public final List<RunListener> listeners;
    public final List<TestArg> tests;
    public final List<TestArg> notTests;
    public final int numShards;
    public final int shardIndex;
    public final boolean disableAnalytics;
    public final List<ApplicationLifecycleCallback> appListeners;

    private RunnerArgs(Builder builder) {
        this.debug = builder.debug;
        this.suiteAssignment = builder.suiteAssignment;
        this.codeCoverage = builder.codeCoverage;
        this.codeCoveragePath = builder.codeCoveragePath;
        this.delayInMillis = builder.delayInMillis;
        this.logOnly = builder.logOnly;
        this.testPackages = builder.testPackages;
        this.notTestPackages = builder.notTestPackages;
        this.testSize = builder.testSize;
        this.annotation = builder.annotation;
        this.notAnnotations = Collections.unmodifiableList(builder.notAnnotations);
        this.testTimeout = builder.testTimeout;
        this.listeners = Collections.unmodifiableList(builder.listeners);
        this.tests = Collections.unmodifiableList(builder.tests);
        this.notTests = Collections.unmodifiableList(builder.notTests);
        this.numShards = builder.numShards;
        this.shardIndex = builder.shardIndex;
        this.disableAnalytics = builder.disableAnalytics;
        this.appListeners = Collections.unmodifiableList(builder.appListeners);
    }

    public static class Builder {
        private boolean debug = false;
        private boolean suiteAssignment = false;
        private boolean codeCoverage = false;
        private String codeCoveragePath = null;
        private int delayInMillis = -1;
        private boolean logOnly = false;
        private List<String> testPackages = new ArrayList<String>();
        private List<String> notTestPackages = new ArrayList<String>();
        private String testSize = null;
        private String annotation = null;
        private List<String> notAnnotations = new ArrayList<String>();
        private long testTimeout = -1L;
        private List<RunListener> listeners = new ArrayList<RunListener>();
        private List<TestArg> tests = new ArrayList<TestArg>();
        private List<TestArg> notTests = new ArrayList<TestArg>();
        private int numShards = 0;
        private int shardIndex = 0;
        private boolean disableAnalytics = false;
        private List<ApplicationLifecycleCallback> appListeners = new ArrayList<ApplicationLifecycleCallback>();

        public Builder fromBundle(Bundle bundle) {
            this.debug = this.parseBoolean(bundle.getString(RunnerArgs.ARGUMENT_DEBUG));
            this.delayInMillis = this.parseUnsignedInt(bundle.get(RunnerArgs.ARGUMENT_DELAY_IN_MILLIS), RunnerArgs.ARGUMENT_DELAY_IN_MILLIS);
            this.tests.addAll(this.parseTestClasses(bundle.getString(RunnerArgs.ARGUMENT_TEST_CLASS)));
            this.tests.addAll(this.parseTestClassesFromFile(bundle.getString(RunnerArgs.ARGUMENT_TEST_FILE)));
            this.notTests.addAll(this.parseTestClasses(bundle.getString(RunnerArgs.ARGUMENT_NOT_TEST_CLASS)));
            this.listeners.addAll(this.parseAndLoadClasses(bundle.getString(RunnerArgs.ARGUMENT_LISTENER), RunListener.class));
            this.testPackages.addAll(this.parseTestPackages(bundle.getString(RunnerArgs.ARGUMENT_TEST_PACKAGE)));
            this.notTestPackages.addAll(this.parseTestPackages(bundle.getString(RunnerArgs.ARGUMENT_NOT_TEST_PACKAGE)));
            this.testSize = bundle.getString(RunnerArgs.ARGUMENT_TEST_SIZE);
            this.annotation = bundle.getString(RunnerArgs.ARGUMENT_ANNOTATION);
            this.notAnnotations.addAll(this.parseStrings(bundle.getString(RunnerArgs.ARGUMENT_NOT_ANNOTATION)));
            this.testTimeout = this.parseUnsignedLong(bundle.getString(RunnerArgs.ARGUMENT_TIMEOUT), RunnerArgs.ARGUMENT_TIMEOUT);
            this.numShards = this.parseUnsignedInt(bundle.get(RunnerArgs.ARGUMENT_NUM_SHARDS), RunnerArgs.ARGUMENT_NUM_SHARDS);
            this.shardIndex = this.parseUnsignedInt(bundle.get(RunnerArgs.ARGUMENT_SHARD_INDEX), RunnerArgs.ARGUMENT_SHARD_INDEX);
            this.logOnly = this.parseBoolean(bundle.getString(RunnerArgs.ARGUMENT_LOG_ONLY));
            this.disableAnalytics = this.parseBoolean(bundle.getString(RunnerArgs.ARGUMENT_DISABLE_ANALYTICS));
            this.appListeners.addAll(this.parseAndLoadClasses(bundle.getString(RunnerArgs.ARGUMENT_APP_LISTENER), ApplicationLifecycleCallback.class));
            this.codeCoverage = this.parseBoolean(bundle.getString(RunnerArgs.ARGUMENT_COVERAGE));
            this.codeCoveragePath = bundle.getString(RunnerArgs.ARGUMENT_COVERAGE_PATH);
            this.suiteAssignment = this.parseBoolean(bundle.getString(RunnerArgs.ARGUMENT_SUITE_ASSIGNMENT));
            return this;
        }

        public Builder fromManifest(Instrumentation instr) {
            PackageManager pm = instr.getContext().getPackageManager();
            try {
                InstrumentationInfo instrInfo = pm.getInstrumentationInfo(instr.getComponentName(), 128);
                Bundle b = instrInfo.metaData;
                if (b == null) {
                    return this;
                }
                return this.fromBundle(b);
            }
            catch (PackageManager.NameNotFoundException e) {
                Log.wtf((String)RunnerArgs.LOG_TAG, (String)String.format("Could not find component %s", instr.getComponentName()));
                return this;
            }
        }

        private List<String> parseStrings(String value) {
            if (value == null) {
                return Collections.emptyList();
            }
            return Arrays.asList(value.split(","));
        }

        private boolean parseBoolean(String booleanValue) {
            return booleanValue != null && Boolean.parseBoolean(booleanValue);
        }

        private int parseUnsignedInt(Object value, String name) {
            if (value != null) {
                int intValue = Integer.parseInt(value.toString());
                if (intValue < 0) {
                    throw new NumberFormatException(name + " can not be negative");
                }
                return intValue;
            }
            return -1;
        }

        private long parseUnsignedLong(Object value, String name) {
            if (value != null) {
                long longValue = Long.parseLong(value.toString());
                if (longValue < 0L) {
                    throw new NumberFormatException(name + " can not be negative");
                }
                return longValue;
            }
            return -1L;
        }

        private List<String> parseTestPackages(String packagesArg) {
            ArrayList<String> packages = new ArrayList<String>();
            if (packagesArg != null) {
                for (String packageName : packagesArg.split(String.valueOf(','))) {
                    packages.add(packageName);
                }
            }
            return packages;
        }

        private List<TestArg> parseTestClasses(String classesArg) {
            ArrayList<TestArg> tests = new ArrayList<TestArg>();
            if (classesArg != null) {
                for (String className : classesArg.split(String.valueOf(','))) {
                    tests.add(this.parseTestClass(className));
                }
            }
            return tests;
        }

        private TestArg parseTestClass(String testClassName) {
            int methodSeparatorIndex = testClassName.indexOf(35);
            if (methodSeparatorIndex > 0) {
                String testMethodName = testClassName.substring(methodSeparatorIndex + 1);
                testClassName = testClassName.substring(0, methodSeparatorIndex);
                return new TestArg(testClassName, testMethodName);
            }
            return new TestArg(testClassName);
        }

        private List<TestArg> parseTestClassesFromFile(String filePath) {
            ArrayList<TestArg> tests = new ArrayList<TestArg>();
            if (filePath == null) {
                return tests;
            }
            BufferedReader br = null;
            try {
                String line;
                br = new BufferedReader(new FileReader(new File(filePath)));
                while ((line = br.readLine()) != null) {
                    tests.add(this.parseTestClass(line));
                }
            }
            catch (FileNotFoundException e) {
                throw new IllegalArgumentException("testfile not found: " + filePath);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Could not read testfile " + filePath, e);
            }
            finally {
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (IOException e) {}
                }
            }
            return tests;
        }

        private <T> List<T> parseAndLoadClasses(String classString, Class<T> type) {
            ArrayList objects = new ArrayList();
            if (classString != null) {
                for (String className : classString.split(",")) {
                    this.addByClassName(objects, className, type);
                }
            }
            return objects;
        }

        private <T> void addByClassName(List<T> objects, String className, Class<T> type) {
            if (className == null || className.length() == 0) {
                return;
            }
            try {
                Class<?> klass = Class.forName(className);
                klass.getConstructor(new Class[0]).setAccessible(true);
                Object l = klass.newInstance();
                objects.add(l);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("Could not find extra class " + className);
            }
            catch (NoSuchMethodException e) {
                throw new IllegalArgumentException("Must have no argument constructor for class " + className);
            }
            catch (ClassCastException e) {
                throw new IllegalArgumentException(className + " does not extend " + type.getName());
            }
            catch (InstantiationException e) {
                throw new IllegalArgumentException("Failed to create: " + className, e);
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException("Failed to create listener: " + className, e);
            }
        }

        public RunnerArgs build() {
            return new RunnerArgs(this);
        }
    }

    public static class TestArg {
        public final String testClassName;
        public final String methodName;

        TestArg(String className, String methodName) {
            this.testClassName = className;
            this.methodName = methodName;
        }

        TestArg(String className) {
            this(className, null);
        }
    }
}

