/*
 * Decompiled with CFR 0.152.
 */
package android.support.test.internal.runner;

import android.app.Instrumentation;
import android.os.Build;
import android.os.Bundle;
import android.support.test.filters.RequiresDevice;
import android.support.test.filters.SdkSuppress;
import android.support.test.internal.runner.AndroidRunnerBuilder;
import android.support.test.internal.runner.ClassPathScanner;
import android.support.test.internal.runner.RunnerArgs;
import android.support.test.internal.runner.TestLoader;
import android.support.test.internal.runner.TestRequest;
import android.support.test.internal.util.AndroidRunnerParams;
import android.support.test.internal.util.Checks;
import android.test.suitebuilder.annotation.LargeTest;
import android.test.suitebuilder.annotation.MediumTest;
import android.test.suitebuilder.annotation.SmallTest;
import android.test.suitebuilder.annotation.Suppress;
import android.util.Log;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.junit.runner.Computer;
import org.junit.runner.Description;
import org.junit.runner.Request;
import org.junit.runner.Runner;
import org.junit.runner.manipulation.Filter;
import org.junit.runner.manipulation.NoTestsRemainException;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.RunnerBuilder;

public class TestRequestBuilder {
    private static final String LOG_TAG = "TestRequestBuilder";
    public static final String LARGE_SIZE = "large";
    public static final String MEDIUM_SIZE = "medium";
    public static final String SMALL_SIZE = "small";
    static final String EMULATOR_HARDWARE = "goldfish";
    private static final String[] DEFAULT_EXCLUDED_PACKAGES = new String[]{"junit", "org.junit", "org.hamcrest", "org.mockito", "android.support.test.internal.runner.junit3"};
    static final String MISSING_ARGUMENTS_MSG = "Must provide either classes to run, or apks to scan";
    static final String AMBIGUOUS_ARGUMENTS_MSG = "Ambiguous arguments: cannot provide both test package and test class(es) to run";
    private List<String> mApkPaths = new ArrayList<String>();
    private Set<String> mIncludedPackages = new HashSet<String>();
    private Set<String> mExcludedPackages = new HashSet<String>();
    private Set<String> mIncludedClasses = new HashSet<String>();
    private Set<String> mExcludedClasses = new HashSet<String>();
    private ClassAndMethodFilter mClassMethodFilter = new ClassAndMethodFilter();
    private Filter mFilter = new AnnotationExclusionFilter(Suppress.class).intersect(new SdkSuppressFilter()).intersect((Filter)new RequiresDeviceFilter()).intersect((Filter)this.mClassMethodFilter);
    private boolean mSkipExecution = false;
    private final DeviceBuild mDeviceBuild;
    private long mPerTestTimeout = 0L;
    private final Instrumentation mInstr;
    private final Bundle mArgsBundle;
    private ClassLoader mClassLoader;
    private boolean mIgnoreSuiteMethods = false;

    public TestRequestBuilder(Instrumentation instr, Bundle bundle) {
        this(new DeviceBuildImpl(), instr, bundle);
    }

    TestRequestBuilder(DeviceBuild deviceBuildAccessor, Instrumentation instr, Bundle bundle) {
        this.mDeviceBuild = Checks.checkNotNull(deviceBuildAccessor);
        this.mInstr = Checks.checkNotNull(instr);
        this.mArgsBundle = Checks.checkNotNull(bundle);
    }

    public TestRequestBuilder addApkToScan(String apkPath) {
        this.mApkPaths.add(apkPath);
        return this;
    }

    public TestRequestBuilder setClassLoader(ClassLoader loader) {
        this.mClassLoader = loader;
        return this;
    }

    public TestRequestBuilder addTestClass(String className) {
        this.mIncludedClasses.add(className);
        return this;
    }

    public TestRequestBuilder removeTestClass(String className) {
        this.mExcludedClasses.add(className);
        return this;
    }

    public TestRequestBuilder addTestMethod(String testClassName, String testMethodName) {
        this.mIncludedClasses.add(testClassName);
        this.mClassMethodFilter.addMethod(testClassName, testMethodName);
        this.mIgnoreSuiteMethods = true;
        return this;
    }

    public TestRequestBuilder removeTestMethod(String testClassName, String testMethodName) {
        this.mClassMethodFilter.removeMethod(testClassName, testMethodName);
        this.mIgnoreSuiteMethods = true;
        return this;
    }

    public TestRequestBuilder addTestPackage(String testPackage) {
        this.mIncludedPackages.add(testPackage);
        return this;
    }

    public TestRequestBuilder removeTestPackage(String testPackage) {
        this.mExcludedPackages.add(testPackage);
        return this;
    }

    public TestRequestBuilder addTestSizeFilter(String testSize) {
        if (SMALL_SIZE.equals(testSize)) {
            this.mFilter = this.mFilter.intersect((Filter)new SizeFilter(SmallTest.class));
        } else if (MEDIUM_SIZE.equals(testSize)) {
            this.mFilter = this.mFilter.intersect((Filter)new SizeFilter(MediumTest.class));
        } else if (LARGE_SIZE.equals(testSize)) {
            this.mFilter = this.mFilter.intersect((Filter)new SizeFilter(LargeTest.class));
        } else {
            Log.e((String)LOG_TAG, (String)String.format("Unrecognized test size '%s'", testSize));
        }
        return this;
    }

    public TestRequestBuilder addAnnotationInclusionFilter(String annotation) {
        Class<? extends Annotation> annotationClass = this.loadAnnotationClass(annotation);
        if (annotationClass != null) {
            this.mFilter = this.mFilter.intersect((Filter)new AnnotationInclusionFilter(annotationClass));
        }
        return this;
    }

    public TestRequestBuilder addAnnotationExclusionFilter(String notAnnotation) {
        Class<? extends Annotation> annotationClass = this.loadAnnotationClass(notAnnotation);
        if (annotationClass != null) {
            this.mFilter = this.mFilter.intersect((Filter)new AnnotationExclusionFilter(annotationClass));
        }
        return this;
    }

    public TestRequestBuilder addShardingFilter(int numShards, int shardIndex) {
        this.mFilter = this.mFilter.intersect((Filter)new ShardingFilter(numShards, shardIndex));
        return this;
    }

    public TestRequestBuilder setSkipExecution(boolean b) {
        this.mSkipExecution = b;
        return this;
    }

    public TestRequestBuilder setPerTestTimeout(long millis) {
        this.mPerTestTimeout = millis;
        return this;
    }

    public TestRequestBuilder addFromRunnerArgs(RunnerArgs runnerArgs) {
        for (RunnerArgs.TestArg test : runnerArgs.tests) {
            if (test.methodName == null) {
                this.addTestClass(test.testClassName);
                continue;
            }
            this.addTestMethod(test.testClassName, test.methodName);
        }
        for (RunnerArgs.TestArg test : runnerArgs.notTests) {
            if (test.methodName == null) {
                this.removeTestClass(test.testClassName);
                continue;
            }
            this.removeTestMethod(test.testClassName, test.methodName);
        }
        for (String pkg : runnerArgs.testPackages) {
            this.addTestPackage(pkg);
        }
        for (String pkg : runnerArgs.notTestPackages) {
            this.removeTestPackage(pkg);
        }
        if (runnerArgs.testSize != null) {
            this.addTestSizeFilter(runnerArgs.testSize);
        }
        if (runnerArgs.annotation != null) {
            this.addAnnotationInclusionFilter(runnerArgs.annotation);
        }
        for (String notAnnotation : runnerArgs.notAnnotations) {
            this.addAnnotationExclusionFilter(notAnnotation);
        }
        if (runnerArgs.testTimeout > 0L) {
            this.setPerTestTimeout(runnerArgs.testTimeout);
        }
        if (runnerArgs.numShards > 0 && runnerArgs.shardIndex >= 0 && runnerArgs.shardIndex < runnerArgs.numShards) {
            this.addShardingFilter(runnerArgs.numShards, runnerArgs.shardIndex);
        }
        if (runnerArgs.logOnly) {
            this.setSkipExecution(true);
        }
        return this;
    }

    public TestRequest build() {
        this.mIncludedPackages.removeAll(this.mExcludedPackages);
        this.mIncludedClasses.removeAll(this.mExcludedClasses);
        this.validate(this.mIncludedClasses);
        TestLoader loader = new TestLoader();
        loader.setClassLoader(this.mClassLoader);
        if (this.mIncludedClasses.isEmpty()) {
            this.loadClassesFromClassPath(loader, this.mExcludedClasses);
        } else {
            this.loadClasses(this.mIncludedClasses, loader);
        }
        Request request = TestRequestBuilder.classes(new AndroidRunnerParams(this.mInstr, this.mArgsBundle, this.mSkipExecution, this.mPerTestTimeout, this.mIgnoreSuiteMethods), new Computer(), loader.getLoadedClasses().toArray(new Class[0]));
        return new TestRequest(loader.getLoadFailures(), new LenientFilterRequest(request, this.mFilter));
    }

    private void validate(Set<String> classNames) {
        if (classNames.isEmpty() && this.mApkPaths.isEmpty()) {
            throw new IllegalArgumentException(MISSING_ARGUMENTS_MSG);
        }
        if (!(this.mIncludedPackages.isEmpty() && this.mExcludedPackages.isEmpty() || classNames.isEmpty())) {
            throw new IllegalArgumentException(AMBIGUOUS_ARGUMENTS_MSG);
        }
    }

    private static Request classes(AndroidRunnerParams runnerParams, Computer computer, Class<?> ... classes) {
        try {
            Runner suite = computer.getSuite((RunnerBuilder)new AndroidRunnerBuilder(runnerParams), (Class[])classes);
            return Request.runner((Runner)suite);
        }
        catch (InitializationError e) {
            throw new RuntimeException("Suite constructor, called as above, should always complete");
        }
    }

    private void loadClassesFromClassPath(TestLoader loader, Set<String> excludedClasses) {
        Collection<String> classNames = this.getClassNamesFromClassPath();
        for (String className : classNames) {
            if (excludedClasses.contains(className)) continue;
            loader.loadIfTest(className);
        }
    }

    private void loadClasses(Collection<String> classNames, TestLoader loader) {
        for (String className : classNames) {
            loader.loadClass(className);
        }
    }

    private Collection<String> getClassNamesFromClassPath() {
        if (this.mApkPaths.isEmpty()) {
            throw new IllegalStateException("neither test class to execute or apk paths were provided");
        }
        Log.i((String)LOG_TAG, (String)String.format("Scanning classpath to find tests in apks %s", this.mApkPaths));
        ClassPathScanner scanner = this.createClassPathScanner(this.mApkPaths);
        ClassPathScanner.ChainedClassNameFilter filter = new ClassPathScanner.ChainedClassNameFilter();
        filter.add(new ClassPathScanner.ExternalClassNameFilter());
        for (String pkg : DEFAULT_EXCLUDED_PACKAGES) {
            if (this.mIncludedPackages.contains(pkg)) continue;
            this.mExcludedPackages.add(pkg);
        }
        for (String pkg : this.mIncludedPackages) {
            filter.add(new ClassPathScanner.InclusivePackageNameFilter(pkg));
        }
        for (String pkg : this.mExcludedPackages) {
            filter.add(new ClassPathScanner.ExcludePackageNameFilter(pkg));
        }
        try {
            return scanner.getClassPathEntries(filter);
        }
        catch (IOException e) {
            Log.e((String)LOG_TAG, (String)"Failed to scan classes", (Throwable)e);
            return Collections.emptyList();
        }
    }

    ClassPathScanner createClassPathScanner(List<String> apkPaths) {
        return new ClassPathScanner(apkPaths);
    }

    private Class<? extends Annotation> loadAnnotationClass(String className) {
        try {
            Class<?> clazz = Class.forName(className);
            return clazz;
        }
        catch (ClassNotFoundException e) {
            Log.e((String)LOG_TAG, (String)String.format("Could not find annotation class: %s", className));
        }
        catch (ClassCastException e) {
            Log.e((String)LOG_TAG, (String)String.format("Class %s is not an annotation", className));
        }
        return null;
    }

    private int getDeviceSdkInt() {
        return this.mDeviceBuild.getSdkVersionInt();
    }

    private String getDeviceHardware() {
        return this.mDeviceBuild.getHardware();
    }

    private static class MethodFilter
    extends Filter {
        private final String mClassName;
        private Set<String> mIncludedMethods = new HashSet<String>();
        private Set<String> mExcludedMethods = new HashSet<String>();

        public MethodFilter(String className) {
            this.mClassName = className;
        }

        public String describe() {
            return "Method filter for " + this.mClassName + " class";
        }

        public boolean shouldRun(Description description) {
            if (description.isTest()) {
                String methodName = description.getMethodName();
                if (this.mExcludedMethods.contains(methodName = this.stripParameterizedSuffix(methodName))) {
                    return false;
                }
                return this.mIncludedMethods.isEmpty() || this.mIncludedMethods.contains(methodName) || methodName.equals("initializationError");
            }
            return true;
        }

        private String stripParameterizedSuffix(String name) {
            Pattern suffixPattern = Pattern.compile(".+(\\[[0-9]+\\])$");
            if (suffixPattern.matcher(name).matches()) {
                name = name.substring(0, name.lastIndexOf(91));
            }
            return name;
        }

        public void add(String methodName) {
            this.mIncludedMethods.add(methodName);
        }

        public void remove(String methodName) {
            this.mExcludedMethods.add(methodName);
        }
    }

    private static class ClassAndMethodFilter
    extends Filter {
        private Map<String, MethodFilter> mMethodFilters = new HashMap<String, MethodFilter>();

        private ClassAndMethodFilter() {
        }

        public boolean shouldRun(Description description) {
            if (this.mMethodFilters.isEmpty()) {
                return true;
            }
            if (description.isTest()) {
                String className = description.getClassName();
                MethodFilter methodFilter = this.mMethodFilters.get(className);
                if (methodFilter != null) {
                    return methodFilter.shouldRun(description);
                }
            } else {
                for (Description child : description.getChildren()) {
                    if (!this.shouldRun(child)) continue;
                    return true;
                }
            }
            return false;
        }

        public String describe() {
            return "Class and method filter";
        }

        public void addMethod(String className, String methodName) {
            MethodFilter mf = this.mMethodFilters.get(className);
            if (mf == null) {
                mf = new MethodFilter(className);
                this.mMethodFilters.put(className, mf);
            }
            mf.add(methodName);
        }

        public void removeMethod(String className, String methodName) {
            MethodFilter mf = this.mMethodFilters.get(className);
            if (mf == null) {
                mf = new MethodFilter(className);
                this.mMethodFilters.put(className, mf);
            }
            mf.remove(methodName);
        }
    }

    private static class BlankRunner
    extends Runner {
        private BlankRunner() {
        }

        public Description getDescription() {
            return Description.createSuiteDescription((String)"no tests found", (Annotation[])new Annotation[0]);
        }

        public void run(RunNotifier notifier) {
        }
    }

    private static class LenientFilterRequest
    extends Request {
        private final Request mRequest;
        private final Filter mFilter;

        public LenientFilterRequest(Request classRequest, Filter filter) {
            this.mRequest = classRequest;
            this.mFilter = filter;
        }

        public Runner getRunner() {
            try {
                Runner runner = this.mRequest.getRunner();
                this.mFilter.apply((Object)runner);
                return runner;
            }
            catch (NoTestsRemainException e) {
                return new BlankRunner();
            }
        }
    }

    private static class ShardingFilter
    extends Filter {
        private final int mNumShards;
        private final int mShardIndex;

        ShardingFilter(int numShards, int shardIndex) {
            this.mNumShards = numShards;
            this.mShardIndex = shardIndex;
        }

        public boolean shouldRun(Description description) {
            if (description.isTest()) {
                return Math.abs(description.hashCode()) % this.mNumShards == this.mShardIndex;
            }
            for (Description each : description.getChildren()) {
                if (!this.shouldRun(each)) continue;
                return true;
            }
            return false;
        }

        public String describe() {
            return String.format("Shard %s of %s shards", this.mShardIndex, this.mNumShards);
        }
    }

    private class RequiresDeviceFilter
    extends AnnotationExclusionFilter {
        RequiresDeviceFilter() {
            super(RequiresDevice.class);
        }

        @Override
        protected boolean evaluateTest(Description description) {
            if (!super.evaluateTest(description)) {
                return !TestRequestBuilder.EMULATOR_HARDWARE.equals(TestRequestBuilder.this.getDeviceHardware());
            }
            return true;
        }

        @Override
        public String describe() {
            return String.format("skip tests annotated with RequiresDevice if necessary", new Object[0]);
        }
    }

    private class SdkSuppressFilter
    extends ParentFilter {
        private SdkSuppressFilter() {
        }

        @Override
        protected boolean evaluateTest(Description description) {
            SdkSuppress s = this.getAnnotationForTest(description);
            return s == null || TestRequestBuilder.this.getDeviceSdkInt() >= s.minSdkVersion();
        }

        private SdkSuppress getAnnotationForTest(Description description) {
            SdkSuppress s = (SdkSuppress)description.getAnnotation(SdkSuppress.class);
            if (s != null) {
                return s;
            }
            Class testClass = description.getTestClass();
            if (testClass != null) {
                return testClass.getAnnotation(SdkSuppress.class);
            }
            return null;
        }

        public String describe() {
            return String.format("skip tests annotated with SdkSuppress if necessary", new Object[0]);
        }
    }

    private static class AnnotationExclusionFilter
    extends ParentFilter {
        private final Class<? extends Annotation> mAnnotationClass;

        AnnotationExclusionFilter(Class<? extends Annotation> annotation) {
            this.mAnnotationClass = annotation;
        }

        @Override
        protected boolean evaluateTest(Description description) {
            Class testClass = description.getTestClass();
            return (testClass == null || !testClass.isAnnotationPresent(this.mAnnotationClass)) && description.getAnnotation(this.mAnnotationClass) == null;
        }

        public String describe() {
            return String.format("not annotation %s", this.mAnnotationClass.getName());
        }
    }

    private static class SizeFilter
    extends AnnotationInclusionFilter {
        private static final Set<Class<?>> ALL_SIZES = Collections.unmodifiableSet(new HashSet<Class>(Arrays.asList(SmallTest.class, MediumTest.class, LargeTest.class)));

        SizeFilter(Class<? extends Annotation> annotation) {
            super(annotation);
        }

        @Override
        protected boolean evaluateTest(Description description) {
            Class testClass = description.getTestClass();
            if (description.getAnnotation(this.getAnnotationClass()) != null) {
                return true;
            }
            if (testClass != null && testClass.isAnnotationPresent(this.getAnnotationClass())) {
                for (Annotation a : description.getAnnotations()) {
                    if (!ALL_SIZES.contains(a.annotationType())) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
    }

    private static class AnnotationInclusionFilter
    extends ParentFilter {
        private final Class<? extends Annotation> mAnnotationClass;

        AnnotationInclusionFilter(Class<? extends Annotation> annotation) {
            this.mAnnotationClass = annotation;
        }

        @Override
        protected boolean evaluateTest(Description description) {
            Class testClass = description.getTestClass();
            return description.getAnnotation(this.mAnnotationClass) != null || testClass != null && testClass.isAnnotationPresent(this.mAnnotationClass);
        }

        protected Class<? extends Annotation> getAnnotationClass() {
            return this.mAnnotationClass;
        }

        public String describe() {
            return String.format("annotation %s", this.mAnnotationClass.getName());
        }
    }

    private static abstract class ParentFilter
    extends Filter {
        private ParentFilter() {
        }

        public boolean shouldRun(Description description) {
            if (description.isTest()) {
                return this.evaluateTest(description);
            }
            for (Description each : description.getChildren()) {
                if (!this.shouldRun(each)) continue;
                return true;
            }
            return false;
        }

        protected abstract boolean evaluateTest(Description var1);
    }

    private static class DeviceBuildImpl
    implements DeviceBuild {
        private DeviceBuildImpl() {
        }

        @Override
        public int getSdkVersionInt() {
            return Build.VERSION.SDK_INT;
        }

        @Override
        public String getHardware() {
            return Build.HARDWARE;
        }
    }

    static interface DeviceBuild {
        public int getSdkVersionInt();

        public String getHardware();
    }
}

