/*
 * Decompiled with CFR 0.152.
 */
package android.support.transition;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ObjectAnimator;
import android.support.transition.TransitionPort;
import android.support.transition.TransitionValues;
import android.support.transition.ViewGroupOverlay;
import android.support.transition.VisibilityPort;
import android.support.v4.view.ViewCompat;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;

class FadePort
extends VisibilityPort {
    public static final int IN = 1;
    public static final int OUT = 2;
    private static final String LOG_TAG = "Fade";
    private static final String PROPNAME_SCREEN_X = "android:fade:screenX";
    private static final String PROPNAME_SCREEN_Y = "android:fade:screenY";
    private static boolean DBG = false;
    private int mFadingMode;

    public FadePort() {
        this(3);
    }

    public FadePort(int fadingMode) {
        this.mFadingMode = fadingMode;
    }

    private Animator createAnimation(View view, float startAlpha, float endAlpha, AnimatorListenerAdapter listener) {
        if (startAlpha == endAlpha) {
            if (listener != null) {
                listener.onAnimationEnd(null);
            }
            return null;
        }
        ObjectAnimator anim = ObjectAnimator.ofFloat((Object)view, (String)"alpha", (float[])new float[]{startAlpha, endAlpha});
        if (DBG) {
            Log.d((String)LOG_TAG, (String)("Created animator " + anim));
        }
        if (listener != null) {
            anim.addListener((Animator.AnimatorListener)listener);
        }
        return anim;
    }

    private void captureValues(TransitionValues transitionValues) {
        int[] loc = new int[2];
        transitionValues.view.getLocationOnScreen(loc);
        transitionValues.values.put(PROPNAME_SCREEN_X, loc[0]);
        transitionValues.values.put(PROPNAME_SCREEN_Y, loc[1]);
    }

    @Override
    public void captureStartValues(TransitionValues transitionValues) {
        super.captureStartValues(transitionValues);
        this.captureValues(transitionValues);
    }

    @Override
    public Animator onAppear(ViewGroup sceneRoot, TransitionValues startValues, int startVisibility, TransitionValues endValues, int endVisibility) {
        if ((this.mFadingMode & 1) != 1 || endValues == null) {
            return null;
        }
        final View endView = endValues.view;
        if (DBG) {
            View startView = startValues != null ? startValues.view : null;
            Log.d((String)LOG_TAG, (String)("Fade.onAppear: startView, startVis, endView, endVis = " + startView + ", " + startVisibility + ", " + endView + ", " + endVisibility));
        }
        endView.setAlpha(0.0f);
        TransitionPort.TransitionListenerAdapter transitionListener = new TransitionPort.TransitionListenerAdapter(){
            boolean mCanceled = false;
            float mPausedAlpha;

            @Override
            public void onTransitionCancel(TransitionPort transition) {
                endView.setAlpha(1.0f);
                this.mCanceled = true;
            }

            @Override
            public void onTransitionEnd(TransitionPort transition) {
                if (!this.mCanceled) {
                    endView.setAlpha(1.0f);
                }
            }

            @Override
            public void onTransitionPause(TransitionPort transition) {
                this.mPausedAlpha = endView.getAlpha();
                endView.setAlpha(1.0f);
            }

            @Override
            public void onTransitionResume(TransitionPort transition) {
                endView.setAlpha(this.mPausedAlpha);
            }
        };
        this.addListener(transitionListener);
        return this.createAnimation(endView, 0.0f, 1.0f, null);
    }

    @Override
    public Animator onDisappear(ViewGroup sceneRoot, TransitionValues startValues, int startVisibility, TransitionValues endValues, int endVisibility) {
        View endView;
        if ((this.mFadingMode & 2) != 2) {
            return null;
        }
        View view = null;
        View startView = startValues != null ? startValues.view : null;
        View view2 = endView = endValues != null ? endValues.view : null;
        if (DBG) {
            Log.d((String)LOG_TAG, (String)("Fade.onDisappear: startView, startVis, endView, endVis = " + startView + ", " + startVisibility + ", " + endView + ", " + endVisibility));
        }
        View overlayView = null;
        View viewToKeep = null;
        if (endView == null || endView.getParent() == null) {
            if (endView != null) {
                view = overlayView = endView;
            } else if (startView != null) {
                View startParent;
                int id2;
                if (startView.getParent() == null) {
                    view = overlayView = startView;
                } else if (startView.getParent() instanceof View && startView.getParent().getParent() == null && (id2 = (startParent = (View)startView.getParent()).getId()) != -1 && sceneRoot.findViewById(id2) != null && this.mCanRemoveViews) {
                    view = overlayView = startView;
                }
            }
        } else if (endVisibility == 4) {
            viewToKeep = view = endView;
        } else if (startView == endView) {
            viewToKeep = view = endView;
        } else {
            overlayView = view = startView;
        }
        final int finalVisibility = endVisibility;
        if (overlayView != null) {
            int screenX = (Integer)startValues.values.get(PROPNAME_SCREEN_X);
            int screenY = (Integer)startValues.values.get(PROPNAME_SCREEN_Y);
            int[] loc = new int[2];
            sceneRoot.getLocationOnScreen(loc);
            ViewCompat.offsetLeftAndRight((View)overlayView, (int)(screenX - loc[0] - overlayView.getLeft()));
            ViewCompat.offsetTopAndBottom((View)overlayView, (int)(screenY - loc[1] - overlayView.getTop()));
            ViewGroupOverlay.createFrom(sceneRoot).add(overlayView);
            float startAlpha = 1.0f;
            float endAlpha = 0.0f;
            final View finalView = view;
            final View finalOverlayView = overlayView;
            final View finalViewToKeep = viewToKeep;
            final ViewGroup finalSceneRoot = sceneRoot;
            AnimatorListenerAdapter endListener = new AnimatorListenerAdapter(){

                public void onAnimationEnd(Animator animation) {
                    finalView.setAlpha(1.0f);
                    if (finalViewToKeep != null) {
                        finalViewToKeep.setVisibility(finalVisibility);
                    }
                    if (finalOverlayView != null) {
                        ViewGroupOverlay.createFrom(finalSceneRoot).remove(finalOverlayView);
                    }
                }
            };
            return this.createAnimation(view, 1.0f, endAlpha, endListener);
        }
        if (viewToKeep != null) {
            viewToKeep.setVisibility(0);
            float startAlpha = 1.0f;
            float endAlpha = 0.0f;
            final View finalView = view;
            final View finalOverlayView = overlayView;
            final View finalViewToKeep = viewToKeep;
            final ViewGroup finalSceneRoot = sceneRoot;
            AnimatorListenerAdapter endListener = new AnimatorListenerAdapter(){
                boolean mCanceled = false;
                float mPausedAlpha = -1.0f;

                public void onAnimationCancel(Animator animation) {
                    this.mCanceled = true;
                    if (this.mPausedAlpha >= 0.0f) {
                        finalView.setAlpha(this.mPausedAlpha);
                    }
                }

                public void onAnimationEnd(Animator animation) {
                    if (!this.mCanceled) {
                        finalView.setAlpha(1.0f);
                    }
                    if (finalViewToKeep != null && !this.mCanceled) {
                        finalViewToKeep.setVisibility(finalVisibility);
                    }
                    if (finalOverlayView != null) {
                        ViewGroupOverlay.createFrom(finalSceneRoot).add(finalOverlayView);
                    }
                }
            };
            return this.createAnimation(view, 1.0f, endAlpha, endListener);
        }
        return null;
    }
}

