/*
 * Decompiled with CFR 0.152.
 */
package android.support.transition;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.TimeInterpolator;
import android.annotation.TargetApi;
import android.support.annotation.RequiresApi;
import android.support.annotation.RestrictTo;
import android.support.transition.TransitionSetPort;
import android.support.transition.TransitionValues;
import android.support.transition.TransitionValuesMaps;
import android.support.transition.WindowIdPort;
import android.support.v4.util.ArrayMap;
import android.support.v4.util.LongSparseArray;
import android.util.SparseArray;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ListView;
import java.util.ArrayList;
import java.util.List;

@RequiresApi(value=14)
@TargetApi(value=14)
abstract class TransitionPort
implements Cloneable {
    static final boolean DBG = false;
    private static final String LOG_TAG = "Transition";
    private static ThreadLocal<ArrayMap<Animator, AnimationInfo>> sRunningAnimators = new ThreadLocal();
    long mStartDelay = -1L;
    long mDuration = -1L;
    TimeInterpolator mInterpolator = null;
    ArrayList<Integer> mTargetIds = new ArrayList();
    ArrayList<View> mTargets = new ArrayList();
    ArrayList<Integer> mTargetIdExcludes = null;
    ArrayList<View> mTargetExcludes = null;
    ArrayList<Class> mTargetTypeExcludes = null;
    ArrayList<Integer> mTargetIdChildExcludes = null;
    ArrayList<View> mTargetChildExcludes = null;
    ArrayList<Class> mTargetTypeChildExcludes = null;
    TransitionSetPort mParent = null;
    ViewGroup mSceneRoot = null;
    boolean mCanRemoveViews = false;
    int mNumInstances = 0;
    boolean mPaused = false;
    ArrayList<TransitionListener> mListeners = null;
    ArrayList<Animator> mAnimators = new ArrayList();
    private String mName = this.getClass().getName();
    private TransitionValuesMaps mStartValues = new TransitionValuesMaps();
    private TransitionValuesMaps mEndValues = new TransitionValuesMaps();
    ArrayList<Animator> mCurrentAnimators = new ArrayList();
    private boolean mEnded = false;

    private static ArrayMap<Animator, AnimationInfo> getRunningAnimators() {
        ArrayMap runningAnimators = sRunningAnimators.get();
        if (runningAnimators == null) {
            runningAnimators = new ArrayMap();
            sRunningAnimators.set((ArrayMap<Animator, AnimationInfo>)runningAnimators);
        }
        return runningAnimators;
    }

    public long getDuration() {
        return this.mDuration;
    }

    public TransitionPort setDuration(long duration) {
        this.mDuration = duration;
        return this;
    }

    public long getStartDelay() {
        return this.mStartDelay;
    }

    public TransitionPort setStartDelay(long startDelay) {
        this.mStartDelay = startDelay;
        return this;
    }

    public TimeInterpolator getInterpolator() {
        return this.mInterpolator;
    }

    public TransitionPort setInterpolator(TimeInterpolator interpolator) {
        this.mInterpolator = interpolator;
        return this;
    }

    public String[] getTransitionProperties() {
        return null;
    }

    public Animator createAnimator(ViewGroup sceneRoot, TransitionValues startValues, TransitionValues endValues) {
        return null;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    protected void createAnimators(ViewGroup sceneRoot, TransitionValuesMaps startValues, TransitionValuesMaps endValues) {
        ArrayMap endCopy = new ArrayMap(endValues.viewValues);
        SparseArray endIdCopy = new SparseArray(endValues.idValues.size());
        for (int i = 0; i < endValues.idValues.size(); ++i) {
            int id2 = endValues.idValues.keyAt(i);
            endIdCopy.put(id2, endValues.idValues.valueAt(i));
        }
        LongSparseArray endItemIdCopy = new LongSparseArray(endValues.itemIdValues.size());
        for (int i = 0; i < endValues.itemIdValues.size(); ++i) {
            long id3 = endValues.itemIdValues.keyAt(i);
            endItemIdCopy.put(id3, endValues.itemIdValues.valueAt(i));
        }
        ArrayList<TransitionValues> startValuesList = new ArrayList<TransitionValues>();
        ArrayList<TransitionValues> endValuesList = new ArrayList<TransitionValues>();
        for (View view : startValues.viewValues.keySet()) {
            TransitionValues start;
            TransitionValues end = null;
            boolean isInListView = false;
            if (view.getParent() instanceof ListView) {
                isInListView = true;
            }
            if (!isInListView) {
                int id4 = view.getId();
                TransitionValues transitionValues = start = startValues.viewValues.get((Object)view) != null ? (TransitionValues)startValues.viewValues.get((Object)view) : (TransitionValues)startValues.idValues.get(id4);
                if (endValues.viewValues.get((Object)view) != null) {
                    end = (TransitionValues)endValues.viewValues.get((Object)view);
                    endCopy.remove((Object)view);
                } else if (id4 != -1) {
                    end = (TransitionValues)endValues.idValues.get(id4);
                    View removeView = null;
                    for (View viewToRemove : endCopy.keySet()) {
                        if (viewToRemove.getId() != id4) continue;
                        removeView = viewToRemove;
                    }
                    if (removeView != null) {
                        endCopy.remove(removeView);
                    }
                }
                endIdCopy.remove(id4);
                if (!this.isValidTarget(view, id4)) continue;
                startValuesList.add(start);
                endValuesList.add(end);
                continue;
            }
            ListView parent = (ListView)view.getParent();
            if (!parent.getAdapter().hasStableIds()) continue;
            int position = parent.getPositionForView(view);
            long itemId = parent.getItemIdAtPosition(position);
            start = (TransitionValues)startValues.itemIdValues.get(itemId);
            endItemIdCopy.remove(itemId);
            startValuesList.add(start);
            endValuesList.add(end);
        }
        int startItemIdCopySize = startValues.itemIdValues.size();
        for (int i = 0; i < startItemIdCopySize; ++i) {
            long id5 = startValues.itemIdValues.keyAt(i);
            if (!this.isValidTarget(null, id5)) continue;
            TransitionValues start = (TransitionValues)startValues.itemIdValues.get(id5);
            TransitionValues end = (TransitionValues)endValues.itemIdValues.get(id5);
            endItemIdCopy.remove(id5);
            startValuesList.add(start);
            endValuesList.add(end);
        }
        for (View view : endCopy.keySet()) {
            int id6;
            if (!this.isValidTarget(view, id6 = view.getId())) continue;
            TransitionValues start = startValues.viewValues.get((Object)view) != null ? (TransitionValues)startValues.viewValues.get((Object)view) : (TransitionValues)startValues.idValues.get(id6);
            TransitionValues end = (TransitionValues)endCopy.get((Object)view);
            endIdCopy.remove(id6);
            startValuesList.add(start);
            endValuesList.add(end);
        }
        int endIdCopySize = endIdCopy.size();
        for (int i = 0; i < endIdCopySize; ++i) {
            int id7 = endIdCopy.keyAt(i);
            if (!this.isValidTarget(null, id7)) continue;
            TransitionValues start = (TransitionValues)startValues.idValues.get(id7);
            TransitionValues end = (TransitionValues)endIdCopy.get(id7);
            startValuesList.add(start);
            endValuesList.add(end);
        }
        int endItemIdCopySize = endItemIdCopy.size();
        for (int i = 0; i < endItemIdCopySize; ++i) {
            long id8 = endItemIdCopy.keyAt(i);
            TransitionValues start = (TransitionValues)startValues.itemIdValues.get(id8);
            TransitionValues end = (TransitionValues)endItemIdCopy.get(id8);
            startValuesList.add(start);
            endValuesList.add(end);
        }
        ArrayMap<Animator, AnimationInfo> runningAnimators = TransitionPort.getRunningAnimators();
        for (int i = 0; i < startValuesList.size(); ++i) {
            View view;
            Animator animator;
            TransitionValues start = (TransitionValues)startValuesList.get(i);
            TransitionValues end = (TransitionValues)endValuesList.get(i);
            if (start == null && end == null || start != null && start.equals(end) || (animator = this.createAnimator(sceneRoot, start, end)) == null) continue;
            TransitionValues infoValues = null;
            if (end != null) {
                view = end.view;
                String[] properties = this.getTransitionProperties();
                if (view != null && properties != null && properties.length > 0) {
                    infoValues = new TransitionValues();
                    infoValues.view = view;
                    TransitionValues newValues = (TransitionValues)endValues.viewValues.get((Object)view);
                    if (newValues != null) {
                        for (int j = 0; j < properties.length; ++j) {
                            infoValues.values.put(properties[j], newValues.values.get(properties[j]));
                        }
                    }
                    int numExistingAnims = runningAnimators.size();
                    for (int j = 0; j < numExistingAnims; ++j) {
                        Animator anim = (Animator)runningAnimators.keyAt(j);
                        AnimationInfo info = (AnimationInfo)runningAnimators.get((Object)anim);
                        if (info.values == null || info.view != view || (info.name != null || this.getName() != null) && !info.name.equals(this.getName()) || !info.values.equals(infoValues)) continue;
                        animator = null;
                        break;
                    }
                }
            } else {
                view = start.view;
            }
            if (animator == null) continue;
            AnimationInfo info = new AnimationInfo(view, this.getName(), WindowIdPort.getWindowId((View)sceneRoot), infoValues);
            runningAnimators.put((Object)animator, (Object)info);
            this.mAnimators.add(animator);
        }
    }

    boolean isValidTarget(View target, long targetId) {
        int i;
        if (this.mTargetIdExcludes != null && this.mTargetIdExcludes.contains((int)targetId)) {
            return false;
        }
        if (this.mTargetExcludes != null && this.mTargetExcludes.contains(target)) {
            return false;
        }
        if (this.mTargetTypeExcludes != null && target != null) {
            int numTypes = this.mTargetTypeExcludes.size();
            for (int i2 = 0; i2 < numTypes; ++i2) {
                Class type = this.mTargetTypeExcludes.get(i2);
                if (!type.isInstance(target)) continue;
                return false;
            }
        }
        if (this.mTargetIds.size() == 0 && this.mTargets.size() == 0) {
            return true;
        }
        if (this.mTargetIds.size() > 0) {
            for (i = 0; i < this.mTargetIds.size(); ++i) {
                if ((long)this.mTargetIds.get(i).intValue() != targetId) continue;
                return true;
            }
        }
        if (target != null && this.mTargets.size() > 0) {
            for (i = 0; i < this.mTargets.size(); ++i) {
                if (this.mTargets.get(i) != target) continue;
                return true;
            }
        }
        return false;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    protected void runAnimators() {
        this.start();
        ArrayMap<Animator, AnimationInfo> runningAnimators = TransitionPort.getRunningAnimators();
        for (Animator anim : this.mAnimators) {
            if (!runningAnimators.containsKey((Object)anim)) continue;
            this.start();
            this.runAnimator(anim, runningAnimators);
        }
        this.mAnimators.clear();
        this.end();
    }

    private void runAnimator(Animator animator, final ArrayMap<Animator, AnimationInfo> runningAnimators) {
        if (animator != null) {
            animator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationStart(Animator animation) {
                    TransitionPort.this.mCurrentAnimators.add(animation);
                }

                public void onAnimationEnd(Animator animation) {
                    runningAnimators.remove((Object)animation);
                    TransitionPort.this.mCurrentAnimators.remove(animation);
                }
            });
            this.animate(animator);
        }
    }

    public abstract void captureStartValues(TransitionValues var1);

    public abstract void captureEndValues(TransitionValues var1);

    public TransitionPort addTarget(int targetId) {
        if (targetId > 0) {
            this.mTargetIds.add(targetId);
        }
        return this;
    }

    public TransitionPort removeTarget(int targetId) {
        if (targetId > 0) {
            this.mTargetIds.remove((Object)targetId);
        }
        return this;
    }

    public TransitionPort excludeTarget(int targetId, boolean exclude) {
        this.mTargetIdExcludes = this.excludeId(this.mTargetIdExcludes, targetId, exclude);
        return this;
    }

    public TransitionPort excludeChildren(int targetId, boolean exclude) {
        this.mTargetIdChildExcludes = this.excludeId(this.mTargetIdChildExcludes, targetId, exclude);
        return this;
    }

    private ArrayList<Integer> excludeId(ArrayList<Integer> list, int targetId, boolean exclude) {
        if (targetId > 0) {
            list = exclude ? ArrayListManager.add(list, targetId) : ArrayListManager.remove(list, targetId);
        }
        return list;
    }

    public TransitionPort excludeTarget(View target, boolean exclude) {
        this.mTargetExcludes = this.excludeView(this.mTargetExcludes, target, exclude);
        return this;
    }

    public TransitionPort excludeChildren(View target, boolean exclude) {
        this.mTargetChildExcludes = this.excludeView(this.mTargetChildExcludes, target, exclude);
        return this;
    }

    private ArrayList<View> excludeView(ArrayList<View> list, View target, boolean exclude) {
        if (target != null) {
            list = exclude ? ArrayListManager.add(list, target) : ArrayListManager.remove(list, target);
        }
        return list;
    }

    public TransitionPort excludeTarget(Class type, boolean exclude) {
        this.mTargetTypeExcludes = this.excludeType(this.mTargetTypeExcludes, type, exclude);
        return this;
    }

    public TransitionPort excludeChildren(Class type, boolean exclude) {
        this.mTargetTypeChildExcludes = this.excludeType(this.mTargetTypeChildExcludes, type, exclude);
        return this;
    }

    private ArrayList<Class> excludeType(ArrayList<Class> list, Class type, boolean exclude) {
        if (type != null) {
            list = exclude ? ArrayListManager.add(list, type) : ArrayListManager.remove(list, type);
        }
        return list;
    }

    public TransitionPort addTarget(View target) {
        this.mTargets.add(target);
        return this;
    }

    public TransitionPort removeTarget(View target) {
        if (target != null) {
            this.mTargets.remove(target);
        }
        return this;
    }

    public List<Integer> getTargetIds() {
        return this.mTargetIds;
    }

    public List<View> getTargets() {
        return this.mTargets;
    }

    void captureValues(ViewGroup sceneRoot, boolean start) {
        this.clearValues(start);
        if (this.mTargetIds.size() > 0 || this.mTargets.size() > 0) {
            int i;
            if (this.mTargetIds.size() > 0) {
                for (i = 0; i < this.mTargetIds.size(); ++i) {
                    int id2 = this.mTargetIds.get(i);
                    View view = sceneRoot.findViewById(id2);
                    if (view == null) continue;
                    TransitionValues values = new TransitionValues();
                    values.view = view;
                    if (start) {
                        this.captureStartValues(values);
                    } else {
                        this.captureEndValues(values);
                    }
                    if (start) {
                        this.mStartValues.viewValues.put((Object)view, (Object)values);
                        if (id2 < 0) continue;
                        this.mStartValues.idValues.put(id2, (Object)values);
                        continue;
                    }
                    this.mEndValues.viewValues.put((Object)view, (Object)values);
                    if (id2 < 0) continue;
                    this.mEndValues.idValues.put(id2, (Object)values);
                }
            }
            if (this.mTargets.size() > 0) {
                for (i = 0; i < this.mTargets.size(); ++i) {
                    View view = this.mTargets.get(i);
                    if (view == null) continue;
                    TransitionValues values = new TransitionValues();
                    values.view = view;
                    if (start) {
                        this.captureStartValues(values);
                    } else {
                        this.captureEndValues(values);
                    }
                    if (start) {
                        this.mStartValues.viewValues.put((Object)view, (Object)values);
                        continue;
                    }
                    this.mEndValues.viewValues.put((Object)view, (Object)values);
                }
            }
        } else {
            this.captureHierarchy((View)sceneRoot, start);
        }
    }

    void clearValues(boolean start) {
        if (start) {
            this.mStartValues.viewValues.clear();
            this.mStartValues.idValues.clear();
            this.mStartValues.itemIdValues.clear();
        } else {
            this.mEndValues.viewValues.clear();
            this.mEndValues.idValues.clear();
            this.mEndValues.itemIdValues.clear();
        }
    }

    private void captureHierarchy(View view, boolean start) {
        if (view == null) {
            return;
        }
        boolean isListViewItem = false;
        if (view.getParent() instanceof ListView) {
            isListViewItem = true;
        }
        if (isListViewItem && !((ListView)view.getParent()).getAdapter().hasStableIds()) {
            return;
        }
        int id2 = -1;
        long itemId = -1L;
        if (!isListViewItem) {
            id2 = view.getId();
        } else {
            ListView listview = (ListView)view.getParent();
            int position = listview.getPositionForView(view);
            itemId = listview.getItemIdAtPosition(position);
        }
        if (this.mTargetIdExcludes != null && this.mTargetIdExcludes.contains(id2)) {
            return;
        }
        if (this.mTargetExcludes != null && this.mTargetExcludes.contains(view)) {
            return;
        }
        if (this.mTargetTypeExcludes != null && view != null) {
            int numTypes = this.mTargetTypeExcludes.size();
            for (int i = 0; i < numTypes; ++i) {
                if (!this.mTargetTypeExcludes.get(i).isInstance(view)) continue;
                return;
            }
        }
        TransitionValues values = new TransitionValues();
        values.view = view;
        if (start) {
            this.captureStartValues(values);
        } else {
            this.captureEndValues(values);
        }
        if (start) {
            if (!isListViewItem) {
                this.mStartValues.viewValues.put((Object)view, (Object)values);
                if (id2 >= 0) {
                    this.mStartValues.idValues.put(id2, (Object)values);
                }
            } else {
                this.mStartValues.itemIdValues.put(itemId, (Object)values);
            }
        } else if (!isListViewItem) {
            this.mEndValues.viewValues.put((Object)view, (Object)values);
            if (id2 >= 0) {
                this.mEndValues.idValues.put(id2, (Object)values);
            }
        } else {
            this.mEndValues.itemIdValues.put(itemId, (Object)values);
        }
        if (view instanceof ViewGroup) {
            int i;
            if (this.mTargetIdChildExcludes != null && this.mTargetIdChildExcludes.contains(id2)) {
                return;
            }
            if (this.mTargetChildExcludes != null && this.mTargetChildExcludes.contains(view)) {
                return;
            }
            if (this.mTargetTypeChildExcludes != null && view != null) {
                int numTypes = this.mTargetTypeChildExcludes.size();
                for (i = 0; i < numTypes; ++i) {
                    if (!this.mTargetTypeChildExcludes.get(i).isInstance(view)) continue;
                    return;
                }
            }
            ViewGroup parent = (ViewGroup)view;
            for (i = 0; i < parent.getChildCount(); ++i) {
                this.captureHierarchy(parent.getChildAt(i), start);
            }
        }
    }

    public TransitionValues getTransitionValues(View view, boolean start) {
        if (this.mParent != null) {
            return this.mParent.getTransitionValues(view, start);
        }
        TransitionValuesMaps valuesMaps = start ? this.mStartValues : this.mEndValues;
        TransitionValues values = (TransitionValues)valuesMaps.viewValues.get((Object)view);
        if (values == null) {
            int id2 = view.getId();
            if (id2 >= 0) {
                values = (TransitionValues)valuesMaps.idValues.get(id2);
            }
            if (values == null && view.getParent() instanceof ListView) {
                ListView listview = (ListView)view.getParent();
                int position = listview.getPositionForView(view);
                long itemId = listview.getItemIdAtPosition(position);
                values = (TransitionValues)valuesMaps.itemIdValues.get(itemId);
            }
        }
        return values;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void pause(View sceneRoot) {
        if (!this.mEnded) {
            ArrayMap<Animator, AnimationInfo> runningAnimators = TransitionPort.getRunningAnimators();
            int numOldAnims = runningAnimators.size();
            WindowIdPort windowId = WindowIdPort.getWindowId(sceneRoot);
            for (int i = numOldAnims - 1; i >= 0; --i) {
                AnimationInfo info = (AnimationInfo)runningAnimators.valueAt(i);
                if (info.view == null || !windowId.equals(info.windowId)) continue;
                Animator anim = (Animator)runningAnimators.keyAt(i);
                anim.cancel();
            }
            if (this.mListeners != null && this.mListeners.size() > 0) {
                ArrayList tmpListeners = (ArrayList)this.mListeners.clone();
                int numListeners = tmpListeners.size();
                for (int i = 0; i < numListeners; ++i) {
                    ((TransitionListener)tmpListeners.get(i)).onTransitionPause(this);
                }
            }
            this.mPaused = true;
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void resume(View sceneRoot) {
        if (this.mPaused) {
            if (!this.mEnded) {
                ArrayMap<Animator, AnimationInfo> runningAnimators = TransitionPort.getRunningAnimators();
                int numOldAnims = runningAnimators.size();
                WindowIdPort windowId = WindowIdPort.getWindowId(sceneRoot);
                for (int i = numOldAnims - 1; i >= 0; --i) {
                    AnimationInfo info = (AnimationInfo)runningAnimators.valueAt(i);
                    if (info.view == null || !windowId.equals(info.windowId)) continue;
                    Animator anim = (Animator)runningAnimators.keyAt(i);
                    anim.end();
                }
                if (this.mListeners != null && this.mListeners.size() > 0) {
                    ArrayList tmpListeners = (ArrayList)this.mListeners.clone();
                    int numListeners = tmpListeners.size();
                    for (int i = 0; i < numListeners; ++i) {
                        ((TransitionListener)tmpListeners.get(i)).onTransitionResume(this);
                    }
                }
            }
            this.mPaused = false;
        }
    }

    void playTransition(ViewGroup sceneRoot) {
        ArrayMap<Animator, AnimationInfo> runningAnimators = TransitionPort.getRunningAnimators();
        int numOldAnims = runningAnimators.size();
        for (int i = numOldAnims - 1; i >= 0; --i) {
            TransitionValues newValues;
            AnimationInfo oldInfo;
            Animator anim = (Animator)runningAnimators.keyAt(i);
            if (anim == null || (oldInfo = (AnimationInfo)runningAnimators.get((Object)anim)) == null || oldInfo.view == null || oldInfo.view.getContext() != sceneRoot.getContext()) continue;
            boolean cancel = false;
            TransitionValues oldValues = oldInfo.values;
            View oldView = oldInfo.view;
            TransitionValues transitionValues = newValues = this.mEndValues.viewValues != null ? (TransitionValues)this.mEndValues.viewValues.get((Object)oldView) : null;
            if (newValues == null) {
                newValues = (TransitionValues)this.mEndValues.idValues.get(oldView.getId());
            }
            if (oldValues != null && newValues != null) {
                for (String key : oldValues.values.keySet()) {
                    Object oldValue = oldValues.values.get(key);
                    Object newValue = newValues.values.get(key);
                    if (oldValue == null || newValue == null || oldValue.equals(newValue)) continue;
                    cancel = true;
                    break;
                }
            }
            if (!cancel) continue;
            if (anim.isRunning() || anim.isStarted()) {
                anim.cancel();
                continue;
            }
            runningAnimators.remove((Object)anim);
        }
        this.createAnimators(sceneRoot, this.mStartValues, this.mEndValues);
        this.runAnimators();
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    protected void animate(Animator animator) {
        if (animator == null) {
            this.end();
        } else {
            if (this.getDuration() >= 0L) {
                animator.setDuration(this.getDuration());
            }
            if (this.getStartDelay() >= 0L) {
                animator.setStartDelay(this.getStartDelay());
            }
            if (this.getInterpolator() != null) {
                animator.setInterpolator(this.getInterpolator());
            }
            animator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationEnd(Animator animation) {
                    TransitionPort.this.end();
                    animation.removeListener((Animator.AnimatorListener)this);
                }
            });
            animator.start();
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    protected void start() {
        if (this.mNumInstances == 0) {
            if (this.mListeners != null && this.mListeners.size() > 0) {
                ArrayList tmpListeners = (ArrayList)this.mListeners.clone();
                int numListeners = tmpListeners.size();
                for (int i = 0; i < numListeners; ++i) {
                    ((TransitionListener)tmpListeners.get(i)).onTransitionStart(this);
                }
            }
            this.mEnded = false;
        }
        ++this.mNumInstances;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    protected void end() {
        --this.mNumInstances;
        if (this.mNumInstances == 0) {
            int i;
            if (this.mListeners != null && this.mListeners.size() > 0) {
                ArrayList tmpListeners = (ArrayList)this.mListeners.clone();
                int numListeners = tmpListeners.size();
                for (int i2 = 0; i2 < numListeners; ++i2) {
                    ((TransitionListener)tmpListeners.get(i2)).onTransitionEnd(this);
                }
            }
            for (i = 0; i < this.mStartValues.itemIdValues.size(); ++i) {
                TransitionValues tv = (TransitionValues)this.mStartValues.itemIdValues.valueAt(i);
                View view = tv.view;
            }
            for (i = 0; i < this.mEndValues.itemIdValues.size(); ++i) {
                TransitionValues tv = (TransitionValues)this.mEndValues.itemIdValues.valueAt(i);
                View view = tv.view;
            }
            this.mEnded = true;
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    protected void cancel() {
        int numAnimators = this.mCurrentAnimators.size();
        for (int i = numAnimators - 1; i >= 0; --i) {
            Animator animator = this.mCurrentAnimators.get(i);
            animator.cancel();
        }
        if (this.mListeners != null && this.mListeners.size() > 0) {
            ArrayList tmpListeners = (ArrayList)this.mListeners.clone();
            int numListeners = tmpListeners.size();
            for (int i = 0; i < numListeners; ++i) {
                ((TransitionListener)tmpListeners.get(i)).onTransitionCancel(this);
            }
        }
    }

    public TransitionPort addListener(TransitionListener listener) {
        if (this.mListeners == null) {
            this.mListeners = new ArrayList();
        }
        this.mListeners.add(listener);
        return this;
    }

    public TransitionPort removeListener(TransitionListener listener) {
        if (this.mListeners == null) {
            return this;
        }
        this.mListeners.remove(listener);
        if (this.mListeners.size() == 0) {
            this.mListeners = null;
        }
        return this;
    }

    TransitionPort setSceneRoot(ViewGroup sceneRoot) {
        this.mSceneRoot = sceneRoot;
        return this;
    }

    void setCanRemoveViews(boolean canRemoveViews) {
        this.mCanRemoveViews = canRemoveViews;
    }

    public String toString() {
        return this.toString("");
    }

    public TransitionPort clone() {
        TransitionPort clone = null;
        try {
            clone = (TransitionPort)super.clone();
            clone.mAnimators = new ArrayList();
            clone.mStartValues = new TransitionValuesMaps();
            clone.mEndValues = new TransitionValuesMaps();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return clone;
    }

    public String getName() {
        return this.mName;
    }

    String toString(String indent) {
        String result = indent + this.getClass().getSimpleName() + "@" + Integer.toHexString(this.hashCode()) + ": ";
        if (this.mDuration != -1L) {
            result = result + "dur(" + this.mDuration + ") ";
        }
        if (this.mStartDelay != -1L) {
            result = result + "dly(" + this.mStartDelay + ") ";
        }
        if (this.mInterpolator != null) {
            result = result + "interp(" + this.mInterpolator + ") ";
        }
        if (this.mTargetIds.size() > 0 || this.mTargets.size() > 0) {
            int i;
            result = result + "tgts(";
            if (this.mTargetIds.size() > 0) {
                for (i = 0; i < this.mTargetIds.size(); ++i) {
                    if (i > 0) {
                        result = result + ", ";
                    }
                    result = result + this.mTargetIds.get(i);
                }
            }
            if (this.mTargets.size() > 0) {
                for (i = 0; i < this.mTargets.size(); ++i) {
                    if (i > 0) {
                        result = result + ", ";
                    }
                    result = result + this.mTargets.get(i);
                }
            }
            result = result + ")";
        }
        return result;
    }

    private static class ArrayListManager {
        private ArrayListManager() {
        }

        static <T> ArrayList<T> add(ArrayList<T> list, T item) {
            if (list == null) {
                list = new ArrayList();
            }
            if (!list.contains(item)) {
                list.add(item);
            }
            return list;
        }

        static <T> ArrayList<T> remove(ArrayList<T> list, T item) {
            if (list != null) {
                list.remove(item);
                if (list.isEmpty()) {
                    list = null;
                }
            }
            return list;
        }
    }

    private static class AnimationInfo {
        View view;
        String name;
        TransitionValues values;
        WindowIdPort windowId;

        AnimationInfo(View view, String name, WindowIdPort windowId, TransitionValues values) {
            this.view = view;
            this.name = name;
            this.values = values;
            this.windowId = windowId;
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static class TransitionListenerAdapter
    implements TransitionListener {
        @Override
        public void onTransitionStart(TransitionPort transition) {
        }

        @Override
        public void onTransitionEnd(TransitionPort transition) {
        }

        @Override
        public void onTransitionCancel(TransitionPort transition) {
        }

        @Override
        public void onTransitionPause(TransitionPort transition) {
        }

        @Override
        public void onTransitionResume(TransitionPort transition) {
        }
    }

    public static interface TransitionListener {
        public void onTransitionStart(TransitionPort var1);

        public void onTransitionEnd(TransitionPort var1);

        public void onTransitionCancel(TransitionPort var1);

        public void onTransitionPause(TransitionPort var1);

        public void onTransitionResume(TransitionPort var1);
    }
}

