/*
 * Decompiled with CFR 0.152.
 */
package android.support.transition;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ObjectAnimator;
import android.animation.PropertyValuesHolder;
import android.animation.TypeEvaluator;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Path;
import android.graphics.PointF;
import android.graphics.Rect;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.transition.ObjectAnimatorUtils;
import android.support.transition.PropertyValuesHolderUtils;
import android.support.transition.RectEvaluator;
import android.support.transition.Transition;
import android.support.transition.TransitionUtils;
import android.support.transition.TransitionValues;
import android.support.transition.ViewGroupUtils;
import android.support.transition.ViewUtils;
import android.support.v4.view.ViewCompat;
import android.util.AttributeSet;
import android.util.Property;
import android.view.View;
import android.view.ViewGroup;
import java.util.Map;

public class ChangeBounds
extends Transition {
    private static final String PROPNAME_BOUNDS = "android:changeBounds:bounds";
    private static final String PROPNAME_PARENT = "android:changeBounds:parent";
    private static final String PROPNAME_WINDOW_X = "android:changeBounds:windowX";
    private static final String PROPNAME_WINDOW_Y = "android:changeBounds:windowY";
    private static final String[] sTransitionProperties = new String[]{"android:changeBounds:bounds", "android:changeBounds:parent", "android:changeBounds:windowX", "android:changeBounds:windowY"};
    private static final Property<Drawable, PointF> DRAWABLE_ORIGIN_PROPERTY = new Property<Drawable, PointF>(PointF.class, "boundsOrigin"){
        private Rect mBounds = new Rect();

        public void set(Drawable object, PointF value) {
            object.copyBounds(this.mBounds);
            this.mBounds.offsetTo(Math.round(value.x), Math.round(value.y));
            object.setBounds(this.mBounds);
        }

        public PointF get(Drawable object) {
            object.copyBounds(this.mBounds);
            return new PointF((float)this.mBounds.left, (float)this.mBounds.top);
        }
    };
    private int[] mTempLocation = new int[2];
    private boolean mResizeClip = false;
    private boolean mReparent = false;
    private static RectEvaluator sRectEvaluator = new RectEvaluator();

    public ChangeBounds() {
    }

    public ChangeBounds(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    @Override
    @Nullable
    public String[] getTransitionProperties() {
        return sTransitionProperties;
    }

    public void setResizeClip(boolean resizeClip) {
        this.mResizeClip = resizeClip;
    }

    private void captureValues(TransitionValues values) {
        View view = values.view;
        if (ViewCompat.isLaidOut((View)view) || view.getWidth() != 0 || view.getHeight() != 0) {
            values.values.put(PROPNAME_BOUNDS, new Rect(view.getLeft(), view.getTop(), view.getRight(), view.getBottom()));
            values.values.put(PROPNAME_PARENT, values.view.getParent());
            if (this.mReparent) {
                values.view.getLocationInWindow(this.mTempLocation);
                values.values.put(PROPNAME_WINDOW_X, this.mTempLocation[0]);
                values.values.put(PROPNAME_WINDOW_Y, this.mTempLocation[1]);
            }
        }
    }

    @Override
    public void captureStartValues(@NonNull TransitionValues transitionValues) {
        this.captureValues(transitionValues);
    }

    @Override
    public void captureEndValues(@NonNull TransitionValues transitionValues) {
        this.captureValues(transitionValues);
    }

    private boolean parentMatches(View startParent, View endParent) {
        boolean parentMatches = true;
        if (this.mReparent) {
            TransitionValues endValues = this.getMatchedTransitionValues(startParent, true);
            parentMatches = endValues == null ? startParent == endParent : endParent == endValues.view;
        }
        return parentMatches;
    }

    @Override
    @Nullable
    public Animator createAnimator(final @NonNull ViewGroup sceneRoot, @Nullable TransitionValues startValues, @Nullable TransitionValues endValues) {
        if (startValues == null || endValues == null) {
            return null;
        }
        Map<String, Object> startParentVals = startValues.values;
        Map<String, Object> endParentVals = endValues.values;
        ViewGroup startParent = (ViewGroup)startParentVals.get(PROPNAME_PARENT);
        ViewGroup endParent = (ViewGroup)endParentVals.get(PROPNAME_PARENT);
        if (startParent == null || endParent == null) {
            return null;
        }
        final View view = endValues.view;
        if (this.parentMatches((View)startParent, (View)endParent)) {
            Rect startBounds = (Rect)startValues.values.get(PROPNAME_BOUNDS);
            Rect endBounds = (Rect)endValues.values.get(PROPNAME_BOUNDS);
            int startLeft = startBounds.left;
            int endLeft = endBounds.left;
            int startTop = startBounds.top;
            int endTop = endBounds.top;
            int startRight = startBounds.right;
            int endRight = endBounds.right;
            int startBottom = startBounds.bottom;
            int endBottom = endBounds.bottom;
            int startWidth = startRight - startLeft;
            int startHeight = startBottom - startTop;
            int endWidth = endRight - endLeft;
            int endHeight = endBottom - endTop;
            int numChanges = 0;
            if (startWidth != 0 && startHeight != 0 && endWidth != 0 && endHeight != 0) {
                if (startLeft != endLeft) {
                    ++numChanges;
                }
                if (startTop != endTop) {
                    ++numChanges;
                }
                if (startRight != endRight) {
                    ++numChanges;
                }
                if (startBottom != endBottom) {
                    ++numChanges;
                }
            }
            if (numChanges > 0) {
                if (!this.mResizeClip) {
                    Animator anim;
                    if (startWidth == endWidth && startHeight == endHeight) {
                        view.offsetLeftAndRight(startLeft - view.getLeft());
                        view.offsetTopAndBottom(startTop - view.getTop());
                        Path positionPath = this.getPathMotion().getPath(0.0f, 0.0f, endLeft - startLeft, endTop - startTop);
                        anim = ObjectAnimatorUtils.ofInt(view, new HorizontalOffsetProperty(), new VerticalOffsetProperty(), positionPath);
                    } else {
                        if (startLeft != endLeft) {
                            view.setLeft(startLeft);
                        }
                        if (startTop != endTop) {
                            view.setTop(startTop);
                        }
                        if (startRight != endRight) {
                            view.setRight(startRight);
                        }
                        if (startBottom != endBottom) {
                            view.setBottom(startBottom);
                        }
                        ObjectAnimator topLeftAnimator = null;
                        if (startLeft != endLeft || startTop != endTop) {
                            Path topLeftPath = this.getPathMotion().getPath(startLeft, startTop, endLeft, endTop);
                            topLeftAnimator = ObjectAnimatorUtils.ofInt(view, "left", "top", topLeftPath);
                        }
                        ObjectAnimator bottomRightAnimator = null;
                        if (startRight != endRight || startBottom != endBottom) {
                            Path bottomRightPath = this.getPathMotion().getPath(startRight, startBottom, endRight, endBottom);
                            bottomRightAnimator = ObjectAnimatorUtils.ofInt(view, "right", "bottom", bottomRightPath);
                        }
                        anim = TransitionUtils.mergeAnimators(topLeftAnimator, bottomRightAnimator);
                    }
                    if (view.getParent() instanceof ViewGroup) {
                        final ViewGroup parent = (ViewGroup)view.getParent();
                        ViewGroupUtils.suppressLayout(parent, true);
                        Transition.TransitionListenerAdapter transitionListener = new Transition.TransitionListenerAdapter(){
                            boolean mCanceled = false;

                            @Override
                            public void onTransitionCancel(@NonNull Transition transition) {
                                ViewGroupUtils.suppressLayout(parent, false);
                                this.mCanceled = true;
                            }

                            @Override
                            public void onTransitionEnd(@NonNull Transition transition) {
                                if (!this.mCanceled) {
                                    ViewGroupUtils.suppressLayout(parent, false);
                                }
                            }

                            @Override
                            public void onTransitionPause(@NonNull Transition transition) {
                                ViewGroupUtils.suppressLayout(parent, false);
                            }

                            @Override
                            public void onTransitionResume(@NonNull Transition transition) {
                                ViewGroupUtils.suppressLayout(parent, true);
                            }
                        };
                        this.addListener(transitionListener);
                    }
                    return anim;
                }
                if (startWidth != endWidth) {
                    view.setRight(endLeft + Math.max(startWidth, endWidth));
                }
                if (startHeight != endHeight) {
                    view.setBottom(endTop + Math.max(startHeight, endHeight));
                }
                if (startLeft != endLeft) {
                    view.setTranslationX((float)(startLeft - endLeft));
                }
                if (startTop != endTop) {
                    view.setTranslationY((float)(startTop - endTop));
                }
                float transXDelta = endLeft - startLeft;
                float transYDelta = endTop - startTop;
                int widthDelta = endWidth - startWidth;
                int heightDelta = endHeight - startHeight;
                ObjectAnimator translationAnimator = null;
                if (transXDelta != 0.0f || transYDelta != 0.0f) {
                    Path topLeftPath = this.getPathMotion().getPath(0.0f, 0.0f, transXDelta, transYDelta);
                    translationAnimator = ObjectAnimatorUtils.ofFloat(view, View.TRANSLATION_X, View.TRANSLATION_Y, topLeftPath);
                }
                ObjectAnimator clipAnimator = null;
                if (widthDelta != 0 || heightDelta != 0) {
                    Rect tempStartBounds = new Rect(0, 0, startWidth, startHeight);
                    Rect tempEndBounds = new Rect(0, 0, endWidth, endHeight);
                    clipAnimator = ObjectAnimator.ofObject((Object)view, ViewUtils.CLIP_BOUNDS, (TypeEvaluator)sRectEvaluator, (Object[])new Rect[]{tempStartBounds, tempEndBounds});
                }
                Animator anim = TransitionUtils.mergeAnimators(translationAnimator, clipAnimator);
                if (view.getParent() instanceof ViewGroup) {
                    final ViewGroup parent = (ViewGroup)view.getParent();
                    ViewGroupUtils.suppressLayout(parent, true);
                    Transition.TransitionListenerAdapter transitionListener = new Transition.TransitionListenerAdapter(){
                        boolean mCanceled = false;

                        @Override
                        public void onTransitionCancel(@NonNull Transition transition) {
                            ViewGroupUtils.suppressLayout(parent, false);
                            this.mCanceled = true;
                        }

                        @Override
                        public void onTransitionEnd(@NonNull Transition transition) {
                            if (!this.mCanceled) {
                                ViewGroupUtils.suppressLayout(parent, false);
                            }
                        }

                        @Override
                        public void onTransitionPause(@NonNull Transition transition) {
                            ViewGroupUtils.suppressLayout(parent, false);
                        }

                        @Override
                        public void onTransitionResume(@NonNull Transition transition) {
                            ViewGroupUtils.suppressLayout(parent, true);
                        }
                    };
                    this.addListener(transitionListener);
                }
                anim.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                    public void onAnimationEnd(Animator animation) {
                        ViewCompat.setClipBounds((View)view, null);
                    }
                });
                return anim;
            }
        } else {
            int startX = (Integer)startValues.values.get(PROPNAME_WINDOW_X);
            int startY = (Integer)startValues.values.get(PROPNAME_WINDOW_Y);
            int endX = (Integer)endValues.values.get(PROPNAME_WINDOW_X);
            int endY = (Integer)endValues.values.get(PROPNAME_WINDOW_Y);
            if (startX != endX || startY != endY) {
                sceneRoot.getLocationInWindow(this.mTempLocation);
                Bitmap bitmap = Bitmap.createBitmap((int)view.getWidth(), (int)view.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
                Canvas canvas = new Canvas(bitmap);
                view.draw(canvas);
                final BitmapDrawable drawable = new BitmapDrawable(bitmap);
                final float transitionAlpha = ViewUtils.getTransitionAlpha(view);
                ViewUtils.setTransitionAlpha(view, 0.0f);
                ViewUtils.getOverlay((View)sceneRoot).add((Drawable)drawable);
                Path topLeftPath = this.getPathMotion().getPath(startX - this.mTempLocation[0], startY - this.mTempLocation[1], endX - this.mTempLocation[0], endY - this.mTempLocation[1]);
                PropertyValuesHolder origin = PropertyValuesHolderUtils.ofPointF(DRAWABLE_ORIGIN_PROPERTY, topLeftPath);
                ObjectAnimator anim = ObjectAnimator.ofPropertyValuesHolder((Object)drawable, (PropertyValuesHolder[])new PropertyValuesHolder[]{origin});
                anim.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                    public void onAnimationEnd(Animator animation) {
                        ViewUtils.getOverlay((View)sceneRoot).remove((Drawable)drawable);
                        ViewUtils.setTransitionAlpha(view, transitionAlpha);
                    }
                });
                return anim;
            }
        }
        return null;
    }

    private static class VerticalOffsetProperty
    extends OffsetProperty {
        VerticalOffsetProperty() {
            super("offsetTopAndBottom");
        }

        @Override
        protected void offsetBy(View view, int by) {
            ViewCompat.offsetTopAndBottom((View)view, (int)by);
        }
    }

    private static class HorizontalOffsetProperty
    extends OffsetProperty {
        HorizontalOffsetProperty() {
            super("offsetLeftAndRight");
        }

        @Override
        protected void offsetBy(View view, int by) {
            ViewCompat.offsetLeftAndRight((View)view, (int)by);
        }
    }

    private static abstract class OffsetProperty
    extends Property<View, Integer> {
        int mPreviousValue;

        OffsetProperty(String name) {
            super(Integer.class, name);
        }

        public void set(View view, Integer value) {
            int offset = value - this.mPreviousValue;
            this.offsetBy(view, offset);
            this.mPreviousValue = value;
        }

        public Integer get(View object) {
            return null;
        }

        protected abstract void offsetBy(View var1, int var2);
    }
}

