/*
 * Decompiled with CFR 0.152.
 */
package android.support.wear.ambient;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.support.annotation.CallSuper;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.support.wear.ambient.AmbientDelegate;
import android.support.wear.ambient.WearableControllerProvider;
import android.util.Log;
import java.io.FileDescriptor;
import java.io.PrintWriter;

public final class AmbientModeSupport
extends Fragment {
    private static final String TAG = "AmbientMode";
    public static final String EXTRA_BURN_IN_PROTECTION = "com.google.android.wearable.compat.extra.BURN_IN_PROTECTION";
    public static final String EXTRA_LOWBIT_AMBIENT = "com.google.android.wearable.compat.extra.LOWBIT_AMBIENT";
    public static final String FRAGMENT_TAG = "android.support.wearable.ambient.AmbientMode";
    private final AmbientDelegate.AmbientCallback mCallback = new AmbientDelegate.AmbientCallback(){

        @Override
        public void onEnterAmbient(Bundle ambientDetails) {
            if (AmbientModeSupport.this.mSuppliedCallback != null) {
                AmbientModeSupport.this.mSuppliedCallback.onEnterAmbient(ambientDetails);
            }
        }

        @Override
        public void onExitAmbient() {
            if (AmbientModeSupport.this.mSuppliedCallback != null) {
                AmbientModeSupport.this.mSuppliedCallback.onExitAmbient();
            }
        }

        @Override
        public void onUpdateAmbient() {
            if (AmbientModeSupport.this.mSuppliedCallback != null) {
                AmbientModeSupport.this.mSuppliedCallback.onUpdateAmbient();
            }
        }
    };
    private AmbientDelegate mDelegate;
    @Nullable
    private AmbientCallback mSuppliedCallback;
    private AmbientController mController = new AmbientController();

    @CallSuper
    public void onAttach(Context context) {
        super.onAttach(context);
        this.mDelegate = new AmbientDelegate((Activity)this.getActivity(), new WearableControllerProvider(), this.mCallback);
        if (context instanceof AmbientCallbackProvider) {
            this.mSuppliedCallback = ((AmbientCallbackProvider)context).getAmbientCallback();
        } else {
            Log.w((String)TAG, (String)"No callback provided - enabling only smart resume");
        }
    }

    @CallSuper
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.mDelegate.onCreate();
        if (this.mSuppliedCallback != null) {
            this.mDelegate.setAmbientEnabled();
        }
    }

    @CallSuper
    public void onResume() {
        super.onResume();
        this.mDelegate.onResume();
    }

    @CallSuper
    public void onPause() {
        this.mDelegate.onPause();
        super.onPause();
    }

    @CallSuper
    public void onStop() {
        this.mDelegate.onStop();
        super.onStop();
    }

    @CallSuper
    public void onDestroy() {
        this.mDelegate.onDestroy();
        super.onDestroy();
    }

    @CallSuper
    public void onDetach() {
        this.mDelegate = null;
        super.onDetach();
    }

    public static <T extends FragmentActivity> AmbientController attach(T activity) {
        FragmentManager fragmentManager = activity.getSupportFragmentManager();
        AmbientModeSupport ambientFragment = (AmbientModeSupport)fragmentManager.findFragmentByTag(FRAGMENT_TAG);
        if (ambientFragment == null) {
            AmbientModeSupport fragment = new AmbientModeSupport();
            fragmentManager.beginTransaction().add((Fragment)fragment, FRAGMENT_TAG).commit();
            ambientFragment = fragment;
        }
        return ambientFragment.mController;
    }

    public void dump(String prefix, FileDescriptor fd, PrintWriter writer, String[] args) {
        if (this.mDelegate != null) {
            this.mDelegate.dump(prefix, fd, writer, args);
        }
    }

    @VisibleForTesting
    void setAmbientDelegate(AmbientDelegate delegate) {
        this.mDelegate = delegate;
    }

    public final class AmbientController {
        private static final String TAG = "AmbientController";

        AmbientController() {
        }

        public boolean isAmbient() {
            return AmbientModeSupport.this.mDelegate == null ? false : AmbientModeSupport.this.mDelegate.isAmbient();
        }
    }

    public static abstract class AmbientCallback {
        public void onEnterAmbient(Bundle ambientDetails) {
        }

        public void onUpdateAmbient() {
        }

        public void onExitAmbient() {
        }
    }

    public static interface AmbientCallbackProvider {
        public AmbientCallback getAmbientCallback();
    }
}

