/*
 * Decompiled with CFR 0.152.
 */
package android.support.wear.internal.widget.drawer;

import android.support.annotation.Nullable;
import android.support.annotation.RestrictTo;
import android.support.wear.internal.widget.drawer.WearableNavigationDrawerPresenter;
import android.support.wear.widget.drawer.WearableNavigationDrawerView;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class MultiPagePresenter
extends WearableNavigationDrawerPresenter {
    private final Ui mUi;
    private final WearableNavigationDrawerView mDrawer;
    private final boolean mIsAccessibilityEnabled;
    @Nullable
    private WearableNavigationDrawerView.WearableNavigationDrawerAdapter mAdapter;

    public MultiPagePresenter(WearableNavigationDrawerView drawer, Ui ui, boolean isAccessibilityEnabled) {
        if (drawer == null) {
            throw new IllegalArgumentException("Received null drawer.");
        }
        if (ui == null) {
            throw new IllegalArgumentException("Received null ui.");
        }
        this.mDrawer = drawer;
        this.mUi = ui;
        this.mUi.initialize(drawer, this);
        this.mIsAccessibilityEnabled = isAccessibilityEnabled;
    }

    @Override
    public void onDataSetChanged() {
        this.mUi.notifyNavigationPagerAdapterDataChanged();
        this.mUi.notifyPageIndicatorDataChanged();
    }

    @Override
    public void onNewAdapter(WearableNavigationDrawerView.WearableNavigationDrawerAdapter adapter) {
        if (adapter == null) {
            throw new IllegalArgumentException("Received null adapter.");
        }
        this.mAdapter = adapter;
        this.mAdapter.setPresenter(this);
        this.mUi.setNavigationPagerAdapter(adapter);
    }

    @Override
    public void onSelected(int index) {
        this.notifyItemSelectedListeners(index);
    }

    @Override
    public void onSetCurrentItemRequested(int index, boolean smoothScrollTo) {
        this.mUi.setNavigationPagerSelectedItem(index, smoothScrollTo);
    }

    @Override
    public boolean onDrawerTapped() {
        if (this.mDrawer.isOpened()) {
            if (this.mIsAccessibilityEnabled) {
                this.mDrawer.getController().peekDrawer();
            } else {
                this.mDrawer.getController().closeDrawer();
            }
            return true;
        }
        return false;
    }

    public static interface Ui {
        public void initialize(WearableNavigationDrawerView var1, WearableNavigationDrawerPresenter var2);

        public void notifyNavigationPagerAdapterDataChanged();

        public void notifyPageIndicatorDataChanged();

        public void setNavigationPagerAdapter(WearableNavigationDrawerView.WearableNavigationDrawerAdapter var1);

        public void setNavigationPagerSelectedItem(int var1, boolean var2);
    }
}

