/*
 * Decompiled with CFR 0.152.
 */
package android.support.wear.widget;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RestrictTo;
import android.support.annotation.StyleRes;
import android.support.annotation.UiThread;
import android.support.wear.R;
import android.util.AttributeSet;
import android.view.Gravity;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowInsets;
import android.widget.FrameLayout;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

@UiThread
public class BoxInsetLayout
extends ViewGroup {
    private static final float FACTOR = 0.146447f;
    private static final int DEFAULT_CHILD_GRAVITY = 0x800033;
    private final int mScreenHeight;
    private final int mScreenWidth;
    private boolean mIsRound;
    private Rect mForegroundPadding;
    private Rect mInsets;
    private Drawable mForegroundDrawable;

    public BoxInsetLayout(@NonNull Context context) {
        this(context, null);
    }

    public BoxInsetLayout(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public BoxInsetLayout(@NonNull Context context, @Nullable AttributeSet attrs, @StyleRes int defStyle) {
        super(context, attrs, defStyle);
        if (this.mForegroundPadding == null) {
            this.mForegroundPadding = new Rect();
        }
        if (this.mInsets == null) {
            this.mInsets = new Rect();
        }
        this.mScreenHeight = Resources.getSystem().getDisplayMetrics().heightPixels;
        this.mScreenWidth = Resources.getSystem().getDisplayMetrics().widthPixels;
    }

    public void setForeground(Drawable drawable2) {
        super.setForeground(drawable2);
        this.mForegroundDrawable = drawable2;
        if (this.mForegroundPadding == null) {
            this.mForegroundPadding = new Rect();
        }
        if (this.mForegroundDrawable != null) {
            drawable2.getPadding(this.mForegroundPadding);
        }
    }

    public LayoutParams generateLayoutParams(AttributeSet attrs) {
        return new LayoutParams(this.getContext(), attrs);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.mIsRound = this.getResources().getConfiguration().isScreenRound();
        WindowInsets insets = this.getRootWindowInsets();
        this.mInsets.set(insets.getSystemWindowInsetLeft(), insets.getSystemWindowInsetTop(), insets.getSystemWindowInsetRight(), insets.getSystemWindowInsetBottom());
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int count = this.getChildCount();
        int maxWidth = 0;
        int maxHeight = 0;
        int childState = 0;
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            int marginLeft = 0;
            int marginRight = 0;
            int marginTop = 0;
            int marginBottom = 0;
            if (this.mIsRound) {
                if ((lp.boxedEdges & 1) == 0) {
                    marginLeft = lp.leftMargin;
                }
                if ((lp.boxedEdges & 4) == 0) {
                    marginRight = lp.rightMargin;
                }
                if ((lp.boxedEdges & 2) == 0) {
                    marginTop = lp.topMargin;
                }
                if ((lp.boxedEdges & 8) == 0) {
                    marginBottom = lp.bottomMargin;
                }
            } else {
                marginLeft = lp.leftMargin;
                marginTop = lp.topMargin;
                marginRight = lp.rightMargin;
                marginBottom = lp.bottomMargin;
            }
            this.measureChildWithMargins(child, widthMeasureSpec, 0, heightMeasureSpec, 0);
            maxWidth = Math.max(maxWidth, child.getMeasuredWidth() + marginLeft + marginRight);
            maxHeight = Math.max(maxHeight, child.getMeasuredHeight() + marginTop + marginBottom);
            childState = BoxInsetLayout.combineMeasuredStates((int)childState, (int)child.getMeasuredState());
        }
        maxWidth += this.getPaddingLeft() + this.mForegroundPadding.left + this.getPaddingRight() + this.mForegroundPadding.right;
        maxHeight += this.getPaddingTop() + this.mForegroundPadding.top + this.getPaddingBottom() + this.mForegroundPadding.bottom;
        maxHeight = Math.max(maxHeight, this.getSuggestedMinimumHeight());
        maxWidth = Math.max(maxWidth, this.getSuggestedMinimumWidth());
        if (this.mForegroundDrawable != null) {
            maxHeight = Math.max(maxHeight, this.mForegroundDrawable.getMinimumHeight());
            maxWidth = Math.max(maxWidth, this.mForegroundDrawable.getMinimumWidth());
        }
        int measuredWidth = BoxInsetLayout.resolveSizeAndState((int)maxWidth, (int)widthMeasureSpec, (int)childState);
        int measuredHeight = BoxInsetLayout.resolveSizeAndState((int)maxHeight, (int)heightMeasureSpec, (int)(childState << 16));
        this.setMeasuredDimension(measuredWidth, measuredHeight);
        int boxInset = this.calculateInset(measuredWidth, measuredHeight);
        for (int i = 0; i < count; ++i) {
            this.measureChild(widthMeasureSpec, heightMeasureSpec, boxInset, i);
        }
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        int count = this.getChildCount();
        int parentLeft = this.getPaddingLeft() + this.mForegroundPadding.left;
        int parentRight = right - left - this.getPaddingRight() - this.mForegroundPadding.right;
        int parentTop = this.getPaddingTop() + this.mForegroundPadding.top;
        int parentBottom = bottom - top - this.getPaddingBottom() - this.mForegroundPadding.bottom;
        for (int i = 0; i < count; ++i) {
            int childTop;
            int childLeft;
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            int width = child.getMeasuredWidth();
            int height = child.getMeasuredHeight();
            int gravity = lp.gravity;
            if (gravity == -1) {
                gravity = 0x800033;
            }
            int layoutDirection = this.getLayoutDirection();
            int absoluteGravity = Gravity.getAbsoluteGravity((int)gravity, (int)layoutDirection);
            int verticalGravity = gravity & 0x70;
            int horizontalGravity = gravity & 7;
            int desiredInset = this.calculateInset(this.getMeasuredWidth(), this.getMeasuredHeight());
            int leftChildMargin = this.calculateChildLeftMargin(lp, horizontalGravity, desiredInset);
            int rightChildMargin = this.calculateChildRightMargin(lp, horizontalGravity, desiredInset);
            if (lp.width == -1) {
                childLeft = parentLeft + leftChildMargin;
            } else {
                switch (absoluteGravity & 7) {
                    case 1: {
                        childLeft = parentLeft + (parentRight - parentLeft - width) / 2 + leftChildMargin - rightChildMargin;
                        break;
                    }
                    case 5: {
                        childLeft = parentRight - width - rightChildMargin;
                        break;
                    }
                    default: {
                        childLeft = parentLeft + leftChildMargin;
                    }
                }
            }
            int topChildMargin = this.calculateChildTopMargin(lp, verticalGravity, desiredInset);
            int bottomChildMargin = this.calculateChildBottomMargin(lp, verticalGravity, desiredInset);
            if (lp.height == -1) {
                childTop = parentTop + topChildMargin;
            } else {
                switch (verticalGravity) {
                    case 16: {
                        childTop = parentTop + (parentBottom - parentTop - height) / 2 + topChildMargin - bottomChildMargin;
                        break;
                    }
                    case 80: {
                        childTop = parentBottom - height - bottomChildMargin;
                        break;
                    }
                    default: {
                        childTop = parentTop + topChildMargin;
                    }
                }
            }
            child.layout(childLeft, childTop, childLeft + width, childTop + height);
        }
    }

    protected boolean checkLayoutParams(ViewGroup.LayoutParams p) {
        return p instanceof LayoutParams;
    }

    protected ViewGroup.LayoutParams generateLayoutParams(ViewGroup.LayoutParams p) {
        return new LayoutParams(p);
    }

    private void measureChild(int widthMeasureSpec, int heightMeasureSpec, int desiredMinInset, int i) {
        View child = this.getChildAt(i);
        LayoutParams childLayoutParams = (LayoutParams)child.getLayoutParams();
        int gravity = childLayoutParams.gravity;
        if (gravity == -1) {
            gravity = 0x800033;
        }
        int verticalGravity = gravity & 0x70;
        int horizontalGravity = gravity & 7;
        int leftParentPadding = this.getPaddingLeft() + this.mForegroundPadding.left;
        int rightParentPadding = this.getPaddingRight() + this.mForegroundPadding.right;
        int topParentPadding = this.getPaddingTop() + this.mForegroundPadding.top;
        int bottomParentPadding = this.getPaddingBottom() + this.mForegroundPadding.bottom;
        int totalWidthMargin = leftParentPadding + rightParentPadding + this.calculateChildLeftMargin(childLayoutParams, horizontalGravity, desiredMinInset) + this.calculateChildRightMargin(childLayoutParams, horizontalGravity, desiredMinInset);
        int totalHeightMargin = topParentPadding + bottomParentPadding + this.calculateChildTopMargin(childLayoutParams, verticalGravity, desiredMinInset) + this.calculateChildBottomMargin(childLayoutParams, verticalGravity, desiredMinInset);
        int childWidthMeasureSpec = BoxInsetLayout.getChildMeasureSpec((int)widthMeasureSpec, (int)totalWidthMargin, (int)childLayoutParams.width);
        int childHeightMeasureSpec = BoxInsetLayout.getChildMeasureSpec((int)heightMeasureSpec, (int)totalHeightMargin, (int)childLayoutParams.height);
        int maxAllowedWidth = this.getMeasuredWidth() - totalWidthMargin;
        int maxAllowedHeight = this.getMeasuredHeight() - totalHeightMargin;
        if (child.getMeasuredWidth() > maxAllowedWidth || child.getMeasuredHeight() > maxAllowedHeight) {
            child.measure(childWidthMeasureSpec, childHeightMeasureSpec);
        }
    }

    private int calculateChildLeftMargin(LayoutParams lp, int horizontalGravity, int desiredMinInset) {
        if (this.mIsRound && (lp.boxedEdges & 1) != 0 && (lp.width == -1 || horizontalGravity == 3)) {
            return lp.leftMargin + desiredMinInset;
        }
        return lp.leftMargin;
    }

    private int calculateChildRightMargin(LayoutParams lp, int horizontalGravity, int desiredMinInset) {
        if (this.mIsRound && (lp.boxedEdges & 4) != 0 && (lp.width == -1 || horizontalGravity == 5)) {
            return lp.rightMargin + desiredMinInset;
        }
        return lp.rightMargin;
    }

    private int calculateChildTopMargin(LayoutParams lp, int verticalGravity, int desiredMinInset) {
        if (this.mIsRound && (lp.boxedEdges & 2) != 0 && (lp.height == -1 || verticalGravity == 48)) {
            return lp.topMargin + desiredMinInset;
        }
        return lp.topMargin;
    }

    private int calculateChildBottomMargin(LayoutParams lp, int verticalGravity, int desiredMinInset) {
        if (this.mIsRound && (lp.boxedEdges & 8) != 0 && (lp.height == -1 || verticalGravity == 80)) {
            return lp.bottomMargin + desiredMinInset;
        }
        return lp.bottomMargin;
    }

    private int calculateInset(int measuredWidth, int measuredHeight) {
        int rightEdge = Math.min(measuredWidth, this.mScreenWidth);
        int bottomEdge = Math.min(measuredHeight, this.mScreenHeight);
        return (int)(0.146447f * (float)Math.max(rightEdge, bottomEdge));
    }

    public static class LayoutParams
    extends FrameLayout.LayoutParams {
        public static final int BOX_NONE = 0;
        public static final int BOX_LEFT = 1;
        public static final int BOX_TOP = 2;
        public static final int BOX_RIGHT = 4;
        public static final int BOX_BOTTOM = 8;
        public static final int BOX_ALL = 15;
        public int boxedEdges = 0;

        public LayoutParams(@NonNull Context context, @Nullable AttributeSet attrs) {
            super(context, attrs);
            TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.BoxInsetLayout_Layout, 0, 0);
            this.boxedEdges = a.getInt(R.styleable.BoxInsetLayout_Layout_boxedEdges, 0);
            a.recycle();
        }

        public LayoutParams(int width, int height) {
            super(width, height);
        }

        public LayoutParams(int width, int height, int gravity) {
            super(width, height, gravity);
        }

        public LayoutParams(int width, int height, int gravity, int boxed) {
            super(width, height, gravity);
            this.boxedEdges = boxed;
        }

        public LayoutParams(@NonNull ViewGroup.LayoutParams source) {
            super(source);
        }

        public LayoutParams(@NonNull ViewGroup.MarginLayoutParams source) {
            super(source);
        }

        public LayoutParams(@NonNull FrameLayout.LayoutParams source) {
            super(source);
        }

        public LayoutParams(@NonNull LayoutParams source) {
            super((FrameLayout.LayoutParams)source);
            this.boxedEdges = source.boxedEdges;
            this.gravity = source.gravity;
        }

        @Retention(value=RetentionPolicy.SOURCE)
        @RestrictTo(value={RestrictTo.Scope.LIBRARY})
        public static @interface BoxedEdges {
        }
    }
}

