/*
 * Decompiled with CFR 0.152.
 */
package android.support.wear.widget;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Paint;
import android.graphics.drawable.Drawable;
import android.support.annotation.ColorInt;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import android.support.v4.content.ContextCompat;
import android.support.v4.widget.CircularProgressDrawable;
import android.support.wear.R;
import android.support.wear.widget.CircularProgressLayoutController;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;

@RequiresApi(value=21)
public class CircularProgressLayout
extends FrameLayout {
    private static final long DEFAULT_UPDATE_INTERVAL = 16L;
    private static final float DEFAULT_ROTATION = 0.75f;
    private CircularProgressDrawable mProgressDrawable;
    private CircularProgressLayoutController mController;
    private float mStartingRotation = 0.75f;
    private long mTotalTime;

    public CircularProgressLayout(Context context) {
        this(context, null);
    }

    public CircularProgressLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public CircularProgressLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        this(context, attrs, defStyleAttr, 0);
    }

    public CircularProgressLayout(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.mProgressDrawable = new CircularProgressDrawable(context);
        this.mProgressDrawable.setProgressRotation(0.75f);
        this.mProgressDrawable.setStrokeCap(Paint.Cap.BUTT);
        this.setBackground((Drawable)this.mProgressDrawable);
        this.setOnHierarchyChangeListener(new ViewGroup.OnHierarchyChangeListener(){

            public void onChildViewAdded(View parent, View child) {
                FrameLayout.LayoutParams params = (FrameLayout.LayoutParams)child.getLayoutParams();
                params.gravity = 17;
                child.setLayoutParams((ViewGroup.LayoutParams)params);
            }

            public void onChildViewRemoved(View parent, View child) {
            }
        });
        this.mController = new CircularProgressLayoutController(this);
        Resources r = context.getResources();
        TypedArray a = r.obtainAttributes(attrs, R.styleable.CircularProgressLayout);
        if (a.getType(R.styleable.CircularProgressLayout_colorSchemeColors) == 1 || !a.hasValue(R.styleable.CircularProgressLayout_colorSchemeColors)) {
            int arrayResId = a.getResourceId(R.styleable.CircularProgressLayout_colorSchemeColors, R.array.circular_progress_layout_color_scheme_colors);
            this.setColorSchemeColors(this.getColorListFromResources(r, arrayResId));
        } else {
            this.setColorSchemeColors(a.getColor(R.styleable.CircularProgressLayout_colorSchemeColors, -16777216));
        }
        this.setStrokeWidth(a.getDimensionPixelSize(R.styleable.CircularProgressLayout_strokeWidth, r.getDimensionPixelSize(R.dimen.circular_progress_layout_stroke_width)));
        this.setBackgroundColor(a.getColor(R.styleable.CircularProgressLayout_backgroundColor, ContextCompat.getColor((Context)context, (int)R.color.circular_progress_layout_background_color)));
        this.setIndeterminate(a.getBoolean(R.styleable.CircularProgressLayout_indeterminate, false));
        a.recycle();
    }

    private int[] getColorListFromResources(Resources resources, int arrayResId) {
        TypedArray colorArray = resources.obtainTypedArray(arrayResId);
        int[] colors = new int[colorArray.length()];
        for (int i = 0; i < colorArray.length(); ++i) {
            colors[i] = colorArray.getColor(i, 0);
        }
        colorArray.recycle();
        return colors;
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        if (this.getChildCount() != 0) {
            View childView = this.getChildAt(0);
            this.mProgressDrawable.setCenterRadius((float)Math.min(childView.getWidth(), childView.getHeight()) / 2.0f);
        } else {
            this.mProgressDrawable.setCenterRadius(0.0f);
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.mController.reset();
    }

    public void setBackgroundColor(@ColorInt int color2) {
        this.mProgressDrawable.setBackgroundColor(color2);
    }

    @ColorInt
    public int getBackgroundColor() {
        return this.mProgressDrawable.getBackgroundColor();
    }

    @NonNull
    public CircularProgressDrawable getProgressDrawable() {
        return this.mProgressDrawable;
    }

    public void setIndeterminate(boolean indeterminate) {
        this.mController.setIndeterminate(indeterminate);
    }

    public boolean isIndeterminate() {
        return this.mController.isIndeterminate();
    }

    public void setTotalTime(long totalTime) {
        if (totalTime <= 0L) {
            throw new IllegalArgumentException("Total time should be greater than zero.");
        }
        this.mTotalTime = totalTime;
    }

    public long getTotalTime() {
        return this.mTotalTime;
    }

    public void startTimer() {
        this.mController.startTimer(this.mTotalTime, 16L);
        this.mProgressDrawable.setProgressRotation(this.mStartingRotation);
    }

    public void stopTimer() {
        this.mController.stopTimer();
    }

    public boolean isTimerRunning() {
        return this.mController.isTimerRunning();
    }

    public void setStartingRotation(float rotation) {
        this.mStartingRotation = rotation;
    }

    public float getStartingRotation() {
        return this.mStartingRotation;
    }

    public void setStrokeWidth(float strokeWidth) {
        this.mProgressDrawable.setStrokeWidth(strokeWidth);
    }

    public float getStrokeWidth() {
        return this.mProgressDrawable.getStrokeWidth();
    }

    public void setColorSchemeColors(int ... colors) {
        this.mProgressDrawable.setColorSchemeColors(colors);
    }

    public int[] getColorSchemeColors() {
        return this.mProgressDrawable.getColorSchemeColors();
    }

    @Nullable
    public OnTimerFinishedListener getOnTimerFinishedListener() {
        return this.mController.getOnTimerFinishedListener();
    }

    public void setOnTimerFinishedListener(@Nullable OnTimerFinishedListener listener) {
        this.mController.setOnTimerFinishedListener(listener);
    }

    public static interface OnTimerFinishedListener {
        public void onTimerFinished(CircularProgressLayout var1);
    }
}

