/*
 * Decompiled with CFR 0.152.
 */
package android.support.wear.widget;

import android.os.CountDownTimer;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import android.support.wear.widget.CircularProgressLayout;

class CircularProgressLayoutController {
    private final CircularProgressLayout mLayout;
    @VisibleForTesting
    CountDownTimer mTimer;
    private boolean mIsIndeterminate;
    private boolean mIsTimerRunning;
    @Nullable
    private CircularProgressLayout.OnTimerFinishedListener mOnTimerFinishedListener;

    CircularProgressLayoutController(CircularProgressLayout layout2) {
        this.mLayout = layout2;
    }

    @Nullable
    public CircularProgressLayout.OnTimerFinishedListener getOnTimerFinishedListener() {
        return this.mOnTimerFinishedListener;
    }

    public void setOnTimerFinishedListener(@Nullable CircularProgressLayout.OnTimerFinishedListener listener) {
        this.mOnTimerFinishedListener = listener;
    }

    boolean isIndeterminate() {
        return this.mIsIndeterminate;
    }

    boolean isTimerRunning() {
        return this.mIsTimerRunning;
    }

    void setIndeterminate(boolean indeterminate) {
        if (this.mIsIndeterminate == indeterminate) {
            return;
        }
        this.mIsIndeterminate = indeterminate;
        if (this.mIsIndeterminate) {
            if (this.mIsTimerRunning) {
                this.stopTimer();
            }
            this.mLayout.getProgressDrawable().start();
        } else {
            this.mLayout.getProgressDrawable().stop();
        }
    }

    void startTimer(long totalTime, long updateInterval) {
        this.reset();
        this.mIsTimerRunning = true;
        this.mTimer = new CircularProgressTimer(totalTime, updateInterval);
        this.mTimer.start();
    }

    void stopTimer() {
        if (this.mIsTimerRunning) {
            this.mTimer.cancel();
            this.mIsTimerRunning = false;
            this.mLayout.getProgressDrawable().setStartEndTrim(0.0f, 0.0f);
        }
    }

    void reset() {
        this.setIndeterminate(false);
        this.stopTimer();
        this.mLayout.getProgressDrawable().setStartEndTrim(0.0f, 0.0f);
    }

    private class CircularProgressTimer
    extends CountDownTimer {
        private final long mTotalTime;

        CircularProgressTimer(long totalTime, long updateInterval) {
            super(totalTime, updateInterval);
            this.mTotalTime = totalTime;
        }

        public void onTick(long millisUntilFinished) {
            CircularProgressLayoutController.this.mLayout.getProgressDrawable().setStartEndTrim(0.0f, 1.0f - (float)millisUntilFinished / (float)this.mTotalTime);
            CircularProgressLayoutController.this.mLayout.invalidate();
        }

        public void onFinish() {
            CircularProgressLayoutController.this.mLayout.getProgressDrawable().setStartEndTrim(0.0f, 1.0f);
            if (CircularProgressLayoutController.this.mOnTimerFinishedListener != null) {
                CircularProgressLayoutController.this.mOnTimerFinishedListener.onTimerFinished(CircularProgressLayoutController.this.mLayout);
            }
            CircularProgressLayoutController.this.mIsTimerRunning = false;
        }
    }
}

