/*
 * Decompiled with CFR 0.152.
 */
package android.support.wear.widget.drawer;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.support.annotation.IdRes;
import android.support.annotation.Nullable;
import android.support.annotation.RestrictTo;
import android.support.annotation.StyleableRes;
import android.support.wear.R;
import android.support.wear.widget.drawer.WearableDrawerController;
import android.util.AttributeSet;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class WearableDrawerView
extends FrameLayout {
    public static final int STATE_IDLE = 0;
    public static final int STATE_DRAGGING = 1;
    public static final int STATE_SETTLING = 2;
    private final ViewGroup mPeekContainer;
    private final ImageView mPeekIcon;
    private View mContent;
    private WearableDrawerController mController;
    private float mOpenedPercent;
    private boolean mIsLocked = false;
    private boolean mCanAutoPeek = true;
    private boolean mLockWhenClosed = false;
    private boolean mOpenOnlyAtTop = false;
    private boolean mPeekOnScrollDown = false;
    private boolean mIsPeeking;
    private int mDrawerState;
    @IdRes
    private int mPeekResId = 0;
    @IdRes
    private int mContentResId = 0;

    public WearableDrawerView(Context context) {
        this(context, null);
    }

    public WearableDrawerView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public WearableDrawerView(Context context, AttributeSet attrs, int defStyleAttr) {
        this(context, attrs, defStyleAttr, 0);
    }

    public WearableDrawerView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        LayoutInflater.from((Context)context).inflate(R.layout.ws_wearable_drawer_view, (ViewGroup)this, true);
        this.setClickable(true);
        this.setElevation(context.getResources().getDimension(R.dimen.ws_wearable_drawer_view_elevation));
        this.mPeekContainer = (ViewGroup)this.findViewById(R.id.ws_drawer_view_peek_container);
        this.mPeekIcon = (ImageView)this.findViewById(R.id.ws_drawer_view_peek_icon);
        this.mPeekContainer.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                WearableDrawerView.this.onPeekContainerClicked(v);
            }
        });
        this.parseAttributes(context, attrs, defStyleAttr, defStyleRes);
    }

    private static Drawable getDrawable(Context context, TypedArray typedArray, @StyleableRes int index) {
        int backgroundResId = typedArray.getResourceId(index, 0);
        Drawable background = backgroundResId == 0 ? typedArray.getDrawable(index) : context.getDrawable(backgroundResId);
        return background;
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        this.mPeekContainer.bringToFront();
    }

    public void onPeekContainerClicked(View v) {
        this.mController.openDrawer();
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        FrameLayout.LayoutParams peekParams = (FrameLayout.LayoutParams)this.mPeekContainer.getLayoutParams();
        if (!Gravity.isVertical((int)peekParams.gravity)) {
            boolean isTopDrawer;
            boolean bl = isTopDrawer = (((FrameLayout.LayoutParams)this.getLayoutParams()).gravity & 0x70) == 48;
            if (isTopDrawer) {
                peekParams.gravity = 80;
                this.mPeekIcon.setImageResource(R.drawable.ws_ic_more_horiz_24dp_wht);
            } else {
                peekParams.gravity = 48;
                this.mPeekIcon.setImageResource(R.drawable.ws_ic_more_vert_24dp_wht);
            }
            this.mPeekContainer.setLayoutParams((ViewGroup.LayoutParams)peekParams);
        }
    }

    public void addView(View child, int index, ViewGroup.LayoutParams params) {
        int childId = child.getId();
        if (childId != 0) {
            if (childId == this.mPeekResId) {
                this.setPeekContent(child, index, params);
                return;
            }
            if (childId == this.mContentResId && !this.setDrawerContentWithoutAdding(child)) {
                return;
            }
        }
        super.addView(child, index, params);
    }

    int preferGravity() {
        return 0;
    }

    ViewGroup getPeekContainer() {
        return this.mPeekContainer;
    }

    void setDrawerController(WearableDrawerController controller) {
        this.mController = controller;
    }

    @Nullable
    public View getDrawerContent() {
        return this.mContent;
    }

    public void setDrawerContent(@Nullable View content) {
        if (this.setDrawerContentWithoutAdding(content)) {
            this.addView(content);
        }
    }

    public void setPeekContent(View content) {
        ViewGroup.LayoutParams layoutParams = content.getLayoutParams();
        this.setPeekContent(content, -1, (ViewGroup.LayoutParams)(layoutParams != null ? layoutParams : this.generateDefaultLayoutParams()));
    }

    public void onDrawerOpened() {
    }

    public void onDrawerClosed() {
    }

    public void onDrawerStateChanged(int state) {
    }

    public void setOpenOnlyAtTopEnabled(boolean openOnlyAtTop) {
        this.mOpenOnlyAtTop = openOnlyAtTop;
    }

    public boolean isOpenOnlyAtTopEnabled() {
        return this.mOpenOnlyAtTop;
    }

    public void setPeekOnScrollDownEnabled(boolean peekOnScrollDown) {
        this.mPeekOnScrollDown = peekOnScrollDown;
    }

    public boolean isPeekOnScrollDownEnabled() {
        return this.mPeekOnScrollDown;
    }

    public void setLockedWhenClosed(boolean locked) {
        this.mLockWhenClosed = locked;
    }

    public boolean isLockedWhenClosed() {
        return this.mLockWhenClosed;
    }

    public int getDrawerState() {
        return this.mDrawerState;
    }

    void setDrawerState(int drawerState) {
        this.mDrawerState = drawerState;
    }

    public boolean isPeeking() {
        return this.mIsPeeking;
    }

    public boolean isAutoPeekEnabled() {
        return this.mCanAutoPeek && !this.mIsLocked;
    }

    public void setIsAutoPeekEnabled(boolean canAutoPeek) {
        this.mCanAutoPeek = canAutoPeek;
    }

    public boolean isLocked() {
        return this.mIsLocked || this.isLockedWhenClosed() && this.mOpenedPercent <= 0.0f;
    }

    public void setIsLocked(boolean locked) {
        this.mIsLocked = locked;
    }

    public boolean isOpened() {
        return this.mOpenedPercent == 1.0f;
    }

    public boolean isClosed() {
        return this.mOpenedPercent == 0.0f;
    }

    public WearableDrawerController getController() {
        return this.mController;
    }

    void setIsPeeking(boolean isPeeking) {
        this.mIsPeeking = isPeeking;
    }

    float getOpenedPercent() {
        return this.mOpenedPercent;
    }

    void setOpenedPercent(float openedPercent) {
        this.mOpenedPercent = openedPercent;
    }

    private void parseAttributes(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        if (attrs == null) {
            return;
        }
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.WearableDrawerView, defStyleAttr, R.style.Widget_Wear_WearableDrawerView);
        Drawable background = WearableDrawerView.getDrawable(context, typedArray, R.styleable.WearableDrawerView_android_background);
        int elevation = typedArray.getDimensionPixelSize(R.styleable.WearableDrawerView_android_elevation, 0);
        this.setBackground(background);
        this.setElevation(elevation);
        this.mContentResId = typedArray.getResourceId(R.styleable.WearableDrawerView_drawerContent, 0);
        this.mPeekResId = typedArray.getResourceId(R.styleable.WearableDrawerView_peekView, 0);
        this.mCanAutoPeek = typedArray.getBoolean(R.styleable.WearableDrawerView_enableAutoPeek, this.mCanAutoPeek);
        typedArray.recycle();
    }

    private void setPeekContent(View content, int index, ViewGroup.LayoutParams params) {
        if (content == null) {
            return;
        }
        if (this.mPeekContainer.getChildCount() > 0) {
            this.mPeekContainer.removeAllViews();
        }
        this.mPeekContainer.addView(content, index, params);
    }

    private boolean setDrawerContentWithoutAdding(View content) {
        if (content == this.mContent) {
            return false;
        }
        if (this.mContent != null) {
            this.removeView(this.mContent);
        }
        this.mContent = content;
        return this.mContent != null;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static @interface DrawerState {
    }
}

