/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.analytics;

import com.android.tools.analytics.AnalyticsPaths;
import com.android.tools.analytics.AnalyticsSettings;
import com.android.tools.analytics.AnalyticsSettingsData;
import com.android.tools.analytics.AnalyticsSettingsKt;
import com.android.tools.analytics.Environment;
import com.android.tools.analytics.WebServerDateProvider;
import com.android.utils.DateProvider;
import com.android.utils.ILogger;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.math.BigInteger;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.nio.charset.Charset;
import java.nio.file.Paths;
import java.security.SecureRandom;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneOffset;
import java.time.temporal.ChronoUnit;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ScheduledExecutorService;
import java.util.logging.Level;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010%\n\u0002\b\u0011\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010`\u001a\u00020,2\u0006\u0010a\u001a\u00020bH\u0003J\b\u0010c\u001a\u00020\u0006H\u0007J\u0006\u0010d\u001a\u00020\u0006J\b\u0010e\u001a\u00020fH\u0007J\b\u0010g\u001a\u00020fH\u0002J\u0018\u0010h\u001a\u00020\u00162\u0006\u0010i\u001a\u00020\u00042\u0006\u0010j\u001a\u00020\u0004H\u0007J(\u0010k\u001a\u00020f2\u0006\u0010a\u001a\u00020b2\n\b\u0002\u0010l\u001a\u0004\u0018\u00010m2\n\b\u0002\u0010n\u001a\u0004\u0018\u00010oH\u0007J\u0015\u0010p\u001a\u00020\u00162\u0006\u0010q\u001a\u00020,H\u0000\u00a2\u0006\u0002\brJ\u0010\u0010s\u001a\u00020,2\u0006\u0010a\u001a\u00020bH\u0003J\u0006\u0010t\u001a\u00020fJ)\u0010u\u001a\u0002Hv\"\u0004\b\u0000\u0010v2\u0006\u0010w\u001a\u0002Hv2\f\u0010x\u001a\b\u0012\u0004\u0012\u0002Hv0yH\u0003\u00a2\u0006\u0002\u0010zJ\b\u0010{\u001a\u00020fH\u0007J\u0012\u0010|\u001a\u00020f2\b\u0010q\u001a\u0004\u0018\u00010,H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n \n*\u0004\u0018\u00010\f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0006X\u0080T\u00a2\u0006\u0002\n\u0000R$\u0010\u000e\u001a\u00020\u000f8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u0010\u0010\u0002\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u00168FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0017\u0010\u0002\u001a\u0004\b\u0018\u0010\u0019R$\u0010\u001a\u001a\u00020\u00168\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u001b\u0010\u0002\u001a\u0004\b\u001c\u0010\u0019\"\u0004\b\u001d\u0010\u001eR\u000e\u0010\u001f\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010 \u001a\u0004\u0018\u00010!8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\"\u0010\u0002\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R&\u0010(\u001a\u00020\u00162\u0006\u0010'\u001a\u00020\u00168\u0006@BX\u0087\u000e\u00a2\u0006\u000e\n\u0000\u0012\u0004\b)\u0010\u0002\u001a\u0004\b*\u0010\u0019R\u001a\u0010+\u001a\u0004\u0018\u00010,8\u0002@\u0002X\u0083\u000e\u00a2\u0006\b\n\u0000\u0012\u0004\b-\u0010\u0002R.\u0010/\u001a\u0004\u0018\u00010\u00042\b\u0010.\u001a\u0004\u0018\u00010\u00048F@FX\u0087\u000e\u00a2\u0006\u0012\u0012\u0004\b0\u0010\u0002\u001a\u0004\b1\u00102\"\u0004\b3\u00104R.\u00106\u001a\u0004\u0018\u0001052\b\u0010.\u001a\u0004\u0018\u0001058F@FX\u0087\u000e\u00a2\u0006\u0012\u0012\u0004\b7\u0010\u0002\u001a\u0004\b8\u00109\"\u0004\b:\u0010;R.\u0010<\u001a\u0004\u0018\u0001052\b\u0010.\u001a\u0004\u0018\u0001058F@FX\u0087\u000e\u00a2\u0006\u0012\u0012\u0004\b=\u0010\u0002\u001a\u0004\b>\u00109\"\u0004\b?\u0010;R.\u0010@\u001a\u0004\u0018\u0001052\b\u0010.\u001a\u0004\u0018\u0001058F@FX\u0087\u000e\u00a2\u0006\u0012\u0012\u0004\bA\u0010\u0002\u001a\u0004\bB\u00109\"\u0004\bC\u0010;RF\u0010E\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u000205\u0018\u00010D2\u0014\u0010.\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u000205\u0018\u00010D8F@FX\u0087\u000e\u00a2\u0006\u0012\u0012\u0004\bF\u0010\u0002\u001a\u0004\bG\u0010H\"\u0004\bI\u0010JR*\u0010K\u001a\u00020\u00162\u0006\u0010.\u001a\u00020\u00168F@FX\u0087\u000e\u00a2\u0006\u0012\u0012\u0004\bL\u0010\u0002\u001a\u0004\bM\u0010\u0019\"\u0004\bN\u0010\u001eR*\u0010O\u001a\u00020\u00062\u0006\u0010.\u001a\u00020\u00068F@FX\u0087\u000e\u00a2\u0006\u0012\u0012\u0004\bP\u0010\u0002\u001a\u0004\bQ\u0010R\"\u0004\bS\u0010TR\u0011\u0010U\u001a\u00020V8F\u00a2\u0006\u0006\u001a\u0004\bW\u0010XR\u0014\u0010Y\u001a\u00020Z8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b[\u0010\\R\u001a\u0010]\u001a\u00020\u00048FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b^\u0010\u0002\u001a\u0004\b_\u00102\u00a8\u0006}"}, d2={"Lcom/android/tools/analytics/AnalyticsSettings;", "", "()V", "ANALYTICS_SETTINGS", "", "DAYS_IN_LEAP_YEAR", "", "DAYS_IN_NON_LEAP_YEAR", "EPOCH", "Ljava/time/LocalDate;", "kotlin.jvm.PlatformType", "LOG", "Ljava/util/logging/Logger;", "SALT_SKEW_NOT_INITIALIZED", "dateProvider", "Lcom/android/utils/DateProvider;", "getDateProvider$annotations", "getDateProvider", "()Lcom/android/utils/DateProvider;", "setDateProvider", "(Lcom/android/utils/DateProvider;)V", "debugDisablePublishing", "", "getDebugDisablePublishing$annotations", "getDebugDisablePublishing", "()Z", "exceptionThrown", "getExceptionThrown$annotations", "getExceptionThrown", "setExceptionThrown", "(Z)V", "gate", "googlePlayDateProvider", "Lcom/android/tools/analytics/WebServerDateProvider;", "getGooglePlayDateProvider$annotations", "getGooglePlayDateProvider", "()Lcom/android/tools/analytics/WebServerDateProvider;", "setGooglePlayDateProvider", "(Lcom/android/tools/analytics/WebServerDateProvider;)V", "<set-?>", "initialized", "getInitialized$annotations", "getInitialized", "instance", "Lcom/android/tools/analytics/AnalyticsSettingsData;", "getInstance$annotations", "value", "lastOptinPromptVersion", "getLastOptinPromptVersion$annotations", "getLastOptinPromptVersion", "()Ljava/lang/String;", "setLastOptinPromptVersion", "(Ljava/lang/String;)V", "Ljava/util/Date;", "lastSentimentAnswerDate", "getLastSentimentAnswerDate$annotations", "getLastSentimentAnswerDate", "()Ljava/util/Date;", "setLastSentimentAnswerDate", "(Ljava/util/Date;)V", "lastSentimentQuestionDate", "getLastSentimentQuestionDate$annotations", "getLastSentimentQuestionDate", "setLastSentimentQuestionDate", "nextFeatureSurveyDate", "getNextFeatureSurveyDate$annotations", "getNextFeatureSurveyDate", "setNextFeatureSurveyDate", "", "nextFeatureSurveyDateMap", "getNextFeatureSurveyDateMap$annotations", "getNextFeatureSurveyDateMap", "()Ljava/util/Map;", "setNextFeatureSurveyDateMap", "(Ljava/util/Map;)V", "optedIn", "getOptedIn$annotations", "getOptedIn", "setOptedIn", "popSentimentQuestionFrequency", "getPopSentimentQuestionFrequency$annotations", "getPopSentimentQuestionFrequency", "()I", "setPopSentimentQuestionFrequency", "(I)V", "salt", "", "getSalt", "()[B", "settingsFile", "Ljava/io/File;", "getSettingsFile$shared", "()Ljava/io/File;", "userId", "getUserId$annotations", "getUserId", "createNewAnalyticsSettingsData", "logger", "Lcom/android/utils/ILogger;", "currentSaltSkew", "daysInYear", "disable", "", "ensureInitialized", "hasUserBeenPromptedForOptin", "currentMajorVersion", "currentMinorVersion", "initialize", "scheduler", "Ljava/util/concurrent/ScheduledExecutorService;", "environment", "Lcom/android/tools/analytics/Environment;", "isValid", "settings", "isValid$shared", "loadSettingsData", "resetUserId", "runIfAnalyticsSettingsUsable", "T", "default", "callback", "Lkotlin/Function0;", "(Ljava/lang/Object;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "saveSettings", "setInstanceForTest", "shared"})
@SourceDebugExtension(value={"SMAP\nAnalyticsSettings.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AnalyticsSettings.kt\ncom/android/tools/analytics/AnalyticsSettings\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,627:1\n1#2:628\n*E\n"})
public final class AnalyticsSettings {
    @NotNull
    public static final AnalyticsSettings INSTANCE = new AnalyticsSettings();
    private static final int DAYS_IN_LEAP_YEAR = 366;
    private static final int DAYS_IN_NON_LEAP_YEAR = 365;
    private static final Logger LOG = Logger.getLogger(INSTANCE.getClass().getName());
    private static boolean initialized;
    private static boolean exceptionThrown;
    public static final int SALT_SKEW_NOT_INITIALIZED = -1;
    @NotNull
    private static DateProvider dateProvider;
    private static final LocalDate EPOCH;
    @NotNull
    private static final Object gate;
    @Nullable
    private static AnalyticsSettingsData instance;
    @Nullable
    private static WebServerDateProvider googlePlayDateProvider;
    @NotNull
    private static final String ANALYTICS_SETTINGS = "analytics.settings";

    private AnalyticsSettings() {
    }

    public static final boolean getInitialized() {
        return initialized;
    }

    @JvmStatic
    public static /* synthetic */ void getInitialized$annotations() {
    }

    public static final boolean getExceptionThrown() {
        return exceptionThrown;
    }

    public static final void setExceptionThrown(boolean bl) {
        exceptionThrown = bl;
    }

    @JvmStatic
    public static /* synthetic */ void getExceptionThrown$annotations() {
    }

    @NotNull
    public static final String getUserId() {
        return AnalyticsSettings.runIfAnalyticsSettingsUsable("", userId.1.INSTANCE);
    }

    @JvmStatic
    public static /* synthetic */ void getUserId$annotations() {
    }

    public static final boolean getOptedIn() {
        return AnalyticsSettings.runIfAnalyticsSettingsUsable(false, optedIn.1.INSTANCE);
    }

    public static final void setOptedIn(boolean value) {
        AnalyticsSettings.runIfAnalyticsSettingsUsable(Unit.INSTANCE, (Function0)new Function0<Object>(value){
            final /* synthetic */ boolean $value;
            {
                this.$value = $value;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                AnalyticsSettingsData analyticsSettingsData;
                AnalyticsSettingsData analyticsSettingsData2 = AnalyticsSettings.access$getInstance$p();
                if (analyticsSettingsData2 != null) {
                    AnalyticsSettingsData analyticsSettingsData3 = analyticsSettingsData2;
                    boolean bl = this.$value;
                    AnalyticsSettingsData $this$invoke_u24lambda_u240 = analyticsSettingsData3;
                    boolean bl2 = false;
                    $this$invoke_u24lambda_u240.setOptedIn(bl);
                    analyticsSettingsData = analyticsSettingsData3;
                } else {
                    analyticsSettingsData = null;
                }
                return analyticsSettingsData;
            }
        });
    }

    @JvmStatic
    public static /* synthetic */ void getOptedIn$annotations() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @JvmStatic
    private static final <T> T runIfAnalyticsSettingsUsable(T t, Function0<? extends T> callback) {
        Object object;
        Throwable throwable = null;
        Object object2 = object = gate;
        synchronized (object2) {
            boolean bl = false;
            if (exceptionThrown) {
                T t2 = t;
                return t2;
            }
            INSTANCE.ensureInitialized();
            try {
                Object object3 = callback.invoke();
                return (T)object3;
            }
            catch (Throwable t3) {
                exceptionThrown = true;
                throwable = t3;
                Unit unit = Unit.INSTANCE;
                // MONITOREXIT @DISABLED, blocks:[3, 4] lbl21 : MonitorExitStatement: MONITOREXIT : var4_5
                if (throwable == null) return t;
                try {
                    LOG.log(Level.SEVERE, throwable, runIfAnalyticsSettingsUsable.2.INSTANCE);
                    return t;
                }
                catch (Throwable throwable2) {
                    // empty catch block
                }
                return t;
            }
        }
    }

    private final void ensureInitialized() {
        if (!initialized && Boolean.getBoolean("idea.is.internal")) {
            throw new RuntimeException("call to AnalyticsSettings before initialization");
        }
    }

    public static final boolean getDebugDisablePublishing() {
        return AnalyticsSettings.runIfAnalyticsSettingsUsable(false, debugDisablePublishing.1.INSTANCE);
    }

    @JvmStatic
    public static /* synthetic */ void getDebugDisablePublishing$annotations() {
    }

    public static final int getPopSentimentQuestionFrequency() {
        return ((Number)AnalyticsSettings.runIfAnalyticsSettingsUsable(INSTANCE.daysInYear(), popSentimentQuestionFrequency.1.INSTANCE)).intValue();
    }

    public static final void setPopSentimentQuestionFrequency(int value) {
        AnalyticsSettings.runIfAnalyticsSettingsUsable(Unit.INSTANCE, (Function0)new Function0<Unit>(value){
            final /* synthetic */ int $value;
            {
                this.$value = $value;
                super(0);
            }

            public final void invoke() {
                AnalyticsSettingsData analyticsSettingsData = AnalyticsSettings.access$getInstance$p();
                if (analyticsSettingsData != null) {
                    analyticsSettingsData.setPopSentimentQuestionFrequency(this.$value);
                }
            }
        });
    }

    @JvmStatic
    public static /* synthetic */ void getPopSentimentQuestionFrequency$annotations() {
    }

    @Nullable
    public static final Date getLastSentimentQuestionDate() {
        return AnalyticsSettings.runIfAnalyticsSettingsUsable(null, lastSentimentQuestionDate.1.INSTANCE);
    }

    public static final void setLastSentimentQuestionDate(@Nullable Date value) {
        AnalyticsSettings.runIfAnalyticsSettingsUsable(Unit.INSTANCE, (Function0)new Function0<Unit>(value){
            final /* synthetic */ Date $value;
            {
                this.$value = $value;
                super(0);
            }

            public final void invoke() {
                AnalyticsSettingsData analyticsSettingsData = AnalyticsSettings.access$getInstance$p();
                if (analyticsSettingsData != null) {
                    analyticsSettingsData.setLastSentimentQuestionDate(this.$value);
                }
            }
        });
    }

    @JvmStatic
    public static /* synthetic */ void getLastSentimentQuestionDate$annotations() {
    }

    @Nullable
    public static final Date getLastSentimentAnswerDate() {
        return AnalyticsSettings.runIfAnalyticsSettingsUsable(null, lastSentimentAnswerDate.1.INSTANCE);
    }

    public static final void setLastSentimentAnswerDate(@Nullable Date value) {
        AnalyticsSettings.runIfAnalyticsSettingsUsable(Unit.INSTANCE, (Function0)new Function0<Unit>(value){
            final /* synthetic */ Date $value;
            {
                this.$value = $value;
                super(0);
            }

            public final void invoke() {
                AnalyticsSettingsData analyticsSettingsData = AnalyticsSettings.access$getInstance$p();
                if (analyticsSettingsData != null) {
                    analyticsSettingsData.setLastSentimentAnswerDate(this.$value);
                }
            }
        });
    }

    @JvmStatic
    public static /* synthetic */ void getLastSentimentAnswerDate$annotations() {
    }

    @Nullable
    public static final Date getNextFeatureSurveyDate() {
        return AnalyticsSettings.runIfAnalyticsSettingsUsable(null, nextFeatureSurveyDate.1.INSTANCE);
    }

    public static final void setNextFeatureSurveyDate(@Nullable Date value) {
        AnalyticsSettings.runIfAnalyticsSettingsUsable(Unit.INSTANCE, (Function0)new Function0<Unit>(value){
            final /* synthetic */ Date $value;
            {
                this.$value = $value;
                super(0);
            }

            public final void invoke() {
                AnalyticsSettingsData analyticsSettingsData = AnalyticsSettings.access$getInstance$p();
                if (analyticsSettingsData != null) {
                    analyticsSettingsData.setNextFeatureSurveyDate(this.$value);
                }
            }
        });
    }

    @JvmStatic
    public static /* synthetic */ void getNextFeatureSurveyDate$annotations() {
    }

    @Nullable
    public static final Map<String, Date> getNextFeatureSurveyDateMap() {
        return AnalyticsSettings.runIfAnalyticsSettingsUsable(null, nextFeatureSurveyDateMap.1.INSTANCE);
    }

    public static final void setNextFeatureSurveyDateMap(@Nullable Map<String, Date> value) {
        AnalyticsSettings.runIfAnalyticsSettingsUsable(Unit.INSTANCE, (Function0)new Function0<Unit>(value){
            final /* synthetic */ Map<String, Date> $value;
            {
                this.$value = $value;
                super(0);
            }

            public final void invoke() {
                AnalyticsSettingsData analyticsSettingsData = AnalyticsSettings.access$getInstance$p();
                if (analyticsSettingsData != null) {
                    analyticsSettingsData.setNextFeatureSurveyDateMap(this.$value);
                }
            }
        });
    }

    @JvmStatic
    public static /* synthetic */ void getNextFeatureSurveyDateMap$annotations() {
    }

    @Nullable
    public static final String getLastOptinPromptVersion() {
        return AnalyticsSettings.runIfAnalyticsSettingsUsable(null, lastOptinPromptVersion.1.INSTANCE);
    }

    public static final void setLastOptinPromptVersion(@Nullable String value) {
        AnalyticsSettings.runIfAnalyticsSettingsUsable(Unit.INSTANCE, (Function0)new Function0<Unit>(value){
            final /* synthetic */ String $value;
            {
                this.$value = $value;
                super(0);
            }

            public final void invoke() {
                AnalyticsSettingsData analyticsSettingsData = AnalyticsSettings.access$getInstance$p();
                if (analyticsSettingsData != null) {
                    analyticsSettingsData.setLastOptinPromptVersion(this.$value);
                }
            }
        });
    }

    @JvmStatic
    public static /* synthetic */ void getLastOptinPromptVersion$annotations() {
    }

    @NotNull
    public static final DateProvider getDateProvider() {
        return dateProvider;
    }

    public static final void setDateProvider(@NotNull DateProvider dateProvider) {
        Intrinsics.checkNotNullParameter((Object)dateProvider, (String)"<set-?>");
        AnalyticsSettings.dateProvider = dateProvider;
    }

    @VisibleForTesting
    @JvmStatic
    public static /* synthetic */ void getDateProvider$annotations() {
    }

    @JvmStatic
    private static /* synthetic */ void getInstance$annotations() {
    }

    @VisibleForTesting
    @JvmStatic
    public static final int currentSaltSkew() {
        LocalDate now = LocalDate.from(Instant.ofEpochMilli(dateProvider.now().getTime()).atZone(ZoneOffset.UTC));
        long days = ChronoUnit.DAYS.between(EPOCH, now) + (long)3;
        return (int)(days / (long)28);
    }

    @JvmStatic
    public static final boolean hasUserBeenPromptedForOptin(@NotNull String currentMajorVersion, @NotNull String currentMinorVersion) {
        Intrinsics.checkNotNullParameter((Object)currentMajorVersion, (String)"currentMajorVersion");
        Intrinsics.checkNotNullParameter((Object)currentMinorVersion, (String)"currentMinorVersion");
        Integer n = StringsKt.toIntOrNull((String)currentMajorVersion);
        if (n == null) {
            return true;
        }
        int currentMajor = n;
        Integer n2 = StringsKt.toIntOrNull((String)currentMinorVersion);
        if (n2 == null) {
            return true;
        }
        int currentMinor = n2;
        Object object = instance;
        if (object == null || (object = ((AnalyticsSettingsData)object).getLastOptinPromptVersion()) == null) {
            return false;
        }
        Object last = object;
        char[] cArray = new char[]{'.'};
        List tokens = StringsKt.split$default((CharSequence)((CharSequence)last), (char[])cArray, (boolean)false, (int)0, (int)6, null);
        if (tokens.size() != 2) {
            return false;
        }
        Integer n3 = StringsKt.toIntOrNull((String)((String)tokens.get(0)));
        if (n3 == null) {
            return false;
        }
        int lastMajor = n3;
        Integer n4 = StringsKt.toIntOrNull((String)((String)tokens.get(1)));
        if (n4 == null) {
            return false;
        }
        int lastMinor = n4;
        return currentMajor == lastMajor ? currentMinor <= lastMinor : currentMajor <= lastMajor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    @JvmStatic
    private static final AnalyticsSettingsData loadSettingsData(ILogger logger) throws IOException {
        File file = INSTANCE.getSettingsFile$shared();
        if (file.exists()) {
            FileChannel channel = new RandomAccessFile(file, "rw").getChannel();
            try {
                AutoCloseable autoCloseable = channel.tryLock();
                Throwable throwable = null;
                try {
                    Unit unit;
                    FileLock it = (FileLock)autoCloseable;
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)channel);
                    AnalyticsSettingsData analyticsSettingsData = AnalyticsSettingsData.Companion.parseSettingsData(channel, file, logger);
                    if (analyticsSettingsData != null) {
                        AnalyticsSettingsData it2 = analyticsSettingsData;
                        boolean bl2 = false;
                        if (INSTANCE.isValid$shared(it2)) {
                            AnalyticsSettingsData analyticsSettingsData2 = it2;
                            return analyticsSettingsData2;
                        }
                        unit = Unit.INSTANCE;
                    } else {
                        unit = null;
                    }
                    Unit unit2 = unit;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                }
            }
            catch (OverlappingFileLockException e) {
                Object[] objectArray = new Object[]{file.toString(), e};
                logger.warning("Unable to lock settings file %s: %s", objectArray);
                AnalyticsSettingsData newSettings = new AnalyticsSettingsData();
                newSettings.setUserId(UUID.randomUUID().toString());
                return newSettings;
            }
        }
        return AnalyticsSettings.createNewAnalyticsSettingsData(logger);
    }

    public final void resetUserId() {
        AnalyticsSettings.runIfAnalyticsSettingsUsable(Unit.INSTANCE, resetUserId.1.INSTANCE);
    }

    @VisibleForTesting
    @JvmStatic
    private static final AnalyticsSettingsData createNewAnalyticsSettingsData(ILogger logger) throws IOException {
        AnalyticsSettingsData settings = new AnalyticsSettingsData();
        String[] stringArray = new String[]{"uid.txt"};
        File uidFile = Paths.get(AnalyticsPaths.getAndEnsureAndroidSettingsHome(), stringArray).toFile();
        if (uidFile.exists()) {
            try {
                String uid = Files.readFirstLine((File)uidFile, (Charset)Charsets.UTF_8);
                settings.setUserId(uid);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (settings.getUserId() == null) {
            settings.setUserId(UUID.randomUUID().toString());
        }
        settings.saveSettings(logger);
        return settings;
    }

    @Nullable
    public static final WebServerDateProvider getGooglePlayDateProvider() {
        return googlePlayDateProvider;
    }

    public static final void setGooglePlayDateProvider(@Nullable WebServerDateProvider webServerDateProvider) {
        googlePlayDateProvider = webServerDateProvider;
    }

    @JvmStatic
    public static /* synthetic */ void getGooglePlayDateProvider$annotations() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    @JvmOverloads
    public static final void initialize(@NotNull ILogger logger, @Nullable ScheduledExecutorService scheduler, @Nullable Environment environment) {
        block7: {
            Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
            Object object = gate;
            synchronized (object) {
                boolean bl = false;
                try {
                    Environment environment2 = environment;
                    if (environment2 != null) {
                        Environment it = environment2;
                        boolean bl2 = false;
                        Environment.Companion.setInstance(environment);
                    }
                    if (instance != null) {
                        return;
                    }
                    initialized = true;
                    instance = AnalyticsSettings.loadSettingsData(logger);
                }
                catch (IOException e) {
                    initialized = true;
                    instance = new AnalyticsSettingsData();
                    Object[] objectArray = new Object[]{AnalyticsPaths.getAndEnsureAndroidSettingsHome(), e.getMessage()};
                    logger.warning("Unable to initialize metrics, ensure %s is writable, details: %s", objectArray);
                }
                Unit unit = Unit.INSTANCE;
            }
            ScheduledExecutorService scheduledExecutorService = scheduler;
            if (scheduledExecutorService == null) break block7;
            scheduledExecutorService.submit(new Runnable(logger){
                final /* synthetic */ ILogger $logger;
                {
                    this.$logger = $logger;
                }

                public final void run() {
                    try {
                        WebServerDateProvider gp = new WebServerDateProvider(new URL("http://play.google.com/"));
                        AnalyticsSettings.setDateProvider(gp);
                        AnalyticsSettings.setGooglePlayDateProvider(gp);
                    }
                    catch (IOException iOException) {
                        this.$logger.warning("Unable to get current time from Google's servers, using local system time instead.", new Object[0]);
                    }
                }
            });
        }
    }

    public static /* synthetic */ void initialize$default(ILogger iLogger, ScheduledExecutorService scheduledExecutorService, Environment environment, int n, Object object) {
        if ((n & 2) != 0) {
            scheduledExecutorService = null;
        }
        if ((n & 4) != 0) {
            environment = null;
        }
        AnalyticsSettings.initialize(iLogger, scheduledExecutorService, environment);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    public static final void disable() {
        Object object = gate;
        synchronized (object) {
            boolean bl = false;
            initialized = true;
            instance = new AnalyticsSettingsData();
            DateProvider dateProvider = DateProvider.SYSTEM;
            Intrinsics.checkNotNullExpressionValue((Object)dateProvider, (String)"SYSTEM");
            AnalyticsSettings.dateProvider = dateProvider;
            googlePlayDateProvider = null;
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    @JvmStatic
    public static final void setInstanceForTest(@Nullable AnalyticsSettingsData settings) {
        Object object = gate;
        synchronized (object) {
            boolean bl = false;
            instance = settings;
            initialized = instance != null;
            exceptionThrown = false;
            Unit unit = Unit.INSTANCE;
        }
    }

    @NotNull
    public final File getSettingsFile$shared() {
        String[] stringArray = new String[]{ANALYTICS_SETTINGS};
        File file = Paths.get(AnalyticsPaths.getAndEnsureAndroidSettingsHome(), stringArray).toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final byte[] getSalt() throws IOException {
        Object object = gate;
        synchronized (object) {
            AnalyticsSettingsData analyticsSettingsData;
            block5: {
                boolean bl = false;
                if (instance != null) break block5;
                byte[] byArray = new byte[]{};
                return byArray;
            }
            AnalyticsSettingsData data = analyticsSettingsData;
            int dataSkew532 = (data.getSaltSkew() - 11) / 19;
            int currentSaltSkew = AnalyticsSettings.currentSaltSkew();
            int currentSaltSkew532 = (currentSaltSkew - 11) / 19;
            if (dataSkew532 != currentSaltSkew532) {
                data.setSaltSkew(currentSaltSkew);
                SecureRandom random = new SecureRandom();
                byte[] blob = new byte[24];
                random.nextBytes(blob);
                data.setSaltValue(new BigInteger(blob));
                AnalyticsSettings.saveSettings();
            }
            BigInteger bigInteger = data.getSaltValue();
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"<get-saltValue>(...)");
            byte[] byArray = AnalyticsSettingsKt.toByteArrayOfLength24(bigInteger);
            return byArray;
        }
    }

    @JvmStatic
    public static final void saveSettings() throws IOException {
        AnalyticsSettings.runIfAnalyticsSettingsUsable(Unit.INSTANCE, saveSettings.1.INSTANCE);
    }

    public final boolean isValid$shared(@NotNull AnalyticsSettingsData settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        return settings.getUserId() != null && (settings.getSaltSkew() == -1 || settings.getSaltValue() != null);
    }

    public final int daysInYear() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(dateProvider.now());
        return new GregorianCalendar().isLeapYear(calendar.get(1)) ? 366 : 365;
    }

    @JvmStatic
    @JvmOverloads
    public static final void initialize(@NotNull ILogger logger, @Nullable ScheduledExecutorService scheduler) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        AnalyticsSettings.initialize$default(logger, scheduler, null, 4, null);
    }

    @JvmStatic
    @JvmOverloads
    public static final void initialize(@NotNull ILogger logger) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        AnalyticsSettings.initialize$default(logger, null, null, 6, null);
    }

    public static final /* synthetic */ AnalyticsSettingsData access$getInstance$p() {
        return instance;
    }

    static {
        DateProvider dateProvider = DateProvider.SYSTEM;
        Intrinsics.checkNotNullExpressionValue((Object)dateProvider, (String)"SYSTEM");
        AnalyticsSettings.dateProvider = dateProvider;
        EPOCH = LocalDate.ofEpochDay(0L);
        gate = new Object();
    }
}

