/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.analytics;

import com.android.tools.analytics.AnalyticsPaths;
import com.android.tools.analytics.AnalyticsSettings;
import com.android.tools.analytics.JournalingUsageTracker;
import com.android.tools.analytics.NullUsageTracker;
import com.android.utils.DateProvider;
import com.android.utils.ILogger;
import com.google.wireless.android.play.playlog.proto.ClientAnalytics;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.ProductDetails;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.UUID;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public abstract class UsageTracker
implements AutoCloseable {
    private static final Object sGate = new Object();
    static String sSessionId = UUID.randomUUID().toString();
    public static DateProvider sDateProvider = DateProvider.SYSTEM;
    private static UsageTracker sInstance = new NullUsageTracker(new AnalyticsSettings(), null);
    private static boolean sIsTesting;
    private final AnalyticsSettings mAnalyticsSettings;
    private final ScheduledExecutorService mScheduler;
    private int mMaxJournalSize;
    private long mMaxJournalTime;
    private String mVersion;
    private AndroidStudioEvent.IdeBrand mIdeBrand = AndroidStudioEvent.IdeBrand.UNKNOWN_IDE_BRAND;
    protected long mStartTimeMs = sDateProvider.now().getTime();

    protected UsageTracker(AnalyticsSettings analyticsSettings, ScheduledExecutorService scheduler) {
        this.mAnalyticsSettings = analyticsSettings;
        this.mScheduler = scheduler;
    }

    public int getMaxJournalSize() {
        return this.mMaxJournalSize;
    }

    public void setMaxJournalSize(int maxJournalSize) {
        this.mMaxJournalSize = maxJournalSize;
    }

    public long getMaxJournalTime() {
        return this.mMaxJournalTime;
    }

    public void setMaxJournalTime(long duration, TimeUnit unit) {
        this.mMaxJournalTime = unit.toNanos(duration);
    }

    public String getVersion() {
        return this.mVersion;
    }

    public void setVersion(String version) {
        this.mVersion = version;
    }

    public AndroidStudioEvent.IdeBrand getIdeBrand() {
        return this.mIdeBrand;
    }

    public void setIdeBrand(AndroidStudioEvent.IdeBrand ideBrand) {
        this.mIdeBrand = ideBrand;
    }

    public AnalyticsSettings getAnalyticsSettings() {
        return this.mAnalyticsSettings;
    }

    public ScheduledExecutorService getScheduler() {
        return this.mScheduler;
    }

    public void log(AndroidStudioEvent.Builder studioEvent) {
        this.log(sDateProvider.now().getTime(), studioEvent);
    }

    public void log(long eventTimeMs, AndroidStudioEvent.Builder studioEvent) {
        studioEvent.setStudioSessionId(sSessionId);
        studioEvent.setIdeBrand(this.mIdeBrand);
        if (this.mVersion != null && !studioEvent.hasProductDetails()) {
            studioEvent.setProductDetails(ProductDetails.newBuilder().setVersion(this.mVersion));
        }
        try {
            this.logDetails(ClientAnalytics.LogEvent.newBuilder().setEventTimeMs(eventTimeMs).setEventUptimeMs(eventTimeMs - this.mStartTimeMs).setSourceExtension(studioEvent.build().toByteString()));
        }
        catch (NullPointerException exception) {
            this.logDetails(ClientAnalytics.LogEvent.newBuilder().setEventTimeMs(eventTimeMs).setEventUptimeMs(eventTimeMs - this.mStartTimeMs));
        }
    }

    public abstract void logDetails(ClientAnalytics.LogEvent.Builder var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UsageTracker getInstance() {
        Object object = sGate;
        synchronized (object) {
            return sInstance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UsageTracker initialize(AnalyticsSettings analyticsSettings, ScheduledExecutorService scheduler) {
        Object object = sGate;
        synchronized (object) {
            UsageTracker oldInstance = sInstance;
            if (analyticsSettings.hasOptedIn()) {
                try {
                    sInstance = new JournalingUsageTracker(analyticsSettings, scheduler, Paths.get(AnalyticsPaths.getSpoolDirectory(), new String[0]));
                }
                catch (RuntimeException ex) {
                    sInstance = new NullUsageTracker(analyticsSettings, scheduler);
                    sInstance.setIdeBrand(oldInstance.getIdeBrand());
                    throw ex;
                }
            } else {
                sInstance = new NullUsageTracker(analyticsSettings, scheduler);
            }
            sInstance.setIdeBrand(oldInstance.getIdeBrand());
            try {
                oldInstance.close();
            }
            catch (Exception ex) {
                throw new RuntimeException("Unable to close usage tracker", ex);
            }
            return sInstance;
        }
    }

    public static UsageTracker setInstanceForTest(UsageTracker tracker) {
        sIsTesting = true;
        sInstance = tracker;
        return sInstance;
    }

    public static void cleanAfterTesting() {
        sIsTesting = false;
        sInstance = new NullUsageTracker(new AnalyticsSettings(), null);
    }

    public static AnalyticsSettings updateSettingsAndTracker(boolean optIn, ILogger logger, ScheduledExecutorService scheduler) {
        AnalyticsSettings settings = AnalyticsSettings.getInstance((ILogger)logger);
        if (sIsTesting) {
            return settings;
        }
        if (optIn != settings.hasOptedIn()) {
            settings.setHasOptedIn(optIn);
            try {
                settings.saveSettings();
            }
            catch (IOException e) {
                logger.error((Throwable)e, "Unable to save analytics settings", new Object[0]);
            }
        }
        try {
            UsageTracker.initialize(settings, scheduler);
        }
        catch (Exception e) {
            logger.error((Throwable)e, "Unable to initialize analytics tracker", new Object[0]);
        }
        return settings;
    }
}

