/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.analytics;

import com.android.tools.analytics.AnalyticsSettings;
import com.android.tools.analytics.UsageTracker;
import com.google.wireless.android.play.playlog.proto.ClientAnalytics;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.UUID;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class JournalingUsageTracker
extends UsageTracker {
    private final Path mSpoolLocation;
    private final Object mGate = new Object();
    private FileLock mLock = null;
    private FileChannel mChannel = null;
    private OutputStream mOutputStream = null;
    private int mCurrentLogCount = 0;
    private ScheduledFuture<?> mJournalTimeout;
    private int mScheduleVersion = 0;
    private State mState = State.Open;

    public JournalingUsageTracker(AnalyticsSettings analyticsSettings, ScheduledExecutorService scheduler, Path spoolLocation) {
        super(analyticsSettings, scheduler);
        this.mSpoolLocation = spoolLocation;
        try {
            this.newTrackFile();
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to initialize first usage tracking spool file", e);
        }
    }

    private void newTrackFile() throws IOException {
        Path spoolFile = Paths.get(this.mSpoolLocation.toString(), UUID.randomUUID().toString() + ".trk");
        Files.createDirectories(spoolFile.getParent(), new FileAttribute[0]);
        this.mChannel = FileChannel.open(spoolFile, StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.DSYNC);
        this.mOutputStream = Channels.newOutputStream(this.mChannel);
        try {
            this.mLock = this.mChannel.tryLock();
        }
        catch (OverlappingFileLockException e) {
            this.closeTrackFile();
            throw new IOException("Unable to lock usage tracking spool file", e);
        }
        if (this.mLock == null) {
            this.closeTrackFile();
            throw new IOException("Unable to lock usage tracking spool file, file already locked");
        }
        this.mCurrentLogCount = 0;
    }

    private void closeTrackFile() throws IOException {
        IOException ex = null;
        try {
            if (this.mLock != null) {
                this.mLock.release();
            }
        }
        catch (IOException e) {
            ex = e;
        }
        this.mLock = null;
        try {
            if (this.mChannel != null) {
                this.mChannel.close();
            }
        }
        catch (IOException e) {
            if (ex == null) {
                ex = e;
            }
            ex.addSuppressed(e);
        }
        this.mChannel = null;
        try {
            if (this.mOutputStream != null) {
                this.mOutputStream.close();
            }
        }
        catch (IOException e) {
            if (ex == null) {
                ex = e;
            }
            ex.addSuppressed(e);
        }
        this.mOutputStream = null;
        if (ex != null) {
            throw ex;
        }
    }

    @Override
    public void logDetails(ClientAnalytics.LogEvent.Builder logEvent) {
        if (this.mState != State.Open) {
            return;
        }
        this.getScheduler().execute(() -> {
            Object object = this.mGate;
            synchronized (object) {
                if (this.mState != State.Open) {
                    return;
                }
                try {
                    logEvent.build().writeDelimitedTo(this.mOutputStream);
                }
                catch (IOException ignored) {
                    this.closeAsBroken();
                    return;
                }
                ++this.mCurrentLogCount;
                if (JournalingUsageTracker.getMaxJournalSize() > 0 && this.mCurrentLogCount >= JournalingUsageTracker.getMaxJournalSize()) {
                    this.switchTrackFile();
                    if (this.mJournalTimeout != null) {
                        this.scheduleJournalTimeout(JournalingUsageTracker.getMaxJournalTime());
                    }
                }
            }
        });
    }

    private void closeAsBroken() {
        try {
            this.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.mState = State.Broken;
    }

    private boolean switchTrackFile() {
        try {
            this.closeTrackFile();
            this.newTrackFile();
            return true;
        }
        catch (IOException e) {
            this.closeAsBroken();
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws Exception {
        Object object = this.mGate;
        synchronized (object) {
            this.mState = State.Closed;
            if (this.mJournalTimeout != null) {
                this.mJournalTimeout.cancel(false);
            }
            this.closeTrackFile();
        }
    }

    @Override
    protected void scheduleJournalTimeout(long maxJournalTime) {
        int currentScheduleVersion = ++this.mScheduleVersion;
        if (this.mJournalTimeout != null) {
            this.mJournalTimeout.cancel(false);
        }
        this.mJournalTimeout = this.getScheduler().schedule(() -> {
            Object object = this.mGate;
            synchronized (object) {
                if (this.mState != State.Open) {
                    return;
                }
                if (this.mCurrentLogCount > 0) {
                    this.switchTrackFile();
                }
                if (this.mScheduleVersion == currentScheduleVersion) {
                    this.scheduleJournalTimeout(maxJournalTime);
                }
            }
        }, maxJournalTime, TimeUnit.NANOSECONDS);
    }

    private static enum State {
        Open,
        Closed,
        Broken;

    }
}

