/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.analytics;

import com.android.tools.analytics.UsageTracker;
import com.google.wireless.android.play.playlog.proto.ClientAnalytics;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.ProductDetails;
import java.util.Date;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bH&J\u000e\u0010\f\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u0006H\u0016\u00a8\u0006\u000f"}, d2={"Lcom/android/tools/analytics/UsageTrackerWriter;", "Ljava/lang/AutoCloseable;", "()V", "logAt", "", "eventTimeMs", "", "studioEvent", "Lcom/google/wireless/android/sdk/stats/AndroidStudioEvent$Builder;", "logDetails", "logEvent", "Lcom/google/wireless/android/play/playlog/proto/ClientAnalytics$LogEvent$Builder;", "logNow", "scheduleJournalTimeout", "maxJournalTime", "tracker"})
public abstract class UsageTrackerWriter
implements AutoCloseable {
    public void scheduleJournalTimeout(long maxJournalTime) {
    }

    public final void logNow(@NotNull AndroidStudioEvent.Builder studioEvent) {
        Intrinsics.checkParameterIsNotNull((Object)studioEvent, (String)"studioEvent");
        Date date = UsageTracker.getDateProvider().now();
        Intrinsics.checkExpressionValueIsNotNull((Object)date, (String)"UsageTracker.dateProvider.now()");
        this.logAt(date.getTime(), studioEvent);
    }

    public final void logAt(long eventTimeMs, @NotNull AndroidStudioEvent.Builder studioEvent) {
        Intrinsics.checkParameterIsNotNull((Object)studioEvent, (String)"studioEvent");
        studioEvent.setStudioSessionId(UsageTracker.getSessionId());
        studioEvent.setIdeBrand(UsageTracker.getIdeBrand());
        if (UsageTracker.getVersion() != null && !studioEvent.hasProductDetails()) {
            ProductDetails.Builder builder = ProductDetails.newBuilder();
            String string = UsageTracker.getVersion();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            studioEvent.setProductDetails(builder.setVersion(string));
        }
        if (UsageTracker.getIdeaIsInternal()) {
            studioEvent.setIdeaIsInternal(true);
        }
        ClientAnalytics.LogEvent.Builder builder = ClientAnalytics.LogEvent.newBuilder().setEventTimeMs(eventTimeMs).setEventUptimeMs(eventTimeMs - UsageTracker.getStartTimeMs()).setSourceExtension(studioEvent.build().toByteString());
        Intrinsics.checkExpressionValueIsNotNull((Object)builder, (String)"ClientAnalytics.LogEvent\u2026t.build().toByteString())");
        this.logDetails(builder);
    }

    public abstract void logDetails(@NotNull ClientAnalytics.LogEvent.Builder var1);
}

