/*
 * Decompiled with CFR 0.152.
 */
package com.android.aaptcompiler;

import com.android.aapt.Resources;
import com.android.aaptcompiler.Container;
import com.android.aaptcompiler.PseudolocaleGenerator;
import com.android.aaptcompiler.ResourceCompiler;
import com.android.aaptcompiler.ResourceCompilerOptions;
import com.android.aaptcompiler.ResourcePathData;
import com.android.aaptcompiler.ResourcePathDataKt;
import com.android.aaptcompiler.ResourceTable;
import com.android.aaptcompiler.TableExtractor;
import com.android.aaptcompiler.TableExtractorOptions;
import com.android.aaptcompiler.proto.ProtoSerializeKt;
import com.android.resources.ResourceType;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u00002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u001a \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u001a \u0010\u0010\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u001a\u001e\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f\u001a \u0010\u0012\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u001a \u0010\u0013\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u001a(\u0010\u0014\u001a\u001a\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\n0\u00152\u0006\u0010\u000b\u001a\u00020\fH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"PNG_EXTENSION", "", "RESOURCE_TABLE_EXTENSION", "VALUES_DIRECTORY_PREFIX", "XML_EXTENSION", "canCompileResourceInJvm", "", "file", "Ljava/io/File;", "compileFile", "", "pathData", "Lcom/android/aaptcompiler/ResourcePathData;", "outputDirectory", "options", "Lcom/android/aaptcompiler/ResourceCompilerOptions;", "compilePng", "compileResource", "compileTable", "compileXml", "getCompileMethod", "Lkotlin/Function3;", "aaptcompiler"})
@JvmName(name="ResourceCompiler")
public final class ResourceCompiler {
    private static final String VALUES_DIRECTORY_PREFIX = "values";
    private static final String XML_EXTENSION = "xml";
    private static final String RESOURCE_TABLE_EXTENSION = "arsc";
    private static final String PNG_EXTENSION = "png";

    public static final boolean canCompileResourceInJvm(@NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        if (file.isHidden()) {
            return true;
        }
        ResourcePathData pathData = ResourcePathDataKt.extractPathData(file);
        return Intrinsics.areEqual((Object)pathData.getResourceDirectory(), (Object)VALUES_DIRECTORY_PREFIX) && Intrinsics.areEqual((Object)pathData.getExtension(), (Object)XML_EXTENSION);
    }

    public static final void compileResource(@NotNull File file, @NotNull File outputDirectory, @NotNull ResourceCompilerOptions options) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)outputDirectory, (String)"outputDirectory");
        Intrinsics.checkParameterIsNotNull((Object)options, (String)"options");
        if (file.isHidden()) {
            return;
        }
        ResourcePathData pathData = ResourcePathDataKt.extractPathData(file);
        Function3<ResourcePathData, File, ResourceCompilerOptions, Unit> compileFunction = ResourceCompiler.getCompileMethod(pathData);
        compileFunction.invoke((Object)pathData, (Object)outputDirectory, (Object)options);
    }

    private static final Function3<ResourcePathData, File, ResourceCompilerOptions, Unit> getCompileMethod(ResourcePathData pathData) {
        if (Intrinsics.areEqual((Object)pathData.getResourceDirectory(), (Object)VALUES_DIRECTORY_PREFIX) && Intrinsics.areEqual((Object)pathData.getExtension(), (Object)XML_EXTENSION)) {
            pathData.setExtension(RESOURCE_TABLE_EXTENSION);
            return getCompileMethod.1.INSTANCE;
        }
        ResourceType type = ResourceType.fromFolderName((String)pathData.getResourceDirectory());
        if (type == null) {
            String errorMsg = "Invalid resource type '" + pathData.getResourceDirectory() + '\'' + " for file " + pathData.getFile().getAbsolutePath();
            boolean bl = false;
            throw (Throwable)new IllegalStateException(errorMsg.toString());
        }
        if (type != ResourceType.RAW) {
            if (Intrinsics.areEqual((Object)pathData.getExtension(), (Object)XML_EXTENSION)) {
                return getCompileMethod.2.INSTANCE;
            }
            if (StringsKt.endsWith$default((String)pathData.getExtension(), (String)PNG_EXTENSION, (boolean)false, (int)2, null)) {
                return getCompileMethod.3.INSTANCE;
            }
        }
        return getCompileMethod.4.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void compileTable(ResourcePathData pathData, File outputDirectory, ResourceCompilerOptions options) {
        File outputFile = new File(outputDirectory, pathData.getIntermediateContainerFilename());
        ResourceTable table = new ResourceTable(false, 1, null);
        TableExtractorOptions extractorOptions = new TableExtractorOptions(!StringsKt.contains$default((CharSequence)pathData.getName(), (CharSequence)"donottranslate", (boolean)false, (int)2, null), !options.getLegacyMode(), options.getVisibility());
        TableExtractor tableExtractor = new TableExtractor(table, pathData.getSource(), pathData.getConfig(), extractorOptions);
        InputStream input = null;
        try {
            Object object = pathData.getFile();
            boolean bl = false;
            input = new FileInputStream((File)object);
            if (!tableExtractor.extract(input)) {
                object = "TODO";
                bl = false;
                throw (Throwable)new IllegalStateException(object.toString());
            }
            if (options.getPseudolocalize() && extractorOptions.getTranslatable()) {
                new PseudolocaleGenerator().consume(table);
            }
        }
        catch (Throwable throwable) {
            InputStream inputStream = input;
            if (inputStream != null) {
                inputStream.close();
            }
            throw throwable;
        }
        input.close();
        ResourceTable.createPackage$default(table, "", (byte)0, 2, null);
        table.sort();
        File file = outputFile;
        boolean bl = false;
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        int n = 1;
        OutputStream outputStream = fileOutputStream;
        Container container = new Container(outputStream, n);
        Resources.ResourceTable pbTable = ProtoSerializeKt.serializeTableToPb$default(table, null, 2, null);
        container.addResTableEntry(pbTable);
    }

    private static final void compileFile(ResourcePathData pathData, File outputDirectory, ResourceCompilerOptions options) {
        File outputFile = new File(outputDirectory, pathData.getIntermediateContainerFilename());
        String string = "Raw file support not yet implemented.";
        boolean bl = false;
        throw (Throwable)new IllegalStateException(string.toString());
    }

    private static final void compileXml(ResourcePathData pathData, File outputDirectory, ResourceCompilerOptions options) {
        File outputFile = new File(outputDirectory, pathData.getIntermediateContainerFilename());
        String string = "XML support not yet implemented.";
        boolean bl = false;
        throw (Throwable)new IllegalStateException(string.toString());
    }

    private static final void compilePng(ResourcePathData pathData, File outputDirectory, ResourceCompilerOptions options) {
        File outputFile = new File(outputDirectory, pathData.getIntermediateContainerFilename());
        String string = "PNG support not yet implemented.";
        boolean bl = false;
        throw (Throwable)new IllegalStateException(string.toString());
    }

    public static final /* synthetic */ void access$compileTable(ResourcePathData pathData, File outputDirectory, ResourceCompilerOptions options) {
        ResourceCompiler.compileTable(pathData, outputDirectory, options);
    }

    public static final /* synthetic */ void access$compileXml(ResourcePathData pathData, File outputDirectory, ResourceCompilerOptions options) {
        ResourceCompiler.compileXml(pathData, outputDirectory, options);
    }

    public static final /* synthetic */ void access$compilePng(ResourcePathData pathData, File outputDirectory, ResourceCompilerOptions options) {
        ResourceCompiler.compilePng(pathData, outputDirectory, options);
    }

    public static final /* synthetic */ void access$compileFile(ResourcePathData pathData, File outputDirectory, ResourceCompilerOptions options) {
        ResourceCompiler.compileFile(pathData, outputDirectory, options);
    }
}

