/*
 * Decompiled with CFR 0.152.
 */
package com.android.aaptcompiler;

import com.android.aaptcompiler.BlameLoggerKt;
import com.android.aaptcompiler.Item;
import com.android.aaptcompiler.Reference;
import com.android.aaptcompiler.ResourceUtilsKt;
import com.android.aaptcompiler.ResourceValuesKt;
import com.android.aaptcompiler.Value;
import com.android.aaptcompiler.android.ResValue;
import com.android.aaptcompiler.android.UtilKt;
import com.android.utils.ILogger;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001:\u0001&B\u001b\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0019\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u001f\u0010\u001a\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0013\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u00d6\u0003J\t\u0010\u001f\u001a\u00020\u0003H\u00d6\u0001J\u000e\u0010 \u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0000J\u000e\u0010!\u001a\u00020\u001c2\u0006\u0010\"\u001a\u00020#J\t\u0010$\u001a\u00020%H\u00d6\u0001R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u000b\"\u0004\b\u0010\u0010\rR\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u000b\"\u0004\b\u0017\u0010\r\u00a8\u0006'"}, d2={"Lcom/android/aaptcompiler/AttributeResource;", "Lcom/android/aaptcompiler/Value;", "typeMask", "", "logger", "Lcom/android/utils/ILogger;", "(ILcom/android/utils/ILogger;)V", "getLogger", "()Lcom/android/utils/ILogger;", "maxInt", "getMaxInt", "()I", "setMaxInt", "(I)V", "minInt", "getMinInt", "setMinInt", "symbols", "", "Lcom/android/aaptcompiler/AttributeResource$Symbol;", "getSymbols", "()Ljava/util/List;", "getTypeMask", "setTypeMask", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "isCompatibleWith", "matches", "item", "Lcom/android/aaptcompiler/Item;", "toString", "", "Symbol", "aaptcompiler"})
public final class AttributeResource
extends Value {
    private int minInt;
    private int maxInt;
    @NotNull
    private final List<Symbol> symbols;
    private int typeMask;
    @Nullable
    private final ILogger logger;

    public final int getMinInt() {
        return this.minInt;
    }

    public final void setMinInt(int n) {
        this.minInt = n;
    }

    public final int getMaxInt() {
        return this.maxInt;
    }

    public final void setMaxInt(int n) {
        this.maxInt = n;
    }

    @NotNull
    public final List<Symbol> getSymbols() {
        return this.symbols;
    }

    public final boolean matches(@NotNull Item item) {
        Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
        ResValue resValue = item.flatten();
        if (resValue == null) {
            Intrinsics.throwNpe();
        }
        ResValue value = resValue;
        int flattenedData = UtilKt.deviceToHost(value.getData());
        int actualType = ResourceUtilsKt.androidTypeToAttributeTypeMask(value.getDataType());
        if ((actualType & (this.typeMask | 1)) == 0) {
            String errorMsg = "%s, Expected %s but got %s";
            ILogger iLogger = this.logger;
            if (iLogger != null) {
                iLogger.error(null, errorMsg, new Object[]{BlameLoggerKt.blameSource$default(this.getSource(), null, null, 6, null), ResourceValuesKt.access$maskToString(this.typeMask), item});
            }
            return false;
        }
        if ((this.typeMask & actualType & 0x10000) != 0) {
            for (Symbol symbol : this.symbols) {
                if (flattenedData != symbol.getValue()) continue;
                return true;
            }
            if ((this.typeMask & 4) == 0) {
                String errorMsg = "%s, %s is not a valid enum.";
                ILogger iLogger = this.logger;
                if (iLogger != null) {
                    iLogger.error(null, errorMsg, new Object[]{BlameLoggerKt.blameSource$default(this.getSource(), null, null, 6, null), item});
                }
                return false;
            }
        }
        if ((this.typeMask & actualType & 0x20000) != 0) {
            int allFlags = 0;
            for (Symbol symbol : this.symbols) {
                allFlags |= symbol.getValue();
            }
            if ((allFlags & flattenedData) == flattenedData) {
                return true;
            }
            if ((this.typeMask & 4) == 0) {
                String errorMsg = "%s, %s is not a valid flag.";
                ILogger iLogger = this.logger;
                if (iLogger != null) {
                    iLogger.error(null, errorMsg, new Object[]{BlameLoggerKt.blameSource$default(this.getSource(), null, null, 6, null), item});
                }
                return false;
            }
        }
        return true;
    }

    public final boolean isCompatibleWith(@NotNull AttributeResource other) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        if ((this.typeMask & ~65535) != 0 || (other.typeMask & ~65535) != 0) {
            return false;
        }
        int thisTypeMask = this.typeMask | 1;
        int otherTypeMask = other.typeMask | 1;
        return thisTypeMask == otherTypeMask;
    }

    public final int getTypeMask() {
        return this.typeMask;
    }

    public final void setTypeMask(int n) {
        this.typeMask = n;
    }

    @Nullable
    public final ILogger getLogger() {
        return this.logger;
    }

    public AttributeResource(int typeMask, @Nullable ILogger logger) {
        List list;
        this.typeMask = typeMask;
        this.logger = logger;
        this.minInt = Integer.MIN_VALUE;
        this.maxInt = Integer.MAX_VALUE;
        AttributeResource attributeResource = this;
        boolean bl = false;
        attributeResource.symbols = list = (List)new ArrayList();
    }

    public /* synthetic */ AttributeResource(int n, ILogger iLogger, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        if ((n2 & 2) != 0) {
            iLogger = null;
        }
        this(n, iLogger);
    }

    public AttributeResource() {
        this(0, null, 3, null);
    }

    public final int component1() {
        return this.typeMask;
    }

    @Nullable
    public final ILogger component2() {
        return this.logger;
    }

    @NotNull
    public final AttributeResource copy(int typeMask, @Nullable ILogger logger) {
        return new AttributeResource(typeMask, logger);
    }

    public static /* synthetic */ AttributeResource copy$default(AttributeResource attributeResource, int n, ILogger iLogger, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = attributeResource.typeMask;
        }
        if ((n2 & 2) != 0) {
            iLogger = attributeResource.logger;
        }
        return attributeResource.copy(n, iLogger);
    }

    @NotNull
    public String toString() {
        return "AttributeResource(typeMask=" + this.typeMask + ", logger=" + this.logger + ")";
    }

    public int hashCode() {
        ILogger iLogger = this.logger;
        return this.typeMask * 31 + (iLogger != null ? iLogger.hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof AttributeResource)) break block3;
                AttributeResource attributeResource = (AttributeResource)object;
                if (this.typeMask != attributeResource.typeMask || !Intrinsics.areEqual((Object)this.logger, (Object)attributeResource.logger)) break block3;
            }
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0005\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0019"}, d2={"Lcom/android/aaptcompiler/AttributeResource$Symbol;", "", "symbol", "Lcom/android/aaptcompiler/Reference;", "value", "", "type", "", "(Lcom/android/aaptcompiler/Reference;IB)V", "getSymbol", "()Lcom/android/aaptcompiler/Reference;", "getType", "()B", "getValue", "()I", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "", "aaptcompiler"})
    public static final class Symbol {
        @NotNull
        private final Reference symbol;
        private final int value;
        private final byte type;

        @NotNull
        public final Reference getSymbol() {
            return this.symbol;
        }

        public final int getValue() {
            return this.value;
        }

        public final byte getType() {
            return this.type;
        }

        public Symbol(@NotNull Reference symbol, int value, byte type) {
            Intrinsics.checkParameterIsNotNull((Object)symbol, (String)"symbol");
            this.symbol = symbol;
            this.value = value;
            this.type = type;
        }

        @NotNull
        public final Reference component1() {
            return this.symbol;
        }

        public final int component2() {
            return this.value;
        }

        public final byte component3() {
            return this.type;
        }

        @NotNull
        public final Symbol copy(@NotNull Reference symbol, int value, byte type) {
            Intrinsics.checkParameterIsNotNull((Object)symbol, (String)"symbol");
            return new Symbol(symbol, value, type);
        }

        public static /* synthetic */ Symbol copy$default(Symbol symbol, Reference reference, int n, byte by, int n2, Object object) {
            if ((n2 & 1) != 0) {
                reference = symbol.symbol;
            }
            if ((n2 & 2) != 0) {
                n = symbol.value;
            }
            if ((n2 & 4) != 0) {
                by = symbol.type;
            }
            return symbol.copy(reference, n, by);
        }

        @NotNull
        public String toString() {
            return "Symbol(symbol=" + this.symbol + ", value=" + this.value + ", type=" + this.type + ")";
        }

        public int hashCode() {
            Reference reference = this.symbol;
            return ((reference != null ? reference.hashCode() : 0) * 31 + this.value) * 31 + this.type;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Symbol)) break block3;
                    Symbol symbol = (Symbol)object;
                    if (!Intrinsics.areEqual((Object)this.symbol, (Object)symbol.symbol) || this.value != symbol.value || this.type != symbol.type) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

