/*
 * Decompiled with CFR 0.152.
 */
package com.android.aaptcompiler;

import com.android.aaptcompiler.ConfigDescription;
import com.android.aaptcompiler.StyleString;
import com.android.aaptcompiler.android.ChunkType;
import com.android.aaptcompiler.android.ResChunkHeader;
import com.android.aaptcompiler.android.ResStringPoolHeader;
import com.android.aaptcompiler.android.ResStringPoolRef;
import com.android.aaptcompiler.android.ResStringPoolSpan;
import com.android.aaptcompiler.android.UtilKt;
import com.android.aaptcompiler.buffer.BigBuffer;
import com.android.utils.ILogger;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u0000 :2\u00020\u0001:\u0007:;<=>?@B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J \u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0012H\u0002J \u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0012H\u0002J \u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0012H\u0002J*\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u000f\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0002J\u000e\u0010 \u001a\u00020\u00072\u0006\u0010!\u001a\u00020\u0012J\"\u0010\"\u001a\u00020\u001a2\u0006\u0010\u000f\u001a\u00020\u001d2\u0006\u0010\u001c\u001a\u00020\u001a2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0002J\u0018\u0010#\u001a\u00020\u001a2\u0006\u0010\u000f\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fJ\u0018\u0010$\u001a\u00020\u001a2\u0006\u0010\u000f\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fJ\u0010\u0010%\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0002J\u0010\u0010&\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0002J\u000e\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020(J\u000e\u0010'\u001a\u00020*2\u0006\u0010+\u001a\u00020*J\u0018\u0010'\u001a\u00020*2\u0006\u0010,\u001a\u00020-2\b\b\u0002\u0010.\u001a\u00020/J\u0018\u0010'\u001a\u00020(2\u0006\u0010\u001b\u001a\u00020\u00052\b\b\u0002\u0010.\u001a\u00020/J \u00100\u001a\u00020(2\u0006\u0010\u001b\u001a\u00020\u00052\u0006\u0010.\u001a\u00020/2\u0006\u00101\u001a\u00020\u001aH\u0002J\b\u00102\u001a\u00020\fH\u0002J\u0006\u00103\u001a\u00020\u0012J$\u00104\u001a\u00020\f2\u001c\b\u0002\u00105\u001a\u0016\u0012\u0004\u0012\u00020/\u0018\u000106j\n\u0012\u0004\u0012\u00020/\u0018\u0001`7J$\u00108\u001a\u00020\f2\u001a\u00105\u001a\u0016\u0012\u0004\u0012\u00020/\u0018\u000106j\n\u0012\u0004\u0012\u00020/\u0018\u0001`7H\u0002J$\u00109\u001a\u00020\f2\u001a\u00105\u001a\u0016\u0012\u0004\u0012\u00020/\u0018\u000106j\n\u0012\u0004\u0012\u00020/\u0018\u0001`7H\u0002R \u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006A"}, d2={"Lcom/android/aaptcompiler/StringPool;", "", "()V", "indexedStrings", "", "", "", "Lcom/android/aaptcompiler/StringPool$Entry;", "strings", "styles", "Lcom/android/aaptcompiler/StringPool$StyleEntry;", "encodeHeader", "", "resHeader", "Lcom/android/aaptcompiler/android/ResStringPoolHeader;", "out", "Lcom/android/aaptcompiler/buffer/BigBuffer$BlockRef;", "encodeLengthUtf16", "", "length", "location", "encodeLengthUtf8", "encodeSpan", "resSpan", "Lcom/android/aaptcompiler/android/ResStringPoolSpan;", "encodeString", "", "str", "utf8", "Lcom/android/aaptcompiler/buffer/BigBuffer;", "logger", "Lcom/android/utils/ILogger;", "entryAt", "index", "flatten", "flattenUtf16", "flattenUtf8", "getLengthUtf16", "getLengthUtf8", "makeRef", "Lcom/android/aaptcompiler/StringPool$Ref;", "ref", "Lcom/android/aaptcompiler/StringPool$StyleRef;", "styleRef", "styleString", "Lcom/android/aaptcompiler/StyleString;", "context", "Lcom/android/aaptcompiler/StringPool$Context;", "makeRefImpl", "isUnique", "reAssignIndices", "size", "sort", "comparator", "Ljava/util/Comparator;", "Lkotlin/Comparator;", "sortEntries", "sortStyles", "Companion", "Context", "Entry", "Ref", "Span", "StyleEntry", "StyleRef", "aaptcompiler"})
public final class StringPool {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<Entry> strings;
    @NotNull
    private final List<StyleEntry> styles;
    @NotNull
    private final Map<String, List<Entry>> indexedStrings;
    public static final int UTF8_ENCODE_LENGTH_MAX = Short.MAX_VALUE;
    public static final int TWO_BYTE_UTF8_LENGTH_SIGNIFIER = 128;
    public static final int ONE_BYTE_UTF8_ENCODE_LENGTH_MAX = 127;
    public static final int UTF16_ENCODE_LENGTH_MAX = Integer.MAX_VALUE;
    public static final int TWO_CHAR_UTF16_LENGTH_SIGNIFIER = 32768;
    public static final int ONE_CHAR_UTF16_ENCODE_LENGTH_MAX = Short.MAX_VALUE;
    @NotNull
    private static final String STRING_TOO_LARGE = "STRING_TOO_LARGE";
    @NotNull
    private static final Comparator<Entry> ENTRY_ON_VALUE;
    @NotNull
    private static final Comparator<StyleEntry> STYLE_ON_VALUE;

    public StringPool() {
        boolean bl = false;
        this.strings = new ArrayList();
        bl = false;
        this.styles = new ArrayList();
        bl = false;
        this.indexedStrings = new LinkedHashMap();
    }

    public final int size() {
        return this.styles.size() + this.strings.size();
    }

    @NotNull
    public final Entry entryAt(int index) {
        return this.strings.get(index);
    }

    @NotNull
    public final Ref makeRef(@NotNull String str, @NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)str, (String)"str");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        return this.makeRefImpl(str, context, true);
    }

    public static /* synthetic */ Ref makeRef$default(StringPool stringPool, String string, Context context, int n, Object object) {
        if ((n & 2) != 0) {
            context = new Context(0L, null, 3, null);
        }
        return stringPool.makeRef(string, context);
    }

    @NotNull
    public final Ref makeRef(@NotNull Ref ref) {
        Intrinsics.checkParameterIsNotNull((Object)ref, (String)"ref");
        if (Intrinsics.areEqual((Object)ref.getEntry$aaptcompiler().getPool(), (Object)this)) {
            return ref;
        }
        return this.makeRef(ref.value(), ref.context());
    }

    private final Ref makeRefImpl(String str, Context context, boolean isUnique) {
        List<Entry> entries;
        if (isUnique && (entries = this.indexedStrings.get(str)) != null) {
            for (Entry entry : entries) {
                if (entry.getContext().getPriority() != context.getPriority()) continue;
                return new Ref(entry);
            }
        }
        Entry entry = new Entry(str, context);
        entry.setIndex$aaptcompiler(this.strings.size());
        entry.setRef$aaptcompiler(0);
        entry.setPool$aaptcompiler(this);
        this.strings.add(entry);
        Object object = this.indexedStrings;
        boolean bl = false;
        Map<String, List<Entry>> map = object;
        boolean bl2 = false;
        if (!map.containsKey(str)) {
            object = this.indexedStrings;
            bl = false;
            List list = new ArrayList();
            boolean bl3 = false;
            object.put(str, list);
        }
        if ((object = this.indexedStrings.get(str)) == null) {
            Intrinsics.throwNpe();
        }
        object.add(entry);
        return new Ref(entry);
    }

    @NotNull
    public final StyleRef makeRef(@NotNull StyleString styleString, @NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)styleString, (String)"styleString");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        boolean bl = false;
        List spanList = new ArrayList();
        for (com.android.aaptcompiler.Span span : styleString.getSpans()) {
            spanList.add(new Span(StringPool.makeRef$default(this, span.getName(), null, 2, null), span.getFirstChar(), span.getLastChar()));
        }
        StyleEntry entry = new StyleEntry(styleString.getStr(), context, spanList);
        entry.setIndex$aaptcompiler(this.styles.size());
        entry.setRef$aaptcompiler(0);
        this.styles.add(entry);
        return new StyleRef(entry);
    }

    public static /* synthetic */ StyleRef makeRef$default(StringPool stringPool, StyleString styleString, Context context, int n, Object object) {
        if ((n & 2) != 0) {
            context = new Context(0L, null, 3, null);
        }
        return stringPool.makeRef(styleString, context);
    }

    @NotNull
    public final StyleRef makeRef(@NotNull StyleRef styleRef) {
        Intrinsics.checkParameterIsNotNull((Object)styleRef, (String)"styleRef");
        StyleEntry styleEntry = new StyleEntry(styleRef.getStyleEntry$aaptcompiler().getValue(), styleRef.getStyleEntry$aaptcompiler().getContext(), styleRef.getStyleEntry$aaptcompiler().getSpans());
        styleEntry.setIndex$aaptcompiler(this.styles.size());
        styleEntry.setRef$aaptcompiler(0);
        for (Span span : styleEntry.getSpans()) {
            this.makeRef(span.getName$aaptcompiler());
        }
        this.styles.add(styleEntry);
        return new StyleRef(styleEntry);
    }

    public final boolean flattenUtf8(@NotNull BigBuffer out, @Nullable ILogger logger) {
        Intrinsics.checkParameterIsNotNull((Object)out, (String)"out");
        return this.flatten(out, true, logger);
    }

    public final boolean flattenUtf16(@NotNull BigBuffer out, @Nullable ILogger logger) {
        Intrinsics.checkParameterIsNotNull((Object)out, (String)"out");
        return this.flatten(out, false, logger);
    }

    public final void sort(@Nullable Comparator<Context> comparator) {
        this.sortEntries(comparator);
        this.sortStyles(comparator);
        this.reAssignIndices();
    }

    public static /* synthetic */ void sort$default(StringPool stringPool, Comparator comparator, int n, Object object) {
        if ((n & 1) != 0) {
            comparator = null;
        }
        stringPool.sort(comparator);
    }

    private final boolean flatten(BigBuffer out, boolean utf8, ILogger logger) {
        boolean error = false;
        ResStringPoolHeader header = new ResStringPoolHeader(new ResChunkHeader(UtilKt.hostToDevice(ChunkType.STRING_POOL_TYPE.getId()), UtilKt.hostToDevice((short)28)), UtilKt.hostToDevice(this.size()), UtilKt.hostToDevice(this.styles.size()));
        if (utf8) {
            header.setFlags(0x100 | header.getFlags());
        }
        int headerStart = out.getSize();
        BigBuffer.BlockRef headerBlock = out.nextBlock(28);
        int currentStringIndex = 0;
        BigBuffer.BlockRef stringIndexBlock = this.size() != 0 ? out.nextBlock(4 * this.size()) : null;
        int currentStyleIndex = 0;
        BigBuffer.BlockRef stylesIndexBlock = this.styles.size() != 0 ? out.nextBlock(4 * this.styles.size()) : null;
        int beginStringsIndex = out.getSize();
        header.setStringsStart(UtilKt.hostToDevice(out.getSize() - headerStart));
        if (stringIndexBlock != null) {
            boolean stringError;
            for (StyleEntry styleEntry : this.styles) {
                stringIndexBlock.writeInt(UtilKt.hostToDevice(out.getSize() - beginStringsIndex), currentStringIndex);
                currentStringIndex += 4;
                stringError = !this.encodeString(styleEntry.getValue(), utf8, out, logger);
                error = stringError || error;
            }
            for (Entry entry : this.strings) {
                stringIndexBlock.writeInt(UtilKt.hostToDevice(out.getSize() - beginStringsIndex), currentStringIndex);
                currentStringIndex += 4;
                stringError = !this.encodeString(entry.getValue(), utf8, out, logger);
                error = stringError || error;
            }
            out.align4();
        }
        if (stylesIndexBlock != null) {
            header.setStylesStart(UtilKt.hostToDevice(out.getSize() - headerStart));
            for (StyleEntry styleEntry : this.styles) {
                stylesIndexBlock.writeInt(UtilKt.hostToDevice(out.getSize() - header.getStylesStart()), currentStyleIndex);
                currentStyleIndex += 4;
                Collection stringError = styleEntry.getSpans();
                boolean bl = false;
                if (!stringError.isEmpty()) {
                    BigBuffer.BlockRef spansBlock = out.nextBlock(12 * styleEntry.getSpans().size());
                    int currentSpanLocation = 0;
                    for (Span span : styleEntry.getSpans()) {
                        ResStringPoolSpan resSpan = new ResStringPoolSpan(new ResStringPoolRef(UtilKt.hostToDevice(span.getName$aaptcompiler().index())), UtilKt.hostToDevice(span.getFirstChar()), UtilKt.hostToDevice(span.getLastChar()));
                        this.encodeSpan(resSpan, spansBlock, currentSpanLocation);
                        currentSpanLocation += 12;
                    }
                }
                BigBuffer.BlockRef spanEnd = out.nextBlock(4);
                spanEnd.writeInt(-1, 0);
            }
            BigBuffer.BlockRef padding = out.nextBlock(8);
            padding.writeInt(-1, 0);
            padding.writeInt(-1, 4);
            out.align4();
        }
        header.getHeader().setSize(UtilKt.hostToDevice(out.getSize() - headerStart));
        this.encodeHeader(header, headerBlock);
        return !error;
    }

    private final void encodeHeader(ResStringPoolHeader resHeader, BigBuffer.BlockRef out) {
        out.writeShort(resHeader.getHeader().getTypeId(), 0);
        out.writeShort(resHeader.getHeader().getHeaderSize(), 2);
        out.writeInt(resHeader.getHeader().getSize(), 4);
        out.writeInt(resHeader.getStringCount(), 8);
        out.writeInt(resHeader.getStyleCount(), 12);
        out.writeInt(resHeader.getFlags(), 16);
        out.writeInt(resHeader.getStringsStart(), 20);
        out.writeInt(resHeader.getStylesStart(), 24);
    }

    private final int encodeSpan(ResStringPoolSpan resSpan, BigBuffer.BlockRef out, int location) {
        out.writeInt(resSpan.getName().getIndex(), location);
        out.writeInt(resSpan.getFirstChar(), location + 4);
        out.writeInt(resSpan.getLastChar(), location + 8);
        return 12;
    }

    private final boolean encodeString(String str, boolean utf8, BigBuffer out, ILogger logger) {
        if (utf8) {
            int utf16Length = str.length();
            String string = str;
            Charset charset = Charsets.UTF_8;
            boolean bl = false;
            String string2 = string;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            byte[] byArray = string2.getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
            byte[] utf8Str = byArray;
            int utf8Length = utf8Str.length;
            if (utf8Length > Short.MAX_VALUE || utf16Length > Integer.MAX_VALUE) {
                String errorMsg = "String too large to encode using UTF-8. Writing the string instead as '%s'.";
                ILogger iLogger = logger;
                if (iLogger != null) {
                    Object[] objectArray = new Object[]{STRING_TOO_LARGE};
                    iLogger.error(null, errorMsg, objectArray);
                }
                this.encodeString(STRING_TOO_LARGE, utf8, out, logger);
                return false;
            }
            int blockSize = this.getLengthUtf8(utf8Length) + this.getLengthUtf8(utf16Length) + utf8Length + 1;
            BigBuffer.BlockRef stringBlock = out.nextBlock(blockSize);
            int locationToWrite = 0;
            locationToWrite += this.encodeLengthUtf8(utf16Length, stringBlock, locationToWrite);
            locationToWrite += this.encodeLengthUtf8(utf8Length, stringBlock, locationToWrite);
            int n = 0;
            if (n < utf8Length) {
                do {
                    int i = n++;
                    stringBlock.writeByte(utf8Str[i], locationToWrite);
                    ++locationToWrite;
                } while (n < utf8Length);
            }
            stringBlock.writeByte((byte)0, locationToWrite);
            return true;
        }
        int utf16Length = str.length();
        if (utf16Length > Integer.MAX_VALUE) {
            String errorMsg = "String too large to encode using UTF-16. Writing the string instead as '%s'.";
            ILogger utf8Length = logger;
            if (utf8Length != null) {
                Object[] blockSize = new Object[]{STRING_TOO_LARGE};
                utf8Length.error(null, errorMsg, blockSize);
            }
            this.encodeString(STRING_TOO_LARGE, utf8, out, logger);
            return false;
        }
        int blockSize = this.getLengthUtf16(utf16Length) + utf16Length * 2 + 2;
        BigBuffer.BlockRef stringBlock = out.nextBlock(blockSize);
        int locationToWrite = 0;
        locationToWrite += this.encodeLengthUtf16(utf16Length, stringBlock, locationToWrite);
        int n = 0;
        if (n < utf16Length) {
            do {
                int i = n++;
                stringBlock.writeShort(UtilKt.hostToDevice((short)str.charAt(i)), locationToWrite);
                locationToWrite += 2;
            } while (n < utf16Length);
        }
        stringBlock.writeShort((short)0, locationToWrite);
        return true;
    }

    private final int getLengthUtf8(int length) {
        return length <= 127 ? 1 : 2;
    }

    private final int encodeLengthUtf8(int length, BigBuffer.BlockRef out, int location) {
        int n;
        if (length <= 127) {
            out.writeByte((byte)length, location);
            n = 1;
        } else {
            out.writeByte((byte)(length >> 8 | 0x80), location);
            out.writeByte((byte)length, location + 1);
            n = 2;
        }
        return n;
    }

    private final int getLengthUtf16(int length) {
        return length <= Short.MAX_VALUE ? 2 : 4;
    }

    private final int encodeLengthUtf16(int length, BigBuffer.BlockRef out, int location) {
        int n;
        if (length <= Short.MAX_VALUE) {
            out.writeShort(UtilKt.hostToDevice((short)length), location);
            n = 2;
        } else {
            out.writeShort(UtilKt.hostToDevice((short)(length >> 16 | 0x8000)), location);
            out.writeShort(UtilKt.hostToDevice((short)length), location + 2);
            n = 4;
        }
        return n;
    }

    private final void sortEntries(Comparator<Context> comparator) {
        Comparator<Entry> comparator2;
        if (comparator != null) {
            boolean bl = false;
            comparator2 = ((Comparator)new Comparator<T>(comparator){
                final /* synthetic */ Comparator $comparator;
                {
                    this.$comparator = comparator;
                }

                public final int compare(T a, T b) {
                    Entry it;
                    Comparator comparator = this.$comparator;
                    boolean bl = false;
                    Entry entry = (Entry)a;
                    Comparator comparator2 = comparator;
                    boolean bl2 = false;
                    Context context = it.getContext();
                    it = (Entry)b;
                    bl2 = false;
                    Context context2 = it.getContext();
                    return comparator2.compare(context, context2);
                }
            }).thenComparing(Companion.getENTRY_ON_VALUE());
        } else {
            comparator2 = Companion.getENTRY_ON_VALUE();
        }
        Comparator<Entry> entryComparator = comparator2;
        Intrinsics.checkExpressionValueIsNotNull(entryComparator, (String)"entryComparator");
        CollectionsKt.sortWith(this.strings, entryComparator);
    }

    private final void sortStyles(Comparator<Context> comparator) {
        Comparator<StyleEntry> comparator2;
        if (comparator != null) {
            boolean bl = false;
            comparator2 = ((Comparator)new Comparator<T>(comparator){
                final /* synthetic */ Comparator $comparator;
                {
                    this.$comparator = comparator;
                }

                public final int compare(T a, T b) {
                    StyleEntry it;
                    Comparator comparator = this.$comparator;
                    boolean bl = false;
                    StyleEntry styleEntry = (StyleEntry)a;
                    Comparator comparator2 = comparator;
                    boolean bl2 = false;
                    Context context = it.getContext();
                    it = (StyleEntry)b;
                    bl2 = false;
                    Context context2 = it.getContext();
                    return comparator2.compare(context, context2);
                }
            }).thenComparing(Companion.getSTYLE_ON_VALUE());
        } else {
            comparator2 = Companion.getSTYLE_ON_VALUE();
        }
        Comparator<StyleEntry> entryComparator = comparator2;
        Intrinsics.checkExpressionValueIsNotNull(entryComparator, (String)"entryComparator");
        CollectionsKt.sortWith(this.styles, entryComparator);
    }

    private final void reAssignIndices() {
        int index;
        int n = 0;
        int n2 = this.styles.size();
        if (n < n2) {
            do {
                index = n++;
                this.styles.get(index).setIndex$aaptcompiler(index);
            } while (n < n2);
        }
        if ((n = 0) < (n2 = this.strings.size())) {
            do {
                index = n++;
                this.strings.get(index).setIndex$aaptcompiler(index);
            } while (n < n2);
        }
    }

    static {
        boolean bl = false;
        ENTRY_ON_VALUE = new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                Entry it = (Entry)a;
                boolean bl2 = false;
                Comparable comparable = (Comparable)((Object)it.getValue());
                it = (Entry)b;
                Comparable comparable2 = comparable;
                bl2 = false;
                Comparable comparable3 = (Comparable)((Object)it.getValue());
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)comparable3);
            }
        };
        bl = false;
        STYLE_ON_VALUE = new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                StyleEntry it = (StyleEntry)a;
                boolean bl2 = false;
                Comparable comparable = (Comparable)((Object)it.getValue());
                it = (StyleEntry)b;
                Comparable comparable2 = comparable;
                bl2 = false;
                Comparable comparable3 = (Comparable)((Object)it.getValue());
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)comparable3);
            }
        };
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u00002\u00020\u0001:\u0001\u000fB\u0019\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u0010"}, d2={"Lcom/android/aaptcompiler/StringPool$Context;", "", "priority", "", "config", "Lcom/android/aaptcompiler/ConfigDescription;", "(JLcom/android/aaptcompiler/ConfigDescription;)V", "getConfig", "()Lcom/android/aaptcompiler/ConfigDescription;", "setConfig", "(Lcom/android/aaptcompiler/ConfigDescription;)V", "getPriority", "()J", "setPriority", "(J)V", "Priority", "aaptcompiler"})
    public static final class Context {
        private long priority;
        @NotNull
        private ConfigDescription config;

        public Context(long priority, @NotNull ConfigDescription config) {
            Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
            this.priority = priority;
            this.config = config;
        }

        public /* synthetic */ Context(long l, ConfigDescription configDescription, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                l = Priority.NORMAL.getPriority();
            }
            if ((n & 2) != 0) {
                configDescription = new ConfigDescription(null, 1, null);
            }
            this(l, configDescription);
        }

        public final long getPriority() {
            return this.priority;
        }

        public final void setPriority(long l) {
            this.priority = l;
        }

        @NotNull
        public final ConfigDescription getConfig() {
            return this.config;
        }

        public final void setConfig(@NotNull ConfigDescription configDescription) {
            Intrinsics.checkParameterIsNotNull((Object)configDescription, (String)"<set-?>");
            this.config = configDescription;
        }

        public Context() {
            this(0L, null, 3, null);
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\t\n\u0002\b\u0007\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\t\u00a8\u0006\n"}, d2={"Lcom/android/aaptcompiler/StringPool$Context$Priority;", "", "priority", "", "(Ljava/lang/String;IJ)V", "getPriority", "()J", "HIGH", "NORMAL", "LOW", "aaptcompiler"})
        public static final class Priority
        extends Enum<Priority> {
            private final long priority;
            public static final /* enum */ Priority HIGH = new Priority(1L);
            public static final /* enum */ Priority NORMAL = new Priority(Integer.MAX_VALUE);
            public static final /* enum */ Priority LOW = new Priority(0xFFFFFFFFL);
            private static final /* synthetic */ Priority[] $VALUES;

            private Priority(long priority) {
                this.priority = priority;
            }

            public final long getPriority() {
                return this.priority;
            }

            public static Priority[] values() {
                Priority[] priorityArray = $VALUES;
                Priority[] priorityArray2 = new Priority[priorityArray.length];
                System.arraycopy(priorityArray, 0, priorityArray2, 0, priorityArray.length);
                return priorityArray2;
            }

            public static Priority valueOf(String value) {
                Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
                return Enum.valueOf(Priority.class, value);
            }

            static {
                Priority[] priorityArray = new Priority[]{HIGH, NORMAL, LOW};
                $VALUES = priorityArray;
            }
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0007\u001a\u00020\bJ\u0006\u0010\t\u001a\u00020\nJ\u0006\u0010\u000b\u001a\u00020\fR\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\r"}, d2={"Lcom/android/aaptcompiler/StringPool$Ref;", "", "entry", "Lcom/android/aaptcompiler/StringPool$Entry;", "(Lcom/android/aaptcompiler/StringPool$Entry;)V", "getEntry$aaptcompiler", "()Lcom/android/aaptcompiler/StringPool$Entry;", "context", "Lcom/android/aaptcompiler/StringPool$Context;", "index", "", "value", "", "aaptcompiler"})
    public static final class Ref {
        @NotNull
        private final Entry entry;

        public Ref(@NotNull Entry entry) {
            Intrinsics.checkParameterIsNotNull((Object)entry, (String)"entry");
            this.entry = entry;
            Entry entry2 = this.entry;
            entry2.setRef$aaptcompiler(entry2.getRef() + 1);
            entry2.getRef();
        }

        @NotNull
        public final Entry getEntry$aaptcompiler() {
            return this.entry;
        }

        @NotNull
        public final String value() {
            return this.entry.getValue();
        }

        public final int index() {
            return this.entry.getPool().styles.size() + this.entry.getIndex();
        }

        @NotNull
        public final Context context() {
            return this.entry.getContext();
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u0096\u0002R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\u0006\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\t\"\u0004\b\r\u0010\u000bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0013"}, d2={"Lcom/android/aaptcompiler/StringPool$Span;", "", "name", "Lcom/android/aaptcompiler/StringPool$Ref;", "firstChar", "", "lastChar", "(Lcom/android/aaptcompiler/StringPool$Ref;II)V", "getFirstChar", "()I", "setFirstChar", "(I)V", "getLastChar", "setLastChar", "getName$aaptcompiler", "()Lcom/android/aaptcompiler/StringPool$Ref;", "equals", "", "other", "aaptcompiler"})
    public static final class Span {
        @NotNull
        private final Ref name;
        private int firstChar;
        private int lastChar;

        public Span(@NotNull Ref name, int firstChar, int lastChar) {
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            this.name = name;
            this.firstChar = firstChar;
            this.lastChar = lastChar;
        }

        public /* synthetic */ Span(Ref ref, int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n3 & 4) != 0) {
                n2 = n;
            }
            this(ref, n, n2);
        }

        @NotNull
        public final Ref getName$aaptcompiler() {
            return this.name;
        }

        public final int getFirstChar() {
            return this.firstChar;
        }

        public final void setFirstChar(int n) {
            this.firstChar = n;
        }

        public final int getLastChar() {
            return this.lastChar;
        }

        public final void setLastChar(int n) {
            this.lastChar = n;
        }

        public boolean equals(@Nullable Object other) {
            if (other instanceof Span) {
                return Intrinsics.areEqual((Object)this.name.value(), (Object)((Span)other).name.value()) && this.firstChar == ((Span)other).firstChar && this.lastChar == ((Span)other).lastChar;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0007\u001a\u00020\bJ\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nJ\u0006\u0010\f\u001a\u00020\rR\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000e"}, d2={"Lcom/android/aaptcompiler/StringPool$StyleRef;", "", "styleEntry", "Lcom/android/aaptcompiler/StringPool$StyleEntry;", "(Lcom/android/aaptcompiler/StringPool$StyleEntry;)V", "getStyleEntry$aaptcompiler", "()Lcom/android/aaptcompiler/StringPool$StyleEntry;", "index", "", "spans", "", "Lcom/android/aaptcompiler/StringPool$Span;", "value", "", "aaptcompiler"})
    public static final class StyleRef {
        @NotNull
        private final StyleEntry styleEntry;

        public StyleRef(@NotNull StyleEntry styleEntry) {
            Intrinsics.checkParameterIsNotNull((Object)styleEntry, (String)"styleEntry");
            this.styleEntry = styleEntry;
        }

        @NotNull
        public final StyleEntry getStyleEntry$aaptcompiler() {
            return this.styleEntry;
        }

        @NotNull
        public final String value() {
            return this.styleEntry.getValue();
        }

        public final int index() {
            return this.styleEntry.getIndex();
        }

        @NotNull
        public final List<Span> spans() {
            return this.styleEntry.getSpans();
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR$\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n@@X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR$\u0010\u0011\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\u0010@@X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R$\u0010\u0016\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n@@X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\r\"\u0004\b\u0018\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006\u001b"}, d2={"Lcom/android/aaptcompiler/StringPool$Entry;", "", "value", "", "context", "Lcom/android/aaptcompiler/StringPool$Context;", "(Ljava/lang/String;Lcom/android/aaptcompiler/StringPool$Context;)V", "getContext", "()Lcom/android/aaptcompiler/StringPool$Context;", "<set-?>", "", "index", "getIndex", "()I", "setIndex$aaptcompiler", "(I)V", "Lcom/android/aaptcompiler/StringPool;", "pool", "getPool", "()Lcom/android/aaptcompiler/StringPool;", "setPool$aaptcompiler", "(Lcom/android/aaptcompiler/StringPool;)V", "ref", "getRef", "setRef$aaptcompiler", "getValue", "()Ljava/lang/String;", "aaptcompiler"})
    public static final class Entry {
        @NotNull
        private final String value;
        @NotNull
        private final Context context;
        private int index;
        private int ref;
        public StringPool pool;

        public Entry(@NotNull String value, @NotNull Context context) {
            Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            this.value = value;
            this.context = context;
        }

        @NotNull
        public final String getValue() {
            return this.value;
        }

        @NotNull
        public final Context getContext() {
            return this.context;
        }

        public final int getIndex() {
            return this.index;
        }

        public final void setIndex$aaptcompiler(int n) {
            this.index = n;
        }

        public final int getRef() {
            return this.ref;
        }

        public final void setRef$aaptcompiler(int n) {
            this.ref = n;
        }

        @NotNull
        public final StringPool getPool() {
            StringPool stringPool = this.pool;
            if (stringPool != null) {
                return stringPool;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"pool");
            throw null;
        }

        public final void setPool$aaptcompiler(@NotNull StringPool stringPool) {
            Intrinsics.checkParameterIsNotNull((Object)stringPool, (String)"<set-?>");
            this.pool = stringPool;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\r\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR$\u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\r@@X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R$\u0010\u0013\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\r@@X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0010\"\u0004\b\u0015\u0010\u0012R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001a"}, d2={"Lcom/android/aaptcompiler/StringPool$StyleEntry;", "", "value", "", "context", "Lcom/android/aaptcompiler/StringPool$Context;", "spans", "", "Lcom/android/aaptcompiler/StringPool$Span;", "(Ljava/lang/String;Lcom/android/aaptcompiler/StringPool$Context;Ljava/util/List;)V", "getContext", "()Lcom/android/aaptcompiler/StringPool$Context;", "<set-?>", "", "index", "getIndex", "()I", "setIndex$aaptcompiler", "(I)V", "ref", "getRef", "setRef$aaptcompiler", "getSpans", "()Ljava/util/List;", "getValue", "()Ljava/lang/String;", "aaptcompiler"})
    public static final class StyleEntry {
        @NotNull
        private final String value;
        @NotNull
        private final Context context;
        @NotNull
        private final List<Span> spans;
        private int index;
        private int ref;

        public StyleEntry(@NotNull String value, @NotNull Context context, @NotNull List<Span> spans) {
            Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull(spans, (String)"spans");
            this.value = value;
            this.context = context;
            this.spans = spans;
        }

        @NotNull
        public final String getValue() {
            return this.value;
        }

        @NotNull
        public final Context getContext() {
            return this.context;
        }

        @NotNull
        public final List<Span> getSpans() {
            return this.spans;
        }

        public final int getIndex() {
            return this.index;
        }

        public final void setIndex$aaptcompiler(int n) {
            this.index = n;
        }

        public final int getRef() {
            return this.ref;
        }

        public final void setRef$aaptcompiler(int n) {
            this.ref = n;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R!\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082T\u00a2\u0006\u0002\n\u0000R!\u0010\u000e\u001a\u0012\u0012\u0004\u0012\u00020\u000f0\u0004j\b\u0012\u0004\u0012\u00020\u000f`\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\bR\u000e\u0010\u0011\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/android/aaptcompiler/StringPool$Companion;", "", "()V", "ENTRY_ON_VALUE", "Ljava/util/Comparator;", "Lcom/android/aaptcompiler/StringPool$Entry;", "Lkotlin/Comparator;", "getENTRY_ON_VALUE", "()Ljava/util/Comparator;", "ONE_BYTE_UTF8_ENCODE_LENGTH_MAX", "", "ONE_CHAR_UTF16_ENCODE_LENGTH_MAX", "STRING_TOO_LARGE", "", "STYLE_ON_VALUE", "Lcom/android/aaptcompiler/StringPool$StyleEntry;", "getSTYLE_ON_VALUE", "TWO_BYTE_UTF8_LENGTH_SIGNIFIER", "TWO_CHAR_UTF16_LENGTH_SIGNIFIER", "UTF16_ENCODE_LENGTH_MAX", "UTF8_ENCODE_LENGTH_MAX", "aaptcompiler"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Comparator<Entry> getENTRY_ON_VALUE() {
            return ENTRY_ON_VALUE;
        }

        @NotNull
        public final Comparator<StyleEntry> getSTYLE_ON_VALUE() {
            return STYLE_ON_VALUE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

