/*
 * Decompiled with CFR 0.152.
 */
package com.android.aaptcompiler;

import com.android.aaptcompiler.FloatConstantsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.FloatCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0010\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0001H\u0002\u001a\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0001H\u0002\u001a\u0015\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000b\u001a\u0015\u0010\f\u001a\u0004\u0018\u00010\b2\u0006\u0010\r\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000b\u001a\u0015\u0010\u000e\u001a\u0004\u0018\u00010\b2\u0006\u0010\r\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000b\u00a8\u0006\u000f"}, d2={"getScalarShift", "", "valueToNormalize", "", "getShift", "exponent", "getValue", "parseFloat", "", "text", "", "(Ljava/lang/String;)Ljava/lang/Float;", "parseFloatDec", "lowerCaseText", "parseFloatHex", "aaptcompiler"})
public final class FloatParsingKt {
    @Nullable
    public static final Float parseFloat(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        CharSequence charSequence = text;
        boolean bl = false;
        if (charSequence.length() == 0) {
            return null;
        }
        String string = text;
        boolean bl2 = false;
        String string2 = string.toLowerCase();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.String).toLowerCase()");
        String lowerText = string2;
        if (StringsKt.startsWith$default((String)lowerText, (String)"0x", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)lowerText, (String)"0x", (int)1, (boolean)false, (int)4, null)) {
            return FloatParsingKt.parseFloatHex(lowerText);
        }
        return FloatParsingKt.parseFloatDec(lowerText);
    }

    private static final long getValue(int exponent) {
        return exponent > FloatConstantsKt.getPositiveSignificands().length ? 0L : (exponent >= 0 ? FloatConstantsKt.getPositiveSignificands()[exponent] : (exponent >= -FloatConstantsKt.getNegativeSignificands().length ? FloatConstantsKt.getNegativeSignificands()[-exponent - 1] : 0L));
    }

    private static final int getShift(int exponent) {
        return exponent > FloatConstantsKt.getPositiveSignificands().length ? 0 : (exponent >= 0 ? FloatConstantsKt.getPositiveShifts()[exponent] : (exponent >= -FloatConstantsKt.getNegativeSignificands().length ? FloatConstantsKt.getNegativeShifts()[-exponent - 1] : 0));
    }

    private static final int getScalarShift(long valueToNormalize) {
        return (valueToNormalize & Long.MIN_VALUE) != 0L ? 4 : ((valueToNormalize & 0x4000000000000000L) != 0L ? 3 : ((valueToNormalize & 0x2000000000000000L) != 0L ? 2 : ((valueToNormalize & 0x1000000000000000L) != 0L ? 1 : 0)));
    }

    @Nullable
    public static final Float parseFloatDec(@NotNull String lowerCaseText) {
        int currentIndex;
        Intrinsics.checkNotNullParameter((Object)lowerCaseText, (String)"lowerCaseText");
        boolean negative = lowerCaseText.charAt(0) == '-';
        int significandBegin = currentIndex = lowerCaseText.charAt(0) == '+' || negative ? 1 : 0;
        boolean significandStart = false;
        boolean validSignificand = false;
        boolean subInteger = false;
        int mostSignificantExponent = 0;
        while (currentIndex < lowerCaseText.length() && lowerCaseText.charAt(currentIndex) != 'e') {
            if (lowerCaseText.charAt(currentIndex) == '.') {
                if (subInteger) {
                    return null;
                }
                subInteger = true;
                ++currentIndex;
                continue;
            }
            if (significandStart && !subInteger) {
                ++mostSignificantExponent;
            } else if (!significandStart && subInteger) {
                --mostSignificantExponent;
            }
            char c = lowerCaseText.charAt(currentIndex);
            boolean bl = '1' <= c ? c <= '9' : false;
            if (bl) {
                validSignificand = true;
                if (!significandStart) {
                    significandStart = true;
                    significandBegin = currentIndex;
                }
            } else if (c == '0') {
                validSignificand = true;
            } else {
                return null;
            }
            ++currentIndex;
        }
        int significandEnd = currentIndex;
        if (!validSignificand) {
            return null;
        }
        int declaredExponent = 0;
        if (currentIndex < lowerCaseText.length()) {
            boolean negativeExponent;
            if (currentIndex == lowerCaseText.length() - 1) {
                return null;
            }
            boolean bl = negativeExponent = lowerCaseText.charAt(++currentIndex) == '-';
            if (negativeExponent || lowerCaseText.charAt(currentIndex) == '+') {
                ++currentIndex;
            }
            while (currentIndex < lowerCaseText.length()) {
                char c = lowerCaseText.charAt(currentIndex);
                if (!('0' <= c ? c <= '9' : false)) {
                    return null;
                }
                int currentValue = lowerCaseText.charAt(currentIndex) - 48;
                declaredExponent = declaredExponent * 10 + currentValue;
                ++currentIndex;
            }
            if (negativeExponent) {
                declaredExponent = -declaredExponent;
            }
        }
        if (!significandStart) {
            return negative ? Float.valueOf(-0.0f) : Float.valueOf(0.0f);
        }
        currentIndex = significandBegin;
        long significandValue = FloatParsingKt.getValue(mostSignificantExponent += declaredExponent);
        int baseBinaryShift = FloatParsingKt.getShift(mostSignificantExponent);
        if (significandValue == 0L) {
            return null;
        }
        int significandScalarShift = FloatParsingKt.getScalarShift(significandValue *= (long)(lowerCaseText.charAt(currentIndex) - 48));
        significandValue >>>= significandScalarShift;
        baseBinaryShift += significandScalarShift;
        int currentExponent = mostSignificantExponent - 1;
        ++currentIndex;
        while (currentIndex < significandEnd) {
            char c = lowerCaseText.charAt(currentIndex);
            if (!('1' <= c ? c <= '9' : false)) {
                if (c == '0') {
                    ++currentIndex;
                    --currentExponent;
                    continue;
                }
                ++currentIndex;
                continue;
            }
            int scalarValue = lowerCaseText.charAt(currentIndex) - 48;
            long currentValue = FloatParsingKt.getValue(currentExponent) * (long)scalarValue;
            int relativeDownShift = baseBinaryShift - FloatParsingKt.getShift(currentExponent);
            int scalarShift = FloatParsingKt.getScalarShift(currentValue);
            currentValue >>>= scalarShift;
            if ((relativeDownShift -= scalarShift) > 59) break;
            if (((significandValue += currentValue >>> relativeDownShift) & 0x1000000000000000L) != 0L) {
                significandValue >>>= 1;
                ++baseBinaryShift;
            }
            --currentExponent;
            ++currentIndex;
        }
        if (((significandValue += 0x800000000L) & 0x1000000000000000L) != 0L) {
            significandValue >>>= 1;
            ++baseBinaryShift;
        }
        if (baseBinaryShift < -126 || baseBinaryShift > 127) {
            return null;
        }
        int mantissa = (int)((significandValue & 0xF7FFFFFFFFFFFFFFL) >>> 36);
        int biasedExp = baseBinaryShift + 127;
        FloatCompanionObject floatCompanionObject = FloatCompanionObject.INSTANCE;
        int n = (negative ? Integer.MIN_VALUE : 0) | mantissa | biasedExp << 23;
        boolean bl = false;
        return Float.valueOf(Float.intBitsToFloat(n));
    }

    @Nullable
    public static final Float parseFloatHex(@NotNull String lowerCaseText) {
        int exponent;
        int n;
        Intrinsics.checkNotNullParameter((Object)lowerCaseText, (String)"lowerCaseText");
        boolean negative = lowerCaseText.charAt(0) == '-';
        boolean signed = lowerCaseText.charAt(0) == '+' || negative;
        int currentIndex = signed ? 3 : 2;
        String string = lowerCaseText;
        int n2 = currentIndex - 2;
        boolean bl = false;
        String string2 = string.substring(n2, currentIndex);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        if (!Intrinsics.areEqual((Object)string2, (Object)"0x")) {
            return null;
        }
        int currentMantissa = 0;
        int currentSkew = 0;
        int mantissaBits = 0;
        boolean mantissaStart = false;
        boolean subInteger = false;
        boolean validMantissa = false;
        while (currentIndex < lowerCaseText.length() && lowerCaseText.charAt(currentIndex) != 'p') {
            int n3;
            char c = lowerCaseText.charAt(currentIndex);
            boolean bl2 = '0' <= c ? c <= '9' : false;
            if (bl2) {
                validMantissa = true;
                n3 = lowerCaseText.charAt(currentIndex) - 48;
            } else {
                boolean bl3 = 'a' <= c ? c <= 'f' : false;
                if (bl3) {
                    validMantissa = true;
                    n3 = lowerCaseText.charAt(currentIndex) - 97 + 10;
                } else {
                    if (c == '.') {
                        if (subInteger) {
                            return null;
                        }
                        subInteger = true;
                        ++currentIndex;
                        continue;
                    }
                    return null;
                }
            }
            int indexValue = n3;
            if (!mantissaStart && indexValue != 0) {
                mantissaStart = true;
                currentMantissa = indexValue;
                if (indexValue >= 8) {
                    --currentSkew;
                    mantissaBits = 3;
                } else if (indexValue >= 4) {
                    currentSkew -= 2;
                    mantissaBits = 2;
                } else if (indexValue >= 2) {
                    currentSkew -= 3;
                    mantissaBits = 1;
                } else {
                    currentSkew -= 4;
                    mantissaBits = 0;
                }
            } else if (mantissaStart && mantissaBits < 24) {
                currentMantissa = (currentMantissa << 4) + indexValue;
                mantissaBits += 4;
            }
            if (mantissaStart && !subInteger) {
                currentSkew += 4;
            } else if (!mantissaStart && subInteger) {
                currentSkew -= 4;
            }
            ++currentIndex;
        }
        if (!validMantissa) {
            return null;
        }
        int declaredExponent = 0;
        if (currentIndex < lowerCaseText.length()) {
            boolean negativeExponent;
            if (currentIndex == lowerCaseText.length() - 1) {
                return null;
            }
            boolean bl4 = negativeExponent = lowerCaseText.charAt(++currentIndex) == '-';
            if (negativeExponent || lowerCaseText.charAt(currentIndex) == '+') {
                ++currentIndex;
            }
            while (currentIndex < lowerCaseText.length()) {
                char c = lowerCaseText.charAt(currentIndex);
                if (!('0' <= c ? c <= '9' : false)) {
                    return null;
                }
                int currentValue = lowerCaseText.charAt(currentIndex) - 48;
                declaredExponent = declaredExponent * 10 + currentValue;
                ++currentIndex;
            }
            if (negativeExponent) {
                declaredExponent = -declaredExponent;
            }
        }
        currentMantissa = 24 - mantissaBits < 0 ? currentMantissa >>> mantissaBits - 24 : currentMantissa << 24 - mantissaBits;
        if ((currentMantissa &= 0xFFFFFF) == 0xFFFFFF) {
            currentMantissa = 0;
            n = declaredExponent + currentSkew + 1;
        } else if (currentMantissa == 0xFFFFFE && declaredExponent + currentSkew + 1 == -126) {
            currentMantissa = 0;
            n = declaredExponent + currentSkew + 1;
        } else {
            currentMantissa = currentMantissa + 1 >>> 1;
            n = exponent = declaredExponent + currentSkew;
        }
        if (!mantissaStart) {
            return negative ? Float.valueOf(-0.0f) : Float.valueOf(0.0f);
        }
        if (exponent < -126 || exponent > 127) {
            return null;
        }
        int biasedExp = exponent + 127;
        FloatCompanionObject floatCompanionObject = FloatCompanionObject.INSTANCE;
        int n4 = (negative ? Integer.MIN_VALUE : 0) | currentMantissa | biasedExp << 23;
        boolean bl5 = false;
        return Float.valueOf(Float.intBitsToFloat(n4));
    }
}

