/*
 * Decompiled with CFR 0.152.
 */
package com.android.aaptcompiler;

import com.android.aaptcompiler.BasicString;
import com.android.aaptcompiler.Item;
import com.android.aaptcompiler.Plural;
import com.android.aaptcompiler.Pseudolocalizer;
import com.android.aaptcompiler.Span;
import com.android.aaptcompiler.StringPool;
import com.android.aaptcompiler.StyleString;
import com.android.aaptcompiler.StyledString;
import com.android.aaptcompiler.UnifiedSpan;
import com.android.aaptcompiler.UntranslatableSection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0016\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u001a \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0000\u001a \u0010\f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0000\u001a \u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0000\u00a8\u0006\u000f"}, d2={"mergeSpans", "", "Lcom/android/aaptcompiler/UnifiedSpan;", "string", "Lcom/android/aaptcompiler/StyledString;", "pseudolocalizeBasicString", "Lcom/android/aaptcompiler/BasicString;", "original", "method", "Lcom/android/aaptcompiler/Pseudolocalizer$Method;", "pool", "Lcom/android/aaptcompiler/StringPool;", "pseudolocalizePlural", "Lcom/android/aaptcompiler/Plural;", "pseudolocalizeStyledString", "aaptcompiler"})
public final class PseudolocaleGeneratorKt {
    @NotNull
    public static final List<UnifiedSpan> mergeSpans(@NotNull StyledString string) {
        Object it;
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        List unifiedSpans = new ArrayList();
        Iterable $this$forEach$iv = string.spans();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (StringPool.Span)element$iv;
            boolean bl = false;
            unifiedSpans.add(new UnifiedSpan((StringPool.Span)it));
        }
        $this$forEach$iv = string.getUntranslatableSections();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (UntranslatableSection)element$iv;
            boolean bl = false;
            unifiedSpans.add(new UnifiedSpan((UntranslatableSection)it));
        }
        CollectionsKt.sort((List)unifiedSpans);
        return unifiedSpans;
    }

    @NotNull
    public static final StyledString pseudolocalizeStyledString(@NotNull StyledString original, @NotNull Pseudolocalizer.Method method, @NotNull StringPool pool) {
        Intrinsics.checkNotNullParameter((Object)original, (String)"original");
        Intrinsics.checkNotNullParameter((Object)((Object)method), (String)"method");
        Intrinsics.checkNotNullParameter((Object)pool, (String)"pool");
        Pseudolocalizer localizer = new Pseudolocalizer(method);
        List<UnifiedSpan> mergedSpans = PseudolocaleGeneratorKt.mergeSpans(original);
        StringBuilder newText = new StringBuilder(localizer.start());
        List spanStack = new ArrayList();
        String originalText = original.getRef().value();
        int cursor = 0;
        boolean inTranslatable = true;
        int currentSpanId = 0;
        while (currentSpanId < mergedSpans.size() || !((Collection)spanStack).isEmpty()) {
            String substr;
            UnifiedSpan parentSpan;
            UnifiedSpan currentSpan = (UnifiedSpan)CollectionsKt.getOrNull(mergedSpans, (int)currentSpanId);
            UnifiedSpan unifiedSpan = parentSpan = spanStack.isEmpty() ? null : mergedSpans.get(((Number)CollectionsKt.last((List)spanStack)).intValue());
            if (currentSpan != null && (parentSpan == null || parentSpan.getLastChar() >= currentSpan.getLastChar())) {
                Intrinsics.checkNotNullExpressionValue((Object)originalText.substring(cursor, currentSpan.getFirstChar()), (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                cursor = currentSpan.getFirstChar();
                String newSubstr = inTranslatable ? localizer.text(substr) : substr;
                newText.append(newSubstr);
                currentSpan.setFirstChar(newText.length());
                if (currentSpan.isUntranslatable()) {
                    inTranslatable = false;
                }
                spanStack.add(currentSpanId);
                ++currentSpanId;
                continue;
            }
            if (parentSpan == null) continue;
            Intrinsics.checkNotNullExpressionValue((Object)originalText.substring(cursor, parentSpan.getLastChar() + 1), (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            cursor = parentSpan.getLastChar() + 1;
            String newSubstring = inTranslatable ? localizer.text(substr) : substr;
            newText.append(newSubstring);
            parentSpan.setLastChar(newText.length() - 1);
            if (parentSpan.isUntranslatable()) {
                inTranslatable = true;
            }
            spanStack.remove(CollectionsKt.getLastIndex((List)spanStack));
        }
        String string = originalText.substring(cursor);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
        newText.append(localizer.text(string));
        newText.append(localizer.end());
        List spans = new ArrayList();
        Iterable $this$forEach$iv = mergedSpans;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            UnifiedSpan it = (UnifiedSpan)element$iv;
            boolean bl = false;
            if (!it.isSpan()) continue;
            Span span = it.toSpan();
            Intrinsics.checkNotNull((Object)span);
            spans.add(span);
        }
        String string2 = newText.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"newText.toString()");
        StyleString styleString = new StyleString(string2, spans);
        return new StyledString(StringPool.makeRef$default(pool, styleString, null, 2, null), CollectionsKt.emptyList());
    }

    @NotNull
    public static final BasicString pseudolocalizeBasicString(@NotNull BasicString original, @NotNull Pseudolocalizer.Method method, @NotNull StringPool pool) {
        Intrinsics.checkNotNullParameter((Object)original, (String)"original");
        Intrinsics.checkNotNullParameter((Object)((Object)method), (String)"method");
        Intrinsics.checkNotNullParameter((Object)pool, (String)"pool");
        try {
            Pseudolocalizer localizer = new Pseudolocalizer(method);
            String originalText = original.getRef().value();
            StringBuilder newText = new StringBuilder(localizer.start());
            int start = 0;
            for (UntranslatableSection section : original.getUntranslatables()) {
                if (section.getStartIndex() != start) {
                    String string = originalText.substring(start, section.getStartIndex());
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                    newText.append(localizer.text(string));
                }
                String string = originalText.substring(section.getStartIndex(), section.getEndIndex());
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                newText.append(string);
                start = section.getEndIndex();
            }
            if (start != originalText.length()) {
                String string = originalText.substring(start);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
                newText.append(localizer.text(string));
            }
            newText.append(localizer.end());
            String string = newText.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"newText.toString()");
            return new BasicString(StringPool.makeRef$default(pool, string, null, 2, null), null, 2, null);
        }
        catch (Exception e) {
            throw new IllegalStateException(("Failed to pseudo-localize string: " + original).toString());
        }
    }

    @NotNull
    public static final Plural pseudolocalizePlural(@NotNull Plural original, @NotNull Pseudolocalizer.Method method, @NotNull StringPool pool) {
        Intrinsics.checkNotNullParameter((Object)original, (String)"original");
        Intrinsics.checkNotNullParameter((Object)((Object)method), (String)"method");
        Intrinsics.checkNotNullParameter((Object)pool, (String)"pool");
        Plural localizedPlural = new Plural();
        int n = original.getValues().length;
        for (int i = 0; i < n; ++i) {
            Item value = original.getValues()[i];
            if (value == null) continue;
            Item item = value;
            localizedPlural.getValues()[i] = item instanceof BasicString ? (Item)PseudolocaleGeneratorKt.pseudolocalizeBasicString((BasicString)value, method, pool) : (item instanceof StyledString ? (Item)PseudolocaleGeneratorKt.pseudolocalizeStyledString((StyledString)value, method, pool) : value.clone(pool));
        }
        return localizedPlural;
    }
}

