/*
 * Decompiled with CFR 0.152.
 */
package com.android.aaptcompiler;

import com.android.aaptcompiler.android.ResTableConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u000f\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\f\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00050\u00172\u0006\u0010\u0018\u001a\u00020\u0015J\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cJ\u000e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0004\u001a\u00020\u0005J\u0010\u0010\u001f\u001a\u00020\u001e2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u0018\u0010 \u001a\u00020\u001e2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010!\u001a\u00020\"H\u0002R$\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0005@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR$\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0005@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\b\"\u0004\b\r\u0010\nR$\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0005@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\b\"\u0004\b\u0010\u0010\nR\u001a\u0010\u0011\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\b\"\u0004\b\u0013\u0010\n\u00a8\u0006#"}, d2={"Lcom/android/aaptcompiler/LocaleValue;", "", "<init>", "()V", "word", "", "language", "getLanguage", "()Ljava/lang/String;", "setLanguage", "(Ljava/lang/String;)V", "region", "getRegion", "setRegion", "script", "getScript", "setScript", "variant", "getVariant", "setVariant", "initFromParts", "", "parts", "", "index", "writeTo", "", "config", "Lcom/android/aaptcompiler/android/ResTableConfig;", "initFromBcp47Tag", "", "isAlpha", "initFromBcp47TagImpl", "separator", "", "aaptcompiler"})
@SourceDebugExtension(value={"SMAP\nLocaleValue.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LocaleValue.kt\ncom/android/aaptcompiler/LocaleValue\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,147:1\n1#2:148\n1069#3,2:149\n1563#4:151\n1634#4,3:152\n*S KotlinDebug\n*F\n+ 1 LocaleValue.kt\ncom/android/aaptcompiler/LocaleValue\n*L\n95#1:149,2\n98#1:151\n98#1:152,3\n*E\n"})
public final class LocaleValue {
    @NotNull
    private String language = "";
    @NotNull
    private String region = "";
    @NotNull
    private String script = "";
    @NotNull
    private String variant = "";

    @NotNull
    public final String getLanguage() {
        return this.language;
    }

    public final void setLanguage(@NotNull String word) {
        Intrinsics.checkNotNullParameter((Object)word, (String)"word");
        String string = word.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        this.language = string;
    }

    @NotNull
    public final String getRegion() {
        return this.region;
    }

    public final void setRegion(@NotNull String word) {
        Intrinsics.checkNotNullParameter((Object)word, (String)"word");
        String string = word.toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
        this.region = string;
    }

    @NotNull
    public final String getScript() {
        return this.script;
    }

    /*
     * WARNING - void declaration
     */
    public final void setScript(@NotNull String word) {
        String string;
        Intrinsics.checkNotNullParameter((Object)word, (String)"word");
        LocaleValue localeValue = this;
        String string2 = word;
        if (((CharSequence)string2).length() > 0) {
            void it;
            char c = string2.charAt(0);
            StringBuilder stringBuilder = new StringBuilder();
            LocaleValue localeValue2 = localeValue;
            boolean bl = false;
            CharSequence charSequence = CharsKt.titlecase((char)it);
            localeValue = localeValue2;
            StringBuilder stringBuilder2 = stringBuilder.append((Object)charSequence);
            String string3 = string2;
            int n = 1;
            String string4 = string3.substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
            string = stringBuilder2.append(string4).toString();
        } else {
            string = string2;
        }
        localeValue.script = string;
    }

    @NotNull
    public final String getVariant() {
        return this.variant;
    }

    public final void setVariant(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.variant = string;
    }

    public final int initFromParts(@NotNull List<String> parts, int index) {
        Intrinsics.checkNotNullParameter(parts, (String)"parts");
        String part = parts.get(index);
        if (StringsKt.startsWith$default((String)part, (String)"b+", (boolean)false, (int)2, null)) {
            String string = part.substring(2);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            this.initFromBcp47TagImpl(string, '+');
            return 1;
        }
        if ((part.length() == 2 || part.length() == 3) && this.isAlpha(part) && !Intrinsics.areEqual((Object)part, (Object)"car")) {
            String maybeRegion;
            this.setLanguage(part);
            if (index + 1 < parts.size() && StringsKt.startsWith$default((CharSequence)(maybeRegion = parts.get(index + 1)), (char)'r', (boolean)false, (int)2, null) && maybeRegion.length() == 3) {
                String string = maybeRegion.substring(1);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                this.setRegion(string);
                return 2;
            }
            return 1;
        }
        return 0;
    }

    public final void writeTo(@NotNull ResTableConfig config) {
        String string;
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        if (((CharSequence)this.language).length() > 0) {
            config.packLanguage(this.language);
        }
        if (((CharSequence)this.region).length() > 0) {
            config.packRegion(this.region);
        }
        if (((CharSequence)this.script).length() > 0) {
            if (this.script.length() > config.getLocaleScript().length) {
                throw new IllegalStateException("Locale script '" + this.script + "' exceeds " + config.getLocaleScript().length + " characters.");
            }
            string = this.script;
            byte[] byArray = string.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            ArraysKt.copyInto((byte[])byArray, (byte[])config.getLocaleScript(), (int)0, (int)0, (int)this.script.length());
        }
        if (((CharSequence)this.variant).length() > 0) {
            if (this.variant.length() > config.getLocaleVariant().length) {
                throw new IllegalStateException("Locale variant '" + this.variant + "' exceeds " + config.getLocaleVariant().length + " characters.");
            }
            string = this.variant;
            byte[] byArray = string.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            ArraysKt.copyInto((byte[])byArray, (byte[])config.getLocaleVariant(), (int)0, (int)0, (int)this.variant.length());
        }
    }

    public final boolean initFromBcp47Tag(@NotNull String word) {
        Intrinsics.checkNotNullParameter((Object)word, (String)"word");
        return this.initFromBcp47TagImpl(word, '-');
    }

    private final boolean isAlpha(String word) {
        boolean bl;
        block1: {
            CharSequence $this$all$iv = word;
            boolean $i$f$all = false;
            for (int i = 0; i < $this$all$iv.length(); ++i) {
                char element$iv;
                char it = element$iv = $this$all$iv.charAt(i);
                boolean bl2 = false;
                if (Character.isLetter(it)) continue;
                bl = false;
                break block1;
            }
            bl = true;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean initFromBcp47TagImpl(String word, char separator) {
        void $this$mapTo$iv$iv;
        char[] cArray = new char[]{separator};
        Iterable $this$map$iv = StringsKt.split$default((CharSequence)word, (char[])cArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string2 = it.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
            collection.add(string2);
        }
        List subTags = (List)destination$iv$iv;
        switch (subTags.size()) {
            case 1: {
                this.setLanguage((String)subTags.get(0));
                break;
            }
            case 2: {
                this.setLanguage((String)subTags.get(0));
                int n = ((String)subTags.get(1)).length();
                if (n == 2 || n == 3) {
                    this.setRegion((String)subTags.get(1));
                    break;
                }
                if (n == 4) {
                    if (Character.isDigit(((String)subTags.get(1)).charAt(0))) {
                        this.variant = (String)subTags.get(1);
                        break;
                    }
                    this.setScript((String)subTags.get(1));
                    break;
                }
                boolean bl = 5 <= n ? n < 9 : false;
                if (bl) {
                    this.variant = (String)subTags.get(1);
                    break;
                }
                return false;
            }
            case 3: {
                this.setLanguage((String)subTags.get(0));
                switch (((String)subTags.get(1)).length()) {
                    case 2: 
                    case 3: {
                        this.setRegion((String)subTags.get(1));
                        break;
                    }
                    case 4: {
                        this.setScript((String)subTags.get(1));
                        break;
                    }
                    default: {
                        return false;
                    }
                }
                if (((String)subTags.get(2)).length() >= 4) {
                    this.variant = (String)subTags.get(2);
                    break;
                }
                this.setRegion((String)subTags.get(2));
                break;
            }
            case 4: {
                this.setLanguage((String)subTags.get(0));
                this.setScript((String)subTags.get(1));
                this.setRegion((String)subTags.get(2));
                this.variant = (String)subTags.get(3);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }
}

