/*
 * Decompiled with CFR 0.152.
 */
package com.android.aaptcompiler;

import com.android.aaptcompiler.ExtractedPackage;
import com.android.aaptcompiler.Reference;
import com.android.aaptcompiler.ResourceName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000:\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\f\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u000f\u001a\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0011\u001a\u00020\u0001\u001a\u0016\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017\u001a\u0018\u0010\u0018\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\r\u001a\u00020\u0001\u001a\u0018\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u001bH\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u001c\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001c"}, d2={"AAPT_ATTR_URI", "", "EMPTY_PACKAGE", "Lcom/android/aaptcompiler/ExtractedPackage;", "SCHEMA_AUTO", "SCHEMA_PRIVATE_PREFIX", "SCHEMA_PUBLIC_PREFIX", "xmlInputFactory", "Ljavax/xml/stream/XMLInputFactory;", "kotlin.jvm.PlatformType", "getXmlInputFactory", "()Ljavax/xml/stream/XMLInputFactory;", "constructPackageUri", "alias", "isPrivate", "", "extractPackageFromUri", "namespaceUri", "resolvePackage", "", "element", "Ljavax/xml/stream/events/StartElement;", "ref", "Lcom/android/aaptcompiler/Reference;", "transformPackageAlias", "walkToEndOfElement", "eventReader", "Ljavax/xml/stream/XMLEventReader;", "aaptcompiler"})
public final class XmlUtilKt {
    private static final XMLInputFactory xmlInputFactory = XMLInputFactory.newDefaultFactory();
    @NotNull
    public static final String SCHEMA_PUBLIC_PREFIX = "http://schemas.android.com/apk/res/";
    @NotNull
    public static final String SCHEMA_PRIVATE_PREFIX = "http://schemas.android.com/apk/prv/res/";
    @NotNull
    public static final String SCHEMA_AUTO = "http://schemas.android.com/apk/res-auto";
    @NotNull
    public static final String AAPT_ATTR_URI = "http://schemas.android.com/aapt";
    @NotNull
    private static final ExtractedPackage EMPTY_PACKAGE = new ExtractedPackage("", false);

    public static final XMLInputFactory getXmlInputFactory() {
        return xmlInputFactory;
    }

    @Nullable
    public static final ExtractedPackage extractPackageFromUri(@NotNull String namespaceUri) {
        ExtractedPackage extractedPackage;
        Intrinsics.checkNotNullParameter((Object)namespaceUri, (String)"namespaceUri");
        if (StringsKt.startsWith$default((String)namespaceUri, (String)SCHEMA_PUBLIC_PREFIX, (boolean)false, (int)2, null)) {
            String string = namespaceUri.substring(35);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String packageName = string;
            if (((CharSequence)packageName).length() == 0) {
                return null;
            }
            extractedPackage = new ExtractedPackage(packageName, false);
        } else if (StringsKt.startsWith$default((String)namespaceUri, (String)SCHEMA_PRIVATE_PREFIX, (boolean)false, (int)2, null)) {
            String string = namespaceUri.substring(39);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String packageName = string;
            if (((CharSequence)packageName).length() == 0) {
                return null;
            }
            extractedPackage = new ExtractedPackage(packageName, true);
        } else {
            extractedPackage = Intrinsics.areEqual((Object)namespaceUri, (Object)SCHEMA_AUTO) ? new ExtractedPackage("", true) : null;
        }
        return extractedPackage;
    }

    @NotNull
    public static final String constructPackageUri(@NotNull String alias, boolean isPrivate) {
        Intrinsics.checkNotNullParameter((Object)alias, (String)"alias");
        return isPrivate ? SCHEMA_PRIVATE_PREFIX + alias : SCHEMA_PUBLIC_PREFIX + alias;
    }

    @Nullable
    public static final ExtractedPackage transformPackageAlias(@NotNull StartElement element, @NotNull String alias) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)alias, (String)"alias");
        if (((CharSequence)alias).length() == 0) {
            return EMPTY_PACKAGE;
        }
        String string = element.getNamespaceURI(alias);
        if (string == null) {
            return null;
        }
        String uri = string;
        return XmlUtilKt.extractPackageFromUri(uri);
    }

    public static final void resolvePackage(@NotNull StartElement element, @NotNull Reference ref) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)ref, (String)"ref");
        if (!Intrinsics.areEqual((Object)ref.getName(), (Object)ResourceName.Companion.getEMPTY())) {
            String string = ref.getName().getPck();
            Intrinsics.checkNotNull((Object)string);
            ExtractedPackage extractedPackage = XmlUtilKt.transformPackageAlias(element, string);
            if (extractedPackage == null) {
                return;
            }
            ExtractedPackage transformedPackage = extractedPackage;
            ref.setName(ResourceName.copy$default(ref.getName(), transformedPackage.getPackageName(), null, null, 6, null));
            ref.setPrivate(ref.isPrivate() || transformedPackage.isPrivate());
        }
    }

    public static final void walkToEndOfElement(@NotNull StartElement element, @NotNull XMLEventReader eventReader) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)eventReader, (String)"eventReader");
        int depth = 1;
        while (eventReader.hasNext()) {
            XMLEvent event = eventReader.nextEvent();
            if (event.isStartElement()) {
                ++depth;
                continue;
            }
            if (!event.isEndElement() || --depth != 0) continue;
            boolean bl = Intrinsics.areEqual((Object)event.asEndElement().getName().getLocalPart(), (Object)element.getName().getLocalPart());
            if (!_Assertions.ENABLED || bl) break;
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
    }
}

