/*
 * Decompiled with CFR 0.152.
 */
package com.android.apksig;

import com.android.apksig.SignerEngine;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.AlgorithmParameterSpec;

public class JcaSignerEngine
implements SignerEngine {
    private final PrivateKey mPrivateKey;
    private final String mSignatureAlgorithm;
    private final AlgorithmParameterSpec mAlgorithmParameterSpec;

    public JcaSignerEngine(PrivateKey privateKey, String signatureAlgorithm, AlgorithmParameterSpec algorithmParameterSpec) {
        if (privateKey == null) {
            throw new IllegalArgumentException("privateKey cannot be null");
        }
        if (signatureAlgorithm == null) {
            throw new IllegalArgumentException("signatureAlgorithm cannot be null");
        }
        this.mPrivateKey = privateKey;
        this.mSignatureAlgorithm = signatureAlgorithm;
        this.mAlgorithmParameterSpec = algorithmParameterSpec;
    }

    @Override
    public byte[] sign(byte[] data) throws InvalidKeyException, NoSuchAlgorithmException, InvalidAlgorithmParameterException, SignatureException {
        Signature signature = Signature.getInstance(this.mSignatureAlgorithm);
        signature.initSign(this.mPrivateKey);
        if (this.mAlgorithmParameterSpec != null) {
            signature.setParameter(this.mAlgorithmParameterSpec);
        }
        signature.update(data);
        return signature.sign();
    }
}

