/*
 * Decompiled with CFR 0.152.
 */
package com.android.apksig.internal.apk.stamp;

import com.android.apksig.apk.ApkFormatException;
import com.android.apksig.internal.apk.ApkSigResult;
import com.android.apksig.internal.apk.ApkSignerInfo;
import com.android.apksig.internal.apk.ApkSigningBlockUtilsLite;
import com.android.apksig.internal.apk.ContentDigestAlgorithm;
import com.android.apksig.internal.apk.SignatureInfo;
import com.android.apksig.internal.apk.SignatureNotFoundException;
import com.android.apksig.internal.apk.stamp.SourceStampVerifier;
import com.android.apksig.internal.util.Pair;
import com.android.apksig.util.DataSource;
import com.android.apksig.zip.ZipSections;
import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class V2SourceStampVerifier {
    private V2SourceStampVerifier() {
    }

    public static ApkSigResult verify(DataSource apk, ZipSections zipSections, byte[] sourceStampCertificateDigest, Map<Integer, Map<ContentDigestAlgorithm, byte[]>> signatureSchemeApkContentDigests, int minSdkVersion, int maxSdkVersion) throws IOException, NoSuchAlgorithmException, SignatureNotFoundException {
        ApkSigResult result = new ApkSigResult(0);
        SignatureInfo signatureInfo = ApkSigningBlockUtilsLite.findSignature(apk, zipSections, 1845461005);
        V2SourceStampVerifier.verify(signatureInfo.signatureBlock, sourceStampCertificateDigest, signatureSchemeApkContentDigests, minSdkVersion, maxSdkVersion, result);
        return result;
    }

    private static void verify(ByteBuffer sourceStampBlock, byte[] sourceStampCertificateDigest, Map<Integer, Map<ContentDigestAlgorithm, byte[]>> signatureSchemeApkContentDigests, int minSdkVersion, int maxSdkVersion, ApkSigResult result) throws NoSuchAlgorithmException {
        ApkSignerInfo signerInfo = new ApkSignerInfo();
        result.mSigners.add(signerInfo);
        try {
            CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
            ByteBuffer sourceStampBlockData = ApkSigningBlockUtilsLite.getLengthPrefixedSlice(sourceStampBlock);
            SourceStampVerifier.verifyV2SourceStamp(sourceStampBlockData, certFactory, signerInfo, V2SourceStampVerifier.getSignatureSchemeDigests(signatureSchemeApkContentDigests), sourceStampCertificateDigest, minSdkVersion, maxSdkVersion);
            result.verified = !result.containsErrors() && !result.containsWarnings();
        }
        catch (CertificateException e) {
            throw new IllegalStateException("Failed to obtain X.509 CertificateFactory", e);
        }
        catch (ApkFormatException | BufferUnderflowException e) {
            signerInfo.addWarning(20, new Object[0]);
        }
    }

    private static Map<Integer, byte[]> getSignatureSchemeDigests(Map<Integer, Map<ContentDigestAlgorithm, byte[]>> signatureSchemeApkContentDigests) {
        HashMap<Integer, byte[]> digests = new HashMap<Integer, byte[]>();
        for (Map.Entry<Integer, Map<ContentDigestAlgorithm, byte[]>> signatureSchemeApkContentDigest : signatureSchemeApkContentDigests.entrySet()) {
            List<Pair<Integer, byte[]>> apkDigests = V2SourceStampVerifier.getApkDigests(signatureSchemeApkContentDigest.getValue());
            digests.put(signatureSchemeApkContentDigest.getKey(), ApkSigningBlockUtilsLite.encodeAsSequenceOfLengthPrefixedPairsOfIntAndLengthPrefixedBytes(apkDigests));
        }
        return digests;
    }

    private static List<Pair<Integer, byte[]>> getApkDigests(Map<ContentDigestAlgorithm, byte[]> apkContentDigests) {
        ArrayList<Pair<Integer, byte[]>> digests = new ArrayList<Pair<Integer, byte[]>>();
        for (Map.Entry<ContentDigestAlgorithm, byte[]> apkContentDigest : apkContentDigests.entrySet()) {
            digests.add(Pair.of(apkContentDigest.getKey().getId(), apkContentDigest.getValue()));
        }
        Collections.sort(digests, new Comparator<Pair<Integer, byte[]>>(){

            @Override
            public int compare(Pair<Integer, byte[]> pair1, Pair<Integer, byte[]> pair2) {
                return pair1.getFirst() - pair2.getFirst();
            }
        });
        return digests;
    }
}

