/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.apkzlib.zip.compress;

import com.android.tools.build.apkzlib.zip.CompressionMethod;
import com.android.tools.build.apkzlib.zip.CompressionResult;
import com.android.tools.build.apkzlib.zip.compress.ExecutorCompressor;
import com.android.tools.build.apkzlib.zip.utils.ByteTracker;
import com.android.tools.build.apkzlib.zip.utils.CloseableByteSource;
import com.android.tools.build.apkzlib.zip.utils.CloseableDelegateByteSource;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.concurrent.Executor;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import javax.annotation.Nonnull;

public class DeflateExecutionCompressor
extends ExecutorCompressor {
    private final int level;
    @Nonnull
    private final ByteTracker tracker;

    public DeflateExecutionCompressor(@Nonnull Executor executor, @Nonnull ByteTracker tracker, int level) {
        super(executor);
        this.level = level;
        this.tracker = tracker;
    }

    @Override
    @Nonnull
    protected CompressionResult immediateCompress(@Nonnull CloseableByteSource source) throws Exception {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        Deflater deflater = new Deflater(this.level, true);
        try (DeflaterOutputStream dos = new DeflaterOutputStream((OutputStream)output, deflater);){
            dos.write(source.read());
        }
        CloseableDelegateByteSource result = this.tracker.fromStream(output);
        if (result.size() >= source.size()) {
            return new CompressionResult(source, CompressionMethod.STORE, source.size());
        }
        return new CompressionResult(result, CompressionMethod.DEFLATE, result.size());
    }
}

