/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.apkzlib.zip.compress;

import com.android.tools.build.apkzlib.bytestorage.ByteStorage;
import com.android.tools.build.apkzlib.zip.CompressionMethod;
import com.android.tools.build.apkzlib.zip.CompressionResult;
import com.android.tools.build.apkzlib.zip.compress.ExecutorCompressor;
import com.android.tools.build.apkzlib.zip.utils.ByteTracker;
import com.android.tools.build.apkzlib.zip.utils.CloseableByteSource;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.concurrent.Executor;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;

public class DeflateExecutionCompressor
extends ExecutorCompressor {
    private final int level;

    public DeflateExecutionCompressor(Executor executor, int level) {
        super(executor);
        this.level = level;
    }

    @Deprecated
    public DeflateExecutionCompressor(Executor executor, ByteTracker tracker, int level) {
        this(executor, level);
    }

    @Override
    protected CompressionResult immediateCompress(CloseableByteSource source, ByteStorage storage) throws Exception {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        Deflater deflater = new Deflater(this.level, true);
        try (DeflaterOutputStream dos = new DeflaterOutputStream((OutputStream)output, deflater);){
            dos.write(source.read());
        }
        CloseableByteSource result = storage.fromStream(output);
        if (result.size() >= source.size()) {
            return new CompressionResult(source, CompressionMethod.STORE, source.size());
        }
        return new CompressionResult(result, CompressionMethod.DEFLATE, result.size());
    }
}

