/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.apkzlib.sign;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SigningOptions {
    @Nullable
    private final PrivateKey key;
    @Nonnull
    private final ImmutableList<X509Certificate> certs;
    private final boolean v1SigningEnabled;
    private final boolean v2SigningEnabled;
    private final int minSdkVersion;

    public SigningOptions(@Nullable PrivateKey key, @Nullable X509Certificate cert, boolean v1, boolean v2, int minSdk) {
        this(key, (ImmutableList<X509Certificate>)(cert == null ? ImmutableList.of() : ImmutableList.of((Object)cert)), v1, v2, minSdk);
    }

    public SigningOptions(@Nullable PrivateKey key, @Nonnull ImmutableList<X509Certificate> certs, boolean v1SigningEnabled, boolean v2SigningEnabled, int minSdkVersion) {
        Preconditions.checkArgument((key == null == certs.isEmpty() ? 1 : 0) != 0, (Object)"Certificates list should be empty if and only if the private key is null");
        Preconditions.checkArgument((minSdkVersion >= 0 ? 1 : 0) != 0, (Object)"minSdkVersion < 0");
        this.key = key;
        this.certs = certs;
        this.v1SigningEnabled = v1SigningEnabled;
        this.v2SigningEnabled = v2SigningEnabled;
        this.minSdkVersion = minSdkVersion;
    }

    @Nullable
    public PrivateKey getKey() {
        return this.key;
    }

    @Nonnull
    public ImmutableList<X509Certificate> getCertificates() {
        return this.certs;
    }

    public boolean isV1SigningEnabled() {
        return this.v1SigningEnabled;
    }

    public boolean isV2SigningEnabled() {
        return this.v2SigningEnabled;
    }

    public int getMinSdkVersion() {
        return this.minSdkVersion;
    }
}

