/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.testing;

import com.android.builder.internal.InstallUtils;
import com.android.builder.internal.testing.CustomTestRunListener;
import com.android.builder.internal.testing.ShardedTestCallable;
import com.android.builder.internal.testing.SimpleTestCallable;
import com.android.builder.testing.TestData;
import com.android.builder.testing.TestRunner;
import com.android.builder.testing.api.DeviceConfigProvider;
import com.android.builder.testing.api.DeviceConfigProviderImpl;
import com.android.builder.testing.api.DeviceConnector;
import com.android.builder.testing.api.DeviceException;
import com.android.builder.testing.api.TestException;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.testrunner.TestIdentifier;
import com.android.ide.common.internal.WaitableExecutor;
import com.android.ide.common.process.ProcessException;
import com.android.ide.common.process.ProcessExecutor;
import com.android.utils.ILogger;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;

public class SimpleTestRunner
implements TestRunner {
    private final File mSplitSelectExec;
    private final ProcessExecutor mProcessExecutor;
    private final boolean mEnableSharding;
    private final Integer mNumShards;

    public SimpleTestRunner(File splitSelectExec, ProcessExecutor processExecutor, boolean enableSharding, Integer numShards) {
        this.mSplitSelectExec = splitSelectExec;
        this.mProcessExecutor = processExecutor;
        this.mEnableSharding = enableSharding;
        this.mNumShards = numShards;
    }

    @Override
    public boolean runTests(String projectName, String variantName, File testApk, TestData testData, List<? extends DeviceConnector> deviceList, int maxThreads, int timeoutInMs, Collection<String> installOptions, File resultsDir, File coverageDir, ILogger logger) throws TestException, TestRunner.NoAuthorizedDeviceFoundException, InterruptedException {
        int n;
        TestIdentifier fakeTest;
        CustomTestRunListener fakeRunListener;
        int threadPoolSize = maxThreads;
        if (this.mEnableSharding) {
            threadPoolSize = deviceList.size();
        }
        WaitableExecutor executor = WaitableExecutor.useNewFixedSizeThreadPool((int)threadPoolSize);
        int totalDevices = deviceList.size();
        int unauthorizedDevices = 0;
        HashMap<DeviceConnector, ImmutableList<File>> availableDevices = new HashMap<DeviceConnector, ImmutableList<File>>();
        for (DeviceConnector deviceConnector : deviceList) {
            if (deviceConnector.getState() != IDevice.DeviceState.UNAUTHORIZED) {
                DeviceConfigProviderImpl deviceConfigProvider;
                if (!InstallUtils.checkDeviceApiLevel(deviceConnector, testData.getMinSdkVersion(), logger, projectName, variantName)) continue;
                try {
                    deviceConfigProvider = new DeviceConfigProviderImpl(deviceConnector);
                }
                catch (DeviceException e) {
                    throw new TestException((Throwable)e);
                }
                ImmutableList<File> testedApks = ImmutableList.of();
                if (!testData.isLibrary()) {
                    try {
                        testedApks = testData.getTestedApks(this.mProcessExecutor, this.mSplitSelectExec, (DeviceConfigProvider)deviceConfigProvider, logger);
                    }
                    catch (ProcessException e) {
                        throw new TestException((Throwable)e);
                    }
                    if (testedApks.isEmpty()) {
                        logger.info("Skipping device '%1$s' for '%2$s:%3$s': No matching output file", new Object[]{deviceConnector.getName(), projectName, variantName});
                        continue;
                    }
                }
                availableDevices.put(deviceConnector, testedApks);
                continue;
            }
            ++unauthorizedDevices;
        }
        if (totalDevices == 0 || availableDevices.isEmpty()) {
            fakeRunListener = new CustomTestRunListener("TestRunner", projectName, variantName, logger);
            fakeRunListener.setReportDir(resultsDir);
            Map<String, String> map = Collections.emptyMap();
            fakeTest = new TestIdentifier(variantName, totalDevices == 0 ? ": No devices connected." : ": No compatible devices connected.");
            fakeRunListener.testStarted(fakeTest);
            fakeRunListener.testFailed(fakeTest, String.format("Found %d connected device(s), %d of which were compatible.", totalDevices, availableDevices.size()));
            fakeRunListener.testEnded(fakeTest, map);
            fakeRunListener.testRunEnded(0L, map);
            return false;
        }
        if (unauthorizedDevices > 0) {
            fakeRunListener = new CustomTestRunListener("TestRunner", projectName, variantName, logger);
            fakeRunListener.setReportDir(resultsDir);
            Map<String, String> map = Collections.emptyMap();
            fakeTest = new TestIdentifier(variantName, ": found unauthorized devices.");
            fakeRunListener.testStarted(fakeTest);
            fakeRunListener.testFailed(fakeTest, String.format("Found %d unauthorized device(s).", unauthorizedDevices));
            fakeRunListener.testEnded(fakeTest, map);
            fakeRunListener.testRunEnded(0L, map);
        }
        if (this.mEnableSharding) {
            final int numShards = this.mNumShards == null ? availableDevices.size() : this.mNumShards.intValue();
            final AtomicInteger atomicInteger = new AtomicInteger(-1);
            ShardedTestCallable.ProgressListener progressListener = new ShardedTestCallable.ProgressListener(numShards, logger);
            ShardedTestCallable.ShardProvider shardProvider = new ShardedTestCallable.ShardProvider(){

                @Override
                public Integer getNextShard() {
                    int shard = atomicInteger.incrementAndGet();
                    return shard < numShards ? Integer.valueOf(shard) : null;
                }

                @Override
                public int getTotalShards() {
                    return numShards;
                }
            };
            logger.info("will shard tests into %d shards", new Object[]{numShards});
            for (Map.Entry runners : availableDevices.entrySet()) {
                ShardedTestCallable shardedTestCallable = new ShardedTestCallable((DeviceConnector)runners.getKey(), projectName, variantName, testApk, (List)runners.getValue(), testData, resultsDir, coverageDir, timeoutInMs, logger, shardProvider);
                shardedTestCallable.setProgressListener(progressListener);
                executor.execute((Callable)shardedTestCallable);
            }
        } else {
            for (Map.Entry entry : availableDevices.entrySet()) {
                SimpleTestCallable testCallable = new SimpleTestCallable((DeviceConnector)entry.getKey(), projectName, variantName, testApk, (List)entry.getValue(), testData, resultsDir, coverageDir, timeoutInMs, installOptions, logger);
                executor.execute((Callable)testCallable);
            }
        }
        List results = executor.waitForAllTasks();
        boolean bl = unauthorizedDevices == 0;
        for (WaitableExecutor.TaskResult result : results) {
            if (result.value != null) {
                n &= ((Boolean)result.value).booleanValue();
                continue;
            }
            n = 0;
            logger.error(result.exception, null, new Object[0]);
        }
        return n != 0;
    }
}

