/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.dexing;

import com.android.apkzlib.zip.ZFile;
import com.android.builder.dexing.ClassFileEntry;
import com.android.builder.dexing.ClassFileInput;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;

final class JarClassFileInputs
implements ClassFileInput {
    private final Path rootPath;
    private final Predicate<Path> filter;
    private ZFile jarFile = null;

    public JarClassFileInputs(Path rootPath, Predicate<Path> filter) {
        this.rootPath = rootPath;
        this.filter = filter;
    }

    @Override
    public Path getRootPath() {
        return this.rootPath;
    }

    @Override
    public Iterator<ClassFileEntry> iterator() {
        if (this.jarFile == null) {
            try {
                this.jarFile = new ZFile(this.rootPath.toFile());
            }
            catch (IOException e) {
                throw new JarClassFileInputsException("Unable to read jar file " + this.rootPath.toString(), e);
            }
        }
        return this.jarFile.entries().stream().filter(entry -> this.filter.test(Paths.get(entry.getCentralDirectoryHeader().getName(), new String[0]))).map(entry -> {
            try {
                byte[] content = entry.read();
                return new ClassFileEntry(Paths.get(entry.getCentralDirectoryHeader().getName(), new String[0]), content);
            }
            catch (IOException e) {
                throw new JarClassFileInputsException("Unable to read file " + entry.getCentralDirectoryHeader().getName(), e);
            }
        }).iterator();
    }

    @Override
    public List<ClassFileEntry> allEntries() {
        return Lists.newLinkedList((Iterable)this);
    }

    @Override
    public void close() throws IOException {
        if (this.jarFile != null) {
            this.jarFile.close();
        }
    }

    public static final class JarClassFileInputsException
    extends RuntimeException {
        public JarClassFileInputsException(String s, IOException e) {
            super(s, e);
        }
    }
}

