/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.symbols;

import com.android.builder.symbols.Symbol;
import com.android.builder.symbols.SymbolJavaType;
import com.android.builder.symbols.SymbolTable;
import com.android.resources.ResourceType;
import com.android.utils.FileUtils;
import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.TreeSet;

public final class SymbolIo {
    private SymbolIo() {
    }

    public static SymbolTable read(File file) throws IOException {
        int lineIndex;
        List<String> lines;
        try {
            lines = Files.readAllLines(file.toPath(), Charsets.UTF_8);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        SymbolTable.Builder table = SymbolTable.builder();
        String line = null;
        try {
            int count = lines.size();
            for (lineIndex = 1; lineIndex <= count; ++lineIndex) {
                line = lines.get(lineIndex - 1);
                int pos = line.indexOf(32);
                String typeName = line.substring(0, pos);
                SymbolJavaType type = SymbolJavaType.getEnum(typeName);
                int pos2 = line.indexOf(32, pos + 1);
                String className = line.substring(pos + 1, pos2);
                ResourceType resourceType = ResourceType.getEnum((String)className);
                if (resourceType == null) {
                    throw new IOException("Invalid resource type " + className);
                }
                int pos3 = line.indexOf(32, pos2 + 1);
                String name = line.substring(pos2 + 1, pos3);
                String value = line.substring(pos3 + 1);
                table.add(Symbol.createSymbol(resourceType, name, type, value));
            }
        }
        catch (IOException | IndexOutOfBoundsException e) {
            throw new IOException(String.format("File format error reading %s line %d: '%s'", file.getAbsolutePath(), lineIndex, line), e);
        }
        return table.build();
    }

    public static void write(SymbolTable table, File file) {
        ArrayList<String> lines = new ArrayList<String>();
        for (Symbol s : table.allSymbols()) {
            lines.add(s.getJavaType().getTypeName() + " " + s.getResourceType().getName() + " " + s.getName() + " " + s.getValue());
        }
        try (FileOutputStream fos = new FileOutputStream(file);
             PrintWriter pw = new PrintWriter(fos);){
            lines.forEach(pw::println);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static File exportToJava(SymbolTable table, File directory, boolean finalIds) {
        Preconditions.checkArgument((boolean)directory.isDirectory());
        Splitter splitter = Splitter.on((char)'.');
        Iterable directories = splitter.split((CharSequence)table.getTablePackage());
        File file = directory;
        for (String d : directories) {
            file = new File(file, d);
        }
        FileUtils.mkdirs((File)file);
        file = new File(file, "R.java");
        EnumSet<ResourceType> resourceTypes = EnumSet.noneOf(ResourceType.class);
        table.allSymbols().forEach(s -> resourceTypes.add(s.getResourceType()));
        String idModifiers = finalIds ? "public static final" : "public static";
        try (FileOutputStream fos = new FileOutputStream(file);
             PrintWriter pw = new PrintWriter(fos);){
            pw.println("/* AUTO-GENERATED FILE.  DO NOT MODIFY.");
            pw.println(" *");
            pw.println(" * This class was automatically generated by the");
            pw.println(" * gradle plugin from the resource data it found. It");
            pw.println(" * should not be modified by hand.");
            pw.println(" */");
            if (!table.getTablePackage().isEmpty()) {
                pw.println("package " + table.getTablePackage() + ";");
            }
            pw.println();
            pw.println("public final class R {");
            for (ResourceType rt : resourceTypes) {
                pw.println("    public static final class " + rt + " {");
                TreeSet<Symbol> syms = new TreeSet<Symbol>(Comparator.comparing(Symbol::getName));
                table.allSymbols().forEach(sym -> {
                    if (sym.getResourceType().equals((Object)rt)) {
                        syms.add((Symbol)sym);
                    }
                });
                for (Symbol s2 : syms) {
                    pw.println("        " + idModifiers + " " + s2.getJavaType().getTypeName() + " " + s2.getName() + " = " + s2.getValue() + ";");
                }
                pw.println("    }");
            }
            pw.println("}");
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return file;
    }
}

