/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.utils;

import com.android.utils.SdkUtils;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;

public class PerformanceUtils {
    public static final long NON_DEX_HEAP_SIZE = 0x20000000L;

    public static long getUserDefinedHeapSize() {
        for (String arg : ManagementFactory.getRuntimeMXBean().getInputArguments()) {
            if (!arg.startsWith("-Xmx")) continue;
            Long heapSize = PerformanceUtils.parseSizeToBytes(arg.substring("-Xmx".length()));
            if (heapSize == null) break;
            return heapSize;
        }
        long heapSize = 0L;
        for (MemoryPoolMXBean mpBean : ManagementFactory.getMemoryPoolMXBeans()) {
            if (mpBean.getType() != MemoryType.HEAP) continue;
            heapSize += mpBean.getUsage().getMax();
        }
        return heapSize;
    }

    public static Long parseSizeToBytes(String sizeParameter) {
        long multiplier = 1L;
        if (SdkUtils.endsWithIgnoreCase((String)sizeParameter, (String)"k")) {
            multiplier = 1024L;
        } else if (SdkUtils.endsWithIgnoreCase((String)sizeParameter, (String)"m")) {
            multiplier = 0x100000L;
        } else if (SdkUtils.endsWithIgnoreCase((String)sizeParameter, (String)"g")) {
            multiplier = 0x40000000L;
        }
        if (multiplier != 1L) {
            sizeParameter = sizeParameter.substring(0, sizeParameter.length() - 1);
        }
        try {
            return multiplier * Long.parseLong(sizeParameter);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static int getNumThreadsForDexArchives() {
        int numCores = Runtime.getRuntime().availableProcessors();
        long heapSize = PerformanceUtils.getUserDefinedHeapSize();
        long available = heapSize - 0x20000000L;
        long threadsBasedOnMemory = Math.max(1L, available / 0xC800000L);
        return (int)Math.min((long)numCores, threadsBasedOnMemory);
    }
}

