/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.dexing;

import com.android.builder.dexing.ClassFileInput;
import com.android.builder.dexing.DirClassFileInputs;
import com.android.builder.dexing.JarClassFileInputs;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.util.function.Predicate;

public class ClassFileInputs {
    static final PathMatcher jarMatcher = FileSystems.getDefault().getPathMatcher("glob:**.jar");
    static final PathMatcher classMatcher = FileSystems.getDefault().getPathMatcher("glob:**.class");

    private ClassFileInputs() {
    }

    public static ClassFileInput fromPath(Path rootPath, Predicate<Path> filterPaths) {
        if (jarMatcher.matches(rootPath)) {
            return new JarClassFileInputs(rootPath, filterPaths.and(classMatcher::matches));
        }
        return new DirClassFileInputs(rootPath, filterPaths.and(classMatcher::matches));
    }
}

