/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.dexing;

import com.android.builder.dexing.DexArchiveMerger;
import com.android.dex.Dex;
import com.android.dx.command.dexer.DxContext;
import com.android.dx.merge.CollisionPolicy;
import com.android.dx.merge.DexMerger;
import com.google.common.base.Throwables;
import com.google.common.base.Verify;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.concurrent.Callable;

public class DexArchiveMergerCallable
implements Callable<Void> {
    private final Collection<Dex> dexesToMerge;
    private final Path outputDex;
    private final DxContext dxContext;

    public DexArchiveMergerCallable(Collection<Dex> dexesToMerge, Path outputDex, DxContext dxContext) {
        this.dexesToMerge = dexesToMerge;
        this.outputDex = outputDex;
        this.dxContext = dxContext;
    }

    @Override
    public Void call() throws Exception {
        Dex mergedDex = this.mergeDexes(this.dexesToMerge);
        Files.write(this.outputDex, mergedDex.getBytes(), new OpenOption[0]);
        return null;
    }

    private Dex mergeDexes(Collection<Dex> dexes) throws IOException {
        try {
            DexMerger dexMerger = new DexMerger(dexes.toArray(new Dex[dexes.size()]), CollisionPolicy.FAIL, this.dxContext);
            Dex mergedDex = dexMerger.merge();
            Verify.verifyNotNull((Object)mergedDex, (String)String.format("Merged dex is null. We tried to merge %d DEX files", dexes.size()), (Object[])new Object[0]);
            return mergedDex;
        }
        catch (Exception e) {
            this.dxContext.err.println("UNEXPECTED TOP-LEVEL EXCEPTION:");
            this.dxContext.err.println(Throwables.getRootCause((Throwable)e));
            this.dxContext.err.print(Throwables.getStackTraceAsString((Throwable)e));
            throw new DexArchiveMerger.DexArchiveMergerException("Unable to merge dex", e);
        }
    }
}

