/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.symbols;

import com.android.builder.internal.aapt.AaptPackageConfig;
import com.android.builder.symbols.RGeneration;
import com.android.builder.symbols.SymbolIo;
import com.android.builder.symbols.SymbolTable;
import com.android.ide.common.xml.AndroidManifestParser;
import com.android.ide.common.xml.ManifestData;
import com.android.io.FileWrapper;
import com.android.io.IAbstractFile;
import com.android.io.StreamException;
import com.android.xml.AndroidManifest;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.CharMatcher;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.xml.sax.SAXException;

public class SymbolUtils {
    public static void processLibraryMainSymbolTable(SymbolTable mainSymbolTable, List<AaptPackageConfig.LibraryInfo> libraries, boolean enforceUniquePackageName, String mainPackageName, File manifestFile, File sourceOut, File symbolsOut, File proguardOut) throws IOException {
        Preconditions.checkNotNull((Object)sourceOut, (Object)"Source output directory should not be null");
        Preconditions.checkNotNull((Object)symbolsOut, (Object)"Symbols output directory should not be null");
        if (mainPackageName == null || proguardOut != null) {
            ManifestData manifestData = SymbolUtils.parseManifest(manifestFile);
            if (mainPackageName == null) {
                mainPackageName = SymbolUtils.getPackageNameFromManifest(manifestData);
            }
            if (proguardOut != null) {
                Files.write(proguardOut.toPath(), SymbolUtils.generateMinifyKeepRules(manifestData), new OpenOption[0]);
            }
        }
        boolean finalIds = false;
        mainSymbolTable = mainSymbolTable.rename(mainPackageName);
        SymbolUtils.generateRTxt(mainSymbolTable, symbolsOut);
        SymbolIo.exportToJava(mainSymbolTable, sourceOut, finalIds);
        Set<SymbolTable> depSymbolTables = SymbolUtils.loadDependenciesSymbolTables(libraries, enforceUniquePackageName, mainPackageName);
        RGeneration.generateRForLibraries(mainSymbolTable, depSymbolTables, sourceOut, finalIds);
    }

    public static Set<SymbolTable> loadDependenciesSymbolTables(List<AaptPackageConfig.LibraryInfo> libraries, boolean enforceUniquePackageName, String mainPackageName) throws IOException {
        HashSet<SymbolTable> depSymbolTables = new HashSet<SymbolTable>();
        for (AaptPackageConfig.LibraryInfo dependency : libraries) {
            String depPackageName;
            File depMan = dependency.getManifest();
            try {
                depPackageName = AndroidManifest.getPackage((IAbstractFile)new FileWrapper(depMan));
            }
            catch (StreamException e) {
                throw new RuntimeException("Failed to read manifest " + depMan.getAbsolutePath(), e);
            }
            if (mainPackageName.equals(depPackageName) && enforceUniquePackageName) {
                throw new RuntimeException(String.format("Error: A library uses the same package as this project: %s", depPackageName));
            }
            File rFile = dependency.getSymbolFile();
            SymbolTable depSymbols = rFile != null && rFile.exists() ? SymbolIo.read(rFile) : SymbolTable.builder().build();
            depSymbols = depSymbols.rename(depPackageName);
            depSymbolTables.add(depSymbols);
        }
        return depSymbolTables;
    }

    public static String getPackageNameFromManifest(File manifestFile) throws IOException {
        ManifestData manifestData;
        AndroidManifestParser parser = new AndroidManifestParser();
        try {
            manifestData = AndroidManifestParser.parse((IAbstractFile)new FileWrapper(manifestFile));
        }
        catch (IOException | SAXException e) {
            throw new IOException("Failed to parse android manifest XML file at path: '" + manifestFile.getAbsolutePath(), e);
        }
        return SymbolUtils.getPackageNameFromManifest(manifestData);
    }

    public static String getPackageNameFromManifest(ManifestData manifest) {
        return manifest.getPackage();
    }

    public static List<String> generateMinifyKeepRules(ManifestData manifest) {
        return SymbolUtils.generateKeepRules(manifest, false);
    }

    public static List<String> generateMainDexKeepRules(ManifestData manifest) {
        return SymbolUtils.generateKeepRules(manifest, true);
    }

    @VisibleForTesting
    static List<String> generateKeepRules(ManifestData manifest, boolean isMainDex) {
        ImmutableList.Builder rules = ImmutableList.builder();
        rules.add((Object)"# Generated by the gradle plugin");
        for (ManifestData.KeepClass keepClass : manifest.getKeepClasses()) {
            if (isMainDex) {
                String type = keepClass.getType();
                String process = keepClass.getProcess();
                if (!(type != "activity" && type != "service" && type != "provider" && type != "receiver" || process != null && !process.isEmpty() && !process.startsWith(":"))) continue;
            }
            rules.add((Object)String.format("-keep class %s { <init>(...); }", keepClass.getName()));
        }
        return rules.build();
    }

    public static void generateRTxt(SymbolTable table, File directory) {
        File file = new File(directory, "R.txt");
        SymbolIo.write(table, file);
    }

    public static ManifestData parseManifest(File manifestFile) throws IOException {
        AndroidManifestParser parser = new AndroidManifestParser();
        try {
            return AndroidManifestParser.parse((IAbstractFile)new FileWrapper(manifestFile));
        }
        catch (IOException | SAXException e) {
            throw new IOException("Failed to parse android manifest XML file at path: '" + manifestFile.getAbsolutePath(), e);
        }
    }

    public static String canonicalizeValueResourceName(String name) {
        return CharMatcher.anyOf((CharSequence)".:").replaceFrom((CharSequence)name, (CharSequence)"_");
    }
}

