/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.dexing;

import com.android.builder.dexing.ClassFileEntry;
import com.android.builder.dexing.ClassFileInput;
import com.android.builder.dexing.ClassFileInputs;
import com.android.builder.dexing.DexArchive;
import com.android.builder.dexing.DexArchiveBuilderCallable;
import com.android.builder.dexing.DexArchiveBuilderConfig;
import com.android.builder.dexing.DexArchiveEntry;
import com.android.ide.common.internal.WaitableExecutor;
import com.google.common.base.MoreObjects;
import com.google.common.base.Throwables;
import com.google.common.base.Verify;
import com.google.common.collect.Maps;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;

public class DexArchiveBuilder {
    private final DexArchiveBuilderConfig config;
    private final WaitableExecutor executor;

    public DexArchiveBuilder(DexArchiveBuilderConfig config) {
        this.config = config;
        this.executor = WaitableExecutor.useGlobalSharedThreadPool();
    }

    public void convert(ClassFileInput input, DexArchive output) throws IOException {
        this.ensureOutputArchiveExists(output);
        HashMap bucketizedJobs = Maps.newHashMap();
        int i = 0;
        for (ClassFileEntry classFileEntry : input.allEntries()) {
            int bucketId = i++ % this.executor.getParallelism();
            Map jobs = bucketizedJobs.getOrDefault(bucketId, Maps.newHashMap());
            jobs.put(classFileEntry.relativePath, classFileEntry.classFileContent);
            bucketizedJobs.put(bucketId, jobs);
        }
        for (Map job : bucketizedJobs.values()) {
            this.processClassFile(job);
        }
        try {
            this.processOutputs(output);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            this.config.getDxContext().err.println("UNEXPECTED TOP-LEVEL EXCEPTION:");
            this.config.getDxContext().err.println(Throwables.getRootCause((Throwable)e).getMessage());
            this.config.getDxContext().err.print(Throwables.getStackTraceAsString((Throwable)e));
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            throw new DexBuilderException("Unable to convert input to dex archive.", (Throwable)MoreObjects.firstNonNull((Object)e.getCause(), (Object)e));
        }
    }

    private void processOutputs(DexArchive output) throws IOException, InterruptedException {
        List entries = this.executor.waitForTasksWithQuickFail(true);
        for (List chunk : entries) {
            for (DexArchiveEntry dexEntry : chunk) {
                Verify.verifyNotNull((Object)dexEntry);
                ByteArrayInputStream dexContent = new ByteArrayInputStream(dexEntry.getDexFileContent());
                Throwable throwable = null;
                try {
                    Path dexFilePath = ClassFileEntry.withDexExtension(dexEntry.getRelativePathInArchive());
                    output.addFile(dexFilePath, dexContent);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (dexContent == null) continue;
                    if (throwable != null) {
                        try {
                            dexContent.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    dexContent.close();
                }
            }
        }
    }

    private void processClassFile(Map<Path, byte[]> pathToContent) throws IOException {
        DexArchiveBuilderCallable converterCallable = new DexArchiveBuilderCallable(pathToContent, this.config.getDxContext(), this.config.getDexOptions(), this.config.getCfOptions());
        this.executor.execute((Callable)converterCallable);
    }

    private void ensureOutputArchiveExists(DexArchive dexArchive) throws IOException {
        if (Files.notExists(dexArchive.getRootPath(), new LinkOption[0])) {
            if (ClassFileInputs.jarMatcher.matches(dexArchive.getRootPath())) {
                Files.createDirectories(dexArchive.getRootPath().getParent(), new FileAttribute[0]);
                Files.createFile(dexArchive.getRootPath(), new FileAttribute[0]);
            } else {
                Files.createDirectories(dexArchive.getRootPath(), new FileAttribute[0]);
            }
        }
    }

    public static class DexBuilderException
    extends RuntimeException {
        public DexBuilderException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

