/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.dexing;

import com.google.common.base.Preconditions;
import com.google.common.io.Files;
import java.nio.file.Path;

public final class DexArchiveEntry {
    private final byte[] dexFileContent;
    private final Path relativePathInArchive;

    public DexArchiveEntry(byte[] dexFileContent, Path relativePathInArchive) {
        this.relativePathInArchive = relativePathInArchive;
        this.dexFileContent = dexFileContent;
    }

    public static Path withClassExtension(Path dexEntryPath) {
        String fileName = dexEntryPath.getFileName().toString();
        Preconditions.checkState((boolean)fileName.endsWith(".dex"), (Object)"Dex archives: setting .CLASS extension only for .DEX files");
        return dexEntryPath.resolveSibling(Files.getNameWithoutExtension((String)fileName) + ".class");
    }

    public byte[] getDexFileContent() {
        return this.dexFileContent;
    }

    public Path getRelativePathInArchive() {
        return this.relativePathInArchive;
    }
}

