/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.internal.aapt.v2;

import com.android.builder.core.VariantType;
import com.android.builder.internal.aapt.AaptException;
import com.android.builder.internal.aapt.AaptPackageConfig;
import com.android.builder.internal.aapt.AaptUtils;
import com.android.ide.common.res2.CompileResourceRequest;
import com.android.sdklib.IAndroidTarget;
import com.android.utils.FileUtils;
import com.android.utils.ILogger;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public final class AaptV2CommandBuilder {
    private AaptV2CommandBuilder() {
    }

    public static ImmutableList<String> makeCompile(CompileResourceRequest request) {
        ImmutableList.Builder parameters = new ImmutableList.Builder();
        if (request.isPseudoLocalize()) {
            parameters.add((Object)"--pseudo-localize");
        }
        if (!request.isPngCrunching()) {
            parameters.add((Object)"--no-crunch");
        }
        parameters.add((Object[])new String[]{"-o", request.getOutput().getAbsolutePath()});
        parameters.add((Object)request.getInput().getAbsolutePath());
        return parameters.build();
    }

    public static ImmutableList<String> makeLink(AaptPackageConfig config, File intermediateDir) throws AaptException {
        List additionalParameters;
        String resourceOutputApk;
        ImmutableList.Builder builder;
        block55: {
            builder = ImmutableList.builder();
            if (config.isVerbose()) {
                builder.add((Object)"-v");
            }
            File stableResourceIdsFile = new File(intermediateDir, "stable-resource-ids.txt");
            IAndroidTarget target = config.getAndroidTarget();
            Preconditions.checkNotNull((Object)target);
            builder.add((Object[])new String[]{"-I", target.getPath(1)});
            File manifestFile = config.getManifestFile();
            Preconditions.checkNotNull((Object)manifestFile);
            builder.add((Object[])new String[]{"--manifest", manifestFile.getAbsolutePath()});
            if (config.getResourceDir() != null) {
                try {
                    if (config.isListResourceFiles()) {
                        File file = new File(intermediateDir, "aapt-resources-list.txt");
                        FileUtils.deleteIfExists((File)file);
                        try (FileOutputStream fos = new FileOutputStream(file);){
                            PrintWriter pw = new PrintWriter(fos);
                            Object object = null;
                            try {
                                Files.walk(config.getResourceDir().toPath(), new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(p -> pw.print(p.toString() + " "));
                            }
                            catch (Throwable throwable) {
                                object = throwable;
                                throw throwable;
                            }
                            finally {
                                if (pw != null) {
                                    if (object != null) {
                                        try {
                                            pw.close();
                                        }
                                        catch (Throwable throwable) {
                                            ((Throwable)object).addSuppressed(throwable);
                                        }
                                    } else {
                                        pw.close();
                                    }
                                }
                            }
                        }
                        builder.add((Object[])new String[]{"-R", "@" + file.getAbsolutePath()});
                        break block55;
                    }
                    Files.walk(config.getResourceDir().toPath(), new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(p -> builder.add((Object[])new String[]{"-R", p.toString()}));
                }
                catch (IOException e) {
                    throw new AaptException("Failed to walk path " + config.getResourceDir(), new Object[0]);
                }
            }
        }
        builder.add((Object)"--auto-add-overlay");
        if (config.getSourceOutputDir() != null) {
            builder.add((Object[])new String[]{"--java", config.getSourceOutputDir().getAbsolutePath()});
        }
        if (config.getResourceOutputApk() != null) {
            resourceOutputApk = config.getResourceOutputApk().getAbsolutePath();
        } else {
            try {
                File tmpOutput = File.createTempFile("aapt-", "-out");
                tmpOutput.deleteOnExit();
                resourceOutputApk = tmpOutput.getAbsolutePath();
            }
            catch (IOException e) {
                throw new AaptException("No output apk defined and failed to create tmp file", new Object[]{e});
            }
        }
        builder.add((Object[])new String[]{"-o", resourceOutputApk});
        if (config.getProguardOutputFile() != null) {
            builder.add((Object[])new String[]{"--proguard", config.getProguardOutputFile().getAbsolutePath()});
        }
        if (config.getMainDexListProguardOutputFile() != null) {
            builder.add((Object[])new String[]{"--proguard-main-dex", config.getMainDexListProguardOutputFile().getAbsolutePath()});
        }
        if (config.getSplits() != null) {
            for (String split : config.getSplits()) {
                String splitter = File.pathSeparator;
                builder.add((Object[])new String[]{"--split", resourceOutputApk + "_" + split + splitter + split});
            }
        }
        ILogger logger = config.getLogger();
        Preconditions.checkNotNull((Object)logger);
        if (config.getVariantType() != VariantType.ANDROID_TEST && config.getCustomPackageForR() != null) {
            builder.add((Object[])new String[]{"--custom-package", config.getCustomPackageForR()});
        }
        boolean generateFinalIds = true;
        if (config.getVariantType() == VariantType.LIBRARY) {
            generateFinalIds = false;
        }
        if (!generateFinalIds) {
            builder.add((Object)"--non-final-ids");
        }
        builder.add((Object[])new String[]{"-0", "apk"});
        Collection noCompressList = config.getOptions().getNoCompress();
        if (noCompressList != null) {
            for (String noCompress : noCompressList) {
                builder.add((Object[])new String[]{"-0", noCompress});
            }
        }
        if ((additionalParameters = config.getOptions().getAdditionalParameters()) != null) {
            builder.addAll((Iterable)additionalParameters);
        }
        ArrayList<String> resourceConfigs = new ArrayList<String>();
        resourceConfigs.addAll(config.getResourceConfigs());
        String preferredDensity = null;
        ArrayList densityResourceConfigs = Lists.newArrayList(AaptUtils.getDensityResConfigs(resourceConfigs));
        ArrayList otherResourceConfigs = Lists.newArrayList(AaptUtils.getNonDensityResConfigs(resourceConfigs));
        preferredDensity = config.getPreferredDensity();
        if (preferredDensity != null && !densityResourceConfigs.isEmpty()) {
            throw new AaptException(String.format("When using splits in tools 21 and above, resConfigs should not contain any densities. Right now, it contains \"%1$s\"\nSuggestion: remove these from resConfigs from build.gradle", Joiner.on((String)"\",\"").join((Iterable)densityResourceConfigs)), new Object[0]);
        }
        if (densityResourceConfigs.size() > 1) {
            throw new AaptException("Cannot filter assets for multiple densities using SDK build tools 21 or later. Consider using apk splits instead.", new Object[0]);
        }
        if (preferredDensity == null && densityResourceConfigs.size() == 1) {
            preferredDensity = (String)Iterables.getOnlyElement((Iterable)densityResourceConfigs);
        }
        if (!otherResourceConfigs.isEmpty()) {
            Joiner joiner = Joiner.on((char)',');
            builder.add((Object[])new String[]{"-c", joiner.join((Iterable)otherResourceConfigs)});
        }
        if (preferredDensity != null) {
            builder.add((Object[])new String[]{"--preferred-density", preferredDensity});
        }
        if (!(config.getSymbolOutputDir() == null || config.getVariantType() != VariantType.LIBRARY && config.getLibraries().isEmpty())) {
            File rDotTxt = new File(config.getSymbolOutputDir(), "R.txt");
            builder.add((Object[])new String[]{"--output-text-symbols", rDotTxt.getAbsolutePath()});
        }
        if (config.getPackageId() != null) {
            builder.add((Object[])new String[]{"--package-id", "0x" + Integer.toHexString(config.getPackageId())});
            for (File dependentFeature : config.getDependentFeatures()) {
                builder.add((Object[])new String[]{"-I", dependentFeature.getAbsolutePath()});
            }
        } else if (!config.getDependentFeatures().isEmpty()) {
            throw new AaptException("Dependent features configured but no package ID was set.", new Object[0]);
        }
        builder.add((Object)"--no-version-vectors");
        return builder.build();
    }
}

