/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.symbols;

import com.android.builder.symbols.IdProvider;
import com.android.builder.symbols.ResourceDirectoryParseException;
import com.android.builder.symbols.ResourceExtraXmlParser;
import com.android.builder.symbols.ResourceValuesXmlParser;
import com.android.builder.symbols.Symbol;
import com.android.builder.symbols.SymbolJavaType;
import com.android.builder.symbols.SymbolTable;
import com.android.ide.common.res2.FileResourceNameValidator;
import com.android.ide.common.res2.MergingException;
import com.android.resources.FolderTypeRelationship;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.utils.SdkUtils;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class ResourceDirectoryParser {
    private ResourceDirectoryParser() {
    }

    public static SymbolTable parseDirectory(File directory, IdProvider idProvider) throws ResourceDirectoryParseException {
        DocumentBuilder documentBuilder;
        Preconditions.checkArgument((boolean)directory.isDirectory(), (Object)"!directory.isDirectory()");
        SymbolTable.Builder builder = SymbolTable.builder();
        File[] resourceDirectories = directory.listFiles();
        assert (resourceDirectories != null);
        Arrays.sort(resourceDirectories, Comparator.comparing(File::getName));
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new ResourceDirectoryParseException("Failed to instantiate DOM parser", e);
        }
        for (File resourceDirectory : resourceDirectories) {
            if (!resourceDirectory.isDirectory()) {
                throw new ResourceDirectoryParseException("'" + resourceDirectory.getAbsolutePath() + "' is not a directory");
            }
            ResourceDirectoryParser.parseResourceDirectory(resourceDirectory, builder, idProvider, documentBuilder);
        }
        return builder.build();
    }

    private static void parseResourceDirectory(File resourceDirectory, SymbolTable.Builder builder, IdProvider idProvider, DocumentBuilder documentBuilder) throws ResourceDirectoryParseException {
        assert (resourceDirectory.isDirectory());
        String directoryName = resourceDirectory.getName();
        ResourceFolderType folderResourceType = ResourceFolderType.getFolderType((String)directoryName);
        File[] resourceFiles = resourceDirectory.listFiles();
        assert (resourceFiles != null);
        Arrays.sort(resourceFiles, Comparator.comparing(File::getName));
        for (File maybeResourceFile : resourceFiles) {
            Document domTree;
            ResourceType resourceType;
            if (maybeResourceFile.isDirectory()) continue;
            if (!maybeResourceFile.isFile()) {
                throw new ResourceDirectoryParseException("'" + maybeResourceFile.getAbsolutePath() + "' is not a file nor directory");
            }
            if (folderResourceType == ResourceFolderType.VALUES) {
                try {
                    Document domTree2 = documentBuilder.parse(maybeResourceFile);
                    SymbolTable parsedXml = ResourceValuesXmlParser.parse(domTree2, idProvider);
                    parsedXml.allSymbols().forEach(s -> ResourceDirectoryParser.addIfNotExisting(builder, s));
                    continue;
                }
                catch (IOException | IllegalArgumentException | SAXException e) {
                    throw new ResourceDirectoryParseException("Failed to parse XML resource file '" + maybeResourceFile.getAbsolutePath() + "'", e);
                }
            }
            try {
                resourceType = FolderTypeRelationship.getNonIdRelatedResourceType((ResourceFolderType)folderResourceType);
                FileResourceNameValidator.validate((File)maybeResourceFile, (ResourceType)resourceType);
            }
            catch (MergingException e) {
                throw new ResourceDirectoryParseException("Failed file name validation", e);
            }
            String fileName = maybeResourceFile.getName();
            String symbolName = ResourceDirectoryParser.getNameWithoutExtensions(fileName);
            ResourceDirectoryParser.addIfNotExisting(builder, Symbol.createSymbol(resourceType, symbolName, SymbolJavaType.INT, Integer.toString(idProvider.next())));
            if (!FolderTypeRelationship.isIdGeneratingFolderType((ResourceFolderType)folderResourceType) || !SdkUtils.endsWithIgnoreCase((String)fileName, (String)".xml")) continue;
            try {
                domTree = documentBuilder.parse(maybeResourceFile);
            }
            catch (IOException | SAXException e) {
                throw new ResourceDirectoryParseException("Failed to parse XML resource file '" + maybeResourceFile.getAbsolutePath() + "'", e);
            }
            SymbolTable extraSymbols = ResourceExtraXmlParser.parse(domTree, idProvider);
            extraSymbols.allSymbols().forEach(s -> ResourceDirectoryParser.addIfNotExisting(builder, s));
        }
    }

    private static String getNameWithoutExtensions(String filename) {
        int dotIndex = filename.indexOf(".");
        return dotIndex > 0 ? filename.substring(0, dotIndex) : filename;
    }

    private static void addIfNotExisting(SymbolTable.Builder builder, Symbol symbol) {
        if (!builder.contains(symbol)) {
            builder.add(symbol);
        }
    }
}

