/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.rop.cst;

import com.android.dx.rop.cst.Constant;

public final class CstMethodHandle
extends Constant {
    public static final int KIND_GETFIELD = 1;
    public static final int KIND_GETSTATIC = 2;
    public static final int KIND_PUTFIELD = 3;
    public static final int KIND_PUTSTATIC = 4;
    public static final int KIND_INVOKEVIRTUAL = 5;
    public static final int KIND_INVOKESTATIC = 6;
    public static final int KIND_INVOKESPECIAL = 7;
    public static final int KIND_NEWINVOKESPECIAL = 8;
    public static final int KIND_INVOKEINTERFACE = 9;
    private int kind;
    private final Constant ref;

    public static CstMethodHandle make(int kind, Constant ref) {
        return new CstMethodHandle(kind, ref);
    }

    private CstMethodHandle(int kind, Constant ref) {
        this.kind = kind;
        this.ref = ref;
    }

    public String toString() {
        return this.ref.toString();
    }

    @Override
    public String typeName() {
        return "method handle";
    }

    @Override
    public String toHuman() {
        return this.toString();
    }

    public Constant getRef() {
        return this.ref;
    }

    public int getKind() {
        return this.kind;
    }

    @Override
    public boolean isCategory2() {
        return false;
    }

    @Override
    protected int compareTo0(Constant other) {
        CstMethodHandle otherHandle = (CstMethodHandle)other;
        if (this.getKind() == otherHandle.getKind()) {
            return this.getRef().compareTo(otherHandle.getRef());
        }
        return Integer.compare(this.getKind(), otherHandle.getKind());
    }
}

