/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.aapt2;

import com.android.tools.aapt2.Aapt2Exception;
import com.android.tools.aapt2.Aapt2JniLogCallback;
import com.android.tools.aapt2.Aapt2Result;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class Aapt2Jni {
    private static boolean isLoaded() {
        try {
            Aapt2Jni.ping();
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    private static void load() {
        String libExt;
        String osName;
        String osNameProperty = System.getProperty("os.name");
        if (osNameProperty.startsWith("Windows")) {
            osName = "win";
            libExt = "dll";
        } else if (osNameProperty.startsWith("Mac OS X")) {
            osName = "mac";
            libExt = "dylib";
        } else if (osNameProperty.startsWith("Linux") || osNameProperty.startsWith("LINUX")) {
            osName = "linux";
            libExt = "so";
        } else {
            throw new Aapt2Exception("Unknown OS: " + osNameProperty);
        }
        boolean is64Bit = System.getProperty("os.arch").contains("64");
        String libDirName = osName + (is64Bit ? "64" : "32");
        String pfx = "/" + libDirName + "/";
        Aapt2Jni.loadSharedLibrariesFromResources(pfx + "libaapt2_jni." + libExt, pfx + "libwinpthread-1." + libExt, pfx + "libc++." + libExt);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private static File loadLibraryFromResource(@Nonnull String resource, @Nonnull File dir, boolean optional) throws Aapt2Exception {
        int lastSlash = resource.lastIndexOf(47);
        if (lastSlash == -1) {
            throw new IllegalArgumentException("Resource should be an absolute path");
        }
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException("'" + dir.getAbsolutePath() + "' is not a directory");
        }
        String fname = resource.substring(lastSlash + 1);
        File extracted = new File(dir, fname);
        try (InputStream is = Aapt2Jni.class.getResourceAsStream(resource);){
            if (is == null) {
                if (!optional) throw new Aapt2Exception("Resource '" + resource + "' not found");
                File file = null;
                return file;
            }
            Files.copy(is, extracted.toPath(), new CopyOption[0]);
        }
        catch (IOException e) {
            throw new Aapt2Exception("Failed copying resource '" + resource + "' to '" + extracted.getAbsolutePath() + "'", e);
        }
        try {
            System.load(extracted.getAbsolutePath());
            return extracted;
        }
        catch (Throwable t) {
            throw new Aapt2Exception("Failed to load shared library '" + extracted.getAbsolutePath() + "'", t);
        }
    }

    private static void loadSharedLibrariesFromResources(@Nonnull String resource, String ... requiredResources) throws Aapt2Exception {
        File tempDir;
        try {
            tempDir = File.createTempFile("aapt2_", ".dir");
        }
        catch (IOException e) {
            throw new Aapt2Exception("Failed creating temporary file to hold aapt2 shared library");
        }
        if (!tempDir.delete() || !tempDir.mkdir()) {
            throw new Aapt2Exception("Failed to create directory at " + tempDir.getAbsolutePath());
        }
        ArrayList<File> files = new ArrayList<File>();
        for (String r : requiredResources) {
            File f = Aapt2Jni.loadLibraryFromResource(r, tempDir, true);
            if (f == null) continue;
            files.add(f);
        }
        files.add(Aapt2Jni.loadLibraryFromResource(resource, tempDir, false));
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            files.forEach(File::delete);
            tempDir.delete();
        }));
    }

    private Aapt2Jni() {
    }

    @CheckReturnValue
    public static Aapt2Result compile(@Nonnull List<String> arguments) {
        Aapt2Result.Builder builder = Aapt2Result.builder();
        int returnCode = Aapt2Jni.nativeCompile(arguments, builder);
        return builder.setReturnCode(returnCode).build();
    }

    @CheckReturnValue
    public static Aapt2Result link(@Nonnull List<String> arguments) {
        Aapt2Result.Builder builder = Aapt2Result.builder();
        int returnCode = Aapt2Jni.nativeLink(arguments, builder);
        return builder.setReturnCode(returnCode).build();
    }

    private static native void ping();

    private static native int nativeCompile(@Nonnull List<String> var0, @Nonnull Aapt2JniLogCallback var1);

    private static native int nativeLink(@Nonnull List<String> var0, @Nonnull Aapt2JniLogCallback var1);

    static {
        if (!Aapt2Jni.isLoaded()) {
            Aapt2Jni.load();
        }
    }
}

